import {
  computedEager,
  createEventHook,
  createGlobalState,
  createSharedComposable,
  defaultWindow,
  isClient,
  isIOS,
  onKeyStroke,
  reactiveComputed,
  reactiveOmit,
  refAutoReset,
  syncRef,
  tryOnBeforeUnmount,
  tryOnScopeDispose,
  unrefElement,
  useDebounceFn,
  useEventListener,
  useFocusWithin,
  useMounted,
  useParentElement,
  useRafFn,
  useResizeObserver,
  useTimeout,
  useTimeoutFn,
  useVModel,
  watchOnce
} from "./chunk-42UXCV6L.js";
import {
  arrow,
  computePosition,
  createCoords,
  flip,
  floor,
  hide,
  limitShift,
  max,
  min,
  offset,
  rectToClientRect,
  round,
  shift,
  size
} from "./chunk-TGTWARXU.js";
import {
  Comment,
  Fragment,
  Teleport,
  camelize,
  cloneVNode,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createTextVNode,
  createVNode,
  defineComponent,
  getCurrentInstance,
  getCurrentScope,
  guardReactiveProps,
  h,
  inject,
  isRef,
  markRaw,
  mergeDefaults,
  mergeProps,
  nextTick,
  normalizeProps,
  normalizeStyle,
  onBeforeMount,
  onBeforeUnmount,
  onMounted,
  onScopeDispose,
  onUnmounted,
  openBlock,
  provide,
  reactive,
  ref,
  renderList,
  renderSlot,
  resolveDynamicComponent,
  shallowReadonly,
  shallowRef,
  toDisplayString,
  toHandlerKey,
  toHandlers,
  toRaw,
  toRef,
  toRefs,
  toValue,
  triggerRef,
  unref,
  useId,
  useSlots,
  vShow,
  vue_runtime_esm_bundler_exports,
  watch,
  watchEffect,
  watchPostEffect,
  watchSyncEffect,
  withCtx,
  withDirectives,
  withKeys,
  withMemo,
  withModifiers
} from "./chunk-QJKNQETX.js";

// node_modules/ohash/dist/shared/ohash.D__AXeF1.mjs
function serialize(o) {
  return typeof o == "string" ? `'${o}'` : new c().serialize(o);
}
var c = (function() {
  class o {
    #t = /* @__PURE__ */ new Map();
    compare(t, r) {
      const e = typeof t, n = typeof r;
      return e === "string" && n === "string" ? t.localeCompare(r) : e === "number" && n === "number" ? t - r : String.prototype.localeCompare.call(this.serialize(t, true), this.serialize(r, true));
    }
    serialize(t, r) {
      if (t === null) return "null";
      switch (typeof t) {
        case "string":
          return r ? t : `'${t}'`;
        case "bigint":
          return `${t}n`;
        case "object":
          return this.$object(t);
        case "function":
          return this.$function(t);
      }
      return String(t);
    }
    serializeObject(t) {
      const r = Object.prototype.toString.call(t);
      if (r !== "[object Object]") return this.serializeBuiltInType(r.length < 10 ? `unknown:${r}` : r.slice(8, -1), t);
      const e = t.constructor, n = e === Object || e === void 0 ? "" : e.name;
      if (n !== "" && globalThis[n] === e) return this.serializeBuiltInType(n, t);
      if (typeof t.toJSON == "function") {
        const i = t.toJSON();
        return n + (i !== null && typeof i == "object" ? this.$object(i) : `(${this.serialize(i)})`);
      }
      return this.serializeObjectEntries(n, Object.entries(t));
    }
    serializeBuiltInType(t, r) {
      const e = this["$" + t];
      if (e) return e.call(this, r);
      if (typeof r?.entries == "function") return this.serializeObjectEntries(t, r.entries());
      throw new Error(`Cannot serialize ${t}`);
    }
    serializeObjectEntries(t, r) {
      const e = Array.from(r).sort((i, a) => this.compare(i[0], a[0]));
      let n = `${t}{`;
      for (let i = 0; i < e.length; i++) {
        const [a, l] = e[i];
        n += `${this.serialize(a, true)}:${this.serialize(l)}`, i < e.length - 1 && (n += ",");
      }
      return n + "}";
    }
    $object(t) {
      let r = this.#t.get(t);
      return r === void 0 && (this.#t.set(t, `#${this.#t.size}`), r = this.serializeObject(t), this.#t.set(t, r)), r;
    }
    $function(t) {
      const r = Function.prototype.toString.call(t);
      return r.slice(-15) === "[native code] }" ? `${t.name || ""}()[native]` : `${t.name}(${t.length})${r.replace(/\s*\n\s*/g, "")}`;
    }
    $Array(t) {
      let r = "[";
      for (let e = 0; e < t.length; e++) r += this.serialize(t[e]), e < t.length - 1 && (r += ",");
      return r + "]";
    }
    $Date(t) {
      try {
        return `Date(${t.toISOString()})`;
      } catch {
        return "Date(null)";
      }
    }
    $ArrayBuffer(t) {
      return `ArrayBuffer[${new Uint8Array(t).join(",")}]`;
    }
    $Set(t) {
      return `Set${this.$Array(Array.from(t).sort((r, e) => this.compare(r, e)))}`;
    }
    $Map(t) {
      return this.serializeObjectEntries("Map", t.entries());
    }
  }
  for (const s of ["Error", "RegExp", "URL"]) o.prototype["$" + s] = function(t) {
    return `${s}(${t})`;
  };
  for (const s of ["Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array"]) o.prototype["$" + s] = function(t) {
    return `${s}[${t.join(",")}]`;
  };
  for (const s of ["BigInt64Array", "BigUint64Array"]) o.prototype["$" + s] = function(t) {
    return `${s}[${t.join("n,")}${t.length > 0 ? "n" : ""}]`;
  };
  return o;
})();
function isEqual(object1, object2) {
  if (object1 === object2) {
    return true;
  }
  if (serialize(object1) === serialize(object2)) {
    return true;
  }
  return false;
}

// node_modules/reka-ui/dist/shared/arrays.js
function areEqual(arrayA, arrayB) {
  if (arrayA.length !== arrayB.length) return false;
  for (let index = 0; index < arrayA.length; index++) if (arrayA[index] !== arrayB[index]) return false;
  return true;
}
function findValuesBetween(array, start, end) {
  const startIndex = array.findIndex((i) => isEqual(i, start));
  const endIndex = array.findIndex((i) => isEqual(i, end));
  if (startIndex === -1 || endIndex === -1) return [];
  const [minIndex, maxIndex] = [startIndex, endIndex].sort((a, b) => a - b);
  return array.slice(minIndex, maxIndex + 1);
}

// node_modules/reka-ui/dist/shared/browser.js
var isBrowser = typeof document !== "undefined";

// node_modules/reka-ui/dist/shared/clamp.js
function clamp(value, min2 = Number.NEGATIVE_INFINITY, max2 = Number.POSITIVE_INFINITY) {
  return Math.min(max2, Math.max(min2, value));
}
function roundToStepPrecision(value, step) {
  let roundedValue = value;
  const stepString = step.toString();
  const pointIndex = stepString.indexOf(".");
  const precision = pointIndex >= 0 ? stepString.length - pointIndex : 0;
  if (precision > 0) {
    const pow = 10 ** precision;
    roundedValue = Math.round(roundedValue * pow) / pow;
  }
  return roundedValue;
}
function snapValueToStep(value, min2, max2, step) {
  min2 = Number(min2);
  max2 = Number(max2);
  const remainder = (value - (Number.isNaN(min2) ? 0 : min2)) % step;
  let snappedValue = roundToStepPrecision(Math.abs(remainder) * 2 >= step ? value + Math.sign(remainder) * (step - Math.abs(remainder)) : value - remainder, step);
  if (!Number.isNaN(min2)) {
    if (snappedValue < min2) snappedValue = min2;
    else if (!Number.isNaN(max2) && snappedValue > max2) snappedValue = min2 + Math.floor(roundToStepPrecision((max2 - min2) / step, step)) * step;
  } else if (!Number.isNaN(max2) && snappedValue > max2) snappedValue = Math.floor(roundToStepPrecision(max2 / step, step)) * step;
  snappedValue = roundToStepPrecision(snappedValue, step);
  return snappedValue;
}

// node_modules/reka-ui/dist/shared/createContext.js
function createContext(providerComponentName, contextName) {
  const symbolDescription = typeof providerComponentName === "string" && !contextName ? `${providerComponentName}Context` : contextName;
  const injectionKey = Symbol(symbolDescription);
  const injectContext = (fallback) => {
    const context2 = inject(injectionKey, fallback);
    if (context2) return context2;
    if (context2 === null) return context2;
    throw new Error(`Injection \`${injectionKey.toString()}\` not found. Component must be used within ${Array.isArray(providerComponentName) ? `one of the following components: ${providerComponentName.join(", ")}` : `\`${providerComponentName}\``}`);
  };
  const provideContext = (contextValue) => {
    provide(injectionKey, contextValue);
    return contextValue;
  };
  return [injectContext, provideContext];
}

// node_modules/reka-ui/dist/shared/getActiveElement.js
function getActiveElement() {
  let activeElement = document.activeElement;
  if (activeElement == null) return null;
  while (activeElement != null && activeElement.shadowRoot != null && activeElement.shadowRoot.activeElement != null) activeElement = activeElement.shadowRoot.activeElement;
  return activeElement;
}

// node_modules/reka-ui/dist/shared/handleAndDispatchCustomEvent.js
function handleAndDispatchCustomEvent(name, handler, detail) {
  const target = detail.originalEvent.target;
  const event = new CustomEvent(name, {
    bubbles: false,
    cancelable: true,
    detail
  });
  if (handler) target.addEventListener(name, handler, { once: true });
  target.dispatchEvent(event);
}

// node_modules/reka-ui/dist/shared/nullish.js
function isNullish(value) {
  return value === null || value === void 0;
}

// node_modules/reka-ui/dist/shared/isValueEqualOrExist.js
function isValueEqualOrExist(base, current) {
  if (isNullish(base)) return false;
  if (Array.isArray(base)) return base.some((val) => isEqual(val, current));
  else return isEqual(base, current);
}

// node_modules/reka-ui/dist/shared/renderSlotFragments.js
function renderSlotFragments(children) {
  if (!children) return [];
  return children.flatMap((child) => {
    if (child.type === Fragment) return renderSlotFragments(child.children);
    return [child];
  });
}

// node_modules/reka-ui/dist/shared/useArrowNavigation.js
var ignoredElement = ["INPUT", "TEXTAREA"];
function useArrowNavigation(e, currentElement, parentElement, options = {}) {
  if (!currentElement || options.enableIgnoredElement && ignoredElement.includes(currentElement.nodeName)) return null;
  const { arrowKeyOptions = "both", attributeName = "[data-reka-collection-item]", itemsArray = [], loop = true, dir = "ltr", preventScroll = true, focus: focus2 = false } = options;
  const [right, left, up, down, home, end] = [
    e.key === "ArrowRight",
    e.key === "ArrowLeft",
    e.key === "ArrowUp",
    e.key === "ArrowDown",
    e.key === "Home",
    e.key === "End"
  ];
  const goingVertical = up || down;
  const goingHorizontal = right || left;
  if (!home && !end && (!goingVertical && !goingHorizontal || arrowKeyOptions === "vertical" && goingHorizontal || arrowKeyOptions === "horizontal" && goingVertical)) return null;
  const allCollectionItems = parentElement ? Array.from(parentElement.querySelectorAll(attributeName)) : itemsArray;
  if (!allCollectionItems.length) return null;
  if (preventScroll) e.preventDefault();
  let item = null;
  if (goingHorizontal || goingVertical) {
    const goForward = goingVertical ? down : dir === "ltr" ? right : left;
    item = findNextFocusableElement(allCollectionItems, currentElement, {
      goForward,
      loop
    });
  } else if (home) item = allCollectionItems.at(0) || null;
  else if (end) item = allCollectionItems.at(-1) || null;
  if (focus2) item?.focus();
  return item;
}
function findNextFocusableElement(elements, currentElement, options, iterations = elements.length) {
  if (--iterations === 0) return null;
  const index = elements.indexOf(currentElement);
  const newIndex = options.goForward ? index + 1 : index - 1;
  if (!options.loop && (newIndex < 0 || newIndex >= elements.length)) return null;
  const adjustedNewIndex = (newIndex + elements.length) % elements.length;
  const candidate = elements[adjustedNewIndex];
  if (!candidate) return null;
  const isDisabled = candidate.hasAttribute("disabled") && candidate.getAttribute("disabled") !== "false";
  if (isDisabled) return findNextFocusableElement(elements, candidate, options, iterations);
  return candidate;
}

// node_modules/reka-ui/dist/ConfigProvider/ConfigProvider.js
var [injectConfigProviderContext, provideConfigProviderContext] = createContext("ConfigProvider");
var ConfigProvider_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ConfigProvider",
  props: {
    dir: {
      type: String,
      required: false,
      default: "ltr"
    },
    locale: {
      type: String,
      required: false,
      default: "en"
    },
    scrollBody: {
      type: [Boolean, Object],
      required: false,
      default: true
    },
    nonce: {
      type: String,
      required: false,
      default: void 0
    },
    useId: {
      type: Function,
      required: false,
      default: void 0
    }
  },
  setup(__props) {
    const props2 = __props;
    const { dir, locale, scrollBody, nonce } = toRefs(props2);
    provideConfigProviderContext({
      dir,
      locale,
      scrollBody,
      nonce,
      useId: props2.useId
    });
    return (_ctx, _cache) => {
      return renderSlot(_ctx.$slots, "default");
    };
  }
});
var ConfigProvider_default = ConfigProvider_vue_vue_type_script_setup_true_lang_default;

// node_modules/defu/dist/defu.mjs
function isPlainObject(value) {
  if (value === null || typeof value !== "object") {
    return false;
  }
  const prototype = Object.getPrototypeOf(value);
  if (prototype !== null && prototype !== Object.prototype && Object.getPrototypeOf(prototype) !== null) {
    return false;
  }
  if (Symbol.iterator in value) {
    return false;
  }
  if (Symbol.toStringTag in value) {
    return Object.prototype.toString.call(value) === "[object Module]";
  }
  return true;
}
function _defu(baseObject, defaults, namespace = ".", merger) {
  if (!isPlainObject(defaults)) {
    return _defu(baseObject, {}, namespace, merger);
  }
  const object = Object.assign({}, defaults);
  for (const key in baseObject) {
    if (key === "__proto__" || key === "constructor") {
      continue;
    }
    const value = baseObject[key];
    if (value === null || value === void 0) {
      continue;
    }
    if (merger && merger(object, key, value, namespace)) {
      continue;
    }
    if (Array.isArray(value) && Array.isArray(object[key])) {
      object[key] = [...value, ...object[key]];
    } else if (isPlainObject(value) && isPlainObject(object[key])) {
      object[key] = _defu(
        value,
        object[key],
        (namespace ? `${namespace}.` : "") + key.toString(),
        merger
      );
    } else {
      object[key] = value;
    }
  }
  return object;
}
function createDefu(merger) {
  return (...arguments_) => (
    // eslint-disable-next-line unicorn/no-array-reduce
    arguments_.reduce((p, c2) => _defu(p, c2, "", merger), {})
  );
}
var defu = createDefu();
var defuFn = createDefu((object, key, currentValue) => {
  if (object[key] !== void 0 && typeof currentValue === "function") {
    object[key] = currentValue(object[key]);
    return true;
  }
});
var defuArrayFn = createDefu((object, key, currentValue) => {
  if (Array.isArray(object[key]) && typeof currentValue === "function") {
    object[key] = currentValue(object[key]);
    return true;
  }
});

// node_modules/reka-ui/dist/shared/useBodyScrollLock.js
var useBodyLockStackCount = createSharedComposable(() => {
  const map = ref(/* @__PURE__ */ new Map());
  const initialOverflow = ref();
  const locked = computed(() => {
    for (const value of map.value.values()) if (value) return true;
    return false;
  });
  const context2 = injectConfigProviderContext({ scrollBody: ref(true) });
  let stopTouchMoveListener = null;
  const resetBodyStyle = () => {
    document.body.style.paddingRight = "";
    document.body.style.marginRight = "";
    document.body.style.pointerEvents = "";
    document.documentElement.style.removeProperty("--scrollbar-width");
    document.body.style.overflow = initialOverflow.value ?? "";
    isIOS && stopTouchMoveListener?.();
    initialOverflow.value = void 0;
  };
  watch(locked, (val, oldVal) => {
    if (!isClient) return;
    if (!val) {
      if (oldVal) resetBodyStyle();
      return;
    }
    if (initialOverflow.value === void 0) initialOverflow.value = document.body.style.overflow;
    const verticalScrollbarWidth = window.innerWidth - document.documentElement.clientWidth;
    const defaultConfig = {
      padding: verticalScrollbarWidth,
      margin: 0
    };
    const config = context2.scrollBody?.value ? typeof context2.scrollBody.value === "object" ? defu({
      padding: context2.scrollBody.value.padding === true ? verticalScrollbarWidth : context2.scrollBody.value.padding,
      margin: context2.scrollBody.value.margin === true ? verticalScrollbarWidth : context2.scrollBody.value.margin
    }, defaultConfig) : defaultConfig : {
      padding: 0,
      margin: 0
    };
    if (verticalScrollbarWidth > 0) {
      document.body.style.paddingRight = typeof config.padding === "number" ? `${config.padding}px` : String(config.padding);
      document.body.style.marginRight = typeof config.margin === "number" ? `${config.margin}px` : String(config.margin);
      document.documentElement.style.setProperty("--scrollbar-width", `${verticalScrollbarWidth}px`);
      document.body.style.overflow = "hidden";
    }
    if (isIOS) stopTouchMoveListener = useEventListener(document, "touchmove", (e) => preventDefault(e), { passive: false });
    nextTick(() => {
      document.body.style.pointerEvents = "none";
      document.body.style.overflow = "hidden";
    });
  }, {
    immediate: true,
    flush: "sync"
  });
  return map;
});
function useBodyScrollLock(initialState) {
  const id = Math.random().toString(36).substring(2, 7);
  const map = useBodyLockStackCount();
  map.value.set(id, initialState ?? false);
  const locked = computed({
    get: () => map.value.get(id) ?? false,
    set: (value) => map.value.set(id, value)
  });
  tryOnBeforeUnmount(() => {
    map.value.delete(id);
  });
  return locked;
}
function checkOverflowScroll(ele) {
  const style = window.getComputedStyle(ele);
  if (style.overflowX === "scroll" || style.overflowY === "scroll" || style.overflowX === "auto" && ele.clientWidth < ele.scrollWidth || style.overflowY === "auto" && ele.clientHeight < ele.scrollHeight) return true;
  else {
    const parent = ele.parentNode;
    if (!(parent instanceof Element) || parent.tagName === "BODY") return false;
    return checkOverflowScroll(parent);
  }
}
function preventDefault(rawEvent) {
  const e = rawEvent || window.event;
  const _target = e.target;
  if (_target instanceof Element && checkOverflowScroll(_target)) return false;
  if (e.touches.length > 1) return true;
  if (e.preventDefault && e.cancelable) e.preventDefault();
  return false;
}

// node_modules/@internationalized/date/dist/utils.mjs
function $2b4dce13dd5a17fa$export$842a2cf37af977e1(amount, numerator) {
  return amount - numerator * Math.floor(amount / numerator);
}

// node_modules/@internationalized/date/dist/GregorianCalendar.mjs
var $3b62074eb05584b2$var$EPOCH = 1721426;
function $3b62074eb05584b2$export$f297eb839006d339(era, year, month, day) {
  year = $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year);
  let y1 = year - 1;
  let monthOffset = -2;
  if (month <= 2) monthOffset = 0;
  else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) monthOffset = -1;
  return $3b62074eb05584b2$var$EPOCH - 1 + 365 * y1 + Math.floor(y1 / 4) - Math.floor(y1 / 100) + Math.floor(y1 / 400) + Math.floor((367 * month - 362) / 12 + monthOffset + day);
}
function $3b62074eb05584b2$export$553d7fa8e3805fc0(year) {
  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
function $3b62074eb05584b2$export$c36e0ecb2d4fa69d(era, year) {
  return era === "BC" ? 1 - year : year;
}
function $3b62074eb05584b2$export$4475b7e617eb123c(year) {
  let era = "AD";
  if (year <= 0) {
    era = "BC";
    year = 1 - year;
  }
  return [
    era,
    year
  ];
}
var $3b62074eb05584b2$var$daysInMonth = {
  standard: [
    31,
    28,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ],
  leapyear: [
    31,
    29,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
  ]
};
var $3b62074eb05584b2$export$80ee6245ec4f29ec = class {
  fromJulianDay(jd) {
    let jd0 = jd;
    let depoch = jd0 - $3b62074eb05584b2$var$EPOCH;
    let quadricent = Math.floor(depoch / 146097);
    let dqc = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(depoch, 146097);
    let cent = Math.floor(dqc / 36524);
    let dcent = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dqc, 36524);
    let quad = Math.floor(dcent / 1461);
    let dquad = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(dcent, 1461);
    let yindex = Math.floor(dquad / 365);
    let extendedYear = quadricent * 400 + cent * 100 + quad * 4 + yindex + (cent !== 4 && yindex !== 4 ? 1 : 0);
    let [era, year] = $3b62074eb05584b2$export$4475b7e617eb123c(extendedYear);
    let yearDay = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, 1, 1);
    let leapAdj = 2;
    if (jd0 < $3b62074eb05584b2$export$f297eb839006d339(era, year, 3, 1)) leapAdj = 0;
    else if ($3b62074eb05584b2$export$553d7fa8e3805fc0(year)) leapAdj = 1;
    let month = Math.floor(((yearDay + leapAdj) * 12 + 373) / 367);
    let day = jd0 - $3b62074eb05584b2$export$f297eb839006d339(era, year, month, 1) + 1;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, month, day);
  }
  toJulianDay(date) {
    return $3b62074eb05584b2$export$f297eb839006d339(date.era, date.year, date.month, date.day);
  }
  getDaysInMonth(date) {
    return $3b62074eb05584b2$var$daysInMonth[$3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? "leapyear" : "standard"][date.month - 1];
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getMonthsInYear(date) {
    return 12;
  }
  getDaysInYear(date) {
    return $3b62074eb05584b2$export$553d7fa8e3805fc0(date.year) ? 366 : 365;
  }
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  getYearsInEra(date) {
    return 9999;
  }
  getEras() {
    return [
      "BC",
      "AD"
    ];
  }
  isInverseEra(date) {
    return date.era === "BC";
  }
  balanceDate(date) {
    if (date.year <= 0) {
      date.era = date.era === "BC" ? "AD" : "BC";
      date.year = 1 - date.year;
    }
  }
  constructor() {
    this.identifier = "gregory";
  }
};

// node_modules/@internationalized/date/dist/weekStartData.mjs
var $2fe286d2fb449abb$export$7a5acbd77d414bd9 = {
  "001": 1,
  AD: 1,
  AE: 6,
  AF: 6,
  AI: 1,
  AL: 1,
  AM: 1,
  AN: 1,
  AR: 1,
  AT: 1,
  AU: 1,
  AX: 1,
  AZ: 1,
  BA: 1,
  BE: 1,
  BG: 1,
  BH: 6,
  BM: 1,
  BN: 1,
  BY: 1,
  CH: 1,
  CL: 1,
  CM: 1,
  CN: 1,
  CR: 1,
  CY: 1,
  CZ: 1,
  DE: 1,
  DJ: 6,
  DK: 1,
  DZ: 6,
  EC: 1,
  EE: 1,
  EG: 6,
  ES: 1,
  FI: 1,
  FJ: 1,
  FO: 1,
  FR: 1,
  GB: 1,
  GE: 1,
  GF: 1,
  GP: 1,
  GR: 1,
  HR: 1,
  HU: 1,
  IE: 1,
  IQ: 6,
  IR: 6,
  IS: 1,
  IT: 1,
  JO: 6,
  KG: 1,
  KW: 6,
  KZ: 1,
  LB: 1,
  LI: 1,
  LK: 1,
  LT: 1,
  LU: 1,
  LV: 1,
  LY: 6,
  MC: 1,
  MD: 1,
  ME: 1,
  MK: 1,
  MN: 1,
  MQ: 1,
  MV: 5,
  MY: 1,
  NL: 1,
  NO: 1,
  NZ: 1,
  OM: 6,
  PL: 1,
  QA: 6,
  RE: 1,
  RO: 1,
  RS: 1,
  RU: 1,
  SD: 6,
  SE: 1,
  SI: 1,
  SK: 1,
  SM: 1,
  SY: 6,
  TJ: 1,
  TM: 1,
  TR: 1,
  UA: 1,
  UY: 1,
  UZ: 1,
  VA: 1,
  VN: 1,
  XK: 1
};

// node_modules/@internationalized/date/dist/queries.mjs
function $14e0f24ef4ac5c92$export$ea39ec197993aef0(a, b) {
  b = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b, a.calendar);
  return a.era === b.era && a.year === b.year && a.month === b.month && a.day === b.day;
}
function $14e0f24ef4ac5c92$export$a18c89cbd24170ff(a, b) {
  b = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(b, a.calendar);
  a = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(a);
  b = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(b);
  return a.era === b.era && a.year === b.year && a.month === b.month;
}
function $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(a, b) {
  return $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a.calendar, b.calendar) && $14e0f24ef4ac5c92$export$ea39ec197993aef0(a, b);
}
function $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(a, b) {
  return $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a.calendar, b.calendar) && $14e0f24ef4ac5c92$export$a18c89cbd24170ff(a, b);
}
function $14e0f24ef4ac5c92$export$dbc69fd56b53d5e(a, b) {
  var _a_isEqual, _b_isEqual;
  var _a_isEqual1, _ref;
  return (_ref = (_a_isEqual1 = (_a_isEqual = a.isEqual) === null || _a_isEqual === void 0 ? void 0 : _a_isEqual.call(a, b)) !== null && _a_isEqual1 !== void 0 ? _a_isEqual1 : (_b_isEqual = b.isEqual) === null || _b_isEqual === void 0 ? void 0 : _b_isEqual.call(b, a)) !== null && _ref !== void 0 ? _ref : a.identifier === b.identifier;
}
function $14e0f24ef4ac5c92$export$629b0a497aa65267(date, timeZone) {
  return $14e0f24ef4ac5c92$export$ea39ec197993aef0(date, $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone));
}
var $14e0f24ef4ac5c92$var$DAY_MAP = {
  sun: 0,
  mon: 1,
  tue: 2,
  wed: 3,
  thu: 4,
  fri: 5,
  sat: 6
};
function $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale, firstDayOfWeek) {
  let julian = date.calendar.toJulianDay(date);
  let weekStart = firstDayOfWeek ? $14e0f24ef4ac5c92$var$DAY_MAP[firstDayOfWeek] : $14e0f24ef4ac5c92$var$getWeekStart(locale);
  let dayOfWeek = Math.ceil(julian + 1 - weekStart) % 7;
  if (dayOfWeek < 0) dayOfWeek += 7;
  return dayOfWeek;
}
function $14e0f24ef4ac5c92$export$461939dd4422153(timeZone) {
  return (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(Date.now(), timeZone);
}
function $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3(timeZone) {
  return (0, $11d87f3f76e88657$export$93522d1a439f3617)($14e0f24ef4ac5c92$export$461939dd4422153(timeZone));
}
function $14e0f24ef4ac5c92$export$68781ddf31c0090f(a, b) {
  return a.calendar.toJulianDay(a) - b.calendar.toJulianDay(b);
}
function $14e0f24ef4ac5c92$export$c19a80a9721b80f6(a, b) {
  return $14e0f24ef4ac5c92$var$timeToMs(a) - $14e0f24ef4ac5c92$var$timeToMs(b);
}
function $14e0f24ef4ac5c92$var$timeToMs(a) {
  return a.hour * 36e5 + a.minute * 6e4 + a.second * 1e3 + a.millisecond;
}
var $14e0f24ef4ac5c92$var$localTimeZone = null;
function $14e0f24ef4ac5c92$export$aa8b41735afcabd2() {
  if ($14e0f24ef4ac5c92$var$localTimeZone == null) $14e0f24ef4ac5c92$var$localTimeZone = new Intl.DateTimeFormat().resolvedOptions().timeZone;
  return $14e0f24ef4ac5c92$var$localTimeZone;
}
function $14e0f24ef4ac5c92$export$a5a3b454ada2268e(date) {
  return date.subtract({
    days: date.day - 1
  });
}
function $14e0f24ef4ac5c92$export$a2258d9c4118825c(date) {
  return date.add({
    days: date.calendar.getDaysInMonth(date) - date.day
  });
}
var $14e0f24ef4ac5c92$var$cachedRegions = /* @__PURE__ */ new Map();
var $14e0f24ef4ac5c92$var$cachedWeekInfo = /* @__PURE__ */ new Map();
function $14e0f24ef4ac5c92$var$getRegion(locale) {
  if (Intl.Locale) {
    let region = $14e0f24ef4ac5c92$var$cachedRegions.get(locale);
    if (!region) {
      region = new Intl.Locale(locale).maximize().region;
      if (region) $14e0f24ef4ac5c92$var$cachedRegions.set(locale, region);
    }
    return region;
  }
  let part = locale.split("-")[1];
  return part === "u" ? void 0 : part;
}
function $14e0f24ef4ac5c92$var$getWeekStart(locale) {
  let weekInfo = $14e0f24ef4ac5c92$var$cachedWeekInfo.get(locale);
  if (!weekInfo) {
    if (Intl.Locale) {
      let localeInst = new Intl.Locale(locale);
      if ("getWeekInfo" in localeInst) {
        weekInfo = localeInst.getWeekInfo();
        if (weekInfo) {
          $14e0f24ef4ac5c92$var$cachedWeekInfo.set(locale, weekInfo);
          return weekInfo.firstDay;
        }
      }
    }
    let region = $14e0f24ef4ac5c92$var$getRegion(locale);
    if (locale.includes("-fw-")) {
      let day = locale.split("-fw-")[1].split("-")[0];
      if (day === "mon") weekInfo = {
        firstDay: 1
      };
      else if (day === "tue") weekInfo = {
        firstDay: 2
      };
      else if (day === "wed") weekInfo = {
        firstDay: 3
      };
      else if (day === "thu") weekInfo = {
        firstDay: 4
      };
      else if (day === "fri") weekInfo = {
        firstDay: 5
      };
      else if (day === "sat") weekInfo = {
        firstDay: 6
      };
      else weekInfo = {
        firstDay: 0
      };
    } else if (locale.includes("-ca-iso8601")) weekInfo = {
      firstDay: 1
    };
    else weekInfo = {
      firstDay: region ? (0, $2fe286d2fb449abb$export$7a5acbd77d414bd9)[region] || 0 : 0
    };
    $14e0f24ef4ac5c92$var$cachedWeekInfo.set(locale, weekInfo);
  }
  return weekInfo.firstDay;
}

// node_modules/@internationalized/date/dist/conversion.mjs
function $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) {
  date = $11d87f3f76e88657$export$b4a036af3fc0b032(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(date.era, date.year);
  return $11d87f3f76e88657$var$epochFromParts(year, date.month, date.day, date.hour, date.minute, date.second, date.millisecond);
}
function $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, millisecond) {
  let date = /* @__PURE__ */ new Date();
  date.setUTCHours(hour, minute, second, millisecond);
  date.setUTCFullYear(year, month - 1, day);
  return date.getTime();
}
function $11d87f3f76e88657$export$59c99f3515d3493f(ms, timeZone) {
  if (timeZone === "UTC") return 0;
  if (ms > 0 && timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)()) return new Date(ms).getTimezoneOffset() * -6e4;
  let { year, month, day, hour, minute, second } = $11d87f3f76e88657$var$getTimeZoneParts(ms, timeZone);
  let utc = $11d87f3f76e88657$var$epochFromParts(year, month, day, hour, minute, second, 0);
  return utc - Math.floor(ms / 1e3) * 1e3;
}
var $11d87f3f76e88657$var$formattersByTimeZone = /* @__PURE__ */ new Map();
function $11d87f3f76e88657$var$getTimeZoneParts(ms, timeZone) {
  let formatter = $11d87f3f76e88657$var$formattersByTimeZone.get(timeZone);
  if (!formatter) {
    formatter = new Intl.DateTimeFormat("en-US", {
      timeZone,
      hour12: false,
      era: "short",
      year: "numeric",
      month: "numeric",
      day: "numeric",
      hour: "numeric",
      minute: "numeric",
      second: "numeric"
    });
    $11d87f3f76e88657$var$formattersByTimeZone.set(timeZone, formatter);
  }
  let parts = formatter.formatToParts(new Date(ms));
  let namedParts = {};
  for (let part of parts) if (part.type !== "literal") namedParts[part.type] = part.value;
  return {
    // Firefox returns B instead of BC... https://bugzilla.mozilla.org/show_bug.cgi?id=1752253
    year: namedParts.era === "BC" || namedParts.era === "B" ? -namedParts.year + 1 : +namedParts.year,
    month: +namedParts.month,
    day: +namedParts.day,
    hour: namedParts.hour === "24" ? 0 : +namedParts.hour,
    minute: +namedParts.minute,
    second: +namedParts.second
  };
}
var $11d87f3f76e88657$var$DAYMILLIS = 864e5;
function $11d87f3f76e88657$var$getValidWallTimes(date, timeZone, earlier, later) {
  let found = earlier === later ? [
    earlier
  ] : [
    earlier,
    later
  ];
  return found.filter((absolute) => $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute));
}
function $11d87f3f76e88657$var$isValidWallTime(date, timeZone, absolute) {
  let parts = $11d87f3f76e88657$var$getTimeZoneParts(absolute, timeZone);
  return date.year === parts.year && date.month === parts.month && date.day === parts.day && date.hour === parts.hour && date.minute === parts.minute && date.second === parts.second;
}
function $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation = "compatible") {
  let dateTime = $11d87f3f76e88657$export$b21e0b124e224484(date);
  if (timeZone === "UTC") return $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  if (timeZone === (0, $14e0f24ef4ac5c92$export$aa8b41735afcabd2)() && disambiguation === "compatible") {
    dateTime = $11d87f3f76e88657$export$b4a036af3fc0b032(dateTime, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
    let date2 = /* @__PURE__ */ new Date();
    let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(dateTime.era, dateTime.year);
    date2.setFullYear(year, dateTime.month - 1, dateTime.day);
    date2.setHours(dateTime.hour, dateTime.minute, dateTime.second, dateTime.millisecond);
    return date2.getTime();
  }
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(dateTime);
  let offsetBefore = $11d87f3f76e88657$export$59c99f3515d3493f(ms - $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let offsetAfter = $11d87f3f76e88657$export$59c99f3515d3493f(ms + $11d87f3f76e88657$var$DAYMILLIS, timeZone);
  let valid = $11d87f3f76e88657$var$getValidWallTimes(dateTime, timeZone, ms - offsetBefore, ms - offsetAfter);
  if (valid.length === 1) return valid[0];
  if (valid.length > 1) switch (disambiguation) {
    // 'compatible' means 'earlier' for "fall back" transitions
    case "compatible":
    case "earlier":
      return valid[0];
    case "later":
      return valid[valid.length - 1];
    case "reject":
      throw new RangeError("Multiple possible absolute times found");
  }
  switch (disambiguation) {
    case "earlier":
      return Math.min(ms - offsetBefore, ms - offsetAfter);
    // 'compatible' means 'later' for "spring forward" transitions
    case "compatible":
    case "later":
      return Math.max(ms - offsetBefore, ms - offsetAfter);
    case "reject":
      throw new RangeError("No such absolute time found");
  }
}
function $11d87f3f76e88657$export$e67a095c620b86fe(dateTime, timeZone, disambiguation = "compatible") {
  return new Date($11d87f3f76e88657$export$5107c82f94518f5c(dateTime, timeZone, disambiguation));
}
function $11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone) {
  let offset3 = $11d87f3f76e88657$export$59c99f3515d3493f(ms, timeZone);
  let date = new Date(ms + offset3);
  let year = date.getUTCFullYear();
  let month = date.getUTCMonth() + 1;
  let day = date.getUTCDate();
  let hour = date.getUTCHours();
  let minute = date.getUTCMinutes();
  let second = date.getUTCSeconds();
  let millisecond = date.getUTCMilliseconds();
  return new (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)(year < 1 ? "BC" : "AD", year < 1 ? -year + 1 : year, month, day, timeZone, offset3, hour, minute, second, millisecond);
}
function $11d87f3f76e88657$export$93522d1a439f3617(dateTime) {
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(dateTime.calendar, dateTime.era, dateTime.year, dateTime.month, dateTime.day);
}
function $11d87f3f76e88657$export$b21e0b124e224484(date, time) {
  let hour = 0, minute = 0, second = 0, millisecond = 0;
  if ("timeZone" in date) ({ hour, minute, second, millisecond } = date);
  else if ("hour" in date && !time) return date;
  if (time) ({ hour, minute, second, millisecond } = time);
  return new (0, $35ea8db9cb2ccb90$export$ca871e8dbb80966f)(date.calendar, date.era, date.year, date.month, date.day, hour, minute, second, millisecond);
}
function $11d87f3f76e88657$export$b4a036af3fc0b032(date, calendar) {
  if ((0, $14e0f24ef4ac5c92$export$dbc69fd56b53d5e)(date.calendar, calendar)) return date;
  let calendarDate = calendar.fromJulianDay(date.calendar.toJulianDay(date));
  let copy = date.copy();
  copy.calendar = calendar;
  copy.era = calendarDate.era;
  copy.year = calendarDate.year;
  copy.month = calendarDate.month;
  copy.day = calendarDate.day;
  (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(copy);
  return copy;
}
function $11d87f3f76e88657$export$84c95a83c799e074(date, timeZone, disambiguation) {
  if (date instanceof (0, $35ea8db9cb2ccb90$export$d3b7288e7994edea)) {
    if (date.timeZone === timeZone) return date;
    return $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone);
  }
  let ms = $11d87f3f76e88657$export$5107c82f94518f5c(date, timeZone, disambiguation);
  return $11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone);
}
function $11d87f3f76e88657$export$83aac07b4c37b25(date) {
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return new Date(ms);
}
function $11d87f3f76e88657$export$538b00033cc11c75(date, timeZone) {
  let ms = $11d87f3f76e88657$export$bd4fb2bc8bb06fb(date) - date.offset;
  return $11d87f3f76e88657$export$b4a036af3fc0b032($11d87f3f76e88657$export$1b96692a1ba042ac(ms, timeZone), date.calendar);
}

// node_modules/@internationalized/date/dist/manipulation.mjs
var $735220c2d4774dd3$var$ONE_HOUR = 36e5;
function $735220c2d4774dd3$export$e16d8520af44a096(date, duration) {
  let mutableDate = date.copy();
  let days = "hour" in mutableDate ? $735220c2d4774dd3$var$addTimeFields(mutableDate, duration) : 0;
  $735220c2d4774dd3$var$addYears(mutableDate, duration.years || 0);
  if (mutableDate.calendar.balanceYearMonth) mutableDate.calendar.balanceYearMonth(mutableDate, date);
  mutableDate.month += duration.months || 0;
  $735220c2d4774dd3$var$balanceYearMonth(mutableDate);
  $735220c2d4774dd3$var$constrainMonthDay(mutableDate);
  mutableDate.day += (duration.weeks || 0) * 7;
  mutableDate.day += duration.days || 0;
  mutableDate.day += days;
  $735220c2d4774dd3$var$balanceDay(mutableDate);
  if (mutableDate.calendar.balanceDate) mutableDate.calendar.balanceDate(mutableDate);
  if (mutableDate.year < 1) {
    mutableDate.year = 1;
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxYear = mutableDate.calendar.getYearsInEra(mutableDate);
  if (mutableDate.year > maxYear) {
    var _mutableDate_calendar_isInverseEra, _mutableDate_calendar;
    let isInverseEra = (_mutableDate_calendar_isInverseEra = (_mutableDate_calendar = mutableDate.calendar).isInverseEra) === null || _mutableDate_calendar_isInverseEra === void 0 ? void 0 : _mutableDate_calendar_isInverseEra.call(_mutableDate_calendar, mutableDate);
    mutableDate.year = maxYear;
    mutableDate.month = isInverseEra ? 1 : mutableDate.calendar.getMonthsInYear(mutableDate);
    mutableDate.day = isInverseEra ? 1 : mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  if (mutableDate.month < 1) {
    mutableDate.month = 1;
    mutableDate.day = 1;
  }
  let maxMonth = mutableDate.calendar.getMonthsInYear(mutableDate);
  if (mutableDate.month > maxMonth) {
    mutableDate.month = maxMonth;
    mutableDate.day = mutableDate.calendar.getDaysInMonth(mutableDate);
  }
  mutableDate.day = Math.max(1, Math.min(mutableDate.calendar.getDaysInMonth(mutableDate), mutableDate.day));
  return mutableDate;
}
function $735220c2d4774dd3$var$addYears(date, years) {
  var _date_calendar_isInverseEra, _date_calendar;
  if ((_date_calendar_isInverseEra = (_date_calendar = date.calendar).isInverseEra) === null || _date_calendar_isInverseEra === void 0 ? void 0 : _date_calendar_isInverseEra.call(_date_calendar, date)) years = -years;
  date.year += years;
}
function $735220c2d4774dd3$var$balanceYearMonth(date) {
  while (date.month < 1) {
    $735220c2d4774dd3$var$addYears(date, -1);
    date.month += date.calendar.getMonthsInYear(date);
  }
  let monthsInYear = 0;
  while (date.month > (monthsInYear = date.calendar.getMonthsInYear(date))) {
    date.month -= monthsInYear;
    $735220c2d4774dd3$var$addYears(date, 1);
  }
}
function $735220c2d4774dd3$var$balanceDay(date) {
  while (date.day < 1) {
    date.month--;
    $735220c2d4774dd3$var$balanceYearMonth(date);
    date.day += date.calendar.getDaysInMonth(date);
  }
  while (date.day > date.calendar.getDaysInMonth(date)) {
    date.day -= date.calendar.getDaysInMonth(date);
    date.month++;
    $735220c2d4774dd3$var$balanceYearMonth(date);
  }
}
function $735220c2d4774dd3$var$constrainMonthDay(date) {
  date.month = Math.max(1, Math.min(date.calendar.getMonthsInYear(date), date.month));
  date.day = Math.max(1, Math.min(date.calendar.getDaysInMonth(date), date.day));
}
function $735220c2d4774dd3$export$c4e2ecac49351ef2(date) {
  if (date.calendar.constrainDate) date.calendar.constrainDate(date);
  date.year = Math.max(1, Math.min(date.calendar.getYearsInEra(date), date.year));
  $735220c2d4774dd3$var$constrainMonthDay(date);
}
function $735220c2d4774dd3$export$3e2544e88a25bff8(duration) {
  let inverseDuration = {};
  for (let key in duration) if (typeof duration[key] === "number") inverseDuration[key] = -duration[key];
  return inverseDuration;
}
function $735220c2d4774dd3$export$4e2d2ead65e5f7e3(date, duration) {
  return $735220c2d4774dd3$export$e16d8520af44a096(date, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
function $735220c2d4774dd3$export$adaa4cf7ef1b65be(date, fields) {
  let mutableDate = date.copy();
  if (fields.era != null) mutableDate.era = fields.era;
  if (fields.year != null) mutableDate.year = fields.year;
  if (fields.month != null) mutableDate.month = fields.month;
  if (fields.day != null) mutableDate.day = fields.day;
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutableDate);
  return mutableDate;
}
function $735220c2d4774dd3$export$e5d5e1c1822b6e56(value, fields) {
  let mutableValue = value.copy();
  if (fields.hour != null) mutableValue.hour = fields.hour;
  if (fields.minute != null) mutableValue.minute = fields.minute;
  if (fields.second != null) mutableValue.second = fields.second;
  if (fields.millisecond != null) mutableValue.millisecond = fields.millisecond;
  $735220c2d4774dd3$export$7555de1e070510cb(mutableValue);
  return mutableValue;
}
function $735220c2d4774dd3$var$balanceTime(time) {
  time.second += Math.floor(time.millisecond / 1e3);
  time.millisecond = $735220c2d4774dd3$var$nonNegativeMod(time.millisecond, 1e3);
  time.minute += Math.floor(time.second / 60);
  time.second = $735220c2d4774dd3$var$nonNegativeMod(time.second, 60);
  time.hour += Math.floor(time.minute / 60);
  time.minute = $735220c2d4774dd3$var$nonNegativeMod(time.minute, 60);
  let days = Math.floor(time.hour / 24);
  time.hour = $735220c2d4774dd3$var$nonNegativeMod(time.hour, 24);
  return days;
}
function $735220c2d4774dd3$export$7555de1e070510cb(time) {
  time.millisecond = Math.max(0, Math.min(time.millisecond, 1e3));
  time.second = Math.max(0, Math.min(time.second, 59));
  time.minute = Math.max(0, Math.min(time.minute, 59));
  time.hour = Math.max(0, Math.min(time.hour, 23));
}
function $735220c2d4774dd3$var$nonNegativeMod(a, b) {
  let result = a % b;
  if (result < 0) result += b;
  return result;
}
function $735220c2d4774dd3$var$addTimeFields(time, duration) {
  time.hour += duration.hours || 0;
  time.minute += duration.minutes || 0;
  time.second += duration.seconds || 0;
  time.millisecond += duration.milliseconds || 0;
  return $735220c2d4774dd3$var$balanceTime(time);
}
function $735220c2d4774dd3$export$7ed87b6bc2506470(time, duration) {
  let res = time.copy();
  $735220c2d4774dd3$var$addTimeFields(res, duration);
  return res;
}
function $735220c2d4774dd3$export$fe34d3a381cd7501(time, duration) {
  return $735220c2d4774dd3$export$7ed87b6bc2506470(time, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
function $735220c2d4774dd3$export$d52ced6badfb9a4c(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "era": {
      let eras = value.calendar.getEras();
      let eraIndex = eras.indexOf(value.era);
      if (eraIndex < 0) throw new Error("Invalid era: " + value.era);
      eraIndex = $735220c2d4774dd3$var$cycleValue(eraIndex, amount, 0, eras.length - 1, options === null || options === void 0 ? void 0 : options.round);
      mutable.era = eras[eraIndex];
      $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
      break;
    }
    case "year":
      var _mutable_calendar_isInverseEra, _mutable_calendar;
      if ((_mutable_calendar_isInverseEra = (_mutable_calendar = mutable.calendar).isInverseEra) === null || _mutable_calendar_isInverseEra === void 0 ? void 0 : _mutable_calendar_isInverseEra.call(_mutable_calendar, mutable)) amount = -amount;
      mutable.year = $735220c2d4774dd3$var$cycleValue(value.year, amount, -Infinity, 9999, options === null || options === void 0 ? void 0 : options.round);
      if (mutable.year === -Infinity) mutable.year = 1;
      if (mutable.calendar.balanceYearMonth) mutable.calendar.balanceYearMonth(mutable, value);
      break;
    case "month":
      mutable.month = $735220c2d4774dd3$var$cycleValue(value.month, amount, 1, value.calendar.getMonthsInYear(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    case "day":
      mutable.day = $735220c2d4774dd3$var$cycleValue(value.day, amount, 1, value.calendar.getDaysInMonth(value), options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  if (value.calendar.balanceDate) value.calendar.balanceDate(mutable);
  $735220c2d4774dd3$export$c4e2ecac49351ef2(mutable);
  return mutable;
}
function $735220c2d4774dd3$export$dd02b3e0007dfe28(value, field, amount, options) {
  let mutable = value.copy();
  switch (field) {
    case "hour": {
      let hours = value.hour;
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = hours >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      mutable.hour = $735220c2d4774dd3$var$cycleValue(hours, amount, min2, max2, options === null || options === void 0 ? void 0 : options.round);
      break;
    }
    case "minute":
      mutable.minute = $735220c2d4774dd3$var$cycleValue(value.minute, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "second":
      mutable.second = $735220c2d4774dd3$var$cycleValue(value.second, amount, 0, 59, options === null || options === void 0 ? void 0 : options.round);
      break;
    case "millisecond":
      mutable.millisecond = $735220c2d4774dd3$var$cycleValue(value.millisecond, amount, 0, 999, options === null || options === void 0 ? void 0 : options.round);
      break;
    default:
      throw new Error("Unsupported field " + field);
  }
  return mutable;
}
function $735220c2d4774dd3$var$cycleValue(value, amount, min2, max2, round2 = false) {
  if (round2) {
    value += Math.sign(amount);
    if (value < min2) value = max2;
    let div = Math.abs(amount);
    if (amount > 0) value = Math.ceil(value / div) * div;
    else value = Math.floor(value / div) * div;
    if (value > max2) value = min2;
  } else {
    value += amount;
    if (value < min2) value = max2 - (min2 - value - 1);
    else if (value > max2) value = min2 + (value - max2 - 1);
  }
  return value;
}
function $735220c2d4774dd3$export$96b1d28349274637(dateTime, duration) {
  let ms;
  if (duration.years != null && duration.years !== 0 || duration.months != null && duration.months !== 0 || duration.weeks != null && duration.weeks !== 0 || duration.days != null && duration.days !== 0) {
    let res2 = $735220c2d4774dd3$export$e16d8520af44a096((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), {
      years: duration.years,
      months: duration.months,
      weeks: duration.weeks,
      days: duration.days
    });
    ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res2, dateTime.timeZone);
  } else
    ms = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
  ms += duration.milliseconds || 0;
  ms += (duration.seconds || 0) * 1e3;
  ms += (duration.minutes || 0) * 6e4;
  ms += (duration.hours || 0) * 36e5;
  let res = (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(res, dateTime.calendar);
}
function $735220c2d4774dd3$export$6814caac34ca03c7(dateTime, duration) {
  return $735220c2d4774dd3$export$96b1d28349274637(dateTime, $735220c2d4774dd3$export$3e2544e88a25bff8(duration));
}
function $735220c2d4774dd3$export$9a297d111fc86b79(dateTime, field, amount, options) {
  switch (field) {
    case "hour": {
      let min2 = 0;
      let max2 = 23;
      if ((options === null || options === void 0 ? void 0 : options.hourCycle) === 12) {
        let isPM = dateTime.hour >= 12;
        min2 = isPM ? 12 : 0;
        max2 = isPM ? 23 : 11;
      }
      let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
      let minDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: min2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let minAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(minDate, dateTime.timeZone, "later")
      ].filter((ms2) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone).day === minDate.day)[0];
      let maxDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)($735220c2d4774dd3$export$e5d5e1c1822b6e56(plainDateTime, {
        hour: max2
      }), new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
      let maxAbsolute = [
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "earlier"),
        (0, $11d87f3f76e88657$export$5107c82f94518f5c)(maxDate, dateTime.timeZone, "later")
      ].filter((ms2) => (0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms2, dateTime.timeZone).day === maxDate.day).pop();
      let ms = (0, $11d87f3f76e88657$export$bd4fb2bc8bb06fb)(dateTime) - dateTime.offset;
      let hours = Math.floor(ms / $735220c2d4774dd3$var$ONE_HOUR);
      let remainder = ms % $735220c2d4774dd3$var$ONE_HOUR;
      ms = $735220c2d4774dd3$var$cycleValue(hours, amount, Math.floor(minAbsolute / $735220c2d4774dd3$var$ONE_HOUR), Math.floor(maxAbsolute / $735220c2d4774dd3$var$ONE_HOUR), options === null || options === void 0 ? void 0 : options.round) * $735220c2d4774dd3$var$ONE_HOUR + remainder;
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
    }
    case "minute":
    case "second":
    case "millisecond":
      return $735220c2d4774dd3$export$dd02b3e0007dfe28(dateTime, field, amount, options);
    case "era":
    case "year":
    case "month":
    case "day": {
      let res = $735220c2d4774dd3$export$d52ced6badfb9a4c((0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime), field, amount, options);
      let ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone);
      return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
    }
    default:
      throw new Error("Unsupported field " + field);
  }
}
function $735220c2d4774dd3$export$31b5430eb18be4f8(dateTime, fields, disambiguation) {
  let plainDateTime = (0, $11d87f3f76e88657$export$b21e0b124e224484)(dateTime);
  let res = $735220c2d4774dd3$export$e5d5e1c1822b6e56($735220c2d4774dd3$export$adaa4cf7ef1b65be(plainDateTime, fields), fields);
  if (res.compare(plainDateTime) === 0) return dateTime;
  let ms = (0, $11d87f3f76e88657$export$5107c82f94518f5c)(res, dateTime.timeZone, disambiguation);
  return (0, $11d87f3f76e88657$export$b4a036af3fc0b032)((0, $11d87f3f76e88657$export$1b96692a1ba042ac)(ms, dateTime.timeZone), dateTime.calendar);
}

// node_modules/@internationalized/date/dist/string.mjs
var $fae977aafc393c5c$var$requiredDurationTimeGroups = [
  "hours",
  "minutes",
  "seconds"
];
var $fae977aafc393c5c$var$requiredDurationGroups = [
  "years",
  "months",
  "weeks",
  "days",
  ...$fae977aafc393c5c$var$requiredDurationTimeGroups
];
function $fae977aafc393c5c$export$f59dee82248f5ad4(time) {
  return `${String(time.hour).padStart(2, "0")}:${String(time.minute).padStart(2, "0")}:${String(time.second).padStart(2, "0")}${time.millisecond ? String(time.millisecond / 1e3).slice(1) : ""}`;
}
function $fae977aafc393c5c$export$60dfd74aa96791bd(date) {
  let gregorianDate = (0, $11d87f3f76e88657$export$b4a036af3fc0b032)(date, new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)());
  let year;
  if (gregorianDate.era === "BC") year = gregorianDate.year === 1 ? "0000" : "-" + String(Math.abs(1 - gregorianDate.year)).padStart(6, "00");
  else year = String(gregorianDate.year).padStart(4, "0");
  return `${year}-${String(gregorianDate.month).padStart(2, "0")}-${String(gregorianDate.day).padStart(2, "0")}`;
}
function $fae977aafc393c5c$export$4223de14708adc63(date) {
  return `${$fae977aafc393c5c$export$60dfd74aa96791bd(date)}T${$fae977aafc393c5c$export$f59dee82248f5ad4(date)}`;
}
function $fae977aafc393c5c$var$offsetToString(offset3) {
  let sign = Math.sign(offset3) < 0 ? "-" : "+";
  offset3 = Math.abs(offset3);
  let offsetHours = Math.floor(offset3 / 36e5);
  let offsetMinutes = Math.floor(offset3 % 36e5 / 6e4);
  let offsetSeconds = Math.floor(offset3 % 36e5 % 6e4 / 1e3);
  let stringOffset = `${sign}${String(offsetHours).padStart(2, "0")}:${String(offsetMinutes).padStart(2, "0")}`;
  if (offsetSeconds !== 0) stringOffset += `:${String(offsetSeconds).padStart(2, "0")}`;
  return stringOffset;
}
function $fae977aafc393c5c$export$bf79f1ebf4b18792(date) {
  return `${$fae977aafc393c5c$export$4223de14708adc63(date)}${$fae977aafc393c5c$var$offsetToString(date.offset)}[${date.timeZone}]`;
}

// node_modules/@swc/helpers/esm/_check_private_redeclaration.js
function _check_private_redeclaration(obj, privateCollection) {
  if (privateCollection.has(obj)) {
    throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
}

// node_modules/@swc/helpers/esm/_class_private_field_init.js
function _class_private_field_init(obj, privateMap, value) {
  _check_private_redeclaration(obj, privateMap);
  privateMap.set(obj, value);
}

// node_modules/@internationalized/date/dist/CalendarDate.mjs
function $35ea8db9cb2ccb90$var$shiftArgs(args) {
  let calendar = typeof args[0] === "object" ? args.shift() : new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)();
  let era;
  if (typeof args[0] === "string") era = args.shift();
  else {
    let eras = calendar.getEras();
    era = eras[eras.length - 1];
  }
  let year = args.shift();
  let month = args.shift();
  let day = args.shift();
  return [
    calendar,
    era,
    year,
    month,
    day
  ];
}
var $35ea8db9cb2ccb90$var$_type = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$99faa760c7908e4f = class _$35ea8db9cb2ccb90$export$99faa760c7908e4f {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.era, this.year, this.month, this.day);
    else return new _$35ea8db9cb2ccb90$export$99faa760c7908e4f(this.calendar, this.year, this.month, this.day);
  }
  /** Returns a new `CalendarDate` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDate` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)(this, fields);
  }
  /**
  * Returns a new `CalendarDate` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object, with the time set to midnight in the given time zone. */
  toDate(timeZone) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$60dfd74aa96791bd)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    return (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b);
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};
var $35ea8db9cb2ccb90$var$_type1 = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$680ea196effce5f = class _$35ea8db9cb2ccb90$export$680ea196effce5f {
  /** Returns a copy of this time. */
  copy() {
    return new _$35ea8db9cb2ccb90$export$680ea196effce5f(this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `Time` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$7ed87b6bc2506470)(this, duration);
  }
  /** Returns a new `Time` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$fe34d3a381cd7501)(this, duration);
  }
  /** Returns a new `Time` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$e5d5e1c1822b6e56)(this, fields);
  }
  /**
  * Returns a new `Time` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$dd02b3e0007dfe28)(this, field, amount, options);
  }
  /** Converts the time to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$f59dee82248f5ad4)(this);
  }
  /** Compares this time with another. A negative result indicates that this time is before the given one, and a positive time indicates that it is after. */
  compare(b) {
    return (0, $14e0f24ef4ac5c92$export$c19a80a9721b80f6)(this, b);
  }
  constructor(hour = 0, minute = 0, second = 0, millisecond = 0) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type1, {
      writable: true,
      value: void 0
    });
    this.hour = hour;
    this.minute = minute;
    this.second = second;
    this.millisecond = millisecond;
    (0, $735220c2d4774dd3$export$7555de1e070510cb)(this);
  }
};
var $35ea8db9cb2ccb90$var$_type2 = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$ca871e8dbb80966f = class _$35ea8db9cb2ccb90$export$ca871e8dbb80966f {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.era, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    else return new _$35ea8db9cb2ccb90$export$ca871e8dbb80966f(this.calendar, this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `CalendarDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$e16d8520af44a096)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$4e2d2ead65e5f7e3)(this, duration);
  }
  /** Returns a new `CalendarDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields) {
    return (0, $735220c2d4774dd3$export$adaa4cf7ef1b65be)((0, $735220c2d4774dd3$export$e5d5e1c1822b6e56)(this, fields), fields);
  }
  /**
  * Returns a new `CalendarDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    switch (field) {
      case "era":
      case "year":
      case "month":
      case "day":
        return (0, $735220c2d4774dd3$export$d52ced6badfb9a4c)(this, field, amount, options);
      default:
        return (0, $735220c2d4774dd3$export$dd02b3e0007dfe28)(this, field, amount, options);
    }
  }
  /** Converts the date to a native JavaScript Date object in the given time zone. */
  toDate(timeZone, disambiguation) {
    return (0, $11d87f3f76e88657$export$e67a095c620b86fe)(this, timeZone, disambiguation);
  }
  /** Converts the date to an ISO 8601 formatted string. */
  toString() {
    return (0, $fae977aafc393c5c$export$4223de14708adc63)(this);
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    let res = (0, $14e0f24ef4ac5c92$export$68781ddf31c0090f)(this, b);
    if (res === 0) return (0, $14e0f24ef4ac5c92$export$c19a80a9721b80f6)(this, (0, $11d87f3f76e88657$export$b21e0b124e224484)(b));
    return res;
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type2, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};
var $35ea8db9cb2ccb90$var$_type3 = /* @__PURE__ */ new WeakMap();
var $35ea8db9cb2ccb90$export$d3b7288e7994edea = class _$35ea8db9cb2ccb90$export$d3b7288e7994edea {
  /** Returns a copy of this date. */
  copy() {
    if (this.era) return new _$35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.era, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
    else return new _$35ea8db9cb2ccb90$export$d3b7288e7994edea(this.calendar, this.year, this.month, this.day, this.timeZone, this.offset, this.hour, this.minute, this.second, this.millisecond);
  }
  /** Returns a new `ZonedDateTime` with the given duration added to it. */
  add(duration) {
    return (0, $735220c2d4774dd3$export$96b1d28349274637)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given duration subtracted from it. */
  subtract(duration) {
    return (0, $735220c2d4774dd3$export$6814caac34ca03c7)(this, duration);
  }
  /** Returns a new `ZonedDateTime` with the given fields set to the provided values. Other fields will be constrained accordingly. */
  set(fields, disambiguation) {
    return (0, $735220c2d4774dd3$export$31b5430eb18be4f8)(this, fields, disambiguation);
  }
  /**
  * Returns a new `ZonedDateTime` with the given field adjusted by a specified amount.
  * When the resulting value reaches the limits of the field, it wraps around.
  */
  cycle(field, amount, options) {
    return (0, $735220c2d4774dd3$export$9a297d111fc86b79)(this, field, amount, options);
  }
  /** Converts the date to a native JavaScript Date object. */
  toDate() {
    return (0, $11d87f3f76e88657$export$83aac07b4c37b25)(this);
  }
  /** Converts the date to an ISO 8601 formatted string, including the UTC offset and time zone identifier. */
  toString() {
    return (0, $fae977aafc393c5c$export$bf79f1ebf4b18792)(this);
  }
  /** Converts the date to an ISO 8601 formatted string in UTC. */
  toAbsoluteString() {
    return this.toDate().toISOString();
  }
  /** Compares this date with another. A negative result indicates that this date is before the given one, and a positive date indicates that it is after. */
  compare(b) {
    return this.toDate().getTime() - (0, $11d87f3f76e88657$export$84c95a83c799e074)(b, this.timeZone).toDate().getTime();
  }
  constructor(...args) {
    (0, _class_private_field_init)(this, $35ea8db9cb2ccb90$var$_type3, {
      writable: true,
      value: void 0
    });
    let [calendar, era, year, month, day] = $35ea8db9cb2ccb90$var$shiftArgs(args);
    let timeZone = args.shift();
    let offset3 = args.shift();
    this.calendar = calendar;
    this.era = era;
    this.year = year;
    this.month = month;
    this.day = day;
    this.timeZone = timeZone;
    this.offset = offset3;
    this.hour = args.shift() || 0;
    this.minute = args.shift() || 0;
    this.second = args.shift() || 0;
    this.millisecond = args.shift() || 0;
    (0, $735220c2d4774dd3$export$c4e2ecac49351ef2)(this);
  }
};

// node_modules/@internationalized/date/dist/JapaneseCalendar.mjs
var $62225008020f0a13$var$ERA_START_DATES = [
  [
    1868,
    9,
    8
  ],
  [
    1912,
    7,
    30
  ],
  [
    1926,
    12,
    25
  ],
  [
    1989,
    1,
    8
  ],
  [
    2019,
    5,
    1
  ]
];
var $62225008020f0a13$var$ERA_END_DATES = [
  [
    1912,
    7,
    29
  ],
  [
    1926,
    12,
    24
  ],
  [
    1989,
    1,
    7
  ],
  [
    2019,
    4,
    30
  ]
];
var $62225008020f0a13$var$ERA_ADDENDS = [
  1867,
  1911,
  1925,
  1988,
  2018
];
var $62225008020f0a13$var$ERA_NAMES = [
  "meiji",
  "taisho",
  "showa",
  "heisei",
  "reiwa"
];
function $62225008020f0a13$var$findEraFromGregorianDate(date) {
  const idx = $62225008020f0a13$var$ERA_START_DATES.findIndex(([year, month, day]) => {
    if (date.year < year) return true;
    if (date.year === year && date.month < month) return true;
    if (date.year === year && date.month === month && date.day < day) return true;
    return false;
  });
  if (idx === -1) return $62225008020f0a13$var$ERA_START_DATES.length - 1;
  if (idx === 0) return 0;
  return idx - 1;
}
function $62225008020f0a13$var$toGregorian(date) {
  let eraAddend = $62225008020f0a13$var$ERA_ADDENDS[$62225008020f0a13$var$ERA_NAMES.indexOf(date.era)];
  if (!eraAddend) throw new Error("Unknown era: " + date.era);
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(date.year + eraAddend, date.month, date.day);
}
var $62225008020f0a13$export$b746ab2b60cdffbf = class extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let era = $62225008020f0a13$var$findEraFromGregorianDate(date);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, $62225008020f0a13$var$ERA_NAMES[era], date.year - $62225008020f0a13$var$ERA_ADDENDS[era], date.month, date.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($62225008020f0a13$var$toGregorian(date));
  }
  balanceDate(date) {
    let gregorianDate = $62225008020f0a13$var$toGregorian(date);
    let era = $62225008020f0a13$var$findEraFromGregorianDate(gregorianDate);
    if ($62225008020f0a13$var$ERA_NAMES[era] !== date.era) {
      date.era = $62225008020f0a13$var$ERA_NAMES[era];
      date.year = gregorianDate.year - $62225008020f0a13$var$ERA_ADDENDS[era];
    }
    this.constrainDate(date);
  }
  constrainDate(date) {
    let idx = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    let end = $62225008020f0a13$var$ERA_END_DATES[idx];
    if (end != null) {
      let [endYear, endMonth, endDay] = end;
      let maxYear = endYear - $62225008020f0a13$var$ERA_ADDENDS[idx];
      date.year = Math.max(1, Math.min(maxYear, date.year));
      if (date.year === maxYear) {
        date.month = Math.min(endMonth, date.month);
        if (date.month === endMonth) date.day = Math.min(endDay, date.day);
      }
    }
    if (date.year === 1 && idx >= 0) {
      let [, startMonth, startDay] = $62225008020f0a13$var$ERA_START_DATES[idx];
      date.month = Math.max(startMonth, date.month);
      if (date.month === startMonth) date.day = Math.max(startDay, date.day);
    }
  }
  getEras() {
    return $62225008020f0a13$var$ERA_NAMES;
  }
  getYearsInEra(date) {
    let era = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    let cur = $62225008020f0a13$var$ERA_START_DATES[era];
    let next = $62225008020f0a13$var$ERA_START_DATES[era + 1];
    if (next == null)
      return 9999 - cur[0] + 1;
    let years = next[0] - cur[0];
    if (date.month < next[1] || date.month === next[1] && date.day < next[2]) years++;
    return years;
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($62225008020f0a13$var$toGregorian(date));
  }
  getMinimumMonthInYear(date) {
    let start = $62225008020f0a13$var$getMinimums(date);
    return start ? start[1] : 1;
  }
  getMinimumDayInMonth(date) {
    let start = $62225008020f0a13$var$getMinimums(date);
    return start && date.month === start[1] ? start[2] : 1;
  }
  constructor(...args) {
    super(...args), this.identifier = "japanese";
  }
};
function $62225008020f0a13$var$getMinimums(date) {
  if (date.year === 1) {
    let idx = $62225008020f0a13$var$ERA_NAMES.indexOf(date.era);
    return $62225008020f0a13$var$ERA_START_DATES[idx];
  }
}

// node_modules/@internationalized/date/dist/BuddhistCalendar.mjs
var $8d73d47422ca7302$var$BUDDHIST_ERA_START = -543;
var $8d73d47422ca7302$export$42d20a78301dee44 = class extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  fromJulianDay(jd) {
    let gregorianDate = super.fromJulianDay(jd);
    let year = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(gregorianDate.era, gregorianDate.year);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year - $8d73d47422ca7302$var$BUDDHIST_ERA_START, gregorianDate.month, gregorianDate.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($8d73d47422ca7302$var$toGregorian(date));
  }
  getEras() {
    return [
      "BE"
    ];
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($8d73d47422ca7302$var$toGregorian(date));
  }
  balanceDate() {
  }
  constructor(...args) {
    super(...args), this.identifier = "buddhist";
  }
};
function $8d73d47422ca7302$var$toGregorian(date) {
  let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)(date.year + $8d73d47422ca7302$var$BUDDHIST_ERA_START);
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, date.month, date.day);
}

// node_modules/@internationalized/date/dist/TaiwanCalendar.mjs
var $5f31bd6f0c8940b2$var$TAIWAN_ERA_START = 1911;
function $5f31bd6f0c8940b2$var$gregorianYear(date) {
  return date.era === "minguo" ? date.year + $5f31bd6f0c8940b2$var$TAIWAN_ERA_START : 1 - date.year + $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
}
function $5f31bd6f0c8940b2$var$gregorianToTaiwan(year) {
  let y = year - $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
  if (y > 0) return [
    "minguo",
    y
  ];
  else return [
    "before_minguo",
    1 - y
  ];
}
var $5f31bd6f0c8940b2$export$65e01080afcb0799 = class extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let extendedYear = (0, $3b62074eb05584b2$export$c36e0ecb2d4fa69d)(date.era, date.year);
    let [era, year] = $5f31bd6f0c8940b2$var$gregorianToTaiwan(extendedYear);
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, date.month, date.day);
  }
  toJulianDay(date) {
    return super.toJulianDay($5f31bd6f0c8940b2$var$toGregorian(date));
  }
  getEras() {
    return [
      "before_minguo",
      "minguo"
    ];
  }
  balanceDate(date) {
    let [era, year] = $5f31bd6f0c8940b2$var$gregorianToTaiwan($5f31bd6f0c8940b2$var$gregorianYear(date));
    date.era = era;
    date.year = year;
  }
  isInverseEra(date) {
    return date.era === "before_minguo";
  }
  getDaysInMonth(date) {
    return super.getDaysInMonth($5f31bd6f0c8940b2$var$toGregorian(date));
  }
  getYearsInEra(date) {
    return date.era === "before_minguo" ? 9999 : 9999 - $5f31bd6f0c8940b2$var$TAIWAN_ERA_START;
  }
  constructor(...args) {
    super(...args), this.identifier = "roc";
  }
};
function $5f31bd6f0c8940b2$var$toGregorian(date) {
  let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)($5f31bd6f0c8940b2$var$gregorianYear(date));
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(era, year, date.month, date.day);
}

// node_modules/@internationalized/date/dist/PersianCalendar.mjs
var $f3ed2e4472ae7e25$var$PERSIAN_EPOCH = 1948320;
var $f3ed2e4472ae7e25$var$MONTH_START = [
  0,
  31,
  62,
  93,
  124,
  155,
  186,
  216,
  246,
  276,
  306,
  336
  // Esfand
];
var $f3ed2e4472ae7e25$export$37fccdbfd14c5939 = class {
  fromJulianDay(jd) {
    let daysSinceEpoch = jd - $f3ed2e4472ae7e25$var$PERSIAN_EPOCH;
    let year = 1 + Math.floor((33 * daysSinceEpoch + 3) / 12053);
    let farvardin1 = 365 * (year - 1) + Math.floor((8 * year + 21) / 33);
    let dayOfYear = daysSinceEpoch - farvardin1;
    let month = dayOfYear < 216 ? Math.floor(dayOfYear / 31) : Math.floor((dayOfYear - 6) / 30);
    let day = dayOfYear - $f3ed2e4472ae7e25$var$MONTH_START[month] + 1;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year, month + 1, day);
  }
  toJulianDay(date) {
    let jd = $f3ed2e4472ae7e25$var$PERSIAN_EPOCH - 1 + 365 * (date.year - 1) + Math.floor((8 * date.year + 21) / 33);
    jd += $f3ed2e4472ae7e25$var$MONTH_START[date.month - 1];
    jd += date.day;
    return jd;
  }
  getMonthsInYear() {
    return 12;
  }
  getDaysInMonth(date) {
    if (date.month <= 6) return 31;
    if (date.month <= 11) return 30;
    let isLeapYear = (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(25 * date.year + 11, 33) < 8;
    return isLeapYear ? 30 : 29;
  }
  getEras() {
    return [
      "AP"
    ];
  }
  getYearsInEra() {
    return 9377;
  }
  constructor() {
    this.identifier = "persian";
  }
};

// node_modules/@internationalized/date/dist/IndianCalendar.mjs
var $82c358003bdda0a8$var$INDIAN_ERA_START = 78;
var $82c358003bdda0a8$var$INDIAN_YEAR_START = 80;
var $82c358003bdda0a8$export$39f31c639fa15726 = class extends (0, $3b62074eb05584b2$export$80ee6245ec4f29ec) {
  fromJulianDay(jd) {
    let date = super.fromJulianDay(jd);
    let indianYear = date.year - $82c358003bdda0a8$var$INDIAN_ERA_START;
    let yDay = jd - (0, $3b62074eb05584b2$export$f297eb839006d339)(date.era, date.year, 1, 1);
    let leapMonth;
    if (yDay < $82c358003bdda0a8$var$INDIAN_YEAR_START) {
      indianYear--;
      leapMonth = (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year - 1) ? 31 : 30;
      yDay += leapMonth + 155 + 90 + 10;
    } else {
      leapMonth = (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year) ? 31 : 30;
      yDay -= $82c358003bdda0a8$var$INDIAN_YEAR_START;
    }
    let indianMonth;
    let indianDay;
    if (yDay < leapMonth) {
      indianMonth = 1;
      indianDay = yDay + 1;
    } else {
      let mDay = yDay - leapMonth;
      if (mDay < 155) {
        indianMonth = Math.floor(mDay / 31) + 2;
        indianDay = mDay % 31 + 1;
      } else {
        mDay -= 155;
        indianMonth = Math.floor(mDay / 30) + 7;
        indianDay = mDay % 30 + 1;
      }
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, indianYear, indianMonth, indianDay);
  }
  toJulianDay(date) {
    let extendedYear = date.year + $82c358003bdda0a8$var$INDIAN_ERA_START;
    let [era, year] = (0, $3b62074eb05584b2$export$4475b7e617eb123c)(extendedYear);
    let leapMonth;
    let jd;
    if ((0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(year)) {
      leapMonth = 31;
      jd = (0, $3b62074eb05584b2$export$f297eb839006d339)(era, year, 3, 21);
    } else {
      leapMonth = 30;
      jd = (0, $3b62074eb05584b2$export$f297eb839006d339)(era, year, 3, 22);
    }
    if (date.month === 1) return jd + date.day - 1;
    jd += leapMonth + Math.min(date.month - 2, 5) * 31;
    if (date.month >= 8) jd += (date.month - 7) * 30;
    jd += date.day - 1;
    return jd;
  }
  getDaysInMonth(date) {
    if (date.month === 1 && (0, $3b62074eb05584b2$export$553d7fa8e3805fc0)(date.year + $82c358003bdda0a8$var$INDIAN_ERA_START)) return 31;
    if (date.month >= 2 && date.month <= 6) return 31;
    return 30;
  }
  getYearsInEra() {
    return 9919;
  }
  getEras() {
    return [
      "saka"
    ];
  }
  balanceDate() {
  }
  constructor(...args) {
    super(...args), this.identifier = "indian";
  }
};

// node_modules/@internationalized/date/dist/IslamicCalendar.mjs
var $f2f3e0e3a817edbd$var$CIVIL_EPOC = 1948440;
var $f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC = 1948439;
var $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START = 1300;
var $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END = 1600;
var $f2f3e0e3a817edbd$var$UMALQURA_START_DAYS = 460322;
function $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, month, day) {
  return day + Math.ceil(29.5 * (month - 1)) + (year - 1) * 354 + Math.floor((3 + 11 * year) / 30) + epoch - 1;
}
function $f2f3e0e3a817edbd$var$julianDayToIslamic(calendar, epoch, jd) {
  let year = Math.floor((30 * (jd - epoch) + 10646) / 10631);
  let month = Math.min(12, Math.ceil((jd - (29 + $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, 1, 1))) / 29.5) + 1);
  let day = jd - $f2f3e0e3a817edbd$var$islamicToJulianDay(epoch, year, month, 1) + 1;
  return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(calendar, year, month, day);
}
function $f2f3e0e3a817edbd$var$isLeapYear(year) {
  return (14 + 11 * year) % 30 < 11;
}
var $f2f3e0e3a817edbd$export$2066795aadd37bfc = class {
  fromJulianDay(jd) {
    return $f2f3e0e3a817edbd$var$julianDayToIslamic(this, $f2f3e0e3a817edbd$var$CIVIL_EPOC, jd);
  }
  toJulianDay(date) {
    return $f2f3e0e3a817edbd$var$islamicToJulianDay($f2f3e0e3a817edbd$var$CIVIL_EPOC, date.year, date.month, date.day);
  }
  getDaysInMonth(date) {
    let length = 29 + date.month % 2;
    if (date.month === 12 && $f2f3e0e3a817edbd$var$isLeapYear(date.year)) length++;
    return length;
  }
  getMonthsInYear() {
    return 12;
  }
  getDaysInYear(date) {
    return $f2f3e0e3a817edbd$var$isLeapYear(date.year) ? 355 : 354;
  }
  getYearsInEra() {
    return 9665;
  }
  getEras() {
    return [
      "AH"
    ];
  }
  constructor() {
    this.identifier = "islamic-civil";
  }
};
var $f2f3e0e3a817edbd$export$37f0887f2f9d22f7 = class extends $f2f3e0e3a817edbd$export$2066795aadd37bfc {
  fromJulianDay(jd) {
    return $f2f3e0e3a817edbd$var$julianDayToIslamic(this, $f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC, jd);
  }
  toJulianDay(date) {
    return $f2f3e0e3a817edbd$var$islamicToJulianDay($f2f3e0e3a817edbd$var$ASTRONOMICAL_EPOC, date.year, date.month, date.day);
  }
  constructor(...args) {
    super(...args), this.identifier = "islamic-tbla";
  }
};
var $f2f3e0e3a817edbd$var$UMALQURA_DATA = "qgpUDckO1AbqBmwDrQpVBakGkgepC9QF2gpcBS0NlQZKB1QLagutBa4ETwoXBYsGpQbVCtYCWwmdBE0KJg2VDawFtgm6AlsKKwWVCsoG6Qr0AnYJtgJWCcoKpAvSC9kF3AJtCU0FpQpSC6ULtAW2CVcFlwJLBaMGUgdlC2oFqworBZUMSg2lDcoF1gpXCasESwmlClILagt1BXYCtwhbBFUFqQW0BdoJ3QRuAjYJqgpUDbIN1QXaAlsJqwRVCkkLZAtxC7QFtQpVCiUNkg7JDtQG6QprCasEkwpJDaQNsg25CroEWworBZUKKgtVC1wFvQQ9Ah0JlQpKC1oLbQW2AjsJmwRVBqkGVAdqC2wFrQpVBSkLkgupC9QF2gpaBasKlQVJB2QHqgu1BbYCVgpNDiULUgtqC60FrgIvCZcESwalBqwG1gpdBZ0ETQoWDZUNqgW1BdoCWwmtBJUFygbkBuoK9QS2AlYJqgpUC9IL2QXqAm0JrQSVCkoLpQuyBbUJ1gSXCkcFkwZJB1ULagVrCisFiwpGDaMNygXWCtsEawJLCaUKUgtpC3UFdgG3CFsCKwVlBbQF2gntBG0BtgimClINqQ3UBdoKWwmrBFMGKQdiB6kLsgW1ClUFJQuSDckO0gbpCmsFqwRVCikNVA2qDbUJugQ7CpsETQqqCtUK2gJdCV4ELgqaDFUNsga5BroEXQotBZUKUguoC7QLuQXaAloJSgukDdEO6AZqC20FNQWVBkoNqA3UDdoGWwWdAisGFQtKC5ULqgWuCi4JjwwnBZUGqgbWCl0FnQI=";
var $f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH;
var $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE;
function $f2f3e0e3a817edbd$var$umalquraYearStart(year) {
  return $f2f3e0e3a817edbd$var$UMALQURA_START_DAYS + $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START];
}
function $f2f3e0e3a817edbd$var$umalquraMonthLength(year, month) {
  let idx = year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START;
  let mask = 1 << 11 - (month - 1);
  if (($f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH[idx] & mask) === 0) return 29;
  else return 30;
}
function $f2f3e0e3a817edbd$var$umalquraMonthStart(year, month) {
  let day = $f2f3e0e3a817edbd$var$umalquraYearStart(year);
  for (let i = 1; i < month; i++) day += $f2f3e0e3a817edbd$var$umalquraMonthLength(year, i);
  return day;
}
function $f2f3e0e3a817edbd$var$umalquraYearLength(year) {
  return $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year + 1 - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START] - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START];
}
var $f2f3e0e3a817edbd$export$5baab4758c231076 = class extends $f2f3e0e3a817edbd$export$2066795aadd37bfc {
  fromJulianDay(jd) {
    let days = jd - $f2f3e0e3a817edbd$var$CIVIL_EPOC;
    let startDays = $f2f3e0e3a817edbd$var$umalquraYearStart($f2f3e0e3a817edbd$var$UMALQURA_YEAR_START);
    let endDays = $f2f3e0e3a817edbd$var$umalquraYearStart($f2f3e0e3a817edbd$var$UMALQURA_YEAR_END);
    if (days < startDays || days > endDays) return super.fromJulianDay(jd);
    else {
      let y = $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START - 1;
      let m = 1;
      let d = 1;
      while (d > 0) {
        y++;
        d = days - $f2f3e0e3a817edbd$var$umalquraYearStart(y) + 1;
        let yearLength = $f2f3e0e3a817edbd$var$umalquraYearLength(y);
        if (d === yearLength) {
          m = 12;
          break;
        } else if (d < yearLength) {
          let monthLength = $f2f3e0e3a817edbd$var$umalquraMonthLength(y, m);
          m = 1;
          while (d > monthLength) {
            d -= monthLength;
            m++;
            monthLength = $f2f3e0e3a817edbd$var$umalquraMonthLength(y, m);
          }
          break;
        }
      }
      return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, y, m, days - $f2f3e0e3a817edbd$var$umalquraMonthStart(y, m) + 1);
    }
  }
  toJulianDay(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.toJulianDay(date);
    return $f2f3e0e3a817edbd$var$CIVIL_EPOC + $f2f3e0e3a817edbd$var$umalquraMonthStart(date.year, date.month) + (date.day - 1);
  }
  getDaysInMonth(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.getDaysInMonth(date);
    return $f2f3e0e3a817edbd$var$umalquraMonthLength(date.year, date.month);
  }
  getDaysInYear(date) {
    if (date.year < $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START || date.year > $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END) return super.getDaysInYear(date);
    return $f2f3e0e3a817edbd$var$umalquraYearLength(date.year);
  }
  constructor() {
    super(), this.identifier = "islamic-umalqura";
    if (!$f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH) $f2f3e0e3a817edbd$var$UMALQURA_MONTHLENGTH = new Uint16Array(Uint8Array.from(atob($f2f3e0e3a817edbd$var$UMALQURA_DATA), (c2) => c2.charCodeAt(0)).buffer);
    if (!$f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE) {
      $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE = new Uint32Array($f2f3e0e3a817edbd$var$UMALQURA_YEAR_END - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START + 1);
      let yearStart = 0;
      for (let year = $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START; year <= $f2f3e0e3a817edbd$var$UMALQURA_YEAR_END; year++) {
        $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START_TABLE[year - $f2f3e0e3a817edbd$var$UMALQURA_YEAR_START] = yearStart;
        for (let i = 1; i <= 12; i++) yearStart += $f2f3e0e3a817edbd$var$umalquraMonthLength(year, i);
      }
    }
  }
};

// node_modules/@internationalized/date/dist/HebrewCalendar.mjs
var $7c5f6fbf42389787$var$HEBREW_EPOCH = 347997;
var $7c5f6fbf42389787$var$HOUR_PARTS = 1080;
var $7c5f6fbf42389787$var$DAY_PARTS = 24 * $7c5f6fbf42389787$var$HOUR_PARTS;
var $7c5f6fbf42389787$var$MONTH_DAYS = 29;
var $7c5f6fbf42389787$var$MONTH_FRACT = 12 * $7c5f6fbf42389787$var$HOUR_PARTS + 793;
var $7c5f6fbf42389787$var$MONTH_PARTS = $7c5f6fbf42389787$var$MONTH_DAYS * $7c5f6fbf42389787$var$DAY_PARTS + $7c5f6fbf42389787$var$MONTH_FRACT;
function $7c5f6fbf42389787$var$isLeapYear(year) {
  return (0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(year * 7 + 1, 19) < 7;
}
function $7c5f6fbf42389787$var$hebrewDelay1(year) {
  let months = Math.floor((235 * year - 234) / 19);
  let parts = 12084 + 13753 * months;
  let day = months * 29 + Math.floor(parts / 25920);
  if ((0, $2b4dce13dd5a17fa$export$842a2cf37af977e1)(3 * (day + 1), 7) < 3) day += 1;
  return day;
}
function $7c5f6fbf42389787$var$hebrewDelay2(year) {
  let last = $7c5f6fbf42389787$var$hebrewDelay1(year - 1);
  let present = $7c5f6fbf42389787$var$hebrewDelay1(year);
  let next = $7c5f6fbf42389787$var$hebrewDelay1(year + 1);
  if (next - present === 356) return 2;
  if (present - last === 382) return 1;
  return 0;
}
function $7c5f6fbf42389787$var$startOfYear(year) {
  return $7c5f6fbf42389787$var$hebrewDelay1(year) + $7c5f6fbf42389787$var$hebrewDelay2(year);
}
function $7c5f6fbf42389787$var$getDaysInYear(year) {
  return $7c5f6fbf42389787$var$startOfYear(year + 1) - $7c5f6fbf42389787$var$startOfYear(year);
}
function $7c5f6fbf42389787$var$getYearType(year) {
  let yearLength = $7c5f6fbf42389787$var$getDaysInYear(year);
  if (yearLength > 380) yearLength -= 30;
  switch (yearLength) {
    case 353:
      return 0;
    // deficient
    case 354:
      return 1;
    // normal
    case 355:
      return 2;
  }
}
function $7c5f6fbf42389787$var$getDaysInMonth(year, month) {
  if (month >= 6 && !$7c5f6fbf42389787$var$isLeapYear(year)) month++;
  if (month === 4 || month === 7 || month === 9 || month === 11 || month === 13) return 29;
  let yearType = $7c5f6fbf42389787$var$getYearType(year);
  if (month === 2) return yearType === 2 ? 30 : 29;
  if (month === 3) return yearType === 0 ? 29 : 30;
  if (month === 6) return $7c5f6fbf42389787$var$isLeapYear(year) ? 30 : 0;
  return 30;
}
var $7c5f6fbf42389787$export$ca405048b8fb5af = class {
  fromJulianDay(jd) {
    let d = jd - $7c5f6fbf42389787$var$HEBREW_EPOCH;
    let m = d * $7c5f6fbf42389787$var$DAY_PARTS / $7c5f6fbf42389787$var$MONTH_PARTS;
    let year = Math.floor((19 * m + 234) / 235) + 1;
    let ys = $7c5f6fbf42389787$var$startOfYear(year);
    let dayOfYear = Math.floor(d - ys);
    while (dayOfYear < 1) {
      year--;
      ys = $7c5f6fbf42389787$var$startOfYear(year);
      dayOfYear = Math.floor(d - ys);
    }
    let month = 1;
    let monthStart = 0;
    while (monthStart < dayOfYear) {
      monthStart += $7c5f6fbf42389787$var$getDaysInMonth(year, month);
      month++;
    }
    month--;
    monthStart -= $7c5f6fbf42389787$var$getDaysInMonth(year, month);
    let day = dayOfYear - monthStart;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, year, month, day);
  }
  toJulianDay(date) {
    let jd = $7c5f6fbf42389787$var$startOfYear(date.year);
    for (let month = 1; month < date.month; month++) jd += $7c5f6fbf42389787$var$getDaysInMonth(date.year, month);
    return jd + date.day + $7c5f6fbf42389787$var$HEBREW_EPOCH;
  }
  getDaysInMonth(date) {
    return $7c5f6fbf42389787$var$getDaysInMonth(date.year, date.month);
  }
  getMonthsInYear(date) {
    return $7c5f6fbf42389787$var$isLeapYear(date.year) ? 13 : 12;
  }
  getDaysInYear(date) {
    return $7c5f6fbf42389787$var$getDaysInYear(date.year);
  }
  getYearsInEra() {
    return 9999;
  }
  getEras() {
    return [
      "AM"
    ];
  }
  balanceYearMonth(date, previousDate) {
    if (previousDate.year !== date.year) {
      if ($7c5f6fbf42389787$var$isLeapYear(previousDate.year) && !$7c5f6fbf42389787$var$isLeapYear(date.year) && previousDate.month > 6) date.month--;
      else if (!$7c5f6fbf42389787$var$isLeapYear(previousDate.year) && $7c5f6fbf42389787$var$isLeapYear(date.year) && previousDate.month > 6) date.month++;
    }
  }
  constructor() {
    this.identifier = "hebrew";
  }
};

// node_modules/@internationalized/date/dist/EthiopicCalendar.mjs
var $b956b2d7a6cf451f$var$ETHIOPIC_EPOCH = 1723856;
var $b956b2d7a6cf451f$var$COPTIC_EPOCH = 1824665;
var $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA = 5500;
function $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, month, day) {
  return epoch + 365 * year + Math.floor(year / 4) + 30 * (month - 1) + day - 1;
}
function $b956b2d7a6cf451f$var$julianDayToCE(epoch, jd) {
  let year = Math.floor(4 * (jd - epoch) / 1461);
  let month = 1 + Math.floor((jd - $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, 1, 1)) / 30);
  let day = jd + 1 - $b956b2d7a6cf451f$var$ceToJulianDay(epoch, year, month, 1);
  return [
    year,
    month,
    day
  ];
}
function $b956b2d7a6cf451f$var$getLeapDay(year) {
  return Math.floor(year % 4 / 3);
}
function $b956b2d7a6cf451f$var$getDaysInMonth(year, month) {
  if (month % 13 !== 0)
    return 30;
  else
    return $b956b2d7a6cf451f$var$getLeapDay(year) + 5;
}
var $b956b2d7a6cf451f$export$26ba6eab5e20cd7d = class {
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, jd);
    let era = "AM";
    if (year <= 0) {
      era = "AA";
      year += $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, month, day);
  }
  toJulianDay(date) {
    let year = date.year;
    if (date.era === "AA") year -= $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    return $b956b2d7a6cf451f$var$ceToJulianDay($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, year, date.month, date.day);
  }
  getDaysInMonth(date) {
    return $b956b2d7a6cf451f$var$getDaysInMonth(date.year, date.month);
  }
  getMonthsInYear() {
    return 13;
  }
  getDaysInYear(date) {
    return 365 + $b956b2d7a6cf451f$var$getLeapDay(date.year);
  }
  getYearsInEra(date) {
    return date.era === "AA" ? 9999 : 9991;
  }
  getEras() {
    return [
      "AA",
      "AM"
    ];
  }
  constructor() {
    this.identifier = "ethiopic";
  }
};
var $b956b2d7a6cf451f$export$d72e0c37005a4914 = class extends $b956b2d7a6cf451f$export$26ba6eab5e20cd7d {
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$ETHIOPIC_EPOCH, jd);
    year += $b956b2d7a6cf451f$var$AMETE_MIHRET_DELTA;
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, "AA", year, month, day);
  }
  getEras() {
    return [
      "AA"
    ];
  }
  getYearsInEra() {
    return 9999;
  }
  constructor(...args) {
    super(...args), this.identifier = "ethioaa";
  }
};
var $b956b2d7a6cf451f$export$fe6243cbe1a4b7c1 = class extends $b956b2d7a6cf451f$export$26ba6eab5e20cd7d {
  fromJulianDay(jd) {
    let [year, month, day] = $b956b2d7a6cf451f$var$julianDayToCE($b956b2d7a6cf451f$var$COPTIC_EPOCH, jd);
    let era = "CE";
    if (year <= 0) {
      era = "BCE";
      year = 1 - year;
    }
    return new (0, $35ea8db9cb2ccb90$export$99faa760c7908e4f)(this, era, year, month, day);
  }
  toJulianDay(date) {
    let year = date.year;
    if (date.era === "BCE") year = 1 - year;
    return $b956b2d7a6cf451f$var$ceToJulianDay($b956b2d7a6cf451f$var$COPTIC_EPOCH, year, date.month, date.day);
  }
  getDaysInMonth(date) {
    let year = date.year;
    if (date.era === "BCE") year = 1 - year;
    return $b956b2d7a6cf451f$var$getDaysInMonth(year, date.month);
  }
  isInverseEra(date) {
    return date.era === "BCE";
  }
  balanceDate(date) {
    if (date.year <= 0) {
      date.era = date.era === "BCE" ? "CE" : "BCE";
      date.year = 1 - date.year;
    }
  }
  getEras() {
    return [
      "BCE",
      "CE"
    ];
  }
  getYearsInEra(date) {
    return date.era === "BCE" ? 9999 : 9715;
  }
  constructor(...args) {
    super(...args), this.identifier = "coptic";
  }
};

// node_modules/@internationalized/date/dist/createCalendar.mjs
function $64244302c3013299$export$dd0bbc9b26defe37(name) {
  switch (name) {
    case "buddhist":
      return new (0, $8d73d47422ca7302$export$42d20a78301dee44)();
    case "ethiopic":
      return new (0, $b956b2d7a6cf451f$export$26ba6eab5e20cd7d)();
    case "ethioaa":
      return new (0, $b956b2d7a6cf451f$export$d72e0c37005a4914)();
    case "coptic":
      return new (0, $b956b2d7a6cf451f$export$fe6243cbe1a4b7c1)();
    case "hebrew":
      return new (0, $7c5f6fbf42389787$export$ca405048b8fb5af)();
    case "indian":
      return new (0, $82c358003bdda0a8$export$39f31c639fa15726)();
    case "islamic-civil":
      return new (0, $f2f3e0e3a817edbd$export$2066795aadd37bfc)();
    case "islamic-tbla":
      return new (0, $f2f3e0e3a817edbd$export$37f0887f2f9d22f7)();
    case "islamic-umalqura":
      return new (0, $f2f3e0e3a817edbd$export$5baab4758c231076)();
    case "japanese":
      return new (0, $62225008020f0a13$export$b746ab2b60cdffbf)();
    case "persian":
      return new (0, $f3ed2e4472ae7e25$export$37fccdbfd14c5939)();
    case "roc":
      return new (0, $5f31bd6f0c8940b2$export$65e01080afcb0799)();
    case "gregory":
    default:
      return new (0, $3b62074eb05584b2$export$80ee6245ec4f29ec)();
  }
}

// node_modules/@internationalized/date/dist/DateFormatter.mjs
var $fb18d541ea1ad717$var$formatterCache = /* @__PURE__ */ new Map();
var $fb18d541ea1ad717$export$ad991b66133851cf = class {
  /** Formats a date as a string according to the locale and format options passed to the constructor. */
  format(value) {
    return this.formatter.format(value);
  }
  /** Formats a date to an array of parts such as separators, numbers, punctuation, and more. */
  formatToParts(value) {
    return this.formatter.formatToParts(value);
  }
  /** Formats a date range as a string. */
  formatRange(start, end) {
    if (typeof this.formatter.formatRange === "function")
      return this.formatter.formatRange(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    return `${this.formatter.format(start)} – ${this.formatter.format(end)}`;
  }
  /** Formats a date range as an array of parts. */
  formatRangeToParts(start, end) {
    if (typeof this.formatter.formatRangeToParts === "function")
      return this.formatter.formatRangeToParts(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    let startParts = this.formatter.formatToParts(start);
    let endParts = this.formatter.formatToParts(end);
    return [
      ...startParts.map((p) => ({
        ...p,
        source: "startRange"
      })),
      {
        type: "literal",
        value: " – ",
        source: "shared"
      },
      ...endParts.map((p) => ({
        ...p,
        source: "endRange"
      }))
    ];
  }
  /** Returns the resolved formatting options based on the values passed to the constructor. */
  resolvedOptions() {
    let resolvedOptions = this.formatter.resolvedOptions();
    if ($fb18d541ea1ad717$var$hasBuggyResolvedHourCycle()) {
      if (!this.resolvedHourCycle) this.resolvedHourCycle = $fb18d541ea1ad717$var$getResolvedHourCycle(resolvedOptions.locale, this.options);
      resolvedOptions.hourCycle = this.resolvedHourCycle;
      resolvedOptions.hour12 = this.resolvedHourCycle === "h11" || this.resolvedHourCycle === "h12";
    }
    if (resolvedOptions.calendar === "ethiopic-amete-alem") resolvedOptions.calendar = "ethioaa";
    return resolvedOptions;
  }
  constructor(locale, options = {}) {
    this.formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options);
    this.options = options;
  }
};
var $fb18d541ea1ad717$var$hour12Preferences = {
  true: {
    // Only Japanese uses the h11 style for 12 hour time. All others use h12.
    ja: "h11"
  },
  false: {}
};
function $fb18d541ea1ad717$var$getCachedDateFormatter(locale, options = {}) {
  if (typeof options.hour12 === "boolean" && $fb18d541ea1ad717$var$hasBuggyHour12Behavior()) {
    options = {
      ...options
    };
    let pref = $fb18d541ea1ad717$var$hour12Preferences[String(options.hour12)][locale.split("-")[0]];
    let defaultHourCycle = options.hour12 ? "h12" : "h23";
    options.hourCycle = pref !== null && pref !== void 0 ? pref : defaultHourCycle;
    delete options.hour12;
  }
  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : "");
  if ($fb18d541ea1ad717$var$formatterCache.has(cacheKey)) return $fb18d541ea1ad717$var$formatterCache.get(cacheKey);
  let numberFormatter = new Intl.DateTimeFormat(locale, options);
  $fb18d541ea1ad717$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
var $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = null;
function $fb18d541ea1ad717$var$hasBuggyHour12Behavior() {
  if ($fb18d541ea1ad717$var$_hasBuggyHour12Behavior == null) $fb18d541ea1ad717$var$_hasBuggyHour12Behavior = new Intl.DateTimeFormat("en-US", {
    hour: "numeric",
    hour12: false
  }).format(new Date(2020, 2, 3, 0)) === "24";
  return $fb18d541ea1ad717$var$_hasBuggyHour12Behavior;
}
var $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = null;
function $fb18d541ea1ad717$var$hasBuggyResolvedHourCycle() {
  if ($fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle == null) $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle = new Intl.DateTimeFormat("fr", {
    hour: "numeric",
    hour12: false
  }).resolvedOptions().hourCycle === "h12";
  return $fb18d541ea1ad717$var$_hasBuggyResolvedHourCycle;
}
function $fb18d541ea1ad717$var$getResolvedHourCycle(locale, options) {
  if (!options.timeStyle && !options.hour) return void 0;
  locale = locale.replace(/(-u-)?-nu-[a-zA-Z0-9]+/, "");
  locale += (locale.includes("-u-") ? "" : "-u") + "-nu-latn";
  let formatter = $fb18d541ea1ad717$var$getCachedDateFormatter(locale, {
    ...options,
    timeZone: void 0
    // use local timezone
  });
  let min2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 0)).find((p) => p.type === "hour").value, 10);
  let max2 = parseInt(formatter.formatToParts(new Date(2020, 2, 3, 23)).find((p) => p.type === "hour").value, 10);
  if (min2 === 0 && max2 === 23) return "h23";
  if (min2 === 24 && max2 === 23) return "h24";
  if (min2 === 0 && max2 === 11) return "h11";
  if (min2 === 12 && max2 === 11) return "h12";
  throw new Error("Unexpected hour cycle result");
}

// node_modules/reka-ui/dist/date/comparators.js
function toDate(dateValue, tz = $14e0f24ef4ac5c92$export$aa8b41735afcabd2()) {
  if (isZonedDateTime(dateValue)) return dateValue.toDate();
  else return dateValue.toDate(tz);
}
function isCalendarDateTime(dateValue) {
  return dateValue instanceof $35ea8db9cb2ccb90$export$ca871e8dbb80966f;
}
function isZonedDateTime(dateValue) {
  return dateValue instanceof $35ea8db9cb2ccb90$export$d3b7288e7994edea;
}
function hasTime(dateValue) {
  return isCalendarDateTime(dateValue) || isZonedDateTime(dateValue);
}
function getDaysInMonth(date) {
  if (date instanceof Date) {
    const year = date.getFullYear();
    const month = date.getMonth() + 1;
    return new Date(year, month, 0).getDate();
  } else return date.set({ day: 100 }).day;
}
function isBefore(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) < 0;
}
function isAfter(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) > 0;
}
function isBeforeOrSame(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) <= 0;
}
function isAfterOrSame(dateToCompare, referenceDate) {
  return dateToCompare.compare(referenceDate) >= 0;
}
function isBetweenInclusive(date, start, end) {
  return isAfterOrSame(date, start) && isBeforeOrSame(date, end);
}
function isBetween(date, start, end) {
  return isAfter(date, start) && isBefore(date, end);
}
function getLastFirstDayOfWeek(date, firstDayOfWeek, locale) {
  const day = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale);
  if (firstDayOfWeek > day) return date.subtract({ days: day + 7 - firstDayOfWeek });
  if (firstDayOfWeek === day) return date;
  return date.subtract({ days: day - firstDayOfWeek });
}
function getNextLastDayOfWeek(date, firstDayOfWeek, locale) {
  const day = $14e0f24ef4ac5c92$export$2061056d06d7cdf7(date, locale);
  const lastDayOfWeek = firstDayOfWeek === 0 ? 6 : firstDayOfWeek - 1;
  if (day === lastDayOfWeek) return date;
  if (day > lastDayOfWeek) return date.add({ days: 7 - day + lastDayOfWeek });
  return date.add({ days: lastDayOfWeek - day });
}
function areAllDaysBetweenValid(start, end, isUnavailable, isDisabled, isHighlightable) {
  if (isUnavailable === void 0 && isDisabled === void 0 && isHighlightable === void 0) return true;
  let dCurrent = start.add({ days: 1 });
  if ((isDisabled?.(dCurrent) || isUnavailable?.(dCurrent)) && !isHighlightable?.(dCurrent)) return false;
  const dEnd = end;
  while (dCurrent.compare(dEnd) < 0) {
    dCurrent = dCurrent.add({ days: 1 });
    if ((isDisabled?.(dCurrent) || isUnavailable?.(dCurrent)) && !isHighlightable?.(dCurrent)) return false;
  }
  return true;
}
function getDefaultDate(props2) {
  const { defaultValue, defaultPlaceholder, granularity = "day", locale = "en" } = props2;
  if (Array.isArray(defaultValue) && defaultValue.length) return defaultValue.at(-1).copy();
  if (defaultValue && !Array.isArray(defaultValue)) return defaultValue.copy();
  if (defaultPlaceholder) return defaultPlaceholder.copy();
  const date = /* @__PURE__ */ new Date();
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const calendarDateTimeGranularities2 = [
    "hour",
    "minute",
    "second"
  ];
  const defaultFormatter = new $fb18d541ea1ad717$export$ad991b66133851cf(locale);
  const calendar = $64244302c3013299$export$dd0bbc9b26defe37(defaultFormatter.resolvedOptions().calendar);
  if (calendarDateTimeGranularities2.includes(granularity ?? "day")) return $11d87f3f76e88657$export$b4a036af3fc0b032(new $35ea8db9cb2ccb90$export$ca871e8dbb80966f(year, month, day, 0, 0, 0), calendar);
  return $11d87f3f76e88657$export$b4a036af3fc0b032(new $35ea8db9cb2ccb90$export$99faa760c7908e4f(year, month, day), calendar);
}
function getDefaultTime(props2) {
  const { defaultValue, defaultPlaceholder } = props2;
  if (defaultValue) return defaultValue.copy();
  if (defaultPlaceholder) return defaultPlaceholder.copy();
  return new $35ea8db9cb2ccb90$export$680ea196effce5f(0, 0, 0);
}

// node_modules/reka-ui/dist/date/utils.js
function chunk(arr, size3) {
  const result = [];
  for (let i = 0; i < arr.length; i += size3) result.push(arr.slice(i, i + size3));
  return result;
}
function getOptsByGranularity(granularity, hourCycle, isTimeValue = false) {
  const opts = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit",
    second: "2-digit",
    timeZoneName: "short",
    hourCycle: normalizeHourCycle(hourCycle),
    hour12: normalizeHour12(hourCycle)
  };
  if (isTimeValue) {
    delete opts.year;
    delete opts.month;
    delete opts.day;
  }
  if (granularity === "day") {
    delete opts.second;
    delete opts.hour;
    delete opts.minute;
    delete opts.timeZoneName;
  }
  if (granularity === "hour") {
    delete opts.minute;
    delete opts.second;
  }
  if (granularity === "minute") delete opts.second;
  return opts;
}
function normalizeDateStep(props2) {
  return defu(props2?.step, {
    year: 1,
    month: 1,
    day: 1,
    hour: 1,
    minute: 1,
    second: 1,
    millisecond: 1
  });
}
function handleCalendarInitialFocus(calendar) {
  const selectedDay = calendar.querySelector("[data-selected]");
  if (selectedDay) return selectedDay.focus();
  const today = calendar.querySelector("[data-today]");
  if (today) return today.focus();
  const firstDay = calendar.querySelector("[data-reka-calendar-day]");
  if (firstDay) return firstDay.focus();
}
function normalizeHourCycle(hourCycle) {
  if (hourCycle === 24) return "h23";
  if (hourCycle === 12) return "h11";
  return void 0;
}
function normalizeHour12(hourCycle) {
  if (hourCycle === 24) return false;
  if (hourCycle === 12) return true;
  return void 0;
}

// node_modules/reka-ui/dist/date/calendar.js
function getDaysBetween(start, end) {
  const days = [];
  let dCurrent = start.add({ days: 1 });
  const dEnd = end;
  while (dCurrent.compare(dEnd) < 0) {
    days.push(dCurrent);
    dCurrent = dCurrent.add({ days: 1 });
  }
  return days;
}
function createMonth(props2) {
  const { dateObj, weekStartsOn, fixedWeeks, locale } = props2;
  const daysInMonth = getDaysInMonth(dateObj);
  const datesArray = Array.from({ length: daysInMonth }, (_, i) => dateObj.set({ day: i + 1 }));
  const firstDayOfMonth = $14e0f24ef4ac5c92$export$a5a3b454ada2268e(dateObj);
  const lastDayOfMonth = $14e0f24ef4ac5c92$export$a2258d9c4118825c(dateObj);
  const lastSunday = getLastFirstDayOfWeek(firstDayOfMonth, weekStartsOn, locale);
  const nextSaturday = getNextLastDayOfWeek(lastDayOfMonth, weekStartsOn, locale);
  const lastMonthDays = getDaysBetween(lastSunday.subtract({ days: 1 }), firstDayOfMonth);
  const nextMonthDays = getDaysBetween(lastDayOfMonth, nextSaturday.add({ days: 1 }));
  const totalDays = lastMonthDays.length + datesArray.length + nextMonthDays.length;
  if (fixedWeeks && totalDays < 42) {
    const extraDays = 42 - totalDays;
    let startFrom = nextMonthDays[nextMonthDays.length - 1];
    if (!startFrom) startFrom = $14e0f24ef4ac5c92$export$a2258d9c4118825c(dateObj);
    const extraDaysArray = Array.from({ length: extraDays }, (_, i) => {
      const incr = i + 1;
      return startFrom.add({ days: incr });
    });
    nextMonthDays.push(...extraDaysArray);
  }
  const allDays = lastMonthDays.concat(datesArray, nextMonthDays);
  const weeks = chunk(allDays, 7);
  return {
    value: dateObj,
    cells: allDays,
    rows: weeks
  };
}
function createMonths(props2) {
  const { numberOfMonths, dateObj, ...monthProps } = props2;
  const months = [];
  if (!numberOfMonths || numberOfMonths === 1) {
    months.push(createMonth({
      ...monthProps,
      dateObj
    }));
    return months;
  }
  months.push(createMonth({
    ...monthProps,
    dateObj
  }));
  for (let i = 1; i < numberOfMonths; i++) {
    const nextMonth = dateObj.add({ months: i });
    months.push(createMonth({
      ...monthProps,
      dateObj: nextMonth
    }));
  }
  return months;
}

// node_modules/reka-ui/dist/shared/useDateFormatter.js
function useDateFormatter(initialLocale, opts = {}) {
  const locale = ref(initialLocale);
  function getLocale() {
    return locale.value;
  }
  function setLocale(newLocale) {
    locale.value = newLocale;
  }
  function custom(date, options) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options
    }).format(date);
  }
  function selectedDate(date, includeTime = true) {
    if (hasTime(date) && includeTime) return custom(toDate(date), {
      dateStyle: "long",
      timeStyle: "long"
    });
    else return custom(toDate(date), { dateStyle: "long" });
  }
  function fullMonthAndYear(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      month: "long",
      year: "numeric",
      ...options
    }).format(date);
  }
  function fullMonth(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      month: "long",
      ...options
    }).format(date);
  }
  function getMonths() {
    const defaultDate = $14e0f24ef4ac5c92$export$d0bdf45af03a6ea3($14e0f24ef4ac5c92$export$aa8b41735afcabd2());
    const months = [
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12
    ];
    return months.map((item) => ({
      label: fullMonth(toDate(defaultDate.set({ month: item }))),
      value: item
    }));
  }
  function fullYear(date, options = {}) {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      year: "numeric",
      ...options
    }).format(date);
  }
  function toParts(date, options) {
    if (isZonedDateTime(date)) return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options,
      timeZone: date.timeZone
    }).formatToParts(toDate(date));
    else return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      ...options
    }).formatToParts(toDate(date));
  }
  function dayOfWeek(date, length = "narrow") {
    return new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      weekday: length
    }).format(date);
  }
  function dayPeriod(date) {
    const parts = new $fb18d541ea1ad717$export$ad991b66133851cf(locale.value, {
      ...opts,
      hour: "numeric",
      minute: "numeric"
    }).formatToParts(date);
    const value = parts.find((p) => p.type === "dayPeriod")?.value;
    if (value === "PM" || value === "p.m.") return "PM";
    return "AM";
  }
  const defaultPartOptions = {
    year: "numeric",
    month: "numeric",
    day: "numeric",
    hour: "numeric",
    minute: "numeric",
    second: "numeric"
  };
  function part(dateObj, type, options = {}) {
    const opts$1 = {
      ...defaultPartOptions,
      ...options
    };
    const parts = toParts(dateObj, opts$1);
    const part$1 = parts.find((p) => p.type === type);
    return part$1 ? part$1.value : "";
  }
  return {
    setLocale,
    getLocale,
    fullMonth,
    fullYear,
    fullMonthAndYear,
    toParts,
    custom,
    part,
    dayPeriod,
    selectedDate,
    dayOfWeek,
    getMonths
  };
}

// node_modules/reka-ui/dist/shared/useDirection.js
function useDirection(dir) {
  const context2 = injectConfigProviderContext({ dir: ref("ltr") });
  return computed(() => dir?.value || context2.dir?.value || "ltr");
}

// node_modules/reka-ui/dist/shared/useEmitAsProps.js
function useEmitAsProps(emit) {
  const vm = getCurrentInstance();
  const events = vm?.type.emits;
  const result = {};
  if (!events?.length) console.warn(`No emitted event found. Please check component: ${vm?.type.__name}`);
  events?.forEach((ev) => {
    result[toHandlerKey(camelize(ev))] = (...arg) => emit(ev, ...arg);
  });
  return result;
}

// node_modules/reka-ui/dist/shared/useFilter.js
function useFilter(options) {
  const computedOptions = computed(() => unref(options));
  const collator = computed(() => new Intl.Collator("en", {
    usage: "search",
    ...computedOptions.value
  }));
  const startsWith = (string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    return collator.value.compare(string.slice(0, substring.length), substring) === 0;
  };
  const endsWith = (string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    return collator.value.compare(string.slice(-substring.length), substring) === 0;
  };
  const contains = (string, substring) => {
    if (substring.length === 0) return true;
    string = string.normalize("NFC");
    substring = substring.normalize("NFC");
    let scan = 0;
    const sliceLen = substring.length;
    for (; scan + sliceLen <= string.length; scan++) {
      const slice = string.slice(scan, scan + sliceLen);
      if (collator.value.compare(substring, slice) === 0) return true;
    }
    return false;
  };
  return {
    startsWith,
    endsWith,
    contains
  };
}

// node_modules/reka-ui/dist/shared/useFocusGuards.js
var count = 0;
function useFocusGuards() {
  watchEffect((cleanupFn) => {
    if (!isClient) return;
    const edgeGuards = document.querySelectorAll("[data-reka-focus-guard]");
    document.body.insertAdjacentElement("afterbegin", edgeGuards[0] ?? createFocusGuard());
    document.body.insertAdjacentElement("beforeend", edgeGuards[1] ?? createFocusGuard());
    count++;
    cleanupFn(() => {
      if (count === 1) document.querySelectorAll("[data-reka-focus-guard]").forEach((node) => node.remove());
      count--;
    });
  });
}
function createFocusGuard() {
  const element = document.createElement("span");
  element.setAttribute("data-reka-focus-guard", "");
  element.tabIndex = 0;
  element.style.outline = "none";
  element.style.opacity = "0";
  element.style.position = "fixed";
  element.style.pointerEvents = "none";
  return element;
}

// node_modules/reka-ui/dist/shared/useFormControl.js
function useFormControl(el) {
  return computed(() => toValue(el) ? Boolean(unrefElement(el)?.closest("form")) : true);
}

// node_modules/reka-ui/dist/shared/useForwardExpose.js
function useForwardExpose() {
  const instance = getCurrentInstance();
  const currentRef = ref();
  const currentElement = computed(() => {
    return ["#text", "#comment"].includes(currentRef.value?.$el.nodeName) ? currentRef.value?.$el.nextElementSibling : unrefElement(currentRef);
  });
  const localExpose = Object.assign({}, instance.exposed);
  const ret = {};
  for (const key in instance.props) Object.defineProperty(ret, key, {
    enumerable: true,
    configurable: true,
    get: () => instance.props[key]
  });
  if (Object.keys(localExpose).length > 0) for (const key in localExpose) Object.defineProperty(ret, key, {
    enumerable: true,
    configurable: true,
    get: () => localExpose[key]
  });
  Object.defineProperty(ret, "$el", {
    enumerable: true,
    configurable: true,
    get: () => instance.vnode.el
  });
  instance.exposed = ret;
  function forwardRef(ref$1) {
    currentRef.value = ref$1;
    if (!ref$1) return;
    Object.defineProperty(ret, "$el", {
      enumerable: true,
      configurable: true,
      get: () => ref$1 instanceof Element ? ref$1 : ref$1.$el
    });
    if (!(ref$1 instanceof Element) && !Object.hasOwn(ref$1, "$el")) {
      const childExposed = ref$1.$.exposed;
      const merged = Object.assign({}, ret);
      for (const key in childExposed) Object.defineProperty(merged, key, {
        enumerable: true,
        configurable: true,
        get: () => childExposed[key]
      });
      instance.exposed = merged;
    }
  }
  return {
    forwardRef,
    currentRef,
    currentElement
  };
}

// node_modules/reka-ui/dist/shared/useForwardProps.js
function useForwardProps(props2) {
  const vm = getCurrentInstance();
  const defaultProps = Object.keys(vm?.type.props ?? {}).reduce((prev, curr) => {
    const defaultValue = (vm?.type.props[curr]).default;
    if (defaultValue !== void 0) prev[curr] = defaultValue;
    return prev;
  }, {});
  const refProps = toRef(props2);
  return computed(() => {
    const preservedProps = {};
    const assignedProps = vm?.vnode.props ?? {};
    Object.keys(assignedProps).forEach((key) => {
      preservedProps[camelize(key)] = assignedProps[key];
    });
    return Object.keys({
      ...defaultProps,
      ...preservedProps
    }).reduce((prev, curr) => {
      if (refProps.value[curr] !== void 0) prev[curr] = refProps.value[curr];
      return prev;
    }, {});
  });
}

// node_modules/reka-ui/dist/shared/useForwardPropsEmits.js
function useForwardPropsEmits(props2, emit) {
  const parsedProps = useForwardProps(props2);
  const emitsAsProps = emit ? useEmitAsProps(emit) : {};
  return computed(() => ({
    ...parsedProps.value,
    ...emitsAsProps
  }));
}

// node_modules/reka-ui/dist/shared/useGraceArea.js
function useGraceArea(triggerElement, containerElement) {
  const isPointerInTransit = refAutoReset(false, 300);
  tryOnScopeDispose(() => {
    isPointerInTransit.value = false;
  });
  const pointerGraceArea = ref(null);
  const pointerExit = createEventHook();
  function handleRemoveGraceArea() {
    pointerGraceArea.value = null;
    isPointerInTransit.value = false;
  }
  function handleCreateGraceArea(event, hoverTarget) {
    const currentTarget = event.currentTarget;
    const exitPoint = {
      x: event.clientX,
      y: event.clientY
    };
    const exitSide = getExitSideFromRect(exitPoint, currentTarget.getBoundingClientRect());
    const paddedExitPoints = getPaddedExitPoints(exitPoint, exitSide);
    const hoverTargetPoints = getPointsFromRect(hoverTarget.getBoundingClientRect());
    const graceArea = getHull([...paddedExitPoints, ...hoverTargetPoints]);
    pointerGraceArea.value = graceArea;
    isPointerInTransit.value = true;
  }
  watchEffect((cleanupFn) => {
    if (triggerElement.value && containerElement.value) {
      const handleTriggerLeave = (event) => handleCreateGraceArea(event, containerElement.value);
      const handleContentLeave = (event) => handleCreateGraceArea(event, triggerElement.value);
      triggerElement.value.addEventListener("pointerleave", handleTriggerLeave);
      containerElement.value.addEventListener("pointerleave", handleContentLeave);
      cleanupFn(() => {
        triggerElement.value?.removeEventListener("pointerleave", handleTriggerLeave);
        containerElement.value?.removeEventListener("pointerleave", handleContentLeave);
      });
    }
  });
  watchEffect((cleanupFn) => {
    if (pointerGraceArea.value) {
      const handleTrackPointerGrace = (event) => {
        if (!pointerGraceArea.value || !(event.target instanceof Element)) return;
        const target = event.target;
        const pointerPosition = {
          x: event.clientX,
          y: event.clientY
        };
        const hasEnteredTarget = triggerElement.value?.contains(target) || containerElement.value?.contains(target);
        const isPointerOutsideGraceArea = !isPointInPolygon(pointerPosition, pointerGraceArea.value);
        const isAnotherGraceAreaTrigger = !!target.closest("[data-grace-area-trigger]");
        if (hasEnteredTarget) handleRemoveGraceArea();
        else if (isPointerOutsideGraceArea || isAnotherGraceAreaTrigger) {
          handleRemoveGraceArea();
          pointerExit.trigger();
        }
      };
      triggerElement.value?.ownerDocument.addEventListener("pointermove", handleTrackPointerGrace);
      cleanupFn(() => triggerElement.value?.ownerDocument.removeEventListener("pointermove", handleTrackPointerGrace));
    }
  });
  return {
    isPointerInTransit,
    onPointerExit: pointerExit.on
  };
}
function getExitSideFromRect(point, rect) {
  const top = Math.abs(rect.top - point.y);
  const bottom = Math.abs(rect.bottom - point.y);
  const right = Math.abs(rect.right - point.x);
  const left = Math.abs(rect.left - point.x);
  switch (Math.min(top, bottom, right, left)) {
    case left:
      return "left";
    case right:
      return "right";
    case top:
      return "top";
    case bottom:
      return "bottom";
    default:
      throw new Error("unreachable");
  }
}
function getPaddedExitPoints(exitPoint, exitSide, padding = 5) {
  const paddedExitPoints = [];
  switch (exitSide) {
    case "top":
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y + padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y + padding
      });
      break;
    case "bottom":
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y - padding
      });
      break;
    case "left":
      paddedExitPoints.push({
        x: exitPoint.x + padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x + padding,
        y: exitPoint.y + padding
      });
      break;
    case "right":
      paddedExitPoints.push({
        x: exitPoint.x - padding,
        y: exitPoint.y - padding
      }, {
        x: exitPoint.x - padding,
        y: exitPoint.y + padding
      });
      break;
  }
  return paddedExitPoints;
}
function getPointsFromRect(rect) {
  const { top, right, bottom, left } = rect;
  return [
    {
      x: left,
      y: top
    },
    {
      x: right,
      y: top
    },
    {
      x: right,
      y: bottom
    },
    {
      x: left,
      y: bottom
    }
  ];
}
function isPointInPolygon(point, polygon) {
  const { x, y } = point;
  let inside = false;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const xi = polygon[i].x;
    const yi = polygon[i].y;
    const xj = polygon[j].x;
    const yj = polygon[j].y;
    const intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) inside = !inside;
  }
  return inside;
}
function getHull(points) {
  const newPoints = points.slice();
  newPoints.sort((a, b) => {
    if (a.x < b.x) return -1;
    else if (a.x > b.x) return 1;
    else if (a.y < b.y) return -1;
    else if (a.y > b.y) return 1;
    else return 0;
  });
  return getHullPresorted(newPoints);
}
function getHullPresorted(points) {
  if (points.length <= 1) return points.slice();
  const upperHull = [];
  for (let i = 0; i < points.length; i++) {
    const p = points[i];
    while (upperHull.length >= 2) {
      const q = upperHull[upperHull.length - 1];
      const r = upperHull[upperHull.length - 2];
      if ((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x)) upperHull.pop();
      else break;
    }
    upperHull.push(p);
  }
  upperHull.pop();
  const lowerHull = [];
  for (let i = points.length - 1; i >= 0; i--) {
    const p = points[i];
    while (lowerHull.length >= 2) {
      const q = lowerHull[lowerHull.length - 1];
      const r = lowerHull[lowerHull.length - 2];
      if ((q.x - r.x) * (p.y - r.y) >= (q.y - r.y) * (p.x - r.x)) lowerHull.pop();
      else break;
    }
    lowerHull.push(p);
  }
  lowerHull.pop();
  if (upperHull.length === 1 && lowerHull.length === 1 && upperHull[0].x === lowerHull[0].x && upperHull[0].y === lowerHull[0].y) return upperHull;
  else return upperHull.concat(lowerHull);
}

// node_modules/aria-hidden/dist/es2015/index.js
var getDefaultParent = function(originalTarget) {
  if (typeof document === "undefined") {
    return null;
  }
  var sampleTarget = Array.isArray(originalTarget) ? originalTarget[0] : originalTarget;
  return sampleTarget.ownerDocument.body;
};
var counterMap = /* @__PURE__ */ new WeakMap();
var uncontrolledNodes = /* @__PURE__ */ new WeakMap();
var markerMap = {};
var lockCount = 0;
var unwrapHost = function(node) {
  return node && (node.host || unwrapHost(node.parentNode));
};
var correctTargets = function(parent, targets) {
  return targets.map(function(target) {
    if (parent.contains(target)) {
      return target;
    }
    var correctedTarget = unwrapHost(target);
    if (correctedTarget && parent.contains(correctedTarget)) {
      return correctedTarget;
    }
    console.error("aria-hidden", target, "in not contained inside", parent, ". Doing nothing");
    return null;
  }).filter(function(x) {
    return Boolean(x);
  });
};
var applyAttributeToOthers = function(originalTarget, parentNode, markerName, controlAttribute) {
  var targets = correctTargets(parentNode, Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  if (!markerMap[markerName]) {
    markerMap[markerName] = /* @__PURE__ */ new WeakMap();
  }
  var markerCounter = markerMap[markerName];
  var hiddenNodes = [];
  var elementsToKeep = /* @__PURE__ */ new Set();
  var elementsToStop = new Set(targets);
  var keep = function(el) {
    if (!el || elementsToKeep.has(el)) {
      return;
    }
    elementsToKeep.add(el);
    keep(el.parentNode);
  };
  targets.forEach(keep);
  var deep = function(parent) {
    if (!parent || elementsToStop.has(parent)) {
      return;
    }
    Array.prototype.forEach.call(parent.children, function(node) {
      if (elementsToKeep.has(node)) {
        deep(node);
      } else {
        try {
          var attr = node.getAttribute(controlAttribute);
          var alreadyHidden = attr !== null && attr !== "false";
          var counterValue = (counterMap.get(node) || 0) + 1;
          var markerValue = (markerCounter.get(node) || 0) + 1;
          counterMap.set(node, counterValue);
          markerCounter.set(node, markerValue);
          hiddenNodes.push(node);
          if (counterValue === 1 && alreadyHidden) {
            uncontrolledNodes.set(node, true);
          }
          if (markerValue === 1) {
            node.setAttribute(markerName, "true");
          }
          if (!alreadyHidden) {
            node.setAttribute(controlAttribute, "true");
          }
        } catch (e) {
          console.error("aria-hidden: cannot operate on ", node, e);
        }
      }
    });
  };
  deep(parentNode);
  elementsToKeep.clear();
  lockCount++;
  return function() {
    hiddenNodes.forEach(function(node) {
      var counterValue = counterMap.get(node) - 1;
      var markerValue = markerCounter.get(node) - 1;
      counterMap.set(node, counterValue);
      markerCounter.set(node, markerValue);
      if (!counterValue) {
        if (!uncontrolledNodes.has(node)) {
          node.removeAttribute(controlAttribute);
        }
        uncontrolledNodes.delete(node);
      }
      if (!markerValue) {
        node.removeAttribute(markerName);
      }
    });
    lockCount--;
    if (!lockCount) {
      counterMap = /* @__PURE__ */ new WeakMap();
      counterMap = /* @__PURE__ */ new WeakMap();
      uncontrolledNodes = /* @__PURE__ */ new WeakMap();
      markerMap = {};
    }
  };
};
var hideOthers = function(originalTarget, parentNode, markerName) {
  if (markerName === void 0) {
    markerName = "data-aria-hidden";
  }
  var targets = Array.from(Array.isArray(originalTarget) ? originalTarget : [originalTarget]);
  var activeParentNode = parentNode || getDefaultParent(originalTarget);
  if (!activeParentNode) {
    return function() {
      return null;
    };
  }
  targets.push.apply(targets, Array.from(activeParentNode.querySelectorAll("[aria-live], script")));
  return applyAttributeToOthers(targets, activeParentNode, markerName, "aria-hidden");
};

// node_modules/reka-ui/dist/shared/useHideOthers.js
function useHideOthers(target) {
  let undo;
  watch(() => unrefElement(target), (el) => {
    if (el) undo = hideOthers(el);
    else if (undo) undo();
  });
  onUnmounted(() => {
    if (undo) undo();
  });
}

// node_modules/reka-ui/dist/shared/useId.js
var count2 = 0;
function useId2(deterministicId, prefix = "reka") {
  if (deterministicId) return deterministicId;
  if ("useId" in vue_runtime_esm_bundler_exports) return `${prefix}-${useId?.()}`;
  const configProviderContext = injectConfigProviderContext({ useId: void 0 });
  if (configProviderContext.useId) return `${prefix}-${configProviderContext.useId()}`;
  return `${prefix}-${++count2}`;
}

// node_modules/reka-ui/dist/shared/useKbd.js
function useKbd() {
  return {
    ALT: "Alt",
    ARROW_DOWN: "ArrowDown",
    ARROW_LEFT: "ArrowLeft",
    ARROW_RIGHT: "ArrowRight",
    ARROW_UP: "ArrowUp",
    BACKSPACE: "Backspace",
    CAPS_LOCK: "CapsLock",
    CONTROL: "Control",
    DELETE: "Delete",
    END: "End",
    ENTER: "Enter",
    ESCAPE: "Escape",
    F1: "F1",
    F10: "F10",
    F11: "F11",
    F12: "F12",
    F2: "F2",
    F3: "F3",
    F4: "F4",
    F5: "F5",
    F6: "F6",
    F7: "F7",
    F8: "F8",
    F9: "F9",
    HOME: "Home",
    META: "Meta",
    PAGE_DOWN: "PageDown",
    PAGE_UP: "PageUp",
    SHIFT: "Shift",
    SPACE: " ",
    TAB: "Tab",
    CTRL: "Control",
    ASTERISK: "*",
    SPACE_CODE: "Space"
  };
}

// node_modules/reka-ui/dist/shared/useLocale.js
function useLocale(locale) {
  const context2 = injectConfigProviderContext({ locale: ref("en") });
  return computed(() => locale?.value || context2.locale?.value || "en");
}

// node_modules/reka-ui/dist/shared/useSelectionBehavior.js
function useSelectionBehavior(modelValue, props2) {
  const firstValue = ref();
  const onSelectItem = (val, condition) => {
    if (props2.multiple && Array.isArray(modelValue.value)) if (props2.selectionBehavior === "replace") {
      modelValue.value = [val];
      firstValue.value = val;
    } else {
      const index = modelValue.value.findIndex((v) => condition(v));
      if (index !== -1) modelValue.value = modelValue.value.filter((_, i) => i !== index);
      else modelValue.value = [...modelValue.value, val];
    }
    else if (props2.selectionBehavior === "replace") modelValue.value = { ...val };
    else if (!Array.isArray(modelValue.value) && condition(modelValue.value)) modelValue.value = void 0;
    else modelValue.value = { ...val };
    return modelValue.value;
  };
  function handleMultipleReplace(intent, currentElement, getItems, options) {
    if (!firstValue?.value || !props2.multiple || !Array.isArray(modelValue.value)) return;
    const collection = getItems().filter((i) => i.ref.dataset.disabled !== "");
    const lastValue = collection.find((i) => i.ref === currentElement)?.value;
    if (!lastValue) return;
    let value = null;
    switch (intent) {
      case "prev":
      case "next": {
        value = findValuesBetween(options, firstValue.value, lastValue);
        break;
      }
      case "first": {
        value = findValuesBetween(options, firstValue.value, options?.[0]);
        break;
      }
      case "last": {
        value = findValuesBetween(options, firstValue.value, options?.[options.length - 1]);
        break;
      }
    }
    modelValue.value = value;
  }
  return {
    firstValue,
    onSelectItem,
    handleMultipleReplace
  };
}

// node_modules/reka-ui/dist/shared/useSize.js
function useSize(element) {
  const size3 = ref();
  const width = computed(() => size3.value?.width ?? 0);
  const height = computed(() => size3.value?.height ?? 0);
  onMounted(() => {
    const el = unrefElement(element);
    if (el) {
      size3.value = {
        width: el.offsetWidth,
        height: el.offsetHeight
      };
      const resizeObserver = new ResizeObserver((entries) => {
        if (!Array.isArray(entries)) return;
        if (!entries.length) return;
        const entry = entries[0];
        let width$1;
        let height$1;
        if ("borderBoxSize" in entry) {
          const borderSizeEntry = entry.borderBoxSize;
          const borderSize = Array.isArray(borderSizeEntry) ? borderSizeEntry[0] : borderSizeEntry;
          width$1 = borderSize.inlineSize;
          height$1 = borderSize.blockSize;
        } else {
          width$1 = el.offsetWidth;
          height$1 = el.offsetHeight;
        }
        size3.value = {
          width: width$1,
          height: height$1
        };
      });
      resizeObserver.observe(el, { box: "border-box" });
      return () => resizeObserver.unobserve(el);
    } else size3.value = void 0;
  });
  return {
    width,
    height
  };
}

// node_modules/reka-ui/dist/shared/useStateMachine.js
function useStateMachine(initialState, machine) {
  const state = ref(initialState);
  function reducer(event) {
    const nextState = machine[state.value][event];
    return nextState ?? state.value;
  }
  const dispatch = (event) => {
    state.value = reducer(event);
  };
  return {
    state,
    dispatch
  };
}

// node_modules/reka-ui/dist/shared/useTypeahead.js
function useTypeahead(callback) {
  const search = refAutoReset("", 1e3);
  const handleTypeaheadSearch = (key, items) => {
    search.value = search.value + key;
    if (callback) callback(key);
    else {
      const currentItem = getActiveElement();
      const itemsWithTextValue = items.map((item) => ({
        ...item,
        textValue: item.value?.textValue ?? item.ref.textContent?.trim() ?? ""
      }));
      const currentMatch = itemsWithTextValue.find((item) => item.ref === currentItem);
      const values = itemsWithTextValue.map((item) => item.textValue);
      const nextMatch = getNextMatch(values, search.value, currentMatch?.textValue);
      const newItem = itemsWithTextValue.find((item) => item.textValue === nextMatch);
      if (newItem) newItem.ref.focus();
      return newItem?.ref;
    }
  };
  const resetTypeahead = () => {
    search.value = "";
  };
  return {
    search,
    handleTypeaheadSearch,
    resetTypeahead
  };
}
function wrapArray(array, startIndex) {
  return array.map((_, index) => array[(startIndex + index) % array.length]);
}
function getNextMatch(values, search, currentMatch) {
  const isRepeated = search.length > 1 && Array.from(search).every((char) => char === search[0]);
  const normalizedSearch = isRepeated ? search[0] : search;
  const currentMatchIndex = currentMatch ? values.indexOf(currentMatch) : -1;
  let wrappedValues = wrapArray(values, Math.max(currentMatchIndex, 0));
  const excludeCurrentMatch = normalizedSearch.length === 1;
  if (excludeCurrentMatch) wrappedValues = wrappedValues.filter((v) => v !== currentMatch);
  const nextMatch = wrappedValues.find((value) => value.toLowerCase().startsWith(normalizedSearch.toLowerCase()));
  return nextMatch !== currentMatch ? nextMatch : void 0;
}

// node_modules/reka-ui/dist/shared/withDefault.js
function withDefault(WrappedComponent, options) {
  return {
    inheritAttrs: false,
    name: `${WrappedComponent.__name ?? ""}Wrapper`,
    setup(_, ctx) {
      return () => {
        const optionProps = typeof options?.props === "function" ? options?.props(ctx.attrs) : options?.props;
        const { forwardRef } = useForwardExpose();
        const mergedProps = mergeProps(optionProps, ctx.attrs);
        return h(WrappedComponent, {
          ...mergedProps,
          ref: forwardRef
        }, ctx.slots);
      };
    }
  };
}

// node_modules/reka-ui/dist/Presence/usePresence.js
function usePresence(present, node) {
  const stylesRef = ref({});
  const prevAnimationNameRef = ref("none");
  const prevPresentRef = ref(present);
  const initialState = present.value ? "mounted" : "unmounted";
  let timeoutId;
  const ownerWindow = node.value?.ownerDocument.defaultView ?? defaultWindow;
  const { state, dispatch } = useStateMachine(initialState, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: { MOUNT: "mounted" }
  });
  const dispatchCustomEvent = (name) => {
    if (isClient) {
      const customEvent = new CustomEvent(name, {
        bubbles: false,
        cancelable: false
      });
      node.value?.dispatchEvent(customEvent);
    }
  };
  watch(present, async (currentPresent, prevPresent) => {
    const hasPresentChanged = prevPresent !== currentPresent;
    await nextTick();
    if (hasPresentChanged) {
      const prevAnimationName = prevAnimationNameRef.value;
      const currentAnimationName = getAnimationName(node.value);
      if (currentPresent) {
        dispatch("MOUNT");
        dispatchCustomEvent("enter");
        if (currentAnimationName === "none") dispatchCustomEvent("after-enter");
      } else if (currentAnimationName === "none" || currentAnimationName === "undefined" || stylesRef.value?.display === "none") {
        dispatch("UNMOUNT");
        dispatchCustomEvent("leave");
        dispatchCustomEvent("after-leave");
      } else {
        const isAnimating = prevAnimationName !== currentAnimationName;
        if (prevPresent && isAnimating) {
          dispatch("ANIMATION_OUT");
          dispatchCustomEvent("leave");
        } else {
          dispatch("UNMOUNT");
          dispatchCustomEvent("after-leave");
        }
      }
    }
  }, { immediate: true });
  const handleAnimationEnd = (event) => {
    const currentAnimationName = getAnimationName(node.value);
    const isCurrentAnimation = currentAnimationName.includes(CSS.escape(event.animationName));
    const directionName = state.value === "mounted" ? "enter" : "leave";
    if (event.target === node.value && isCurrentAnimation) {
      dispatchCustomEvent(`after-${directionName}`);
      dispatch("ANIMATION_END");
      if (!prevPresentRef.value) {
        const currentFillMode = node.value.style.animationFillMode;
        node.value.style.animationFillMode = "forwards";
        timeoutId = ownerWindow?.setTimeout(() => {
          if (node.value?.style.animationFillMode === "forwards") node.value.style.animationFillMode = currentFillMode;
        });
      }
    }
    if (event.target === node.value && currentAnimationName === "none") dispatch("ANIMATION_END");
  };
  const handleAnimationStart = (event) => {
    if (event.target === node.value) prevAnimationNameRef.value = getAnimationName(node.value);
  };
  const watcher = watch(node, (newNode, oldNode) => {
    if (newNode) {
      stylesRef.value = getComputedStyle(newNode);
      newNode.addEventListener("animationstart", handleAnimationStart);
      newNode.addEventListener("animationcancel", handleAnimationEnd);
      newNode.addEventListener("animationend", handleAnimationEnd);
    } else {
      dispatch("ANIMATION_END");
      if (timeoutId !== void 0) ownerWindow?.clearTimeout(timeoutId);
      oldNode?.removeEventListener("animationstart", handleAnimationStart);
      oldNode?.removeEventListener("animationcancel", handleAnimationEnd);
      oldNode?.removeEventListener("animationend", handleAnimationEnd);
    }
  }, { immediate: true });
  const stateWatcher = watch(state, () => {
    const currentAnimationName = getAnimationName(node.value);
    prevAnimationNameRef.value = state.value === "mounted" ? currentAnimationName : "none";
  });
  onUnmounted(() => {
    watcher();
    stateWatcher();
  });
  const isPresent = computed(() => ["mounted", "unmountSuspended"].includes(state.value));
  return { isPresent };
}
function getAnimationName(node) {
  return node ? getComputedStyle(node).animationName || "none" : "none";
}

// node_modules/reka-ui/dist/Presence/Presence.js
var Presence_default = defineComponent({
  name: "Presence",
  props: {
    present: {
      type: Boolean,
      required: true
    },
    forceMount: { type: Boolean }
  },
  slots: {},
  setup(props2, { slots, expose }) {
    const { present, forceMount } = toRefs(props2);
    const node = ref();
    const { isPresent } = usePresence(present, node);
    expose({ present: isPresent });
    let children = slots.default({ present: isPresent.value });
    children = renderSlotFragments(children || []);
    const instance = getCurrentInstance();
    if (children && children?.length > 1) {
      const componentName = instance?.parent?.type.name ? `<${instance.parent.type.name} />` : "component";
      throw new Error([
        `Detected an invalid children for \`${componentName}\` for  \`Presence\` component.`,
        "",
        "Note: Presence works similarly to `v-if` directly, but it waits for animation/transition to finished before unmounting. So it expect only one direct child of valid VNode type.",
        "You can apply a few solutions:",
        ["Provide a single child element so that `presence` directive attach correctly.", "Ensure the first child is an actual element instead of a raw text node or comment node."].map((line) => `  - ${line}`).join("\n")
      ].join("\n"));
    }
    return () => {
      if (forceMount.value || present.value || isPresent.value) return h(slots.default({ present: isPresent.value })[0], { ref: (v) => {
        const el = unrefElement(v);
        if (typeof el?.hasAttribute === "undefined") return el;
        if (el?.hasAttribute("data-reka-popper-content-wrapper")) node.value = el.firstElementChild;
        else node.value = el;
        return el;
      } });
      else return null;
    };
  }
});

// node_modules/reka-ui/dist/Primitive/Slot.js
var Slot = defineComponent({
  name: "PrimitiveSlot",
  inheritAttrs: false,
  setup(_, { attrs, slots }) {
    return () => {
      if (!slots.default) return null;
      const children = renderSlotFragments(slots.default());
      const firstNonCommentChildrenIndex = children.findIndex((child) => child.type !== Comment);
      if (firstNonCommentChildrenIndex === -1) return children;
      const firstNonCommentChildren = children[firstNonCommentChildrenIndex];
      delete firstNonCommentChildren.props?.ref;
      const mergedProps = firstNonCommentChildren.props ? mergeProps(attrs, firstNonCommentChildren.props) : attrs;
      const cloned = cloneVNode({
        ...firstNonCommentChildren,
        props: {}
      }, mergedProps);
      if (children.length === 1) return cloned;
      children[firstNonCommentChildrenIndex] = cloned;
      return children;
    };
  }
});

// node_modules/reka-ui/dist/Primitive/Primitive.js
var SELF_CLOSING_TAGS = [
  "area",
  "img",
  "input"
];
var Primitive = defineComponent({
  name: "Primitive",
  inheritAttrs: false,
  props: {
    asChild: {
      type: Boolean,
      default: false
    },
    as: {
      type: [String, Object],
      default: "div"
    }
  },
  setup(props2, { attrs, slots }) {
    const asTag = props2.asChild ? "template" : props2.as;
    if (typeof asTag === "string" && SELF_CLOSING_TAGS.includes(asTag)) return () => h(asTag, attrs);
    if (asTag !== "template") return () => h(props2.as, attrs, { default: slots.default });
    return () => h(Slot, attrs, { default: slots.default });
  }
});

// node_modules/reka-ui/dist/Primitive/usePrimitiveElement.js
function usePrimitiveElement() {
  const primitiveElement = ref();
  const currentElement = computed(() => ["#text", "#comment"].includes(primitiveElement.value?.$el.nodeName) ? primitiveElement.value?.$el.nextElementSibling : unrefElement(primitiveElement));
  return {
    primitiveElement,
    currentElement
  };
}

// node_modules/reka-ui/dist/Collapsible/CollapsibleRoot.js
var [injectCollapsibleRootContext, provideCollapsibleRootContext] = createContext("CollapsibleRoot");
var CollapsibleRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CollapsibleRoot",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    disabled: {
      type: Boolean,
      required: false
    },
    unmountOnHide: {
      type: Boolean,
      required: false,
      default: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:open"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const { disabled, unmountOnHide } = toRefs(props2);
    provideCollapsibleRootContext({
      contentId: "",
      disabled,
      open,
      unmountOnHide,
      onOpenToggle: () => {
        if (disabled.value) return;
        open.value = !open.value;
      }
    });
    __expose({ open });
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": props2.asChild,
        "data-state": unref(open) ? "open" : "closed",
        "data-disabled": unref(disabled) ? "" : void 0
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "data-state",
        "data-disabled"
      ]);
    };
  }
});
var CollapsibleRoot_default = CollapsibleRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Collapsible/CollapsibleContent.js
var CollapsibleContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "CollapsibleContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["contentFound"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectCollapsibleRootContext();
    rootContext.contentId ||= useId2(void 0, "reka-collapsible-content");
    const presentRef = ref();
    const { forwardRef, currentElement } = useForwardExpose();
    const width = ref(0);
    const height = ref(0);
    const isOpen = computed(() => rootContext.open.value);
    const isMountAnimationPrevented = ref(isOpen.value);
    const currentStyle = ref();
    watch(() => [isOpen.value, presentRef.value?.present], async () => {
      await nextTick();
      const node = currentElement.value;
      if (!node) return;
      currentStyle.value = currentStyle.value || {
        transitionDuration: node.style.transitionDuration,
        animationName: node.style.animationName
      };
      node.style.transitionDuration = "0s";
      node.style.animationName = "none";
      const rect = node.getBoundingClientRect();
      height.value = rect.height;
      width.value = rect.width;
      if (!isMountAnimationPrevented.value) {
        node.style.transitionDuration = currentStyle.value.transitionDuration;
        node.style.animationName = currentStyle.value.animationName;
      }
    }, { immediate: true });
    const skipAnimation = computed(() => isMountAnimationPrevented.value && rootContext.open.value);
    onMounted(() => {
      requestAnimationFrame(() => {
        isMountAnimationPrevented.value = false;
      });
    });
    useEventListener(currentElement, "beforematch", (ev) => {
      requestAnimationFrame(() => {
        rootContext.onOpenToggle();
        emits("contentFound");
      });
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), {
        ref_key: "presentRef",
        ref: presentRef,
        present: _ctx.forceMount || unref(rootContext).open.value,
        "force-mount": true
      }, {
        default: withCtx(({ present }) => [createVNode(unref(Primitive), mergeProps(_ctx.$attrs, {
          id: unref(rootContext).contentId,
          ref: unref(forwardRef),
          "as-child": props2.asChild,
          as: _ctx.as,
          hidden: !present ? unref(rootContext).unmountOnHide.value ? "" : "until-found" : void 0,
          "data-state": skipAnimation.value ? void 0 : unref(rootContext).open.value ? "open" : "closed",
          "data-disabled": unref(rootContext).disabled?.value ? "" : void 0,
          style: {
            [`--reka-collapsible-content-height`]: `${height.value}px`,
            [`--reka-collapsible-content-width`]: `${width.value}px`
          }
        }), {
          default: withCtx(() => [(unref(rootContext).unmountOnHide.value ? present : true) ? renderSlot(_ctx.$slots, "default", { key: 0 }) : createCommentVNode("v-if", true)]),
          _: 2
        }, 1040, [
          "id",
          "as-child",
          "as",
          "hidden",
          "data-state",
          "data-disabled",
          "style"
        ])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var CollapsibleContent_default = CollapsibleContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Collapsible/CollapsibleTrigger.js
var CollapsibleTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CollapsibleTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectCollapsibleRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        type: _ctx.as === "button" ? "button" : void 0,
        as: _ctx.as,
        "as-child": props2.asChild,
        "aria-controls": unref(rootContext).contentId,
        "aria-expanded": unref(rootContext).open.value,
        "data-state": unref(rootContext).open.value ? "open" : "closed",
        "data-disabled": unref(rootContext).disabled?.value ? "" : void 0,
        disabled: unref(rootContext).disabled?.value,
        onClick: unref(rootContext).onOpenToggle
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "type",
        "as",
        "as-child",
        "aria-controls",
        "aria-expanded",
        "data-state",
        "data-disabled",
        "disabled",
        "onClick"
      ]);
    };
  }
});
var CollapsibleTrigger_default = CollapsibleTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/shared/useSingleOrMultipleValue.js
function validateProps({ type, defaultValue, modelValue }) {
  const value = modelValue || defaultValue;
  const canTypeBeInferred = modelValue !== void 0 || defaultValue !== void 0;
  if (canTypeBeInferred) return Array.isArray(value) ? "multiple" : "single";
  else return type ?? "single";
}
function getDefaultType({ type, defaultValue, modelValue }) {
  if (type) return type;
  return validateProps({
    type,
    defaultValue,
    modelValue
  });
}
function getDefaultValue({ type, defaultValue }) {
  if (defaultValue !== void 0) return defaultValue;
  return type === "single" ? void 0 : [];
}
function useSingleOrMultipleValue(props2, emits) {
  const type = computed(() => getDefaultType(props2));
  const modelValue = useVModel(props2, "modelValue", emits, {
    defaultValue: getDefaultValue(props2),
    passive: props2.modelValue === void 0,
    deep: true
  });
  function changeModelValue(value) {
    if (type.value === "single") modelValue.value = isEqual(value, modelValue.value) ? void 0 : value;
    else {
      const modelValueArray = Array.isArray(modelValue.value) ? [...modelValue.value || []] : [modelValue.value].filter(Boolean);
      if (isValueEqualOrExist(modelValueArray, value)) {
        const index = modelValueArray.findIndex((i) => isEqual(i, value));
        modelValueArray.splice(index, 1);
      } else modelValueArray.push(value);
      modelValue.value = modelValueArray;
    }
  }
  const isSingle = computed(() => type.value === "single");
  return {
    modelValue,
    changeModelValue,
    isSingle
  };
}

// node_modules/reka-ui/dist/Accordion/AccordionRoot.js
var [injectAccordionRootContext, provideAccordionRootContext] = createContext("AccordionRoot");
var AccordionRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AccordionRoot",
  props: {
    collapsible: {
      type: Boolean,
      required: false,
      default: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    dir: {
      type: String,
      required: false
    },
    orientation: {
      type: String,
      required: false,
      default: "vertical"
    },
    unmountOnHide: {
      type: Boolean,
      required: false,
      default: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    type: {
      type: String,
      required: false
    },
    modelValue: {
      type: null,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { dir, disabled, unmountOnHide } = toRefs(props2);
    const direction = useDirection(dir);
    const { modelValue, changeModelValue, isSingle } = useSingleOrMultipleValue(props2, emits);
    const { forwardRef, currentElement: parentElement } = useForwardExpose();
    provideAccordionRootContext({
      disabled,
      direction,
      orientation: props2.orientation,
      parentElement,
      isSingle,
      collapsible: props2.collapsible,
      modelValue,
      changeModelValue,
      unmountOnHide
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        "as-child": _ctx.asChild,
        as: _ctx.as
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
        _: 3
      }, 8, ["as-child", "as"]);
    };
  }
});
var AccordionRoot_default = AccordionRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Accordion/AccordionItem.js
var AccordionItemState = (function(AccordionItemState$1) {
  AccordionItemState$1["Open"] = "open";
  AccordionItemState$1["Closed"] = "closed";
  return AccordionItemState$1;
})(AccordionItemState || {});
var [injectAccordionItemContext, provideAccordionItemContext] = createContext("AccordionItem");
var AccordionItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AccordionItem",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    value: {
      type: String,
      required: true
    },
    unmountOnHide: {
      type: Boolean,
      required: false,
      default: void 0
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props, { expose: __expose }) {
    const props2 = __props;
    const rootContext = injectAccordionRootContext();
    const open = computed(() => rootContext.isSingle.value ? props2.value === rootContext.modelValue.value : Array.isArray(rootContext.modelValue.value) && rootContext.modelValue.value.includes(props2.value));
    const disabled = computed(() => {
      return rootContext.disabled.value || props2.disabled;
    });
    const dataDisabled = computed(() => disabled.value ? "" : void 0);
    const dataState = computed(() => open.value ? AccordionItemState.Open : AccordionItemState.Closed);
    __expose({
      open,
      dataDisabled
    });
    const { currentRef, currentElement } = useForwardExpose();
    provideAccordionItemContext({
      open,
      dataState,
      disabled,
      dataDisabled,
      triggerId: "",
      currentRef,
      currentElement,
      value: computed(() => props2.value)
    });
    function handleArrowKey(e) {
      const target = e.target;
      const allCollectionItems = Array.from(rootContext.parentElement.value?.querySelectorAll("[data-reka-collection-item]") ?? []);
      const collectionItemIndex = allCollectionItems.findIndex((item) => item === target);
      if (collectionItemIndex === -1) return null;
      useArrowNavigation(e, target, rootContext.parentElement.value, {
        arrowKeyOptions: rootContext.orientation,
        dir: rootContext.direction.value,
        focus: true
      });
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollapsibleRoot_default), {
        "data-orientation": unref(rootContext).orientation,
        "data-disabled": dataDisabled.value,
        "data-state": dataState.value,
        disabled: disabled.value,
        open: open.value,
        as: props2.as,
        "as-child": props2.asChild,
        "unmount-on-hide": props2.unmountOnHide ?? unref(rootContext).unmountOnHide.value,
        onKeydown: withKeys(handleArrowKey, [
          "up",
          "down",
          "left",
          "right",
          "home",
          "end"
        ])
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: open.value })]),
        _: 3
      }, 8, [
        "data-orientation",
        "data-disabled",
        "data-state",
        "disabled",
        "open",
        "as",
        "as-child",
        "unmount-on-hide"
      ]);
    };
  }
});
var AccordionItem_default = AccordionItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Accordion/AccordionContent.js
var AccordionContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AccordionContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectAccordionRootContext();
    const itemContext = injectAccordionItemContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollapsibleContent_default), {
        role: "region",
        "as-child": props2.asChild,
        as: _ctx.as,
        "force-mount": props2.forceMount,
        "aria-labelledby": unref(itemContext).triggerId,
        "data-state": unref(itemContext).dataState.value,
        "data-disabled": unref(itemContext).dataDisabled.value,
        "data-orientation": unref(rootContext).orientation,
        style: {
          "--reka-accordion-content-width": "var(--reka-collapsible-content-width)",
          "--reka-accordion-content-height": "var(--reka-collapsible-content-height)"
        },
        onContentFound: _cache[0] || (_cache[0] = ($event) => unref(rootContext).changeModelValue(unref(itemContext).value.value))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "force-mount",
        "aria-labelledby",
        "data-state",
        "data-disabled",
        "data-orientation"
      ]);
    };
  }
});
var AccordionContent_default = AccordionContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Accordion/AccordionHeader.js
var AccordionHeader_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AccordionHeader",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "h3"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectAccordionRootContext();
    const itemContext = injectAccordionItemContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: props2.as,
        "as-child": props2.asChild,
        "data-orientation": unref(rootContext).orientation,
        "data-state": unref(itemContext).dataState.value,
        "data-disabled": unref(itemContext).dataDisabled.value
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "data-orientation",
        "data-state",
        "data-disabled"
      ]);
    };
  }
});
var AccordionHeader_default = AccordionHeader_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Accordion/AccordionTrigger.js
var AccordionTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AccordionTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectAccordionRootContext();
    const itemContext = injectAccordionItemContext();
    itemContext.triggerId ||= useId2(void 0, "reka-accordion-trigger");
    function changeItem() {
      const triggerDisabled = rootContext.isSingle.value && itemContext.open.value && !rootContext.collapsible;
      if (itemContext.disabled.value || triggerDisabled) return;
      rootContext.changeModelValue(itemContext.value.value);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollapsibleTrigger_default), {
        id: unref(itemContext).triggerId,
        ref: unref(itemContext).currentRef,
        "data-reka-collection-item": "",
        as: props2.as,
        "as-child": props2.asChild,
        "aria-disabled": unref(itemContext).disabled.value || void 0,
        "aria-expanded": unref(itemContext).open.value || false,
        "data-disabled": unref(itemContext).dataDisabled.value,
        "data-orientation": unref(rootContext).orientation,
        "data-state": unref(itemContext).dataState.value,
        disabled: unref(itemContext).disabled.value,
        onClick: changeItem
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "id",
        "as",
        "as-child",
        "aria-disabled",
        "aria-expanded",
        "data-disabled",
        "data-orientation",
        "data-state",
        "disabled"
      ]);
    };
  }
});
var AccordionTrigger_default = AccordionTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogRoot.js
var [injectDialogRootContext, provideDialogRootContext] = createContext("DialogRoot");
var DialogRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "DialogRoot",
  props: {
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    modal: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const triggerElement = ref();
    const contentElement = ref();
    const { modal } = toRefs(props2);
    provideDialogRootContext({
      open,
      modal,
      openModal: () => {
        open.value = true;
      },
      onOpenChange: (value) => {
        open.value = value;
      },
      onOpenToggle: () => {
        open.value = !open.value;
      },
      contentId: "",
      titleId: "",
      descriptionId: "",
      triggerElement,
      contentElement
    });
    return (_ctx, _cache) => {
      return renderSlot(_ctx.$slots, "default", {
        open: unref(open),
        close: () => open.value = false
      });
    };
  }
});
var DialogRoot_default = DialogRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogClose.js
var DialogClose_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogClose",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectDialogRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        type: _ctx.as === "button" ? "button" : void 0,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).onOpenChange(false))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["type"]);
    };
  }
});
var DialogClose_default = DialogClose_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DismissableLayer/utils.js
var POINTER_DOWN_OUTSIDE = "dismissableLayer.pointerDownOutside";
var FOCUS_OUTSIDE = "dismissableLayer.focusOutside";
function isLayerExist(layerElement, targetElement) {
  const targetLayer = targetElement.closest("[data-dismissable-layer]");
  const mainLayer = layerElement.dataset.dismissableLayer === "" ? layerElement : layerElement.querySelector("[data-dismissable-layer]");
  const nodeList = Array.from(layerElement.ownerDocument.querySelectorAll("[data-dismissable-layer]"));
  if (targetLayer && (mainLayer === targetLayer || nodeList.indexOf(mainLayer) < nodeList.indexOf(targetLayer))) return true;
  else return false;
}
function usePointerDownOutside(onPointerDownOutside, element, enabled = true) {
  const ownerDocument = element?.value?.ownerDocument ?? globalThis?.document;
  const isPointerInsideDOMTree = ref(false);
  const handleClickRef = ref(() => {
  });
  watchEffect((cleanupFn) => {
    if (!isClient || !toValue(enabled)) return;
    const handlePointerDown2 = async (event) => {
      const target = event.target;
      if (!element?.value || !target) return;
      if (isLayerExist(element.value, target)) {
        isPointerInsideDOMTree.value = false;
        return;
      }
      if (event.target && !isPointerInsideDOMTree.value) {
        let handleAndDispatchPointerDownOutsideEvent = function() {
          handleAndDispatchCustomEvent(POINTER_DOWN_OUTSIDE, onPointerDownOutside, eventDetail);
        };
        const eventDetail = { originalEvent: event };
        if (event.pointerType === "touch") {
          ownerDocument.removeEventListener("click", handleClickRef.value);
          handleClickRef.value = handleAndDispatchPointerDownOutsideEvent;
          ownerDocument.addEventListener("click", handleClickRef.value, { once: true });
        } else handleAndDispatchPointerDownOutsideEvent();
      } else ownerDocument.removeEventListener("click", handleClickRef.value);
      isPointerInsideDOMTree.value = false;
    };
    const timerId = window.setTimeout(() => {
      ownerDocument.addEventListener("pointerdown", handlePointerDown2);
    }, 0);
    cleanupFn(() => {
      window.clearTimeout(timerId);
      ownerDocument.removeEventListener("pointerdown", handlePointerDown2);
      ownerDocument.removeEventListener("click", handleClickRef.value);
    });
  });
  return { onPointerDownCapture: () => {
    if (!toValue(enabled)) return;
    isPointerInsideDOMTree.value = true;
  } };
}
function useFocusOutside(onFocusOutside, element, enabled = true) {
  const ownerDocument = element?.value?.ownerDocument ?? globalThis?.document;
  const isFocusInsideDOMTree = ref(false);
  watchEffect((cleanupFn) => {
    if (!isClient || !toValue(enabled)) return;
    const handleFocus = async (event) => {
      if (!element?.value) return;
      await nextTick();
      await nextTick();
      const target = event.target;
      if (!element.value || !target || isLayerExist(element.value, target)) return;
      if (event.target && !isFocusInsideDOMTree.value) {
        const eventDetail = { originalEvent: event };
        handleAndDispatchCustomEvent(FOCUS_OUTSIDE, onFocusOutside, eventDetail);
      }
    };
    ownerDocument.addEventListener("focusin", handleFocus);
    cleanupFn(() => ownerDocument.removeEventListener("focusin", handleFocus));
  });
  return {
    onFocusCapture: () => {
      if (!toValue(enabled)) return;
      isFocusInsideDOMTree.value = true;
    },
    onBlurCapture: () => {
      if (!toValue(enabled)) return;
      isFocusInsideDOMTree.value = false;
    }
  };
}

// node_modules/reka-ui/dist/DismissableLayer/DismissableLayer.js
var context = reactive({
  layersRoot: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  originalBodyPointerEvents: void 0,
  branches: /* @__PURE__ */ new Set()
});
var DismissableLayer_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DismissableLayer",
  props: {
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "dismiss"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { forwardRef, currentElement: layerElement } = useForwardExpose();
    const ownerDocument = computed(() => layerElement.value?.ownerDocument ?? globalThis.document);
    const layers = computed(() => context.layersRoot);
    const index = computed(() => {
      return layerElement.value ? Array.from(layers.value).indexOf(layerElement.value) : -1;
    });
    const isBodyPointerEventsDisabled = computed(() => {
      return context.layersWithOutsidePointerEventsDisabled.size > 0;
    });
    const isPointerEventsEnabled = computed(() => {
      const localLayers = Array.from(layers.value);
      const [highestLayerWithOutsidePointerEventsDisabled] = [...context.layersWithOutsidePointerEventsDisabled].slice(-1);
      const highestLayerWithOutsidePointerEventsDisabledIndex = localLayers.indexOf(highestLayerWithOutsidePointerEventsDisabled);
      return index.value >= highestLayerWithOutsidePointerEventsDisabledIndex;
    });
    const pointerDownOutside = usePointerDownOutside(async (event) => {
      const isPointerDownOnBranch = [...context.branches].some((branch) => branch?.contains(event.target));
      if (!isPointerEventsEnabled.value || isPointerDownOnBranch) return;
      emits("pointerDownOutside", event);
      emits("interactOutside", event);
      await nextTick();
      if (!event.defaultPrevented) emits("dismiss");
    }, layerElement);
    const focusOutside = useFocusOutside((event) => {
      const isFocusInBranch = [...context.branches].some((branch) => branch?.contains(event.target));
      if (isFocusInBranch) return;
      emits("focusOutside", event);
      emits("interactOutside", event);
      if (!event.defaultPrevented) emits("dismiss");
    }, layerElement);
    onKeyStroke("Escape", (event) => {
      const isHighestLayer = index.value === layers.value.size - 1;
      if (!isHighestLayer) return;
      emits("escapeKeyDown", event);
      if (!event.defaultPrevented) emits("dismiss");
    });
    watchEffect((cleanupFn) => {
      if (!layerElement.value) return;
      if (props2.disableOutsidePointerEvents) {
        if (context.layersWithOutsidePointerEventsDisabled.size === 0) {
          context.originalBodyPointerEvents = ownerDocument.value.body.style.pointerEvents;
          ownerDocument.value.body.style.pointerEvents = "none";
        }
        context.layersWithOutsidePointerEventsDisabled.add(layerElement.value);
      }
      layers.value.add(layerElement.value);
      cleanupFn(() => {
        if (props2.disableOutsidePointerEvents && context.layersWithOutsidePointerEventsDisabled.size === 1 && !isNullish(context.originalBodyPointerEvents)) ownerDocument.value.body.style.pointerEvents = context.originalBodyPointerEvents;
      });
    });
    watchEffect((cleanupFn) => {
      cleanupFn(() => {
        if (!layerElement.value) return;
        layers.value.delete(layerElement.value);
        context.layersWithOutsidePointerEventsDisabled.delete(layerElement.value);
      });
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        "as-child": _ctx.asChild,
        as: _ctx.as,
        "data-dismissable-layer": "",
        style: normalizeStyle({ pointerEvents: isBodyPointerEventsDisabled.value ? isPointerEventsEnabled.value ? "auto" : "none" : void 0 }),
        onFocusCapture: unref(focusOutside).onFocusCapture,
        onBlurCapture: unref(focusOutside).onBlurCapture,
        onPointerdownCapture: unref(pointerDownOutside).onPointerDownCapture
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "style",
        "onFocusCapture",
        "onBlurCapture",
        "onPointerdownCapture"
      ]);
    };
  }
});
var DismissableLayer_default = DismissableLayer_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DismissableLayer/DismissableLayerBranch.js
var DismissableLayerBranch_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DismissableLayerBranch",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef, currentElement } = useForwardExpose();
    onMounted(() => {
      context.branches.add(currentElement.value);
    });
    onUnmounted(() => {
      context.branches.delete(currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ ref: unref(forwardRef) }, props2), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DismissableLayerBranch_default = DismissableLayerBranch_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/FocusScope/stack.js
var useFocusStackState = createGlobalState(() => {
  const stack = ref([]);
  return stack;
});
function createFocusScopesStack() {
  const stack = useFocusStackState();
  return {
    add(focusScope) {
      const activeFocusScope = stack.value[0];
      if (focusScope !== activeFocusScope) activeFocusScope?.pause();
      stack.value = arrayRemove(stack.value, focusScope);
      stack.value.unshift(focusScope);
    },
    remove(focusScope) {
      stack.value = arrayRemove(stack.value, focusScope);
      stack.value[0]?.resume();
    }
  };
}
function arrayRemove(array, item) {
  const updatedArray = [...array];
  const index = updatedArray.indexOf(item);
  if (index !== -1) updatedArray.splice(index, 1);
  return updatedArray;
}
function removeLinks(items) {
  return items.filter((item) => item.tagName !== "A");
}

// node_modules/reka-ui/dist/FocusScope/utils.js
var AUTOFOCUS_ON_MOUNT = "focusScope.autoFocusOnMount";
var AUTOFOCUS_ON_UNMOUNT = "focusScope.autoFocusOnUnmount";
var EVENT_OPTIONS = {
  bubbles: false,
  cancelable: true
};
function focusFirst(candidates, { select = false } = {}) {
  const previouslyFocusedElement = getActiveElement();
  for (const candidate of candidates) {
    focus(candidate, { select });
    if (getActiveElement() !== previouslyFocusedElement) return true;
  }
}
function getTabbableEdges(container) {
  const candidates = getTabbableCandidates(container);
  const first = findVisible(candidates, container);
  const last = findVisible(candidates.reverse(), container);
  return [first, last];
}
function getTabbableCandidates(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, { acceptNode: (node) => {
    const isHiddenInput = node.tagName === "INPUT" && node.type === "hidden";
    if (node.disabled || node.hidden || isHiddenInput) return NodeFilter.FILTER_SKIP;
    return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
  } });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}
function findVisible(elements, container) {
  for (const element of elements) if (!isHidden(element, { upTo: container })) return element;
}
function isHidden(node, { upTo }) {
  if (getComputedStyle(node).visibility === "hidden") return true;
  while (node) {
    if (upTo !== void 0 && node === upTo) return false;
    if (getComputedStyle(node).display === "none") return true;
    node = node.parentElement;
  }
  return false;
}
function isSelectableInput(element) {
  return element instanceof HTMLInputElement && "select" in element;
}
function focus(element, { select = false } = {}) {
  if (element && element.focus) {
    const previouslyFocusedElement = getActiveElement();
    element.focus({ preventScroll: true });
    if (element !== previouslyFocusedElement && isSelectableInput(element) && select) element.select();
  }
}

// node_modules/reka-ui/dist/FocusScope/FocusScope.js
var FocusScope_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "FocusScope",
  props: {
    loop: {
      type: Boolean,
      required: false,
      default: false
    },
    trapped: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["mountAutoFocus", "unmountAutoFocus"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { currentRef, currentElement } = useForwardExpose();
    const lastFocusedElementRef = ref(null);
    const focusScopesStack = createFocusScopesStack();
    const focusScope = reactive({
      paused: false,
      pause() {
        this.paused = true;
      },
      resume() {
        this.paused = false;
      }
    });
    watchEffect((cleanupFn) => {
      if (!isClient) return;
      const container = currentElement.value;
      if (!props2.trapped) return;
      function handleFocusIn(event) {
        if (focusScope.paused || !container) return;
        const target = event.target;
        if (container.contains(target)) lastFocusedElementRef.value = target;
        else focus(lastFocusedElementRef.value, { select: true });
      }
      function handleFocusOut(event) {
        if (focusScope.paused || !container) return;
        const relatedTarget = event.relatedTarget;
        if (relatedTarget === null) return;
        if (!container.contains(relatedTarget)) focus(lastFocusedElementRef.value, { select: true });
      }
      function handleMutations(mutations) {
        const isLastFocusedElementExist = container.contains(lastFocusedElementRef.value);
        if (!isLastFocusedElementExist) focus(container);
      }
      document.addEventListener("focusin", handleFocusIn);
      document.addEventListener("focusout", handleFocusOut);
      const mutationObserver = new MutationObserver(handleMutations);
      if (container) mutationObserver.observe(container, {
        childList: true,
        subtree: true
      });
      cleanupFn(() => {
        document.removeEventListener("focusin", handleFocusIn);
        document.removeEventListener("focusout", handleFocusOut);
        mutationObserver.disconnect();
      });
    });
    watchEffect(async (cleanupFn) => {
      const container = currentElement.value;
      await nextTick();
      if (!container) return;
      focusScopesStack.add(focusScope);
      const previouslyFocusedElement = getActiveElement();
      const hasFocusedCandidate = container.contains(previouslyFocusedElement);
      if (!hasFocusedCandidate) {
        const mountEvent = new CustomEvent(AUTOFOCUS_ON_MOUNT, EVENT_OPTIONS);
        container.addEventListener(AUTOFOCUS_ON_MOUNT, (ev) => emits("mountAutoFocus", ev));
        container.dispatchEvent(mountEvent);
        if (!mountEvent.defaultPrevented) {
          focusFirst(removeLinks(getTabbableCandidates(container)), { select: true });
          if (getActiveElement() === previouslyFocusedElement) focus(container);
        }
      }
      cleanupFn(() => {
        container.removeEventListener(AUTOFOCUS_ON_MOUNT, (ev) => emits("mountAutoFocus", ev));
        const unmountEvent = new CustomEvent(AUTOFOCUS_ON_UNMOUNT, EVENT_OPTIONS);
        const unmountEventHandler = (ev) => {
          emits("unmountAutoFocus", ev);
        };
        container.addEventListener(AUTOFOCUS_ON_UNMOUNT, unmountEventHandler);
        container.dispatchEvent(unmountEvent);
        setTimeout(() => {
          if (!unmountEvent.defaultPrevented) focus(previouslyFocusedElement ?? document.body, { select: true });
          container.removeEventListener(AUTOFOCUS_ON_UNMOUNT, unmountEventHandler);
          focusScopesStack.remove(focusScope);
        }, 0);
      });
    });
    function handleKeyDown(event) {
      if (!props2.loop && !props2.trapped) return;
      if (focusScope.paused) return;
      const isTabKey = event.key === "Tab" && !event.altKey && !event.ctrlKey && !event.metaKey;
      const focusedElement = getActiveElement();
      if (isTabKey && focusedElement) {
        const container = event.currentTarget;
        const [first, last] = getTabbableEdges(container);
        const hasTabbableElementsInside = first && last;
        if (!hasTabbableElementsInside) {
          if (focusedElement === container) event.preventDefault();
        } else if (!event.shiftKey && focusedElement === last) {
          event.preventDefault();
          if (props2.loop) focus(first, { select: true });
        } else if (event.shiftKey && focusedElement === first) {
          event.preventDefault();
          if (props2.loop) focus(last, { select: true });
        }
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "currentRef",
        ref: currentRef,
        tabindex: "-1",
        "as-child": _ctx.asChild,
        as: _ctx.as,
        onKeydown: handleKeyDown
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as-child", "as"]);
    };
  }
});
var FocusScope_default = FocusScope_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/utils.js
var ITEM_SELECT = "menu.itemSelect";
var SELECTION_KEYS = ["Enter", " "];
var FIRST_KEYS = [
  "ArrowDown",
  "PageUp",
  "Home"
];
var LAST_KEYS = [
  "ArrowUp",
  "PageDown",
  "End"
];
var FIRST_LAST_KEYS = [...FIRST_KEYS, ...LAST_KEYS];
var SUB_OPEN_KEYS = {
  ltr: [...SELECTION_KEYS, "ArrowRight"],
  rtl: [...SELECTION_KEYS, "ArrowLeft"]
};
var SUB_CLOSE_KEYS = {
  ltr: ["ArrowLeft"],
  rtl: ["ArrowRight"]
};
function getOpenState(open) {
  return open ? "open" : "closed";
}
function isIndeterminate(checked) {
  return checked === "indeterminate";
}
function getCheckedState(checked) {
  return isIndeterminate(checked) ? "indeterminate" : checked ? "checked" : "unchecked";
}
function focusFirst2(candidates) {
  const PREVIOUSLY_FOCUSED_ELEMENT = getActiveElement();
  for (const candidate of candidates) {
    if (candidate === PREVIOUSLY_FOCUSED_ELEMENT) return;
    candidate.focus();
    if (getActiveElement() !== PREVIOUSLY_FOCUSED_ELEMENT) return;
  }
}
function isPointInPolygon2(point, polygon) {
  const { x, y } = point;
  let inside = false;
  for (let i = 0, j = polygon.length - 1; i < polygon.length; j = i++) {
    const xi = polygon[i].x;
    const yi = polygon[i].y;
    const xj = polygon[j].x;
    const yj = polygon[j].y;
    const intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;
    if (intersect) inside = !inside;
  }
  return inside;
}
function isPointerInGraceArea(event, area) {
  if (!area) return false;
  const cursorPos = {
    x: event.clientX,
    y: event.clientY
  };
  return isPointInPolygon2(cursorPos, area);
}
function isMouseEvent(event) {
  return event.pointerType === "mouse";
}

// node_modules/reka-ui/dist/Dialog/utils.js
var DEFAULT_TITLE_NAME = "DialogTitle";
var DEFAULT_CONTENT_NAME = "DialogContent";
function useWarning({ titleName = DEFAULT_TITLE_NAME, contentName = DEFAULT_CONTENT_NAME, componentLink = "dialog.html#title", titleId, descriptionId, contentElement }) {
  const TITLE_MESSAGE = `Warning: \`${contentName}\` requires a \`${titleName}\` for the component to be accessible for screen reader users.

If you want to hide the \`${titleName}\`, you can wrap it with our VisuallyHidden component.

For more information, see https://www.reka-ui.com/docs/components/${componentLink}`;
  const DESCRIPTION_MESSAGE = `Warning: Missing \`Description\` or \`aria-describedby="undefined"\` for ${contentName}.`;
  onMounted(() => {
    const hasTitle = document.getElementById(titleId);
    if (!hasTitle) console.warn(TITLE_MESSAGE);
    const describedById = contentElement.value?.getAttribute("aria-describedby");
    if (descriptionId && describedById) {
      const hasDescription = document.getElementById(descriptionId);
      if (!hasDescription) console.warn(DESCRIPTION_MESSAGE);
    }
  });
}

// node_modules/reka-ui/dist/Dialog/DialogContentImpl.js
var DialogContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogContentImpl",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    trapFocus: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectDialogRootContext();
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    rootContext.titleId ||= useId2(void 0, "reka-dialog-title");
    rootContext.descriptionId ||= useId2(void 0, "reka-dialog-description");
    onMounted(() => {
      rootContext.contentElement = contentElement;
      if (getActiveElement() !== document.body) rootContext.triggerElement.value = getActiveElement();
    });
    if (true) useWarning({
      titleName: "DialogTitle",
      contentName: "DialogContent",
      componentLink: "dialog.html#title",
      titleId: rootContext.titleId,
      descriptionId: rootContext.descriptionId,
      contentElement
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(FocusScope_default), {
        "as-child": "",
        loop: "",
        trapped: props2.trapFocus,
        onMountAutoFocus: _cache[5] || (_cache[5] = ($event) => emits("openAutoFocus", $event)),
        onUnmountAutoFocus: _cache[6] || (_cache[6] = ($event) => emits("closeAutoFocus", $event))
      }, {
        default: withCtx(() => [createVNode(unref(DismissableLayer_default), mergeProps({
          id: unref(rootContext).contentId,
          ref: unref(forwardRef),
          as: _ctx.as,
          "as-child": _ctx.asChild,
          "disable-outside-pointer-events": _ctx.disableOutsidePointerEvents,
          role: "dialog",
          "aria-describedby": unref(rootContext).descriptionId,
          "aria-labelledby": unref(rootContext).titleId,
          "data-state": unref(getOpenState)(unref(rootContext).open.value)
        }, _ctx.$attrs, {
          onDismiss: _cache[0] || (_cache[0] = ($event) => unref(rootContext).onOpenChange(false)),
          onEscapeKeyDown: _cache[1] || (_cache[1] = ($event) => emits("escapeKeyDown", $event)),
          onFocusOutside: _cache[2] || (_cache[2] = ($event) => emits("focusOutside", $event)),
          onInteractOutside: _cache[3] || (_cache[3] = ($event) => emits("interactOutside", $event)),
          onPointerDownOutside: _cache[4] || (_cache[4] = ($event) => emits("pointerDownOutside", $event))
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "id",
          "as",
          "as-child",
          "disable-outside-pointer-events",
          "aria-describedby",
          "aria-labelledby",
          "data-state"
        ])]),
        _: 3
      }, 8, ["trapped"]);
    };
  }
});
var DialogContentImpl_default = DialogContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogContentModal.js
var DialogContentModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogContentModal",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    trapFocus: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectDialogRootContext();
    const emitsAsProps = useEmitAsProps(emits);
    const { forwardRef, currentElement } = useForwardExpose();
    useHideOthers(currentElement);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(DialogContentImpl_default, mergeProps({
        ...props2,
        ...unref(emitsAsProps)
      }, {
        ref: unref(forwardRef),
        "trap-focus": unref(rootContext).open.value,
        "disable-outside-pointer-events": true,
        onCloseAutoFocus: _cache[0] || (_cache[0] = (event) => {
          if (!event.defaultPrevented) {
            event.preventDefault();
            unref(rootContext).triggerElement.value?.focus();
          }
        }),
        onPointerDownOutside: _cache[1] || (_cache[1] = (event) => {
          const originalEvent = event.detail.originalEvent;
          const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
          const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
          if (isRightClick) event.preventDefault();
        }),
        onFocusOutside: _cache[2] || (_cache[2] = (event) => {
          event.preventDefault();
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["trap-focus"]);
    };
  }
});
var DialogContentModal_default = DialogContentModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogContentNonModal.js
var DialogContentNonModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogContentNonModal",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    trapFocus: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    const rootContext = injectDialogRootContext();
    const hasInteractedOutsideRef = ref(false);
    const hasPointerDownOutsideRef = ref(false);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(DialogContentImpl_default, mergeProps({
        ...props2,
        ...unref(emitsAsProps)
      }, {
        "trap-focus": false,
        "disable-outside-pointer-events": false,
        onCloseAutoFocus: _cache[0] || (_cache[0] = (event) => {
          if (!event.defaultPrevented) {
            if (!hasInteractedOutsideRef.value) unref(rootContext).triggerElement.value?.focus();
            event.preventDefault();
          }
          hasInteractedOutsideRef.value = false;
          hasPointerDownOutsideRef.value = false;
        }),
        onInteractOutside: _cache[1] || (_cache[1] = (event) => {
          if (!event.defaultPrevented) {
            hasInteractedOutsideRef.value = true;
            if (event.detail.originalEvent.type === "pointerdown") hasPointerDownOutsideRef.value = true;
          }
          const target = event.target;
          const targetIsTrigger = unref(rootContext).triggerElement.value?.contains(target);
          if (targetIsTrigger) event.preventDefault();
          if (event.detail.originalEvent.type === "focusin" && hasPointerDownOutsideRef.value) event.preventDefault();
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DialogContentNonModal_default = DialogContentNonModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogContent.js
var DialogContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectDialogRootContext();
    const emitsAsProps = useEmitAsProps(emits);
    const { forwardRef } = useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(rootContext).open.value }, {
        default: withCtx(() => [unref(rootContext).modal.value ? (openBlock(), createBlock(DialogContentModal_default, mergeProps({
          key: 0,
          ref: unref(forwardRef)
        }, {
          ...props2,
          ...unref(emitsAsProps),
          ..._ctx.$attrs
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)) : (openBlock(), createBlock(DialogContentNonModal_default, mergeProps({
          key: 1,
          ref: unref(forwardRef)
        }, {
          ...props2,
          ...unref(emitsAsProps),
          ..._ctx.$attrs
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16))]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var DialogContent_default = DialogContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogDescription.js
var DialogDescription_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogDescription",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "p"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectDialogRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { id: unref(rootContext).descriptionId }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var DialogDescription_default = DialogDescription_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogOverlayImpl.js
var DialogOverlayImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogOverlayImpl",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const rootContext = injectDialogRootContext();
    useBodyScrollLock(true);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "data-state": unref(rootContext).open.value ? "open" : "closed",
        style: { "pointer-events": "auto" }
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "data-state"
      ]);
    };
  }
});
var DialogOverlayImpl_default = DialogOverlayImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogOverlay.js
var DialogOverlay_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogOverlay",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const rootContext = injectDialogRootContext();
    const { forwardRef } = useForwardExpose();
    return (_ctx, _cache) => {
      return unref(rootContext)?.modal.value ? (openBlock(), createBlock(unref(Presence_default), {
        key: 0,
        present: _ctx.forceMount || unref(rootContext).open.value
      }, {
        default: withCtx(() => [createVNode(DialogOverlayImpl_default, mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          as: _ctx.as,
          "as-child": _ctx.asChild
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["as", "as-child"])]),
        _: 3
      }, 8, ["present"])) : createCommentVNode("v-if", true);
    };
  }
});
var DialogOverlay_default = DialogOverlay_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Teleport/Teleport.js
var Teleport_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "Teleport",
  props: {
    to: {
      type: null,
      required: false,
      default: "body"
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const isMounted = useMounted();
    return (_ctx, _cache) => {
      return unref(isMounted) || _ctx.forceMount ? (openBlock(), createBlock(Teleport, {
        key: 0,
        to: _ctx.to,
        disabled: _ctx.disabled,
        defer: _ctx.defer
      }, [renderSlot(_ctx.$slots, "default")], 8, [
        "to",
        "disabled",
        "defer"
      ])) : createCommentVNode("v-if", true);
    };
  }
});
var Teleport_default = Teleport_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogPortal.js
var DialogPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DialogPortal_default = DialogPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogTitle.js
var DialogTitle_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogTitle",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "h2"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDialogRootContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { id: unref(rootContext).titleId }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var DialogTitle_default = DialogTitle_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Dialog/DialogTrigger.js
var DialogTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DialogTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDialogRootContext();
    const { forwardRef, currentElement } = useForwardExpose();
    rootContext.contentId ||= useId2(void 0, "reka-dialog-content");
    onMounted(() => {
      rootContext.triggerElement.value = currentElement.value;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        ref: unref(forwardRef),
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-haspopup": "dialog",
        "aria-expanded": unref(rootContext).open.value || false,
        "aria-controls": unref(rootContext).open.value ? unref(rootContext).contentId : void 0,
        "data-state": unref(rootContext).open.value ? "open" : "closed",
        onClick: unref(rootContext).onOpenToggle
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "type",
        "aria-expanded",
        "aria-controls",
        "data-state",
        "onClick"
      ]);
    };
  }
});
var DialogTrigger_default = DialogTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogAction.js
var AlertDialogAction_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogAction",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogClose_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogAction_default = AlertDialogAction_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogContent.js
var [injectAlertDialogContentContext, provideAlertDialogContentContext] = createContext("AlertDialogContent");
var AlertDialogContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    const cancelElement = ref();
    provideAlertDialogContentContext({ onCancelElementChange: (el) => {
      cancelElement.value = el;
    } });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogContent_default), mergeProps({
        ...props2,
        ...unref(emitsAsProps)
      }, {
        role: "alertdialog",
        onPointerDownOutside: _cache[0] || (_cache[0] = withModifiers(() => {
        }, ["prevent"])),
        onInteractOutside: _cache[1] || (_cache[1] = withModifiers(() => {
        }, ["prevent"])),
        onOpenAutoFocus: _cache[2] || (_cache[2] = () => {
          nextTick(() => {
            cancelElement.value?.focus({ preventScroll: true });
          });
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogContent_default = AlertDialogContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogCancel.js
var AlertDialogCancel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogCancel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const contentContext = injectAlertDialogContentContext();
    const { forwardRef, currentElement } = useForwardExpose();
    onMounted(() => {
      contentContext.onCancelElementChange(currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogClose_default), mergeProps(props2, { ref: unref(forwardRef) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogCancel_default = AlertDialogCancel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogDescription.js
var AlertDialogDescription_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogDescription",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "p"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogDescription_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogDescription_default = AlertDialogDescription_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogOverlay.js
var AlertDialogOverlay_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogOverlay",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogOverlay_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogOverlay_default = AlertDialogOverlay_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogPortal.js
var AlertDialogPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogPortal_default = AlertDialogPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogRoot.js
var AlertDialogRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogRoot",
  props: {
    open: {
      type: Boolean,
      required: false
    },
    defaultOpen: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogRoot_default), mergeProps(unref(forwarded), { modal: true }), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogRoot_default = AlertDialogRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogTitle.js
var AlertDialogTitle_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogTitle",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "h2"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogTitle_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogTitle_default = AlertDialogTitle_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AlertDialog/AlertDialogTrigger.js
var AlertDialogTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AlertDialogTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DialogTrigger_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var AlertDialogTrigger_default = AlertDialogTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/AspectRatio/AspectRatio.js
var AspectRatio_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "AspectRatio",
  props: {
    ratio: {
      type: Number,
      required: false,
      default: 1
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef } = useForwardExpose();
    const aspect = computed(() => {
      return 1 / props2.ratio * 100;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        style: normalizeStyle(`position: relative; width: 100%; padding-bottom: ${aspect.value}%`),
        "data-reka-aspect-ratio-wrapper": ""
      }, [createVNode(unref(Primitive), mergeProps({
        ref: unref(forwardRef),
        "as-child": _ctx.asChild,
        as: _ctx.as,
        style: {
          "position": "absolute",
          "inset": "0px"
        }
      }, _ctx.$attrs), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { aspect: aspect.value })]),
        _: 3
      }, 16, ["as-child", "as"])], 4);
    };
  }
});
var AspectRatio_default = AspectRatio_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Avatar/AvatarRoot.js
var [injectAvatarRootContext, provideAvatarRootContext] = createContext("AvatarRoot");
var AvatarRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AvatarRoot",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    useForwardExpose();
    provideAvatarRootContext({ imageLoadingStatus: ref("idle") });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "as-child": _ctx.asChild,
        as: _ctx.as
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as-child", "as"]);
    };
  }
});
var AvatarRoot_default = AvatarRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Avatar/AvatarFallback.js
var AvatarFallback_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AvatarFallback",
  props: {
    delayMs: {
      type: Number,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectAvatarRootContext();
    useForwardExpose();
    const canRender = ref(props2.delayMs === void 0);
    watchEffect((onCleanup) => {
      if (props2.delayMs && isClient) {
        const timerId = window.setTimeout(() => {
          canRender.value = true;
        }, props2.delayMs);
        onCleanup(() => {
          window.clearTimeout(timerId);
        });
      }
    });
    return (_ctx, _cache) => {
      return canRender.value && unref(rootContext).imageLoadingStatus.value !== "loaded" ? (openBlock(), createBlock(unref(Primitive), {
        key: 0,
        "as-child": _ctx.asChild,
        as: _ctx.as
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as-child", "as"])) : createCommentVNode("v-if", true);
    };
  }
});
var AvatarFallback_default = AvatarFallback_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Avatar/utils.js
function resolveLoadingStatus(image, src) {
  if (!image) return "idle";
  if (!src) return "error";
  if (image.src !== src) image.src = src;
  return image.complete && image.naturalWidth > 0 ? "loaded" : "loading";
}
function useImageLoadingStatus(src, { referrerPolicy, crossOrigin } = {}) {
  const isMounted = ref(false);
  const imageRef = ref(null);
  const image = computed(() => {
    if (!isMounted.value) return null;
    if (!imageRef.value && isClient) imageRef.value = new window.Image();
    return imageRef.value;
  });
  const loadingStatus = ref(resolveLoadingStatus(image.value, src.value));
  const updateStatus = (status) => () => {
    if (isMounted.value) loadingStatus.value = status;
  };
  onMounted(() => {
    isMounted.value = true;
    watchEffect((onCleanup) => {
      const img = image.value;
      if (!img) return;
      loadingStatus.value = resolveLoadingStatus(img, src.value);
      const handleLoad = updateStatus("loaded");
      const handleError = updateStatus("error");
      img.addEventListener("load", handleLoad);
      img.addEventListener("error", handleError);
      if (referrerPolicy?.value) img.referrerPolicy = referrerPolicy.value;
      if (typeof crossOrigin?.value === "string") img.crossOrigin = crossOrigin.value;
      onCleanup(() => {
        img.removeEventListener("load", handleLoad);
        img.removeEventListener("error", handleError);
      });
    });
  });
  onUnmounted(() => {
    isMounted.value = false;
  });
  return loadingStatus;
}

// node_modules/reka-ui/dist/Avatar/AvatarImage.js
var AvatarImage_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "AvatarImage",
  props: {
    src: {
      type: String,
      required: true
    },
    referrerPolicy: {
      type: null,
      required: false
    },
    crossOrigin: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "img"
    }
  },
  emits: ["loadingStatusChange"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { src, referrerPolicy, crossOrigin } = toRefs(props2);
    useForwardExpose();
    const rootContext = injectAvatarRootContext();
    const imageLoadingStatus = useImageLoadingStatus(src, {
      referrerPolicy,
      crossOrigin
    });
    watch(imageLoadingStatus, (newValue) => {
      emits("loadingStatusChange", newValue);
      if (newValue !== "idle") rootContext.imageLoadingStatus.value = newValue;
    }, { immediate: true });
    return (_ctx, _cache) => {
      return withDirectives((openBlock(), createBlock(unref(Primitive), {
        role: "img",
        "as-child": _ctx.asChild,
        as: _ctx.as,
        src: unref(src),
        "referrer-policy": unref(referrerPolicy)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "src",
        "referrer-policy"
      ])), [[vShow, unref(imageLoadingStatus) === "loaded"]]);
    };
  }
});
var AvatarImage_default = AvatarImage_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/date/parts.js
var DATE_SEGMENT_PARTS = [
  "day",
  "month",
  "year"
];
var TIME_SEGMENT_PARTS = [
  "hour",
  "minute",
  "second",
  "dayPeriod"
];
var NON_EDITABLE_SEGMENT_PARTS = ["literal", "timeZoneName"];
var EDITABLE_SEGMENT_PARTS = [...DATE_SEGMENT_PARTS, ...TIME_SEGMENT_PARTS];
var EDITABLE_TIME_SEGMENT_PARTS = [...TIME_SEGMENT_PARTS];
var ALL_SEGMENT_PARTS = [...EDITABLE_SEGMENT_PARTS, ...NON_EDITABLE_SEGMENT_PARTS];
var ALL_EXCEPT_LITERAL_PARTS = ALL_SEGMENT_PARTS.filter((part) => part !== "literal");
function isDateSegmentPart(part) {
  return DATE_SEGMENT_PARTS.includes(part);
}
function isSegmentPart(part) {
  return EDITABLE_SEGMENT_PARTS.includes(part);
}

// node_modules/reka-ui/dist/date/placeholders.js
var supportedLocales = [
  "ach",
  "af",
  "am",
  "an",
  "ar",
  "ast",
  "az",
  "be",
  "bg",
  "bn",
  "br",
  "bs",
  "ca",
  "cak",
  "ckb",
  "cs",
  "cy",
  "da",
  "de",
  "dsb",
  "el",
  "en",
  "eo",
  "es",
  "et",
  "eu",
  "fa",
  "ff",
  "fi",
  "fr",
  "fy",
  "ga",
  "gd",
  "gl",
  "he",
  "hr",
  "hsb",
  "hu",
  "ia",
  "id",
  "it",
  "ja",
  "ka",
  "kk",
  "kn",
  "ko",
  "lb",
  "lo",
  "lt",
  "lv",
  "meh",
  "ml",
  "ms",
  "nl",
  "nn",
  "no",
  "oc",
  "pl",
  "pt",
  "rm",
  "ro",
  "ru",
  "sc",
  "scn",
  "sk",
  "sl",
  "sr",
  "sv",
  "szl",
  "tg",
  "th",
  "tr",
  "uk",
  "zh-CN",
  "zh-TW"
];
var placeholderFields = [
  "year",
  "month",
  "day"
];
var placeholders = {
  "ach": {
    year: "mwaka",
    month: "dwe",
    day: "nino"
  },
  "af": {
    year: "jjjj",
    month: "mm",
    day: "dd"
  },
  "am": {
    year: "ዓዓዓዓ",
    month: "ሚሜ",
    day: "ቀቀ"
  },
  "an": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "ar": {
    year: "سنة",
    month: "شهر",
    day: "يوم"
  },
  "ast": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "az": {
    year: "iiii",
    month: "aa",
    day: "gg"
  },
  "be": {
    year: "гггг",
    month: "мм",
    day: "дд"
  },
  "bg": {
    year: "гггг",
    month: "мм",
    day: "дд"
  },
  "bn": {
    year: "yyyy",
    month: "মিমি",
    day: "dd"
  },
  "br": {
    year: "bbbb",
    month: "mm",
    day: "dd"
  },
  "bs": {
    year: "gggg",
    month: "mm",
    day: "dd"
  },
  "ca": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "cak": {
    year: "jjjj",
    month: "ii",
    day: "q'q'"
  },
  "ckb": {
    year: "ساڵ",
    month: "مانگ",
    day: "ڕۆژ"
  },
  "cs": {
    year: "rrrr",
    month: "mm",
    day: "dd"
  },
  "cy": {
    year: "bbbb",
    month: "mm",
    day: "dd"
  },
  "da": {
    year: "åååå",
    month: "mm",
    day: "dd"
  },
  "de": {
    year: "jjjj",
    month: "mm",
    day: "tt"
  },
  "dsb": {
    year: "llll",
    month: "mm",
    day: "źź"
  },
  "el": {
    year: "εεεε",
    month: "μμ",
    day: "ηη"
  },
  "en": {
    year: "yyyy",
    month: "mm",
    day: "dd"
  },
  "eo": {
    year: "jjjj",
    month: "mm",
    day: "tt"
  },
  "es": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "et": {
    year: "aaaa",
    month: "kk",
    day: "pp"
  },
  "eu": {
    year: "uuuu",
    month: "hh",
    day: "ee"
  },
  "fa": {
    year: "سال",
    month: "ماه",
    day: "روز"
  },
  "ff": {
    year: "hhhh",
    month: "ll",
    day: "ññ"
  },
  "fi": {
    year: "vvvv",
    month: "kk",
    day: "pp"
  },
  "fr": {
    year: "aaaa",
    month: "mm",
    day: "jj"
  },
  "fy": {
    year: "jjjj",
    month: "mm",
    day: "dd"
  },
  "ga": {
    year: "bbbb",
    month: "mm",
    day: "ll"
  },
  "gd": {
    year: "bbbb",
    month: "mm",
    day: "ll"
  },
  "gl": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "he": {
    year: "שנה",
    month: "חודש",
    day: "יום"
  },
  "hr": {
    year: "gggg",
    month: "mm",
    day: "dd"
  },
  "hsb": {
    year: "llll",
    month: "mm",
    day: "dd"
  },
  "hu": {
    year: "éééé",
    month: "hh",
    day: "nn"
  },
  "ia": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "id": {
    year: "tttt",
    month: "bb",
    day: "hh"
  },
  "it": {
    year: "aaaa",
    month: "mm",
    day: "gg"
  },
  "ja": {
    year: " 年 ",
    month: "月",
    day: "日"
  },
  "ka": {
    year: "წწწწ",
    month: "თთ",
    day: "რრ"
  },
  "kk": {
    year: "жжжж",
    month: "аа",
    day: "кк"
  },
  "kn": {
    year: "ವವವವ",
    month: "ಮಿಮೀ",
    day: "ದಿದಿ"
  },
  "ko": {
    year: "연도",
    month: "월",
    day: "일"
  },
  "lb": {
    year: "jjjj",
    month: "mm",
    day: "dd"
  },
  "lo": {
    year: "ປປປປ",
    month: "ດດ",
    day: "ວວ"
  },
  "lt": {
    year: "mmmm",
    month: "mm",
    day: "dd"
  },
  "lv": {
    year: "gggg",
    month: "mm",
    day: "dd"
  },
  "meh": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "ml": {
    year: "വർഷം",
    month: "മാസം",
    day: "തീയതി"
  },
  "ms": {
    year: "tttt",
    month: "mm",
    day: "hh"
  },
  "nl": {
    year: "jjjj",
    month: "mm",
    day: "dd"
  },
  "nn": {
    year: "åååå",
    month: "mm",
    day: "dd"
  },
  "no": {
    year: "åååå",
    month: "mm",
    day: "dd"
  },
  "oc": {
    year: "aaaa",
    month: "mm",
    day: "jj"
  },
  "pl": {
    year: "rrrr",
    month: "mm",
    day: "dd"
  },
  "pt": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "rm": {
    year: "oooo",
    month: "mm",
    day: "dd"
  },
  "ro": {
    year: "aaaa",
    month: "ll",
    day: "zz"
  },
  "ru": {
    year: "гггг",
    month: "мм",
    day: "дд"
  },
  "sc": {
    year: "aaaa",
    month: "mm",
    day: "dd"
  },
  "scn": {
    year: "aaaa",
    month: "mm",
    day: "jj"
  },
  "sk": {
    year: "rrrr",
    month: "mm",
    day: "dd"
  },
  "sl": {
    year: "llll",
    month: "mm",
    day: "dd"
  },
  "sr": {
    year: "гггг",
    month: "мм",
    day: "дд"
  },
  "sv": {
    year: "åååå",
    month: "mm",
    day: "dd"
  },
  "szl": {
    year: "rrrr",
    month: "mm",
    day: "dd"
  },
  "tg": {
    year: "сссс",
    month: "мм",
    day: "рр"
  },
  "th": {
    year: "ปปปป",
    month: "ดด",
    day: "วว"
  },
  "tr": {
    year: "yyyy",
    month: "aa",
    day: "gg"
  },
  "uk": {
    year: "рррр",
    month: "мм",
    day: "дд"
  },
  "zh-CN": {
    year: "年",
    month: "月",
    day: "日"
  },
  "zh-TW": {
    year: "年",
    month: "月",
    day: "日"
  }
};
function getPlaceholderObj(locale) {
  if (!isSupportedLocale(locale)) {
    const localeLanguage = getLocaleLanguage(locale);
    if (!isSupportedLocale(localeLanguage)) return placeholders.en;
    else return placeholders[localeLanguage];
  } else return placeholders[locale];
}
function getPlaceholder(field, value, locale) {
  if (isPlaceholderField(field)) return getPlaceholderObj(locale)[field];
  if (isDefaultField(field)) return value;
  if (isTimeField(field)) return "––";
  return "";
}
function isSupportedLocale(locale) {
  return supportedLocales.includes(locale);
}
function isPlaceholderField(field) {
  return placeholderFields.includes(field);
}
function isTimeField(field) {
  return field === "hour" || field === "minute" || field === "second";
}
function isDefaultField(field) {
  return field === "era" || field === "dayPeriod";
}
function getLocaleLanguage(locale) {
  if (Intl.Locale) return new Intl.Locale(locale).language;
  return locale.split("-")[0];
}

// node_modules/reka-ui/dist/date/parser.js
var calendarDateTimeGranularities = [
  "hour",
  "minute",
  "second"
];
function syncTimeSegmentValues(props2) {
  return Object.fromEntries(TIME_SEGMENT_PARTS.map((part) => {
    if (part === "dayPeriod") return [part, props2.formatter.dayPeriod(toDate(props2.value))];
    return [part, props2.value[part]];
  }));
}
function syncSegmentValues(props2) {
  const { formatter } = props2;
  const dateValues = DATE_SEGMENT_PARTS.map((part) => {
    return [part, props2.value[part]];
  });
  if ("hour" in props2.value) {
    const timeValues = syncTimeSegmentValues({
      value: props2.value,
      formatter
    });
    return {
      ...Object.fromEntries(dateValues),
      ...timeValues
    };
  }
  return Object.fromEntries(dateValues);
}
function initializeTimeSegmentValues(granularity) {
  return Object.fromEntries(TIME_SEGMENT_PARTS.map((part) => {
    if (part === "dayPeriod") return [part, "AM"];
    return [part, null];
  }).filter(([key]) => {
    if (key === "literal" || key === null) return false;
    if (granularity === "minute" && key === "second") return false;
    if (granularity === "hour" && (key === "second" || key === "minute")) return false;
    else return true;
  }));
}
function initializeSegmentValues(granularity) {
  const initialParts = EDITABLE_SEGMENT_PARTS.map((part) => {
    if (part === "dayPeriod") return [part, "AM"];
    return [part, null];
  }).filter(([key]) => {
    if (key === "literal" || key === null) return false;
    if (granularity === "minute" && key === "second") return false;
    if (granularity === "hour" && (key === "second" || key === "minute")) return false;
    if (granularity === "day") return !calendarDateTimeGranularities.includes(key) && key !== "dayPeriod";
    else return true;
  });
  return Object.fromEntries(initialParts);
}
function createContentObj(props2) {
  const { segmentValues, formatter, locale } = props2;
  function getPartContent(part) {
    if ("hour" in segmentValues) {
      const value = segmentValues[part];
      if (value !== null) {
        if (part === "day") return formatter.part(props2.dateRef.set({
          [part]: value,
          month: segmentValues.month ?? 1
        }), part, { hourCycle: normalizeHourCycle(props2.hourCycle) });
        return formatter.part(props2.dateRef.set({ [part]: value }), part, { hourCycle: normalizeHourCycle(props2.hourCycle) });
      } else return getPlaceholder(part, "", locale.value);
    } else {
      if (isDateSegmentPart(part)) {
        const value = segmentValues[part];
        if (value !== null) {
          if (part === "day") return formatter.part(props2.dateRef.set({
            [part]: value,
            month: segmentValues.month ?? 1
          }), part);
          return formatter.part(props2.dateRef.set({ [part]: value }), part);
        } else return getPlaceholder(part, "", locale.value);
      }
      return "";
    }
  }
  const content = Object.keys(segmentValues).reduce((obj, part) => {
    if (!isSegmentPart(part)) return obj;
    if ("hour" in segmentValues && part === "dayPeriod") {
      const value = segmentValues[part];
      if (value !== null) obj[part] = value;
      else obj[part] = getPlaceholder(part, "AM", locale.value);
    } else obj[part] = getPartContent(part);
    return obj;
  }, {});
  return content;
}
function createContentArr(props2) {
  const { granularity, formatter, contentObj, hideTimeZone, hourCycle, isTimeValue } = props2;
  const parts = formatter.toParts(props2.dateRef, getOptsByGranularity(granularity, hourCycle, isTimeValue));
  const segmentContentArr = parts.map((part) => {
    const defaultParts = [
      "literal",
      "timeZoneName",
      null
    ];
    if (defaultParts.includes(part.type) || !isSegmentPart(part.type)) return {
      part: part.type,
      value: part.value
    };
    return {
      part: part.type,
      value: contentObj[part.type]
    };
  }).filter((segment) => {
    if (segment.part === null || segment.value === null) return false;
    if (segment.part === "timeZoneName" && (!isZonedDateTime(props2.dateRef) || hideTimeZone)) return false;
    return true;
  });
  return segmentContentArr;
}
function createContent(props2) {
  const contentObj = createContentObj(props2);
  const contentArr = createContentArr({
    contentObj,
    ...props2
  });
  return {
    obj: contentObj,
    arr: contentArr
  };
}

// node_modules/reka-ui/dist/date/segment.js
function isSegmentNavigationKey(key) {
  const kbd = useKbd();
  if (key === kbd.ARROW_RIGHT || key === kbd.ARROW_LEFT) return true;
  return false;
}
function isNumberString(value) {
  if (Number.isNaN(Number.parseInt(value))) return false;
  return true;
}
function isAcceptableSegmentKey(key) {
  const kbd = useKbd();
  const acceptableSegmentKeys = [
    kbd.ENTER,
    kbd.ARROW_UP,
    kbd.ARROW_DOWN,
    kbd.ARROW_LEFT,
    kbd.ARROW_RIGHT,
    kbd.BACKSPACE,
    kbd.SPACE,
    "a",
    "A",
    "p",
    "P"
  ];
  if (acceptableSegmentKeys.includes(key)) return true;
  if (isNumberString(key)) return true;
  return false;
}
function getSegmentElements(parentElement) {
  return Array.from(parentElement.querySelectorAll("[data-reka-date-field-segment]")).filter((item) => item.getAttribute("data-reka-date-field-segment") !== "literal");
}
function getTimeFieldSegmentElements(parentElement) {
  return Array.from(parentElement.querySelectorAll("[data-reka-time-field-segment]")).filter((item) => item.getAttribute("data-reka-time-field-segment") !== "literal");
}

// node_modules/reka-ui/dist/date/useDateField.js
function commonSegmentAttrs(props2) {
  return {
    role: "spinbutton",
    contenteditable: true,
    tabindex: props2.disabled ? void 0 : 0,
    spellcheck: false,
    inputmode: "numeric",
    autocorrect: "off",
    enterkeyhint: "next",
    style: "caret-color: transparent;"
  };
}
function daySegmentAttrs(props2) {
  const { segmentValues, placeholder } = props2;
  const isEmpty = segmentValues.day === null;
  const dateFields = {};
  if (segmentValues.day) dateFields.day = segmentValues.day;
  if (segmentValues.month) dateFields.month = segmentValues.month;
  const date = Object.keys(dateFields).length > 0 ? placeholder.set(dateFields) : placeholder;
  const valueNow = date.day;
  const valueMin = 1;
  const valueMax = getDaysInMonth(date);
  const valueText = isEmpty ? "Empty" : `${valueNow}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "day,",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function monthSegmentAttrs(props2) {
  const { segmentValues, placeholder, formatter } = props2;
  const isEmpty = segmentValues.month === null;
  const date = segmentValues.month ? placeholder.set({ month: segmentValues.month }) : placeholder;
  const valueNow = date.month;
  const valueMin = 1;
  const valueMax = 12;
  const valueText = isEmpty ? "Empty" : `${valueNow} - ${formatter.fullMonth(toDate(date))}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "month, ",
    "contenteditable": true,
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function yearSegmentAttrs(props2) {
  const { segmentValues, placeholder } = props2;
  const isEmpty = segmentValues.year === null;
  const date = segmentValues.year ? placeholder.set({ year: segmentValues.year }) : placeholder;
  const valueMin = 1;
  const valueMax = 9999;
  const valueNow = date.year;
  const valueText = isEmpty ? "Empty" : `${valueNow}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "year, ",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function hourSegmentAttrs(props2) {
  const { segmentValues, hourCycle, placeholder } = props2;
  if (!("hour" in segmentValues) || !("hour" in placeholder)) return {};
  const isEmpty = segmentValues.hour === null;
  const date = segmentValues.hour ? placeholder.set({ hour: segmentValues.hour }) : placeholder;
  const valueMin = hourCycle === 12 ? 1 : 0;
  const valueMax = hourCycle === 12 ? 12 : 23;
  const valueNow = date.hour;
  const valueText = isEmpty ? "Empty" : `${valueNow} ${segmentValues.dayPeriod ?? ""}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "hour, ",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function minuteSegmentAttrs(props2) {
  const { segmentValues, placeholder } = props2;
  if (!("minute" in segmentValues) || !("minute" in placeholder)) return {};
  const isEmpty = segmentValues.minute === null;
  const date = segmentValues.minute ? placeholder.set({ minute: segmentValues.minute }) : placeholder;
  const valueNow = date.minute;
  const valueMin = 0;
  const valueMax = 59;
  const valueText = isEmpty ? "Empty" : `${valueNow}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "minute, ",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function secondSegmentAttrs(props2) {
  const { segmentValues, placeholder } = props2;
  if (!("second" in segmentValues) || !("second" in placeholder)) return {};
  const isEmpty = segmentValues.second === null;
  const date = segmentValues.second ? placeholder.set({ second: segmentValues.second }) : placeholder;
  const valueNow = date.second;
  const valueMin = 0;
  const valueMax = 59;
  const valueText = isEmpty ? "Empty" : `${valueNow}`;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "second, ",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText,
    "data-placeholder": isEmpty ? "" : void 0
  };
}
function dayPeriodSegmentAttrs(props2) {
  const { segmentValues } = props2;
  if (!("dayPeriod" in segmentValues)) return {};
  const valueMin = 0;
  const valueMax = 12;
  const valueNow = segmentValues.hour ? segmentValues.hour > 12 ? segmentValues.hour - 12 : segmentValues.hour : 0;
  const valueText = segmentValues.dayPeriod ?? "AM";
  return {
    ...commonSegmentAttrs(props2),
    "inputmode": "text",
    "aria-label": "AM/PM",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText
  };
}
function literalSegmentAttrs(_props) {
  return {
    "aria-hidden": true,
    "data-segment": "literal"
  };
}
function timeZoneSegmentAttrs(props2) {
  return {
    "role": "textbox",
    "aria-label": "timezone, ",
    "data-readonly": true,
    "data-segment": "timeZoneName",
    "tabindex": props2.disabled ? void 0 : 0,
    "style": "caret-color: transparent;"
  };
}
function eraSegmentAttrs(props2) {
  const { segmentValues, placeholder } = props2;
  const valueMin = 0;
  const valueMax = 0;
  const valueNow = 0;
  const valueText = "era" in segmentValues ? segmentValues.era : placeholder.era;
  return {
    ...commonSegmentAttrs(props2),
    "aria-label": "era",
    "aria-valuemin": valueMin,
    "aria-valuemax": valueMax,
    "aria-valuenow": valueNow,
    "aria-valuetext": valueText
  };
}
var segmentBuilders = {
  day: { attrs: daySegmentAttrs },
  month: { attrs: monthSegmentAttrs },
  year: { attrs: yearSegmentAttrs },
  hour: { attrs: hourSegmentAttrs },
  minute: { attrs: minuteSegmentAttrs },
  second: { attrs: secondSegmentAttrs },
  dayPeriod: { attrs: dayPeriodSegmentAttrs },
  literal: { attrs: literalSegmentAttrs },
  timeZoneName: { attrs: timeZoneSegmentAttrs },
  era: { attrs: eraSegmentAttrs }
};
function useDateField(props2) {
  const kbd = useKbd();
  function minuteSecondIncrementation({ e, part, dateRef, prevValue }) {
    const step = props2.step.value[part] ?? 1;
    const sign = e.key === kbd.ARROW_UP ? step : -step;
    const min2 = 0;
    const max2 = 59;
    if (prevValue === null) return sign > 0 ? min2 : max2;
    const cycleArgs = [part, sign];
    return dateRef.set({ [part]: prevValue }).cycle(...cycleArgs)[part];
  }
  function deleteValue(prevValue) {
    props2.hasLeftFocus.value = false;
    if (prevValue === null) return prevValue;
    const str = prevValue.toString();
    if (str.length === 1) {
      props2.modelValue.value = void 0;
      return null;
    }
    return Number.parseInt(str.slice(0, -1));
  }
  function dateTimeValueIncrementation({ e, part, dateRef, prevValue, hourCycle }) {
    const step = props2.step.value[part] ?? 1;
    const sign = e.key === kbd.ARROW_UP ? step : -step;
    if (prevValue === null) return dateRef[part];
    if (part === "hour" && "hour" in dateRef) {
      const cycleArgs$1 = [
        part,
        sign,
        { hourCycle }
      ];
      return dateRef.set({ [part]: prevValue }).cycle(...cycleArgs$1)[part];
    }
    const cycleArgs = [part, sign];
    if (part === "day") return dateRef.set({
      [part]: prevValue,
      month: props2.segmentValues.value.month ?? 1
    }).cycle(...cycleArgs)[part];
    return dateRef.set({ [part]: prevValue }).cycle(...cycleArgs)[part];
  }
  function updateDayOrMonth(max2, num, prev) {
    let moveToNext = false;
    const maxStart = Math.floor(max2 / 10);
    if (props2.hasLeftFocus.value) {
      props2.hasLeftFocus.value = false;
      prev = null;
    }
    if (prev === null) {
      if (num === 0) {
        props2.lastKeyZero.value = true;
        return {
          value: null,
          moveToNext
        };
      }
      if (props2.lastKeyZero.value || num > maxStart) moveToNext = true;
      props2.lastKeyZero.value = false;
      return {
        value: num,
        moveToNext
      };
    }
    const digits = prev.toString().length;
    const total = Number.parseInt(prev.toString() + num.toString());
    if (digits === 2 || total > max2) {
      if (num > maxStart || total > max2) moveToNext = true;
      return {
        value: num,
        moveToNext
      };
    }
    moveToNext = true;
    return {
      value: total,
      moveToNext
    };
  }
  function updateMinuteOrSecond(num, prev) {
    const max2 = 59;
    let moveToNext = false;
    const maxStart = Math.floor(max2 / 10);
    if (props2.hasLeftFocus.value) {
      props2.hasLeftFocus.value = false;
      prev = null;
    }
    if (prev === null) {
      if (num === 0) {
        props2.lastKeyZero.value = true;
        return {
          value: 0,
          moveToNext
        };
      }
      if (props2.lastKeyZero.value || num > maxStart) moveToNext = true;
      props2.lastKeyZero.value = false;
      return {
        value: num,
        moveToNext
      };
    }
    const digits = prev.toString().length;
    const total = Number.parseInt(prev.toString() + num.toString());
    if (digits === 2 || total > max2) {
      if (num > maxStart) moveToNext = true;
      return {
        value: num,
        moveToNext
      };
    }
    moveToNext = true;
    return {
      value: total,
      moveToNext
    };
  }
  function updateHour(num, prev) {
    const max2 = 24;
    let moveToNext = false;
    const maxStart = Math.floor(max2 / 10);
    if (props2.hasLeftFocus.value) {
      props2.hasLeftFocus.value = false;
      prev = null;
    }
    if (prev === null) {
      if (num === 0) {
        props2.lastKeyZero.value = true;
        return {
          value: 0,
          moveToNext
        };
      }
      if (props2.lastKeyZero.value || num > maxStart) moveToNext = true;
      props2.lastKeyZero.value = false;
      return {
        value: num,
        moveToNext
      };
    }
    const digits = prev.toString().length;
    const total = Number.parseInt(prev.toString() + num.toString());
    if (digits === 2 || total > max2) {
      if (num > maxStart) moveToNext = true;
      return {
        value: num,
        moveToNext
      };
    }
    moveToNext = true;
    return {
      value: total,
      moveToNext
    };
  }
  function updateYear(num, prev) {
    let moveToNext = false;
    if (props2.hasLeftFocus.value) {
      props2.hasLeftFocus.value = false;
      prev = null;
    }
    if (prev === null) return {
      value: num === 0 ? 1 : num,
      moveToNext
    };
    const str = prev.toString() + num.toString();
    if (str.length > 4) return {
      value: num === 0 ? 1 : num,
      moveToNext
    };
    if (str.length === 4) moveToNext = true;
    const int = Number.parseInt(str);
    return {
      value: int,
      moveToNext
    };
  }
  const attributes = computed(() => segmentBuilders[props2.part]?.attrs({
    disabled: props2.disabled.value,
    placeholder: props2.placeholder.value,
    hourCycle: props2.hourCycle,
    segmentValues: props2.segmentValues.value,
    formatter: props2.formatter
  }) ?? {});
  function handleDaySegmentKeydown(e) {
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key)) return;
    const prevValue = props2.segmentValues.value.day;
    if (e.key === kbd.ARROW_DOWN || e.key === kbd.ARROW_UP) {
      props2.segmentValues.value.day = dateTimeValueIncrementation({
        e,
        part: "day",
        dateRef: props2.placeholder.value,
        prevValue
      });
      return;
    }
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const segmentMonthValue = props2.segmentValues.value.month;
      const daysInMonth = segmentMonthValue ? getDaysInMonth(props2.placeholder.value.set({ month: segmentMonthValue })) : 31;
      const { value, moveToNext } = updateDayOrMonth(daysInMonth, num, prevValue);
      props2.segmentValues.value.day = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.day = deleteValue(prevValue);
    }
  }
  function handleMonthSegmentKeydown(e) {
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key)) return;
    const prevValue = props2.segmentValues.value.month;
    if (e.key === kbd.ARROW_DOWN || e.key === kbd.ARROW_UP) {
      props2.segmentValues.value.month = dateTimeValueIncrementation({
        e,
        part: "month",
        dateRef: props2.placeholder.value,
        prevValue
      });
      return;
    }
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const { value, moveToNext } = updateDayOrMonth(12, num, prevValue);
      props2.segmentValues.value.month = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.month = deleteValue(prevValue);
    }
  }
  function handleYearSegmentKeydown(e) {
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key)) return;
    const prevValue = props2.segmentValues.value.year;
    if (e.key === kbd.ARROW_DOWN || e.key === kbd.ARROW_UP) {
      props2.segmentValues.value.year = dateTimeValueIncrementation({
        e,
        part: "year",
        dateRef: props2.placeholder.value,
        prevValue
      });
      return;
    }
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const { value, moveToNext } = updateYear(num, prevValue);
      props2.segmentValues.value.year = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.year = deleteValue(prevValue);
    }
  }
  function handleHourSegmentKeydown(e) {
    const dateRef = props2.placeholder.value;
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key) || !("hour" in dateRef) || !("hour" in props2.segmentValues.value)) return;
    const prevValue = props2.segmentValues.value.hour;
    const hourCycle = props2.hourCycle;
    if (e.key === kbd.ARROW_UP || e.key === kbd.ARROW_DOWN) {
      props2.segmentValues.value.hour = dateTimeValueIncrementation({
        e,
        part: "hour",
        dateRef: props2.placeholder.value,
        prevValue,
        hourCycle
      });
      if ("dayPeriod" in props2.segmentValues.value) {
        if (props2.segmentValues.value.hour < 12) props2.segmentValues.value.dayPeriod = "AM";
        else if (props2.segmentValues.value.hour) props2.segmentValues.value.dayPeriod = "PM";
      }
      return;
    }
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const { value, moveToNext } = updateHour(num, prevValue);
      if ("dayPeriod" in props2.segmentValues.value && value && value > 12) props2.segmentValues.value.dayPeriod = "PM";
      else if ("dayPeriod" in props2.segmentValues.value && value) props2.segmentValues.value.dayPeriod = "AM";
      props2.segmentValues.value.hour = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.hour = deleteValue(prevValue);
    }
  }
  function handleMinuteSegmentKeydown(e) {
    const dateRef = props2.placeholder.value;
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key) || !("minute" in dateRef) || !("minute" in props2.segmentValues.value)) return;
    const prevValue = props2.segmentValues.value.minute;
    if (e.key === kbd.ARROW_UP || e.key === kbd.ARROW_DOWN) props2.segmentValues.value.minute = minuteSecondIncrementation({
      e,
      part: "minute",
      dateRef: props2.placeholder.value,
      prevValue
    });
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const { value, moveToNext } = updateMinuteOrSecond(num, prevValue);
      props2.segmentValues.value.minute = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.minute = deleteValue(prevValue);
    }
  }
  function handleSecondSegmentKeydown(e) {
    const dateRef = props2.placeholder.value;
    if (!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key) || !("second" in dateRef) || !("second" in props2.segmentValues.value)) return;
    const prevValue = props2.segmentValues.value.second;
    if (e.key === kbd.ARROW_UP || e.key === kbd.ARROW_DOWN) props2.segmentValues.value.second = minuteSecondIncrementation({
      e,
      part: "second",
      dateRef: props2.placeholder.value,
      prevValue
    });
    if (isNumberString(e.key)) {
      const num = Number.parseInt(e.key);
      const { value, moveToNext } = updateMinuteOrSecond(num, prevValue);
      props2.segmentValues.value.second = value;
      if (moveToNext) props2.focusNext();
    }
    if (e.key === kbd.BACKSPACE) {
      props2.hasLeftFocus.value = false;
      props2.segmentValues.value.second = deleteValue(prevValue);
    }
  }
  function handleDayPeriodSegmentKeydown(e) {
    if ((!isAcceptableSegmentKey(e.key) || isSegmentNavigationKey(e.key)) && e.key !== "a" && e.key !== "p" || !("hour" in props2.placeholder.value) || !("dayPeriod" in props2.segmentValues.value)) return;
    if (e.key === kbd.ARROW_UP || e.key === kbd.ARROW_DOWN) {
      if (props2.segmentValues.value.dayPeriod === "AM") {
        props2.segmentValues.value.dayPeriod = "PM";
        props2.segmentValues.value.hour = props2.segmentValues.value.hour + 12;
        return;
      }
      props2.segmentValues.value.dayPeriod = "AM";
      props2.segmentValues.value.hour = props2.segmentValues.value.hour - 12;
      return;
    }
    if (["a", "A"].includes(e.key) && props2.segmentValues.value.dayPeriod !== "AM") {
      props2.segmentValues.value.dayPeriod = "AM";
      props2.segmentValues.value.hour = props2.segmentValues.value.hour - 12;
      return;
    }
    if (["p", "P"].includes(e.key) && props2.segmentValues.value.dayPeriod !== "PM") {
      props2.segmentValues.value.dayPeriod = "PM";
      props2.segmentValues.value.hour = props2.segmentValues.value.hour + 12;
    }
  }
  function handleSegmentClick(e) {
    const disabled = props2.disabled.value;
    if (disabled) e.preventDefault();
  }
  function handleSegmentKeydown(e) {
    const disabled = props2.disabled.value;
    const readonly = props2.readonly.value;
    if (e.key !== kbd.TAB) e.preventDefault();
    if (disabled || readonly) return;
    const segmentKeydownHandlers = {
      day: handleDaySegmentKeydown,
      month: handleMonthSegmentKeydown,
      year: handleYearSegmentKeydown,
      hour: handleHourSegmentKeydown,
      minute: handleMinuteSegmentKeydown,
      second: handleSecondSegmentKeydown,
      dayPeriod: handleDayPeriodSegmentKeydown,
      timeZoneName: () => {
      }
    };
    segmentKeydownHandlers[props2.part](e);
    if (![kbd.ARROW_LEFT, kbd.ARROW_RIGHT].includes(e.key) && e.key !== kbd.TAB && e.key !== kbd.SHIFT && isAcceptableSegmentKey(e.key)) {
      if (Object.values(props2.segmentValues.value).every((item) => item !== null)) {
        const updateObject = { ...props2.segmentValues.value };
        const dateRef = props2.placeholder.value.set(updateObject);
        props2.modelValue.value = dateRef.copy();
      }
    }
  }
  return {
    handleSegmentClick,
    handleSegmentKeydown,
    attributes
  };
}

// node_modules/reka-ui/dist/Calendar/useCalendar.js
function useCalendarState(props2) {
  function isDateSelected(dateObj) {
    if (Array.isArray(props2.date.value)) return props2.date.value.some((d) => $14e0f24ef4ac5c92$export$ea39ec197993aef0(d, dateObj));
    else if (!props2.date.value) return false;
    else return $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.date.value, dateObj);
  }
  const isInvalid = computed(() => {
    if (Array.isArray(props2.date.value)) {
      if (!props2.date.value.length) return false;
      for (const dateObj of props2.date.value) {
        if (props2.isDateDisabled?.(dateObj)) return true;
        if (props2.isDateUnavailable?.(dateObj)) return true;
      }
    } else {
      if (!props2.date.value) return false;
      if (props2.isDateDisabled?.(props2.date.value)) return true;
      if (props2.isDateUnavailable?.(props2.date.value)) return true;
    }
    return false;
  });
  return {
    isDateSelected,
    isInvalid
  };
}
function handleNextDisabled(lastPeriodInView, nextPageFunc) {
  const firstPeriodOfNextPage = nextPageFunc(lastPeriodInView);
  const diff = firstPeriodOfNextPage.compare(lastPeriodInView);
  const duration = {};
  if (diff >= 7) duration.day = 1;
  if (diff >= getDaysInMonth(lastPeriodInView)) duration.month = 1;
  return firstPeriodOfNextPage.set({ ...duration });
}
function handlePrevDisabled(firstPeriodInView, prevPageFunc) {
  const lastPeriodOfPrevPage = prevPageFunc(firstPeriodInView);
  const diff = firstPeriodInView.compare(lastPeriodOfPrevPage);
  const duration = {};
  if (diff >= 7) duration.day = 35;
  if (diff >= getDaysInMonth(firstPeriodInView)) duration.month = 13;
  return lastPeriodOfPrevPage.set({ ...duration });
}
function handleNextPage(date, nextPageFunc) {
  return nextPageFunc(date);
}
function handlePrevPage(date, prevPageFunc) {
  return prevPageFunc(date);
}
function useCalendar(props2) {
  const formatter = useDateFormatter(props2.locale.value);
  const headingFormatOptions = computed(() => {
    const options = { calendar: props2.placeholder.value.calendar.identifier };
    if (props2.placeholder.value.calendar.identifier === "gregory" && props2.placeholder.value.era === "BC") options.era = "short";
    return options;
  });
  const grid = ref(createMonths({
    dateObj: props2.placeholder.value,
    weekStartsOn: props2.weekStartsOn.value,
    locale: props2.locale.value,
    fixedWeeks: props2.fixedWeeks.value,
    numberOfMonths: props2.numberOfMonths.value
  }));
  const visibleView = computed(() => {
    return grid.value.map((month) => month.value);
  });
  function isOutsideVisibleView(date) {
    return !visibleView.value.some((month) => $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(date, month));
  }
  const isNextButtonDisabled = (nextPageFunc) => {
    if (!props2.maxValue.value || !grid.value.length) return false;
    if (props2.disabled.value) return true;
    const lastPeriodInView = grid.value[grid.value.length - 1].value;
    if (!nextPageFunc && !props2.nextPage.value) {
      const firstPeriodOfNextPage$1 = lastPeriodInView.add({ months: 1 }).set({ day: 1 });
      return isAfter(firstPeriodOfNextPage$1, props2.maxValue.value);
    }
    const firstPeriodOfNextPage = handleNextDisabled(lastPeriodInView, nextPageFunc || props2.nextPage.value);
    return isAfter(firstPeriodOfNextPage, props2.maxValue.value);
  };
  const isPrevButtonDisabled = (prevPageFunc) => {
    if (!props2.minValue.value || !grid.value.length) return false;
    if (props2.disabled.value) return true;
    const firstPeriodInView = grid.value[0].value;
    if (!prevPageFunc && !props2.prevPage.value) {
      const lastPeriodOfPrevPage$1 = firstPeriodInView.subtract({ months: 1 }).set({ day: 35 });
      return isBefore(lastPeriodOfPrevPage$1, props2.minValue.value);
    }
    const lastPeriodOfPrevPage = handlePrevDisabled(firstPeriodInView, prevPageFunc || props2.prevPage.value);
    return isBefore(lastPeriodOfPrevPage, props2.minValue.value);
  };
  function isDateDisabled(dateObj) {
    if (props2.isDateDisabled?.(dateObj) || props2.disabled.value) return true;
    if (props2.maxValue.value && isAfter(dateObj, props2.maxValue.value)) return true;
    if (props2.minValue.value && isBefore(dateObj, props2.minValue.value)) return true;
    return false;
  }
  const isDateUnavailable = (date) => {
    if (props2.isDateUnavailable?.(date)) return true;
    return false;
  };
  const weekdays = computed(() => {
    if (!grid.value.length) return [];
    return grid.value[0].rows[0].map((date) => {
      return formatter.dayOfWeek(toDate(date), props2.weekdayFormat.value);
    });
  });
  const nextPage = (nextPageFunc) => {
    const firstDate = grid.value[0].value;
    if (!nextPageFunc && !props2.nextPage.value) {
      const newDate$1 = firstDate.add({ months: props2.pagedNavigation.value ? props2.numberOfMonths.value : 1 });
      const newGrid$1 = createMonths({
        dateObj: newDate$1,
        weekStartsOn: props2.weekStartsOn.value,
        locale: props2.locale.value,
        fixedWeeks: props2.fixedWeeks.value,
        numberOfMonths: props2.numberOfMonths.value
      });
      grid.value = newGrid$1;
      props2.placeholder.value = newGrid$1[0].value.set({ day: 1 });
      return;
    }
    const newDate = handleNextPage(firstDate, nextPageFunc || props2.nextPage.value);
    const newGrid = createMonths({
      dateObj: newDate,
      weekStartsOn: props2.weekStartsOn.value,
      locale: props2.locale.value,
      fixedWeeks: props2.fixedWeeks.value,
      numberOfMonths: props2.numberOfMonths.value
    });
    grid.value = newGrid;
    const duration = {};
    if (!nextPageFunc) {
      const diff = newGrid[0].value.compare(firstDate);
      if (diff >= getDaysInMonth(firstDate)) duration.day = 1;
      if (diff >= 365) duration.month = 1;
    }
    props2.placeholder.value = newGrid[0].value.set({ ...duration });
  };
  const prevPage = (prevPageFunc) => {
    const firstDate = grid.value[0].value;
    if (!prevPageFunc && !props2.prevPage.value) {
      const newDate$1 = firstDate.subtract({ months: props2.pagedNavigation.value ? props2.numberOfMonths.value : 1 });
      const newGrid$1 = createMonths({
        dateObj: newDate$1,
        weekStartsOn: props2.weekStartsOn.value,
        locale: props2.locale.value,
        fixedWeeks: props2.fixedWeeks.value,
        numberOfMonths: props2.numberOfMonths.value
      });
      grid.value = newGrid$1;
      props2.placeholder.value = newGrid$1[0].value.set({ day: 1 });
      return;
    }
    const newDate = handlePrevPage(firstDate, prevPageFunc || props2.prevPage.value);
    const newGrid = createMonths({
      dateObj: newDate,
      weekStartsOn: props2.weekStartsOn.value,
      locale: props2.locale.value,
      fixedWeeks: props2.fixedWeeks.value,
      numberOfMonths: props2.numberOfMonths.value
    });
    grid.value = newGrid;
    const duration = {};
    if (!prevPageFunc) {
      const diff = firstDate.compare(newGrid[0].value);
      if (diff >= getDaysInMonth(firstDate)) duration.day = 1;
      if (diff >= 365) duration.month = 1;
    }
    props2.placeholder.value = newGrid[0].value.set({ ...duration });
  };
  watch(props2.placeholder, (value) => {
    if (visibleView.value.some((month) => $14e0f24ef4ac5c92$export$5a8da0c44a3afdf2(month, value))) return;
    grid.value = createMonths({
      dateObj: value,
      weekStartsOn: props2.weekStartsOn.value,
      locale: props2.locale.value,
      fixedWeeks: props2.fixedWeeks.value,
      numberOfMonths: props2.numberOfMonths.value
    });
  });
  watch([
    props2.locale,
    props2.weekStartsOn,
    props2.fixedWeeks,
    props2.numberOfMonths
  ], () => {
    grid.value = createMonths({
      dateObj: props2.placeholder.value,
      weekStartsOn: props2.weekStartsOn.value,
      locale: props2.locale.value,
      fixedWeeks: props2.fixedWeeks.value,
      numberOfMonths: props2.numberOfMonths.value
    });
  });
  const headingValue = computed(() => {
    if (!grid.value.length) return "";
    if (props2.locale.value !== formatter.getLocale()) formatter.setLocale(props2.locale.value);
    if (grid.value.length === 1) {
      const month = grid.value[0].value;
      return `${formatter.fullMonthAndYear(toDate(month), headingFormatOptions.value)}`;
    }
    const startMonth = toDate(grid.value[0].value);
    const endMonth = toDate(grid.value[grid.value.length - 1].value);
    const startMonthName = formatter.fullMonth(startMonth, headingFormatOptions.value);
    const endMonthName = formatter.fullMonth(endMonth, headingFormatOptions.value);
    const startMonthYear = formatter.fullYear(startMonth, headingFormatOptions.value);
    const endMonthYear = formatter.fullYear(endMonth, headingFormatOptions.value);
    const content = startMonthYear === endMonthYear ? `${startMonthName} - ${endMonthName} ${endMonthYear}` : `${startMonthName} ${startMonthYear} - ${endMonthName} ${endMonthYear}`;
    return content;
  });
  const fullCalendarLabel = computed(() => `${props2.calendarLabel.value ?? "Event Date"}, ${headingValue.value}`);
  return {
    isDateDisabled,
    isDateUnavailable,
    isNextButtonDisabled,
    isPrevButtonDisabled,
    grid,
    weekdays,
    visibleView,
    isOutsideVisibleView,
    formatter,
    nextPage,
    prevPage,
    headingValue,
    fullCalendarLabel
  };
}

// node_modules/reka-ui/dist/Calendar/CalendarRoot.js
var _hoisted_1 = { style: {
  "border": "0px",
  "clip": "rect(0px, 0px, 0px, 0px)",
  "clip-path": "inset(50%)",
  "height": "1px",
  "margin": "-1px",
  "overflow": "hidden",
  "padding": "0px",
  "position": "absolute",
  "white-space": "nowrap",
  "width": "1px"
} };
var _hoisted_2 = {
  role: "heading",
  "aria-level": "2"
};
var [injectCalendarRootContext, provideCalendarRootContext] = createContext("CalendarRoot");
var CalendarRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarRoot",
  props: {
    defaultValue: {
      type: null,
      required: false,
      default: void 0
    },
    defaultPlaceholder: {
      type: null,
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    pagedNavigation: {
      type: Boolean,
      required: false,
      default: false
    },
    preventDeselect: {
      type: Boolean,
      required: false,
      default: false
    },
    weekStartsOn: {
      type: Number,
      required: false,
      default: 0
    },
    weekdayFormat: {
      type: String,
      required: false,
      default: "narrow"
    },
    calendarLabel: {
      type: String,
      required: false
    },
    fixedWeeks: {
      type: Boolean,
      required: false,
      default: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false
    },
    numberOfMonths: {
      type: Number,
      required: false,
      default: 1
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    initialFocus: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateDisabled: {
      type: Function,
      required: false,
      default: void 0
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    dir: {
      type: String,
      required: false
    },
    nextPage: {
      type: Function,
      required: false
    },
    prevPage: {
      type: Function,
      required: false
    },
    modelValue: {
      type: null,
      required: false
    },
    multiple: {
      type: Boolean,
      required: false,
      default: false
    },
    disableDaysOutsideCurrentView: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, readonly, initialFocus, pagedNavigation, weekStartsOn, weekdayFormat, fixedWeeks, multiple, minValue, maxValue, numberOfMonths, preventDeselect, isDateDisabled: propsIsDateDisabled, isDateUnavailable: propsIsDateUnavailable, calendarLabel, defaultValue, nextPage: propsNextPage, prevPage: propsPrevPage, dir: propDir, locale: propLocale, disableDaysOutsideCurrentView } = toRefs(props2);
    const { primitiveElement, currentElement: parentElement } = usePrimitiveElement();
    const locale = useLocale(propLocale);
    const dir = useDirection(propDir);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: defaultValue.value,
      passive: props2.modelValue === void 0
    });
    const defaultDate = getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      defaultValue: modelValue.value,
      locale: props2.locale
    });
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.copy(),
      passive: props2.placeholder === void 0
    });
    function onPlaceholderChange(value) {
      placeholder.value = value.copy();
    }
    const { fullCalendarLabel, headingValue, isDateDisabled, isDateUnavailable, isNextButtonDisabled, isPrevButtonDisabled, weekdays, isOutsideVisibleView, nextPage, prevPage, formatter, grid } = useCalendar({
      locale,
      placeholder,
      weekStartsOn,
      fixedWeeks,
      numberOfMonths,
      minValue,
      maxValue,
      disabled,
      weekdayFormat,
      pagedNavigation,
      isDateDisabled: propsIsDateDisabled.value,
      isDateUnavailable: propsIsDateUnavailable.value,
      calendarLabel,
      nextPage: propsNextPage,
      prevPage: propsPrevPage
    });
    const { isInvalid, isDateSelected } = useCalendarState({
      date: modelValue,
      isDateDisabled,
      isDateUnavailable
    });
    watch(modelValue, (_modelValue) => {
      if (Array.isArray(_modelValue) && _modelValue.length) {
        const lastValue = _modelValue[_modelValue.length - 1];
        if (lastValue && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(placeholder.value, lastValue)) onPlaceholderChange(lastValue);
      } else if (!Array.isArray(_modelValue) && _modelValue && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(placeholder.value, _modelValue)) onPlaceholderChange(_modelValue);
    });
    function onDateChange(value) {
      if (!multiple.value) {
        if (!modelValue.value) {
          modelValue.value = value.copy();
          return;
        }
        if (!preventDeselect.value && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(modelValue.value, value)) {
          placeholder.value = value.copy();
          modelValue.value = void 0;
        } else modelValue.value = value.copy();
      } else if (!modelValue.value) modelValue.value = [value.copy()];
      else if (Array.isArray(modelValue.value)) {
        const index = modelValue.value.findIndex((date) => $14e0f24ef4ac5c92$export$ea39ec197993aef0(date, value));
        if (index === -1) modelValue.value = [...modelValue.value, value];
        else if (!preventDeselect.value) {
          const next = modelValue.value.filter((date) => !$14e0f24ef4ac5c92$export$ea39ec197993aef0(date, value));
          if (!next.length) {
            placeholder.value = value.copy();
            modelValue.value = void 0;
            return;
          }
          modelValue.value = next.map((date) => date.copy());
        }
      }
    }
    onMounted(() => {
      if (initialFocus.value) handleCalendarInitialFocus(parentElement.value);
    });
    provideCalendarRootContext({
      isDateUnavailable,
      dir,
      isDateDisabled,
      locale,
      formatter,
      modelValue,
      placeholder,
      disabled,
      initialFocus,
      pagedNavigation,
      grid,
      weekDays: weekdays,
      weekStartsOn,
      weekdayFormat,
      fixedWeeks,
      multiple,
      numberOfMonths,
      readonly,
      preventDeselect,
      fullCalendarLabel,
      headingValue,
      isInvalid,
      isDateSelected,
      isNextButtonDisabled,
      isPrevButtonDisabled,
      isOutsideVisibleView,
      nextPage,
      prevPage,
      parentElement,
      onPlaceholderChange,
      onDateChange,
      disableDaysOutsideCurrentView,
      minValue,
      maxValue
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "aria-label": unref(fullCalendarLabel),
        "data-readonly": unref(readonly) ? "" : void 0,
        "data-disabled": unref(disabled) ? "" : void 0,
        "data-invalid": unref(isInvalid) ? "" : void 0,
        dir: unref(dir)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          date: unref(placeholder),
          grid: unref(grid),
          weekDays: unref(weekdays),
          weekStartsOn: unref(weekStartsOn),
          locale: unref(locale),
          fixedWeeks: unref(fixedWeeks),
          modelValue: unref(modelValue)
        }), createBaseVNode("div", _hoisted_1, [createBaseVNode("div", _hoisted_2, toDisplayString(unref(fullCalendarLabel)), 1)])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-label",
        "data-readonly",
        "data-disabled",
        "data-invalid",
        "dir"
      ]);
    };
  }
});
var CalendarRoot_default = CalendarRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarCell.js
var CalendarCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarCell",
  props: {
    date: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "td"
    }
  },
  setup(__props) {
    const rootContext = injectCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        role: "gridcell",
        "aria-selected": unref(rootContext).isDateSelected(_ctx.date) ? true : void 0,
        "aria-disabled": unref(rootContext).isDateDisabled(_ctx.date) || unref(rootContext).isDateUnavailable?.(_ctx.date) || unref(rootContext).disableDaysOutsideCurrentView.value,
        "data-disabled": unref(rootContext).isDateDisabled(_ctx.date) || unref(rootContext).disableDaysOutsideCurrentView.value ? "" : void 0
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-selected",
        "aria-disabled",
        "data-disabled"
      ]);
    };
  }
});
var CalendarCell_default = CalendarCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarCellTrigger.js
var CalendarCellTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarCellTrigger",
  props: {
    day: {
      type: null,
      required: true
    },
    month: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const kbd = useKbd();
    const rootContext = injectCalendarRootContext();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const dayValue = computed(() => props2.day.day.toLocaleString(rootContext.locale.value));
    const labelText = computed(() => {
      return rootContext.formatter.custom(toDate(props2.day), {
        weekday: "long",
        month: "long",
        day: "numeric",
        year: "numeric"
      });
    });
    const isUnavailable = computed(() => rootContext.isDateUnavailable?.(props2.day) ?? false);
    const isDateToday = computed(() => {
      return $14e0f24ef4ac5c92$export$629b0a497aa65267(props2.day, $14e0f24ef4ac5c92$export$aa8b41735afcabd2());
    });
    const isOutsideView = computed(() => {
      return !$14e0f24ef4ac5c92$export$a18c89cbd24170ff(props2.day, props2.month);
    });
    const isOutsideVisibleView = computed(() => rootContext.isOutsideVisibleView(props2.day));
    const isDisabled = computed(() => rootContext.isDateDisabled(props2.day) || rootContext.disableDaysOutsideCurrentView.value && isOutsideView.value);
    const isFocusedDate = computed(() => {
      return !rootContext.disabled.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.day, rootContext.placeholder.value);
    });
    const isSelectedDate = computed(() => rootContext.isDateSelected(props2.day));
    function changeDate(date) {
      if (rootContext.readonly.value) return;
      if (rootContext.isDateDisabled(date) || rootContext.isDateUnavailable?.(date)) return;
      rootContext.onDateChange(date);
    }
    function handleClick() {
      if (isDisabled.value) return;
      changeDate(props2.day);
    }
    function handleArrowKey(e) {
      if (isDisabled.value) return;
      e.preventDefault();
      e.stopPropagation();
      const parentElement = rootContext.parentElement.value;
      const indexIncrementation = 7;
      const sign = rootContext.dir.value === "rtl" ? -1 : 1;
      switch (e.code) {
        case kbd.ARROW_RIGHT:
          shiftFocus(props2.day, sign);
          break;
        case kbd.ARROW_LEFT:
          shiftFocus(props2.day, -sign);
          break;
        case kbd.ARROW_UP:
          shiftFocus(props2.day, -indexIncrementation);
          break;
        case kbd.ARROW_DOWN:
          shiftFocus(props2.day, indexIncrementation);
          break;
        case kbd.ENTER:
        case kbd.SPACE_CODE:
          changeDate(props2.day);
      }
      function shiftFocus(day, add) {
        const candidateDayValue = day.add({ days: add });
        if (rootContext.minValue.value && candidateDayValue.compare(rootContext.minValue.value) < 0 || rootContext.maxValue.value && candidateDayValue.compare(rootContext.maxValue.value) > 0) return;
        const candidateDay = parentElement.querySelector(`[data-value='${candidateDayValue.toString()}']:not([data-outside-view])`);
        if (!candidateDay) {
          if (add > 0) {
            if (rootContext.isNextButtonDisabled()) return;
            rootContext.nextPage();
          } else {
            if (rootContext.isPrevButtonDisabled()) return;
            rootContext.prevPage();
          }
          nextTick(() => {
            shiftFocus(day, add);
          });
          return;
        }
        if (candidateDay && candidateDay.hasAttribute("data-disabled")) return shiftFocus(candidateDayValue, add);
        rootContext.onPlaceholderChange(candidateDayValue);
        candidateDay?.focus();
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement
      }, props2, {
        role: "button",
        "aria-label": labelText.value,
        "data-reka-calendar-cell-trigger": "",
        "aria-disabled": isDisabled.value || isUnavailable.value ? true : void 0,
        "data-selected": isSelectedDate.value ? true : void 0,
        "data-value": _ctx.day.toString(),
        "data-disabled": isDisabled.value ? "" : void 0,
        "data-unavailable": isUnavailable.value ? "" : void 0,
        "data-today": isDateToday.value ? "" : void 0,
        "data-outside-view": isOutsideView.value ? "" : void 0,
        "data-outside-visible-view": isOutsideVisibleView.value ? "" : void 0,
        "data-focused": isFocusedDate.value ? "" : void 0,
        tabindex: isFocusedDate.value ? 0 : isOutsideView.value || isDisabled.value ? void 0 : -1,
        onClick: handleClick,
        onKeydown: [withKeys(handleArrowKey, [
          "up",
          "down",
          "left",
          "right",
          "space",
          "enter"
        ]), _cache[0] || (_cache[0] = withKeys(withModifiers(() => {
        }, ["prevent"]), ["enter"]))]
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          dayValue: dayValue.value,
          disabled: isDisabled.value,
          today: isDateToday.value,
          selected: isSelectedDate.value,
          outsideView: isOutsideView.value,
          outsideVisibleView: isOutsideVisibleView.value,
          unavailable: isUnavailable.value
        }, () => [createTextVNode(toDisplayString(dayValue.value), 1)])]),
        _: 3
      }, 16, [
        "aria-label",
        "aria-disabled",
        "data-selected",
        "data-value",
        "data-disabled",
        "data-unavailable",
        "data-today",
        "data-outside-view",
        "data-outside-visible-view",
        "data-focused",
        "tabindex"
      ]);
    };
  }
});
var CalendarCellTrigger_default = CalendarCellTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarGrid.js
var CalendarGrid_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarGrid",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "table"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectCalendarRootContext();
    const disabled = computed(() => rootContext.disabled.value ? true : void 0);
    const readonly = computed(() => rootContext.readonly.value ? true : void 0);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        tabindex: "-1",
        role: "grid",
        "aria-readonly": readonly.value,
        "aria-disabled": disabled.value,
        "data-readonly": readonly.value && "",
        "data-disabled": disabled.value && ""
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "aria-readonly",
        "aria-disabled",
        "data-readonly",
        "data-disabled"
      ]);
    };
  }
});
var CalendarGrid_default = CalendarGrid_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarGridBody.js
var CalendarGridBody_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarGridBody",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "tbody"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var CalendarGridBody_default = CalendarGridBody_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarGridHead.js
var CalendarGridHead_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarGridHead",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "thead"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "aria-hidden": "true" }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var CalendarGridHead_default = CalendarGridHead_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarGridRow.js
var CalendarGridRow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarGridRow",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "tr"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var CalendarGridRow_default = CalendarGridRow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarHeadCell.js
var CalendarHeadCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarHeadCell",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "th"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var CalendarHeadCell_default = CalendarHeadCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarHeader.js
var CalendarHeader_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarHeader",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var CalendarHeader_default = CalendarHeader_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarHeading.js
var CalendarHeading_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarHeading",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "data-disabled": unref(rootContext).disabled.value ? "" : void 0 }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { headingValue: unref(rootContext).headingValue.value }, () => [createTextVNode(toDisplayString(unref(rootContext).headingValue.value), 1)])]),
        _: 3
      }, 16, ["data-disabled"]);
    };
  }
});
var CalendarHeading_default = CalendarHeading_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarNext.js
var CalendarNext_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarNext",
  props: {
    nextPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const disabled = computed(() => rootContext.disabled.value || rootContext.isNextButtonDisabled(props2.nextPage));
    const rootContext = injectCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: props2.as,
        "as-child": props2.asChild,
        "aria-label": "Next page",
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-disabled": disabled.value || void 0,
        "data-disabled": disabled.value || void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).nextPage(props2.nextPage))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { disabled: disabled.value }, () => [_cache[1] || (_cache[1] = createTextVNode(" Next page "))])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "type",
        "aria-disabled",
        "data-disabled",
        "disabled"
      ]);
    };
  }
});
var CalendarNext_default = CalendarNext_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Calendar/CalendarPrev.js
var CalendarPrev_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CalendarPrev",
  props: {
    prevPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const disabled = computed(() => rootContext.disabled.value || rootContext.isPrevButtonDisabled(props2.prevPage));
    const rootContext = injectCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "aria-label": "Previous page",
        as: props2.as,
        "as-child": props2.asChild,
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-disabled": disabled.value || void 0,
        "data-disabled": disabled.value || void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).prevPage(props2.prevPage))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { disabled: disabled.value }, () => [_cache[1] || (_cache[1] = createTextVNode(" Prev page "))])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "type",
        "aria-disabled",
        "data-disabled",
        "disabled"
      ]);
    };
  }
});
var CalendarPrev_default = CalendarPrev_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Collection/Collection.js
var ITEM_DATA_ATTR = "data-reka-collection-item";
function useCollection(options = {}) {
  const { key = "", isProvider = false } = options;
  const injectionKey = `${key}CollectionProvider`;
  let context2;
  if (isProvider) {
    const itemMap = ref(/* @__PURE__ */ new Map());
    const collectionRef = ref();
    context2 = {
      collectionRef,
      itemMap
    };
    provide(injectionKey, context2);
  } else context2 = inject(injectionKey);
  const getItems = (includeDisabledItem = false) => {
    const collectionNode = context2.collectionRef.value;
    if (!collectionNode) return [];
    const orderedNodes = Array.from(collectionNode.querySelectorAll(`[${ITEM_DATA_ATTR}]`));
    const items = Array.from(context2.itemMap.value.values());
    const orderedItems = items.sort((a, b) => orderedNodes.indexOf(a.ref) - orderedNodes.indexOf(b.ref));
    if (includeDisabledItem) return orderedItems;
    else return orderedItems.filter((i) => i.ref.dataset.disabled !== "");
  };
  const CollectionSlot = defineComponent({
    name: "CollectionSlot",
    setup(_, { slots }) {
      const { primitiveElement, currentElement } = usePrimitiveElement();
      watch(currentElement, () => {
        context2.collectionRef.value = currentElement.value;
      });
      return () => h(Slot, { ref: primitiveElement }, slots);
    }
  });
  const CollectionItem = defineComponent({
    name: "CollectionItem",
    inheritAttrs: false,
    props: { value: { validator: () => true } },
    setup(props2, { slots, attrs }) {
      const { primitiveElement, currentElement } = usePrimitiveElement();
      watchEffect((cleanupFn) => {
        if (currentElement.value) {
          const key$1 = markRaw(currentElement.value);
          context2.itemMap.value.set(key$1, {
            ref: currentElement.value,
            value: props2.value
          });
          cleanupFn(() => context2.itemMap.value.delete(key$1));
        }
      });
      return () => h(Slot, {
        ...attrs,
        [ITEM_DATA_ATTR]: "",
        ref: primitiveElement
      }, slots);
    }
  });
  const reactiveItems = computed(() => Array.from(context2.itemMap.value.values()));
  const itemMapSize = computed(() => context2.itemMap.value.size);
  return {
    getItems,
    reactiveItems,
    itemMapSize,
    CollectionSlot,
    CollectionItem
  };
}

// node_modules/reka-ui/dist/RovingFocus/utils.js
var ENTRY_FOCUS = "rovingFocusGroup.onEntryFocus";
var EVENT_OPTIONS2 = {
  bubbles: false,
  cancelable: true
};
var MAP_KEY_TO_FOCUS_INTENT = {
  ArrowLeft: "prev",
  ArrowUp: "prev",
  ArrowRight: "next",
  ArrowDown: "next",
  PageUp: "first",
  Home: "first",
  PageDown: "last",
  End: "last"
};
function getDirectionAwareKey(key, dir) {
  if (dir !== "rtl") return key;
  return key === "ArrowLeft" ? "ArrowRight" : key === "ArrowRight" ? "ArrowLeft" : key;
}
function getFocusIntent(event, orientation, dir) {
  const key = getDirectionAwareKey(event.key, dir);
  if (orientation === "vertical" && ["ArrowLeft", "ArrowRight"].includes(key)) return void 0;
  if (orientation === "horizontal" && ["ArrowUp", "ArrowDown"].includes(key)) return void 0;
  return MAP_KEY_TO_FOCUS_INTENT[key];
}
function focusFirst3(candidates, preventScroll = false) {
  const PREVIOUSLY_FOCUSED_ELEMENT = getActiveElement();
  for (const candidate of candidates) {
    if (candidate === PREVIOUSLY_FOCUSED_ELEMENT) return;
    candidate.focus({ preventScroll });
    if (getActiveElement() !== PREVIOUSLY_FOCUSED_ELEMENT) return;
  }
}
function wrapArray2(array, startIndex) {
  return array.map((_, index) => array[(startIndex + index) % array.length]);
}

// node_modules/reka-ui/dist/RovingFocus/RovingFocusGroup.js
var [injectRovingFocusGroupContext, provideRovingFocusGroupContext] = createContext("RovingFocusGroup");
var RovingFocusGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RovingFocusGroup",
  props: {
    orientation: {
      type: String,
      required: false,
      default: void 0
    },
    dir: {
      type: String,
      required: false
    },
    loop: {
      type: Boolean,
      required: false,
      default: false
    },
    currentTabStopId: {
      type: [String, null],
      required: false
    },
    defaultCurrentTabStopId: {
      type: String,
      required: false
    },
    preventScrollOnEntryFocus: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["entryFocus", "update:currentTabStopId"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { loop, orientation, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    const currentTabStopId = useVModel(props2, "currentTabStopId", emits, {
      defaultValue: props2.defaultCurrentTabStopId,
      passive: props2.currentTabStopId === void 0
    });
    const isTabbingBackOut = ref(false);
    const isClickFocus = ref(false);
    const focusableItemsCount = ref(0);
    const { getItems, CollectionSlot } = useCollection({ isProvider: true });
    function handleFocus(event) {
      const isKeyboardFocus = !isClickFocus.value;
      if (event.currentTarget && event.target === event.currentTarget && isKeyboardFocus && !isTabbingBackOut.value) {
        const entryFocusEvent = new CustomEvent(ENTRY_FOCUS, EVENT_OPTIONS2);
        event.currentTarget.dispatchEvent(entryFocusEvent);
        emits("entryFocus", entryFocusEvent);
        if (!entryFocusEvent.defaultPrevented) {
          const items = getItems().map((i) => i.ref).filter((i) => i.dataset.disabled !== "");
          const activeItem = items.find((item) => item.getAttribute("data-active") === "");
          const highlightedItem = items.find((item) => item.getAttribute("data-highlighted") === "");
          const currentItem = items.find((item) => item.id === currentTabStopId.value);
          const candidateItems = [
            activeItem,
            highlightedItem,
            currentItem,
            ...items
          ].filter(Boolean);
          focusFirst3(candidateItems, props2.preventScrollOnEntryFocus);
        }
      }
      isClickFocus.value = false;
    }
    function handleMouseUp() {
      setTimeout(() => {
        isClickFocus.value = false;
      }, 1);
    }
    __expose({ getItems });
    provideRovingFocusGroupContext({
      loop,
      dir,
      orientation,
      currentTabStopId,
      onItemFocus: (tabStopId) => {
        currentTabStopId.value = tabStopId;
      },
      onItemShiftTab: () => {
        isTabbingBackOut.value = true;
      },
      onFocusableItemAdd: () => {
        focusableItemsCount.value++;
      },
      onFocusableItemRemove: () => {
        focusableItemsCount.value--;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          tabindex: isTabbingBackOut.value || focusableItemsCount.value === 0 ? -1 : 0,
          "data-orientation": unref(orientation),
          as: _ctx.as,
          "as-child": _ctx.asChild,
          dir: unref(dir),
          style: { "outline": "none" },
          onMousedown: _cache[0] || (_cache[0] = ($event) => isClickFocus.value = true),
          onMouseup: handleMouseUp,
          onFocus: handleFocus,
          onBlur: _cache[1] || (_cache[1] = ($event) => isTabbingBackOut.value = false)
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "tabindex",
          "data-orientation",
          "as",
          "as-child",
          "dir"
        ])]),
        _: 3
      });
    };
  }
});
var RovingFocusGroup_default = RovingFocusGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RovingFocus/RovingFocusItem.js
var RovingFocusItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RovingFocusItem",
  props: {
    tabStopId: {
      type: String,
      required: false
    },
    focusable: {
      type: Boolean,
      required: false,
      default: true
    },
    active: {
      type: Boolean,
      required: false
    },
    allowShiftKey: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectRovingFocusGroupContext();
    const randomId = useId2();
    const id = computed(() => props2.tabStopId || randomId);
    const isCurrentTabStop = computed(() => context2.currentTabStopId.value === id.value);
    const { getItems, CollectionItem } = useCollection();
    onMounted(() => {
      if (props2.focusable) context2.onFocusableItemAdd();
    });
    onUnmounted(() => {
      if (props2.focusable) context2.onFocusableItemRemove();
    });
    function handleKeydown(event) {
      if (event.key === "Tab" && event.shiftKey) {
        context2.onItemShiftTab();
        return;
      }
      if (event.target !== event.currentTarget) return;
      const focusIntent = getFocusIntent(event, context2.orientation.value, context2.dir.value);
      if (focusIntent !== void 0) {
        if (event.metaKey || event.ctrlKey || event.altKey || (props2.allowShiftKey ? false : event.shiftKey)) return;
        event.preventDefault();
        let candidateNodes = [...getItems().map((i) => i.ref).filter((i) => i.dataset.disabled !== "")];
        if (focusIntent === "last") candidateNodes.reverse();
        else if (focusIntent === "prev" || focusIntent === "next") {
          if (focusIntent === "prev") candidateNodes.reverse();
          const currentIndex = candidateNodes.indexOf(event.currentTarget);
          candidateNodes = context2.loop.value ? wrapArray2(candidateNodes, currentIndex + 1) : candidateNodes.slice(currentIndex + 1);
        }
        nextTick(() => focusFirst3(candidateNodes));
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          tabindex: isCurrentTabStop.value ? 0 : -1,
          "data-orientation": unref(context2).orientation.value,
          "data-active": _ctx.active ? "" : void 0,
          "data-disabled": !_ctx.focusable ? "" : void 0,
          as: _ctx.as,
          "as-child": _ctx.asChild,
          onMousedown: _cache[0] || (_cache[0] = (event) => {
            if (!_ctx.focusable) event.preventDefault();
            else unref(context2).onItemFocus(id.value);
          }),
          onFocus: _cache[1] || (_cache[1] = ($event) => unref(context2).onItemFocus(id.value)),
          onKeydown: handleKeydown
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "tabindex",
          "data-orientation",
          "data-active",
          "data-disabled",
          "as",
          "as-child"
        ])]),
        _: 3
      });
    };
  }
});
var RovingFocusItem_default = RovingFocusItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/VisuallyHidden/VisuallyHidden.js
var VisuallyHidden_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "VisuallyHidden",
  props: {
    feature: {
      type: String,
      required: false,
      default: "focusable"
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "aria-hidden": _ctx.feature === "focusable" ? "true" : void 0,
        "data-hidden": _ctx.feature === "fully-hidden" ? "" : void 0,
        tabindex: _ctx.feature === "fully-hidden" ? "-1" : void 0,
        style: {
          position: "absolute",
          border: 0,
          width: "1px",
          height: "1px",
          padding: 0,
          margin: "-1px",
          overflow: "hidden",
          clip: "rect(0, 0, 0, 0)",
          clipPath: "inset(50%)",
          whiteSpace: "nowrap",
          wordWrap: "normal",
          top: "-1px",
          left: "-1px"
        }
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-hidden",
        "data-hidden",
        "tabindex"
      ]);
    };
  }
});
var VisuallyHidden_default = VisuallyHidden_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/VisuallyHidden/VisuallyHiddenInputBubble.js
var VisuallyHiddenInputBubble_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "VisuallyHiddenInputBubble",
  props: {
    name: {
      type: String,
      required: true
    },
    value: {
      type: null,
      required: true
    },
    checked: {
      type: Boolean,
      required: false,
      default: void 0
    },
    required: {
      type: Boolean,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    feature: {
      type: String,
      required: false,
      default: "fully-hidden"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const valueState = computed(() => props2.checked ?? props2.value);
    watch(valueState, (cur, prev) => {
      if (!currentElement.value) return;
      const input = currentElement.value;
      const inputProto = window.HTMLInputElement.prototype;
      const descriptor = Object.getOwnPropertyDescriptor(inputProto, "value");
      const setValue = descriptor.set;
      if (setValue && cur !== prev) {
        const inputEvent = new Event("input", { bubbles: true });
        const changeEvent = new Event("change", { bubbles: true });
        setValue.call(input, cur);
        input.dispatchEvent(inputEvent);
        input.dispatchEvent(changeEvent);
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(VisuallyHidden_default, mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement
      }, {
        ...props2,
        ..._ctx.$attrs
      }, { as: "input" }), null, 16);
    };
  }
});
var VisuallyHiddenInputBubble_default = VisuallyHiddenInputBubble_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/VisuallyHidden/VisuallyHiddenInput.js
var VisuallyHiddenInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "VisuallyHiddenInput",
  props: {
    name: {
      type: String,
      required: true
    },
    value: {
      type: null,
      required: true
    },
    checked: {
      type: Boolean,
      required: false,
      default: void 0
    },
    required: {
      type: Boolean,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    feature: {
      type: String,
      required: false,
      default: "fully-hidden"
    }
  },
  setup(__props) {
    const props2 = __props;
    const isFormArrayEmptyAndRequired = computed(() => typeof props2.value === "object" && Array.isArray(props2.value) && props2.value.length === 0 && props2.required);
    const parsedValue = computed(() => {
      if (typeof props2.value === "string" || typeof props2.value === "number" || typeof props2.value === "boolean" || props2.value === null || props2.value === void 0) return [{
        name: props2.name,
        value: props2.value
      }];
      else if (typeof props2.value === "object" && Array.isArray(props2.value)) return props2.value.flatMap((obj, index) => {
        if (typeof obj === "object") return Object.entries(obj).map(([key, value]) => ({
          name: `${props2.name}[${index}][${key}]`,
          value
        }));
        else return {
          name: `${props2.name}[${index}]`,
          value: obj
        };
      });
      else if (props2.value !== null && typeof props2.value === "object" && !Array.isArray(props2.value)) return Object.entries(props2.value).map(([key, value]) => ({
        name: `${props2.name}[${key}]`,
        value
      }));
      return [];
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createCommentVNode(" We render single input if it's required "), isFormArrayEmptyAndRequired.value ? (openBlock(), createBlock(VisuallyHiddenInputBubble_default, mergeProps({ key: _ctx.name }, {
        ...props2,
        ..._ctx.$attrs
      }, {
        name: _ctx.name,
        value: _ctx.value
      }), null, 16, ["name", "value"])) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(parsedValue.value, (parsed) => {
        return openBlock(), createBlock(VisuallyHiddenInputBubble_default, mergeProps({ key: parsed.name }, { ref_for: true }, {
          ...props2,
          ..._ctx.$attrs
        }, {
          name: parsed.name,
          value: parsed.value
        }), null, 16, ["name", "value"]);
      }), 128))], 2112);
    };
  }
});
var VisuallyHiddenInput_default = VisuallyHiddenInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Checkbox/CheckboxGroupRoot.js
var [injectCheckboxGroupRootContext, provideCheckboxGroupRootContext] = createContext("CheckboxGroupRoot");
var CheckboxGroupRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CheckboxGroupRoot",
  props: {
    defaultValue: {
      type: Array,
      required: false
    },
    modelValue: {
      type: Array,
      required: false
    },
    rovingFocus: {
      type: Boolean,
      required: false,
      default: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    orientation: {
      type: String,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, rovingFocus, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const isFormControl = useFormControl(currentElement);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? [],
      passive: props2.modelValue === void 0
    });
    const rovingFocusProps = computed(() => {
      return rovingFocus.value ? {
        loop: props2.loop,
        dir: dir.value,
        orientation: props2.orientation
      } : {};
    });
    provideCheckboxGroupRootContext({
      modelValue,
      rovingFocus,
      disabled
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(rovingFocus) ? unref(RovingFocusGroup_default) : unref(Primitive)), mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, rovingFocusProps.value), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default"), unref(isFormControl) && _ctx.name ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          name: _ctx.name,
          value: unref(modelValue),
          required: _ctx.required
        }, null, 8, [
          "name",
          "value",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 16, ["as", "as-child"]);
    };
  }
});
var CheckboxGroupRoot_default = CheckboxGroupRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Checkbox/utils.js
function isIndeterminate2(checked) {
  return checked === "indeterminate";
}
function getState(checked) {
  return isIndeterminate2(checked) ? "indeterminate" : checked ? "checked" : "unchecked";
}

// node_modules/reka-ui/dist/Checkbox/CheckboxRoot.js
var [injectCheckboxRootContext, provideCheckboxRootContext] = createContext("CheckboxRoot");
var CheckboxRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "CheckboxRoot",
  props: {
    defaultValue: {
      type: [Boolean, String],
      required: false
    },
    modelValue: {
      type: [
        Boolean,
        String,
        null
      ],
      required: false,
      default: void 0
    },
    disabled: {
      type: Boolean,
      required: false
    },
    value: {
      type: null,
      required: false,
      default: "on"
    },
    id: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { forwardRef, currentElement } = useForwardExpose();
    const checkboxGroupContext = injectCheckboxGroupRootContext(null);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue,
      passive: props2.modelValue === void 0
    });
    const disabled = computed(() => checkboxGroupContext?.disabled.value || props2.disabled);
    const checkboxState = computed(() => {
      if (!isNullish(checkboxGroupContext?.modelValue.value)) return isValueEqualOrExist(checkboxGroupContext.modelValue.value, props2.value);
      else return modelValue.value === "indeterminate" ? "indeterminate" : modelValue.value;
    });
    function handleClick() {
      if (!isNullish(checkboxGroupContext?.modelValue.value)) {
        const modelValueArray = [...checkboxGroupContext.modelValue.value || []];
        if (isValueEqualOrExist(modelValueArray, props2.value)) {
          const index = modelValueArray.findIndex((i) => isEqual(i, props2.value));
          modelValueArray.splice(index, 1);
        } else modelValueArray.push(props2.value);
        checkboxGroupContext.modelValue.value = modelValueArray;
      } else modelValue.value = isIndeterminate2(modelValue.value) ? true : !modelValue.value;
    }
    const isFormControl = useFormControl(currentElement);
    const ariaLabel = computed(() => props2.id && currentElement.value ? document.querySelector(`[for="${props2.id}"]`)?.innerText : void 0);
    provideCheckboxRootContext({
      disabled,
      state: checkboxState
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(checkboxGroupContext)?.rovingFocus.value ? unref(RovingFocusItem_default) : unref(Primitive)), mergeProps(_ctx.$attrs, {
        id: _ctx.id,
        ref: unref(forwardRef),
        role: "checkbox",
        "as-child": _ctx.asChild,
        as: _ctx.as,
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-checked": unref(isIndeterminate2)(checkboxState.value) ? "mixed" : checkboxState.value,
        "aria-required": _ctx.required,
        "aria-label": _ctx.$attrs["aria-label"] || ariaLabel.value,
        "data-state": unref(getState)(checkboxState.value),
        "data-disabled": disabled.value ? "" : void 0,
        disabled: disabled.value,
        focusable: unref(checkboxGroupContext)?.rovingFocus.value ? !disabled.value : void 0,
        onKeydown: withKeys(withModifiers(() => {
        }, ["prevent"]), ["enter"]),
        onClick: handleClick
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          state: checkboxState.value
        }), unref(isFormControl) && _ctx.name && !unref(checkboxGroupContext) ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          type: "checkbox",
          checked: !!checkboxState.value,
          name: _ctx.name,
          value: _ctx.value,
          disabled: disabled.value,
          required: _ctx.required
        }, null, 8, [
          "checked",
          "name",
          "value",
          "disabled",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 16, [
        "id",
        "as-child",
        "as",
        "type",
        "aria-checked",
        "aria-required",
        "aria-label",
        "data-state",
        "data-disabled",
        "disabled",
        "focusable",
        "onKeydown"
      ]);
    };
  }
});
var CheckboxRoot_default = CheckboxRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Checkbox/CheckboxIndicator.js
var CheckboxIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "CheckboxIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const { forwardRef } = useForwardExpose();
    const rootContext = injectCheckboxRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(isIndeterminate2)(unref(rootContext).state.value) || unref(rootContext).state.value === true }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          ref: unref(forwardRef),
          "data-state": unref(getState)(unref(rootContext).state.value),
          "data-disabled": unref(rootContext).disabled.value ? "" : void 0,
          style: { pointerEvents: "none" },
          "as-child": _ctx.asChild,
          as: _ctx.as
        }, _ctx.$attrs), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "data-state",
          "data-disabled",
          "as-child",
          "as"
        ])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var CheckboxIndicator_default = CheckboxIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popper/PopperRoot.js
var [injectPopperRootContext, providePopperRootContext] = createContext("PopperRoot");
var PopperRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "PopperRoot",
  setup(__props) {
    const anchor = ref();
    providePopperRootContext({
      anchor,
      onAnchorChange: (element) => anchor.value = element
    });
    return (_ctx, _cache) => {
      return renderSlot(_ctx.$slots, "default");
    };
  }
});
var PopperRoot_default = PopperRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popper/PopperAnchor.js
var PopperAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopperAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectPopperRootContext();
    watchPostEffect(() => {
      rootContext.onAnchorChange(props2.reference ?? currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as", "as-child"]);
    };
  }
});
var PopperAnchor_default = PopperAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/component/Arrow.js
var _hoisted_12 = {
  key: 0,
  d: "M0 0L6 6L12 0"
};
var _hoisted_22 = {
  key: 1,
  d: "M0 0L4.58579 4.58579C5.36683 5.36683 6.63316 5.36684 7.41421 4.58579L12 0"
};
var Arrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "Arrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        width: _ctx.width,
        height: _ctx.height,
        viewBox: _ctx.asChild ? void 0 : "0 0 12 6",
        preserveAspectRatio: _ctx.asChild ? void 0 : "none"
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [!_ctx.rounded ? (openBlock(), createElementBlock("path", _hoisted_12)) : (openBlock(), createElementBlock("path", _hoisted_22))])]),
        _: 3
      }, 16, [
        "width",
        "height",
        "viewBox",
        "preserveAspectRatio"
      ]);
    };
  }
});
var Arrow_default = Arrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popper/utils.js
function isNotNull(value) {
  return value !== null;
}
function transformOrigin(options) {
  return {
    name: "transformOrigin",
    options,
    fn(data) {
      const { placement, rects, middlewareData } = data;
      const cannotCenterArrow = middlewareData.arrow?.centerOffset !== 0;
      const isArrowHidden = cannotCenterArrow;
      const arrowWidth = isArrowHidden ? 0 : options.arrowWidth;
      const arrowHeight = isArrowHidden ? 0 : options.arrowHeight;
      const [placedSide, placedAlign] = getSideAndAlignFromPlacement(placement);
      const noArrowAlign = {
        start: "0%",
        center: "50%",
        end: "100%"
      }[placedAlign];
      const arrowXCenter = (middlewareData.arrow?.x ?? 0) + arrowWidth / 2;
      const arrowYCenter = (middlewareData.arrow?.y ?? 0) + arrowHeight / 2;
      let x = "";
      let y = "";
      if (placedSide === "bottom") {
        x = isArrowHidden ? noArrowAlign : `${arrowXCenter}px`;
        y = `${-arrowHeight}px`;
      } else if (placedSide === "top") {
        x = isArrowHidden ? noArrowAlign : `${arrowXCenter}px`;
        y = `${rects.floating.height + arrowHeight}px`;
      } else if (placedSide === "right") {
        x = `${-arrowHeight}px`;
        y = isArrowHidden ? noArrowAlign : `${arrowYCenter}px`;
      } else if (placedSide === "left") {
        x = `${rects.floating.width + arrowHeight}px`;
        y = isArrowHidden ? noArrowAlign : `${arrowYCenter}px`;
      }
      return { data: {
        x,
        y
      } };
    }
  };
}
function getSideAndAlignFromPlacement(placement) {
  const [side, align = "center"] = placement.split("-");
  return [side, align];
}

// node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs
function hasWindow() {
  return typeof window !== "undefined";
}
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || "").toLowerCase();
  }
  return "#document";
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (!hasWindow() || typeof ShadowRoot === "undefined") {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
var invalidOverflowDisplayValues = /* @__PURE__ */ new Set(["inline", "contents"]);
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle2(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);
}
var tableElements = /* @__PURE__ */ new Set(["table", "td", "th"]);
function isTableElement(element) {
  return tableElements.has(getNodeName(element));
}
var topLayerSelectors = [":popover-open", ":modal"];
function isTopLayer(element) {
  return topLayerSelectors.some((selector) => {
    try {
      return element.matches(selector);
    } catch (_e) {
      return false;
    }
  });
}
var transformProperties = ["transform", "translate", "scale", "rotate", "perspective"];
var willChangeValues = ["transform", "translate", "scale", "rotate", "perspective", "filter"];
var containValues = ["paint", "layout", "strict", "content"];
function isContainingBlock(elementOrCss) {
  const webkit = isWebKit();
  const css = isElement(elementOrCss) ? getComputedStyle2(elementOrCss) : elementOrCss;
  return transformProperties.some((value) => css[value] ? css[value] !== "none" : false) || (css.containerType ? css.containerType !== "normal" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== "none" : false) || !webkit && (css.filter ? css.filter !== "none" : false) || willChangeValues.some((value) => (css.willChange || "").includes(value)) || containValues.some((value) => (css.contain || "").includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else if (isTopLayer(currentNode)) {
      return null;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === "undefined" || !CSS.supports) return false;
  return CSS.supports("-webkit-backdrop-filter", "none");
}
var lastTraversableNodeNames = /* @__PURE__ */ new Set(["html", "body", "#document"]);
function isLastTraversableNode(node) {
  return lastTraversableNodeNames.has(getNodeName(node));
}
function getComputedStyle2(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === "html") {
    return node;
  }
  const result = (
    // Step into the shadow DOM of the parent of a slotted node.
    node.assignedSlot || // DOM Element detected.
    node.parentNode || // ShadowRoot detected.
    isShadowRoot(node) && node.host || // Fallback.
    getDocumentElement(node)
  );
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    const frameElement = getFrameElement(win);
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}

// node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs
function getCssDimensions(element) {
  const css = getComputedStyle2(element);
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = isHTMLElement(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = round(width) !== offsetWidth || round(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}
function unwrapElement(element) {
  return !isElement(element) ? element.contextElement : element;
}
function getScale(element) {
  const domElement = unwrapElement(element);
  if (!isHTMLElement(domElement)) {
    return createCoords(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? round(rect.width) : rect.width) / width;
  let y = ($ ? round(rect.height) : rect.height) / height;
  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}
var noOffsets = createCoords(0);
function getVisualOffsets(element) {
  const win = getWindow(element);
  if (!isWebKit() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow(element)) {
    return false;
  }
  return isFixed;
}
function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = createCoords(1);
  if (includeScale) {
    if (offsetParent) {
      if (isElement(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : createCoords(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = getWindow(domElement);
    const offsetWin = offsetParent && isElement(offsetParent) ? getWindow(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = getFrameElement(currentWin);
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = getComputedStyle2(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = getWindow(currentIFrame);
      currentIFrame = getFrameElement(currentWin);
    }
  }
  return rectToClientRect({
    width,
    height,
    x,
    y
  });
}
function getWindowScrollBarX(element, rect) {
  const leftScroll = getNodeScroll(element).scrollLeft;
  if (!rect) {
    return getBoundingClientRect(getDocumentElement(element)).left + leftScroll;
  }
  return rect.left + leftScroll;
}
function getHTMLOffset(documentElement, scroll) {
  const htmlRect = documentElement.getBoundingClientRect();
  const x = htmlRect.left + scroll.scrollLeft - getWindowScrollBarX(documentElement, htmlRect);
  const y = htmlRect.top + scroll.scrollTop;
  return {
    x,
    y
  };
}
function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === "fixed";
  const documentElement = getDocumentElement(offsetParent);
  const topLayer = elements ? isTopLayer(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = createCoords(1);
  const offsets = createCoords(0);
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isHTMLElement(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : createCoords(0);
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y
  };
}
function getClientRects(element) {
  return Array.from(element.getClientRects());
}
function getDocumentRect(element) {
  const html = getDocumentElement(element);
  const scroll = getNodeScroll(element);
  const body = element.ownerDocument.body;
  const width = max(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = max(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if (getComputedStyle2(body).direction === "rtl") {
    x += max(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}
var SCROLLBAR_MAX = 25;
function getViewportRect(element, strategy) {
  const win = getWindow(element);
  const html = getDocumentElement(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = isWebKit();
    if (!visualViewportBased || visualViewportBased && strategy === "fixed") {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  const windowScrollbarX = getWindowScrollBarX(html);
  if (windowScrollbarX <= 0) {
    const doc = html.ownerDocument;
    const body = doc.body;
    const bodyStyles = getComputedStyle(body);
    const bodyMarginInline = doc.compatMode === "CSS1Compat" ? parseFloat(bodyStyles.marginLeft) + parseFloat(bodyStyles.marginRight) || 0 : 0;
    const clippingStableScrollbarWidth = Math.abs(html.clientWidth - body.clientWidth - bodyMarginInline);
    if (clippingStableScrollbarWidth <= SCROLLBAR_MAX) {
      width -= clippingStableScrollbarWidth;
    }
  } else if (windowScrollbarX <= SCROLLBAR_MAX) {
    width += windowScrollbarX;
  }
  return {
    width,
    height,
    x,
    y
  };
}
var absoluteOrFixed = /* @__PURE__ */ new Set(["absolute", "fixed"]);
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === "fixed");
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = isHTMLElement(element) ? getScale(element) : createCoords(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === "viewport") {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === "document") {
    rect = getDocumentRect(getDocumentElement(element));
  } else if (isElement(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y,
      width: clippingAncestor.width,
      height: clippingAncestor.height
    };
  }
  return rectToClientRect(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = getParentNode(element);
  if (parentNode === stopNode || !isElement(parentNode) || isLastTraversableNode(parentNode)) {
    return false;
  }
  return getComputedStyle2(parentNode).position === "fixed" || hasFixedPositionAncestor(parentNode, stopNode);
}
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = getOverflowAncestors(element, [], false).filter((el) => isElement(el) && getNodeName(el) !== "body");
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = getComputedStyle2(element).position === "fixed";
  let currentNode = elementIsFixed ? getParentNode(element) : element;
  while (isElement(currentNode) && !isLastTraversableNode(currentNode)) {
    const computedStyle = getComputedStyle2(currentNode);
    const currentNodeIsContaining = isContainingBlock(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === "fixed") {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === "static" && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      result = result.filter((ancestor) => ancestor !== currentNode);
    } else {
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = getParentNode(currentNode);
  }
  cache.set(element, result);
  return result;
}
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === "clippingAncestors" ? isTopLayer(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = max(rect.top, accRect.top);
    accRect.right = min(rect.right, accRect.right);
    accRect.bottom = min(rect.bottom, accRect.bottom);
    accRect.left = max(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}
function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}
function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = isHTMLElement(offsetParent);
  const documentElement = getDocumentElement(offsetParent);
  const isFixed = strategy === "fixed";
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = createCoords(0);
  function setLeftRTLScrollbarOffset() {
    offsets.x = getWindowScrollBarX(documentElement);
  }
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if (getNodeName(offsetParent) !== "body" || isOverflowElement(documentElement)) {
      scroll = getNodeScroll(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      setLeftRTLScrollbarOffset();
    }
  }
  if (isFixed && !isOffsetParentAnElement && documentElement) {
    setLeftRTLScrollbarOffset();
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : createCoords(0);
  const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;
  const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}
function isStaticPositioned(element) {
  return getComputedStyle2(element).position === "static";
}
function getTrueOffsetParent(element, polyfill) {
  if (!isHTMLElement(element) || getComputedStyle2(element).position === "fixed") {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  let rawOffsetParent = element.offsetParent;
  if (getDocumentElement(element) === rawOffsetParent) {
    rawOffsetParent = rawOffsetParent.ownerDocument.body;
  }
  return rawOffsetParent;
}
function getOffsetParent(element, polyfill) {
  const win = getWindow(element);
  if (isTopLayer(element)) {
    return win;
  }
  if (!isHTMLElement(element)) {
    let svgOffsetParent = getParentNode(element);
    while (svgOffsetParent && !isLastTraversableNode(svgOffsetParent)) {
      if (isElement(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = getParentNode(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && isTableElement(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && isLastTraversableNode(offsetParent) && isStaticPositioned(offsetParent) && !isContainingBlock(offsetParent)) {
    return win;
  }
  return offsetParent || getContainingBlock(element) || win;
}
var getElementRects = async function(data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};
function isRTL(element) {
  return getComputedStyle2(element).direction === "rtl";
}
var platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement,
  isRTL
};
function rectsAreEqual(a, b) {
  return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
}
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = getDocumentElement(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const elementRectForRootMargin = element.getBoundingClientRect();
    const {
      left,
      top,
      width,
      height
    } = elementRectForRootMargin;
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = floor(top);
    const insetRight = floor(root.clientWidth - (left + width));
    const insetBottom = floor(root.clientHeight - (top + height));
    const insetLeft = floor(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: max(0, min(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1e3);
        } else {
          refresh(false, ratio);
        }
      }
      if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {
        refresh();
      }
      isFirstUpdate = false;
    }
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (_e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === "function",
    layoutShift = typeof IntersectionObserver === "function",
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...referenceEl ? getOverflowAncestors(referenceEl) : [], ...getOverflowAncestors(floating)] : [];
  ancestors.forEach((ancestor) => {
    ancestorScroll && ancestor.addEventListener("scroll", update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener("resize", update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver((_ref) => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach((ancestor) => {
      ancestorScroll && ancestor.removeEventListener("scroll", update);
      ancestorResize && ancestor.removeEventListener("resize", update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}
var offset2 = offset;
var shift2 = shift;
var flip2 = flip;
var size2 = size;
var hide2 = hide;
var arrow2 = arrow;
var limitShift2 = limitShift;
var computePosition2 = (reference, floating, options) => {
  const cache = /* @__PURE__ */ new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return computePosition(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};

// node_modules/@floating-ui/vue/dist/floating-ui.vue.mjs
function isComponentPublicInstance(target) {
  return target != null && typeof target === "object" && "$el" in target;
}
function unwrapElement2(target) {
  if (isComponentPublicInstance(target)) {
    const element = target.$el;
    return isNode(element) && getNodeName(element) === "#comment" ? null : element;
  }
  return target;
}
function toValue2(source) {
  return typeof source === "function" ? source() : unref(source);
}
function arrow3(options) {
  return {
    name: "arrow",
    options,
    fn(args) {
      const element = unwrapElement2(toValue2(options.element));
      if (element == null) {
        return {};
      }
      return arrow2({
        element,
        padding: options.padding
      }).fn(args);
    }
  };
}
function getDPR(element) {
  if (typeof window === "undefined") {
    return 1;
  }
  const win = element.ownerDocument.defaultView || window;
  return win.devicePixelRatio || 1;
}
function roundByDPR(element, value) {
  const dpr = getDPR(element);
  return Math.round(value * dpr) / dpr;
}
function useFloating(reference, floating, options) {
  if (options === void 0) {
    options = {};
  }
  const whileElementsMountedOption = options.whileElementsMounted;
  const openOption = computed(() => {
    var _toValue;
    return (_toValue = toValue2(options.open)) != null ? _toValue : true;
  });
  const middlewareOption = computed(() => toValue2(options.middleware));
  const placementOption = computed(() => {
    var _toValue2;
    return (_toValue2 = toValue2(options.placement)) != null ? _toValue2 : "bottom";
  });
  const strategyOption = computed(() => {
    var _toValue3;
    return (_toValue3 = toValue2(options.strategy)) != null ? _toValue3 : "absolute";
  });
  const transformOption = computed(() => {
    var _toValue4;
    return (_toValue4 = toValue2(options.transform)) != null ? _toValue4 : true;
  });
  const referenceElement = computed(() => unwrapElement2(reference.value));
  const floatingElement = computed(() => unwrapElement2(floating.value));
  const x = ref(0);
  const y = ref(0);
  const strategy = ref(strategyOption.value);
  const placement = ref(placementOption.value);
  const middlewareData = shallowRef({});
  const isPositioned = ref(false);
  const floatingStyles = computed(() => {
    const initialStyles = {
      position: strategy.value,
      left: "0",
      top: "0"
    };
    if (!floatingElement.value) {
      return initialStyles;
    }
    const xVal = roundByDPR(floatingElement.value, x.value);
    const yVal = roundByDPR(floatingElement.value, y.value);
    if (transformOption.value) {
      return {
        ...initialStyles,
        transform: "translate(" + xVal + "px, " + yVal + "px)",
        ...getDPR(floatingElement.value) >= 1.5 && {
          willChange: "transform"
        }
      };
    }
    return {
      position: strategy.value,
      left: xVal + "px",
      top: yVal + "px"
    };
  });
  let whileElementsMountedCleanup;
  function update() {
    if (referenceElement.value == null || floatingElement.value == null) {
      return;
    }
    const open = openOption.value;
    computePosition2(referenceElement.value, floatingElement.value, {
      middleware: middlewareOption.value,
      placement: placementOption.value,
      strategy: strategyOption.value
    }).then((position) => {
      x.value = position.x;
      y.value = position.y;
      strategy.value = position.strategy;
      placement.value = position.placement;
      middlewareData.value = position.middlewareData;
      isPositioned.value = open !== false;
    });
  }
  function cleanup() {
    if (typeof whileElementsMountedCleanup === "function") {
      whileElementsMountedCleanup();
      whileElementsMountedCleanup = void 0;
    }
  }
  function attach() {
    cleanup();
    if (whileElementsMountedOption === void 0) {
      update();
      return;
    }
    if (referenceElement.value != null && floatingElement.value != null) {
      whileElementsMountedCleanup = whileElementsMountedOption(referenceElement.value, floatingElement.value, update);
      return;
    }
  }
  function reset() {
    if (!openOption.value) {
      isPositioned.value = false;
    }
  }
  watch([middlewareOption, placementOption, strategyOption, openOption], update, {
    flush: "sync"
  });
  watch([referenceElement, floatingElement], attach, {
    flush: "sync"
  });
  watch(openOption, reset, {
    flush: "sync"
  });
  if (getCurrentScope()) {
    onScopeDispose(cleanup);
  }
  return {
    x: shallowReadonly(x),
    y: shallowReadonly(y),
    strategy: shallowReadonly(strategy),
    placement: shallowReadonly(placement),
    middlewareData: shallowReadonly(middlewareData),
    isPositioned: shallowReadonly(isPositioned),
    floatingStyles,
    update
  };
}

// node_modules/reka-ui/dist/Popper/PopperContent.js
var PopperContentPropsDefaultValue = {
  side: "bottom",
  sideOffset: 0,
  sideFlip: true,
  align: "center",
  alignOffset: 0,
  alignFlip: true,
  arrowPadding: 0,
  avoidCollisions: true,
  collisionBoundary: () => [],
  collisionPadding: 0,
  sticky: "partial",
  hideWhenDetached: false,
  positionStrategy: "fixed",
  updatePositionStrategy: "optimized",
  prioritizePosition: false
};
var [injectPopperContentContext, providePopperContentContext] = createContext("PopperContent");
var PopperContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "PopperContent",
  props: mergeDefaults({
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  }, { ...PopperContentPropsDefaultValue }),
  emits: ["placed"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectPopperRootContext();
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    const floatingRef = ref();
    const arrow$1 = ref();
    const { width: arrowWidth, height: arrowHeight } = useSize(arrow$1);
    const desiredPlacement = computed(() => props2.side + (props2.align !== "center" ? `-${props2.align}` : ""));
    const collisionPadding = computed(() => {
      return typeof props2.collisionPadding === "number" ? props2.collisionPadding : {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        ...props2.collisionPadding
      };
    });
    const boundary = computed(() => {
      return Array.isArray(props2.collisionBoundary) ? props2.collisionBoundary : [props2.collisionBoundary];
    });
    const detectOverflowOptions = computed(() => {
      return {
        padding: collisionPadding.value,
        boundary: boundary.value.filter(isNotNull),
        altBoundary: boundary.value.length > 0
      };
    });
    const flipOptions = computed(() => {
      return {
        mainAxis: props2.sideFlip,
        crossAxis: props2.alignFlip
      };
    });
    const computedMiddleware = computedEager(() => {
      return [
        offset2({
          mainAxis: props2.sideOffset + arrowHeight.value,
          alignmentAxis: props2.alignOffset
        }),
        props2.prioritizePosition && props2.avoidCollisions && flip2({
          ...detectOverflowOptions.value,
          ...flipOptions.value
        }),
        props2.avoidCollisions && shift2({
          mainAxis: true,
          crossAxis: !!props2.prioritizePosition,
          limiter: props2.sticky === "partial" ? limitShift2() : void 0,
          ...detectOverflowOptions.value
        }),
        !props2.prioritizePosition && props2.avoidCollisions && flip2({
          ...detectOverflowOptions.value,
          ...flipOptions.value
        }),
        size2({
          ...detectOverflowOptions.value,
          apply: ({ elements, rects, availableWidth, availableHeight }) => {
            const { width: anchorWidth, height: anchorHeight } = rects.reference;
            const contentStyle = elements.floating.style;
            contentStyle.setProperty("--reka-popper-available-width", `${availableWidth}px`);
            contentStyle.setProperty("--reka-popper-available-height", `${availableHeight}px`);
            contentStyle.setProperty("--reka-popper-anchor-width", `${anchorWidth}px`);
            contentStyle.setProperty("--reka-popper-anchor-height", `${anchorHeight}px`);
          }
        }),
        arrow$1.value && arrow3({
          element: arrow$1.value,
          padding: props2.arrowPadding
        }),
        transformOrigin({
          arrowWidth: arrowWidth.value,
          arrowHeight: arrowHeight.value
        }),
        props2.hideWhenDetached && hide2({
          strategy: "referenceHidden",
          ...detectOverflowOptions.value
        })
      ];
    });
    const reference = computed(() => props2.reference ?? rootContext.anchor.value);
    const { floatingStyles, placement, isPositioned, middlewareData, update } = useFloating(reference, floatingRef, {
      strategy: props2.positionStrategy,
      placement: desiredPlacement,
      whileElementsMounted: (...args) => {
        const cleanup = autoUpdate(...args, {
          layoutShift: !props2.disableUpdateOnLayoutShift,
          animationFrame: props2.updatePositionStrategy === "always"
        });
        return cleanup;
      },
      middleware: computedMiddleware
    });
    const placedSide = computed(() => getSideAndAlignFromPlacement(placement.value)[0]);
    const placedAlign = computed(() => getSideAndAlignFromPlacement(placement.value)[1]);
    watchPostEffect(() => {
      if (isPositioned.value) emits("placed");
    });
    const cannotCenterArrow = computed(() => middlewareData.value.arrow?.centerOffset !== 0);
    const contentZIndex = ref("");
    watchEffect(() => {
      if (contentElement.value) contentZIndex.value = window.getComputedStyle(contentElement.value).zIndex;
    });
    const arrowX = computed(() => middlewareData.value.arrow?.x ?? 0);
    const arrowY = computed(() => middlewareData.value.arrow?.y ?? 0);
    providePopperContentContext({
      placedSide,
      onArrowChange: (element) => arrow$1.value = element,
      arrowX,
      arrowY,
      shouldHideArrow: cannotCenterArrow
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "floatingRef",
        ref: floatingRef,
        "data-reka-popper-content-wrapper": "",
        style: normalizeStyle({
          ...unref(floatingStyles),
          transform: unref(isPositioned) ? unref(floatingStyles).transform : "translate(0, -200%)",
          minWidth: "max-content",
          zIndex: contentZIndex.value,
          ["--reka-popper-transform-origin"]: [unref(middlewareData).transformOrigin?.x, unref(middlewareData).transformOrigin?.y].join(" "),
          ...unref(middlewareData).hide?.referenceHidden && {
            visibility: "hidden",
            pointerEvents: "none"
          }
        })
      }, [createVNode(unref(Primitive), mergeProps({ ref: unref(forwardRef) }, _ctx.$attrs, {
        "as-child": props2.asChild,
        as: _ctx.as,
        "data-side": placedSide.value,
        "data-align": placedAlign.value,
        style: { animation: !unref(isPositioned) ? "none" : void 0 }
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as-child",
        "as",
        "data-side",
        "data-align",
        "style"
      ])], 4);
    };
  }
});
var PopperContent_default = PopperContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popper/PopperArrow.js
var OPPOSITE_SIDE = {
  top: "bottom",
  right: "left",
  bottom: "top",
  left: "right"
};
var PopperArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "PopperArrow",
  props: {
    width: {
      type: Number,
      required: false
    },
    height: {
      type: Number,
      required: false
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const { forwardRef } = useForwardExpose();
    const contentContext = injectPopperContentContext();
    const baseSide = computed(() => OPPOSITE_SIDE[contentContext.placedSide.value]);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("span", {
        ref: (el) => {
          unref(contentContext).onArrowChange(el);
          return void 0;
        },
        style: normalizeStyle({
          position: "absolute",
          left: unref(contentContext).arrowX?.value ? `${unref(contentContext).arrowX?.value}px` : void 0,
          top: unref(contentContext).arrowY?.value ? `${unref(contentContext).arrowY?.value}px` : void 0,
          [baseSide.value]: 0,
          transformOrigin: {
            top: "",
            right: "0 0",
            bottom: "center 0",
            left: "100% 0"
          }[unref(contentContext).placedSide.value],
          transform: {
            top: "translateY(100%)",
            right: "translateY(50%) rotate(90deg) translateX(-50%)",
            bottom: `rotate(180deg)`,
            left: "translateY(50%) rotate(-90deg) translateX(50%)"
          }[unref(contentContext).placedSide.value],
          visibility: unref(contentContext).shouldHideArrow.value ? "hidden" : void 0
        })
      }, [createVNode(Arrow_default, mergeProps(_ctx.$attrs, {
        ref: unref(forwardRef),
        style: { display: "block" },
        as: _ctx.as,
        "as-child": _ctx.asChild,
        rounded: _ctx.rounded,
        width: _ctx.width,
        height: _ctx.height
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "rounded",
        "width",
        "height"
      ])], 4);
    };
  }
});
var PopperArrow_default = PopperArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxAnchor.js
var ComboboxAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const { forwardRef } = useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperAnchor_default), {
        "as-child": "",
        reference: _ctx.reference
      }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          ref: unref(forwardRef),
          "as-child": _ctx.asChild,
          as: _ctx.as
        }, _ctx.$attrs), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["as-child", "as"])]),
        _: 3
      }, 8, ["reference"]);
    };
  }
});
var ComboboxAnchor_default = ComboboxAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/utils.js
function queryCheckedElement(parentEl) {
  return parentEl?.querySelector("[data-state=checked]");
}
function valueComparator(value, currentValue, comparator) {
  if (value === void 0) return false;
  else if (Array.isArray(value)) return value.some((val) => compare(val, currentValue, comparator));
  else return compare(value, currentValue, comparator);
}
function compare(value, currentValue, comparator) {
  if (value === void 0 || currentValue === void 0) return false;
  if (typeof value === "string") return value === currentValue;
  if (typeof comparator === "function") return comparator(value, currentValue);
  if (typeof comparator === "string") return value?.[comparator] === currentValue?.[comparator];
  return isEqual(value, currentValue);
}

// node_modules/reka-ui/dist/Listbox/ListboxRoot.js
var [injectListboxRootContext, provideListboxRootContext] = createContext("ListboxRoot");
var ListboxRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxRoot",
  props: {
    modelValue: {
      type: null,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    },
    multiple: {
      type: Boolean,
      required: false
    },
    orientation: {
      type: String,
      required: false,
      default: "vertical"
    },
    dir: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    selectionBehavior: {
      type: String,
      required: false,
      default: "toggle"
    },
    highlightOnHover: {
      type: Boolean,
      required: false
    },
    by: {
      type: [String, Function],
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "update:modelValue",
    "highlight",
    "entryFocus",
    "leave"
  ],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { multiple, highlightOnHover, orientation, disabled, selectionBehavior, dir: propDir } = toRefs(props2);
    const { getItems } = useCollection({ isProvider: true });
    const { handleTypeaheadSearch } = useTypeahead();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const kbd = useKbd();
    const dir = useDirection(propDir);
    const isFormControl = useFormControl(currentElement);
    const firstValue = ref();
    const isUserAction = ref(false);
    const focusable = ref(true);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? (multiple.value ? [] : void 0),
      passive: props2.modelValue === void 0,
      deep: true
    });
    function onValueChange(val) {
      isUserAction.value = true;
      if (props2.multiple) {
        const modelArray = Array.isArray(modelValue.value) ? [...modelValue.value] : [];
        const index = modelArray.findIndex((i) => compare(i, val, props2.by));
        if (props2.selectionBehavior === "toggle") {
          index === -1 ? modelArray.push(val) : modelArray.splice(index, 1);
          modelValue.value = modelArray;
        } else {
          modelValue.value = [val];
          firstValue.value = val;
        }
      } else if (props2.selectionBehavior === "toggle") if (compare(modelValue.value, val, props2.by)) modelValue.value = void 0;
      else modelValue.value = val;
      else modelValue.value = val;
      setTimeout(() => {
        isUserAction.value = false;
      }, 1);
    }
    const highlightedElement = ref(null);
    const previousElement = ref(null);
    const isVirtual = ref(false);
    const isComposing = ref(false);
    const virtualFocusHook = createEventHook();
    const virtualKeydownHook = createEventHook();
    const virtualHighlightHook = createEventHook();
    function getCollectionItem() {
      return getItems().map((i) => i.ref).filter((i) => i.dataset.disabled !== "");
    }
    function changeHighlight(el, scrollIntoView = true) {
      if (!el) return;
      highlightedElement.value = el;
      if (focusable.value) highlightedElement.value.focus();
      if (scrollIntoView) highlightedElement.value.scrollIntoView({ block: "nearest" });
      const highlightedItem = getItems().find((i) => i.ref === el);
      emits("highlight", highlightedItem);
    }
    function highlightItem(value) {
      if (isVirtual.value) virtualHighlightHook.trigger(value);
      else {
        const item = getItems().find((i) => compare(i.value, value, props2.by));
        if (item) {
          highlightedElement.value = item.ref;
          changeHighlight(item.ref);
        }
      }
    }
    function onKeydownEnter(event) {
      if (highlightedElement.value && highlightedElement.value.isConnected) {
        event.preventDefault();
        event.stopPropagation();
        if (!isComposing.value) highlightedElement.value.click();
      }
    }
    function onKeydownTypeAhead(event) {
      if (!focusable.value) return;
      isUserAction.value = true;
      if (isVirtual.value) virtualKeydownHook.trigger(event);
      else {
        const isMetaKey = event.altKey || event.ctrlKey || event.metaKey;
        if (isMetaKey && event.key === "a" && multiple.value) {
          const collection = getItems();
          const values = collection.map((i) => i.value);
          modelValue.value = [...values];
          event.preventDefault();
          changeHighlight(collection[collection.length - 1].ref);
        } else if (!isMetaKey) {
          const el = handleTypeaheadSearch(event.key, getItems());
          if (el) changeHighlight(el);
        }
      }
      setTimeout(() => {
        isUserAction.value = false;
      }, 1);
    }
    function onCompositionStart() {
      isComposing.value = true;
    }
    function onCompositionEnd() {
      nextTick(() => {
        isComposing.value = false;
      });
    }
    function highlightFirstItem() {
      nextTick(() => {
        const event = new KeyboardEvent("keydown", { key: "PageUp" });
        onKeydownNavigation(event);
      });
    }
    function onLeave(event) {
      const el = highlightedElement.value;
      if (el?.isConnected) previousElement.value = el;
      highlightedElement.value = null;
      emits("leave", event);
    }
    function onEnter(event) {
      const entryFocusEvent = new CustomEvent("listbox.entryFocus", {
        bubbles: false,
        cancelable: true
      });
      event.currentTarget?.dispatchEvent(entryFocusEvent);
      emits("entryFocus", entryFocusEvent);
      if (entryFocusEvent.defaultPrevented) return;
      if (previousElement.value) changeHighlight(previousElement.value);
      else {
        const el = getCollectionItem()?.[0];
        changeHighlight(el);
      }
    }
    function onKeydownNavigation(event) {
      const intent = getFocusIntent(event, orientation.value, dir.value);
      if (!intent) return;
      let collection = getCollectionItem();
      if (highlightedElement.value) {
        if (intent === "last") collection.reverse();
        else if (intent === "prev" || intent === "next") {
          if (intent === "prev") collection.reverse();
          const currentIndex = collection.indexOf(highlightedElement.value);
          collection = collection.slice(currentIndex + 1);
        }
        handleMultipleReplace(event, collection[0]);
      }
      if (collection.length) {
        const index = !highlightedElement.value && intent === "prev" ? collection.length - 1 : 0;
        changeHighlight(collection[index]);
      }
      if (isVirtual.value) return virtualKeydownHook.trigger(event);
    }
    function handleMultipleReplace(event, targetEl) {
      if (isVirtual.value || props2.selectionBehavior !== "replace" || !multiple.value || !Array.isArray(modelValue.value)) return;
      const isMetaKey = event.altKey || event.ctrlKey || event.metaKey;
      if (isMetaKey && !event.shiftKey) return;
      if (event.shiftKey) {
        const collection = getItems().filter((i) => i.ref.dataset.disabled !== "");
        let lastValue = collection.find((i) => i.ref === targetEl)?.value;
        if (event.key === kbd.END) lastValue = collection[collection.length - 1].value;
        else if (event.key === kbd.HOME) lastValue = collection[0].value;
        if (!lastValue || !firstValue.value) return;
        const values = findValuesBetween(collection.map((i) => i.value), firstValue.value, lastValue);
        modelValue.value = values;
      }
    }
    async function highlightSelected(event) {
      await nextTick();
      if (isVirtual.value) virtualFocusHook.trigger(event);
      else {
        const collection = getCollectionItem();
        const item = collection.find((i) => i.dataset.state === "checked");
        if (item) changeHighlight(item);
        else if (collection.length) changeHighlight(collection[0]);
      }
    }
    watch(modelValue, () => {
      if (!isUserAction.value) nextTick(() => {
        highlightSelected();
      });
    }, {
      immediate: true,
      deep: true
    });
    __expose({
      highlightedElement,
      highlightItem,
      highlightFirstItem,
      highlightSelected,
      getItems
    });
    provideListboxRootContext({
      modelValue,
      onValueChange,
      multiple,
      orientation,
      dir,
      disabled,
      highlightOnHover,
      highlightedElement,
      isVirtual,
      virtualFocusHook,
      virtualKeydownHook,
      virtualHighlightHook,
      by: props2.by,
      firstValue,
      selectionBehavior,
      focusable,
      onLeave,
      onEnter,
      changeHighlight,
      onKeydownEnter,
      onKeydownNavigation,
      onKeydownTypeAhead,
      onCompositionStart,
      onCompositionEnd,
      highlightFirstItem
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        dir: unref(dir),
        "data-disabled": unref(disabled) ? "" : void 0,
        onPointerleave: onLeave,
        onFocusout: _cache[0] || (_cache[0] = async (event) => {
          const target = event.relatedTarget || event.target;
          await nextTick();
          if (highlightedElement.value && unref(currentElement) && !unref(currentElement).contains(target)) onLeave(event);
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) }), unref(isFormControl) && _ctx.name ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          name: _ctx.name,
          value: unref(modelValue),
          disabled: unref(disabled),
          required: _ctx.required
        }, null, 8, [
          "name",
          "value",
          "disabled",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "dir",
        "data-disabled"
      ]);
    };
  }
});
var ListboxRoot_default = ListboxRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxContent.js
var ListboxContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxContent",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const { CollectionSlot } = useCollection();
    const rootContext = injectListboxRootContext();
    const isClickFocus = refAutoReset(false, 10);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          role: "listbox",
          as: _ctx.as,
          "as-child": _ctx.asChild,
          tabindex: unref(rootContext).focusable.value ? unref(rootContext).highlightedElement.value ? "-1" : "0" : "-1",
          "aria-orientation": unref(rootContext).orientation.value,
          "aria-multiselectable": !!unref(rootContext).multiple.value,
          "data-orientation": unref(rootContext).orientation.value,
          onMousedown: _cache[0] || (_cache[0] = withModifiers(($event) => isClickFocus.value = true, ["left"])),
          onFocus: _cache[1] || (_cache[1] = (ev) => {
            if (unref(isClickFocus)) return;
            unref(rootContext).onEnter(ev);
          }),
          onKeydown: [
            _cache[2] || (_cache[2] = withKeys((event) => {
              if (unref(rootContext).orientation.value === "vertical" && (event.key === "ArrowLeft" || event.key === "ArrowRight") || unref(rootContext).orientation.value === "horizontal" && (event.key === "ArrowUp" || event.key === "ArrowDown")) return;
              event.preventDefault();
              unref(rootContext).focusable.value && unref(rootContext).onKeydownNavigation(event);
            }, [
              "down",
              "up",
              "left",
              "right",
              "home",
              "end"
            ])),
            withKeys(unref(rootContext).onKeydownEnter, ["enter"]),
            unref(rootContext).onKeydownTypeAhead
          ]
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "as",
          "as-child",
          "tabindex",
          "aria-orientation",
          "aria-multiselectable",
          "data-orientation",
          "onKeydown"
        ])]),
        _: 3
      });
    };
  }
});
var ListboxContent_default = ListboxContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxFilter.js
var ListboxFilter_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxFilter",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    autoFocus: {
      type: Boolean,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "input"
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: "",
      passive: props2.modelValue === void 0
    });
    const rootContext = injectListboxRootContext();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const disabled = computed(() => props2.disabled || rootContext.disabled.value || false);
    const activedescendant = ref();
    watchSyncEffect(() => activedescendant.value = rootContext.highlightedElement.value?.id);
    onMounted(() => {
      rootContext.focusable.value = false;
      setTimeout(() => {
        if (props2.autoFocus) currentElement.value?.focus();
      }, 1);
    });
    onUnmounted(() => {
      rootContext.focusable.value = true;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        value: unref(modelValue),
        disabled: disabled.value ? "" : void 0,
        "data-disabled": disabled.value ? "" : void 0,
        "aria-disabled": disabled.value ?? void 0,
        "aria-activedescendant": activedescendant.value,
        type: "text",
        onKeydown: [withKeys(withModifiers(unref(rootContext).onKeydownNavigation, ["prevent"]), [
          "down",
          "up",
          "home",
          "end"
        ]), withKeys(unref(rootContext).onKeydownEnter, ["enter"])],
        onInput: _cache[0] || (_cache[0] = (event) => {
          modelValue.value = event.target.value;
          unref(rootContext).highlightFirstItem();
        }),
        onCompositionstart: unref(rootContext).onCompositionStart,
        onCompositionend: unref(rootContext).onCompositionEnd
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "value",
        "disabled",
        "data-disabled",
        "aria-disabled",
        "aria-activedescendant",
        "onKeydown",
        "onCompositionstart",
        "onCompositionend"
      ]);
    };
  }
});
var ListboxFilter_default = ListboxFilter_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxGroup.js
var [injectListboxGroupContext, provideListboxGroupContext] = createContext("ListboxGroup");
var ListboxGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const id = useId2(void 0, "reka-listbox-group");
    provideListboxGroupContext({ id });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ role: "group" }, props2, { "aria-labelledby": unref(id) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["aria-labelledby"]);
    };
  }
});
var ListboxGroup_default = ListboxGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxGroupLabel.js
var ListboxGroupLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxGroupLabel",
  props: {
    for: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const groupContext = injectListboxGroupContext({ id: "" });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { id: unref(groupContext).id }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var ListboxGroupLabel_default = ListboxGroupLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxItem.js
var LISTBOX_SELECT = "listbox.select";
var [injectListboxItemContext, provideListboxItemContext] = createContext("ListboxItem");
var ListboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxItem",
  props: {
    value: {
      type: null,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const id = useId2(void 0, "reka-listbox-item");
    const { CollectionItem } = useCollection();
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectListboxRootContext();
    const isHighlighted = computed(() => currentElement.value === rootContext.highlightedElement.value);
    const isSelected = computed(() => valueComparator(rootContext.modelValue.value, props2.value, rootContext.by));
    const disabled = computed(() => rootContext.disabled.value || props2.disabled);
    async function handleSelect2(ev) {
      emits("select", ev);
      if (ev?.defaultPrevented) return;
      if (!disabled.value && ev) {
        rootContext.onValueChange(props2.value);
        rootContext.changeHighlight(currentElement.value);
      }
    }
    function handleSelectCustomEvent(ev) {
      const eventDetail = {
        originalEvent: ev,
        value: props2.value
      };
      handleAndDispatchCustomEvent(LISTBOX_SELECT, handleSelect2, eventDetail);
    }
    provideListboxItemContext({ isSelected });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), { value: _ctx.value }, {
        default: withCtx(() => [withMemo([isHighlighted.value, isSelected.value], () => createVNode(unref(Primitive), mergeProps({ id: unref(id) }, _ctx.$attrs, {
          ref: unref(forwardRef),
          role: "option",
          tabindex: unref(rootContext).focusable.value ? isHighlighted.value ? "0" : "-1" : -1,
          "aria-selected": isSelected.value,
          as: _ctx.as,
          "as-child": _ctx.asChild,
          disabled: disabled.value ? "" : void 0,
          "data-disabled": disabled.value ? "" : void 0,
          "data-highlighted": isHighlighted.value ? "" : void 0,
          "data-state": isSelected.value ? "checked" : "unchecked",
          onClick: handleSelectCustomEvent,
          onKeydown: withKeys(withModifiers(handleSelectCustomEvent, ["prevent"]), ["space"]),
          onPointermove: _cache[0] || (_cache[0] = () => {
            if (unref(rootContext).highlightedElement.value === unref(currentElement)) return;
            if (unref(rootContext).highlightOnHover.value && !unref(rootContext).focusable.value) unref(rootContext).changeHighlight(unref(currentElement), false);
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "id",
          "tabindex",
          "aria-selected",
          "as",
          "as-child",
          "disabled",
          "data-disabled",
          "data-highlighted",
          "data-state",
          "onKeydown"
        ]), _cache, 1)]),
        _: 3
      }, 8, ["value"]);
    };
  }
});
var ListboxItem_default = ListboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Listbox/ListboxItemIndicator.js
var ListboxItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxItemIndicator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const itemContext = injectListboxItemContext();
    return (_ctx, _cache) => {
      return unref(itemContext).isSelected.value ? (openBlock(), createBlock(unref(Primitive), mergeProps({
        key: 0,
        "aria-hidden": "true"
      }, props2), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var ListboxItemIndicator_default = ListboxItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/@tanstack/virtual-core/dist/esm/utils.js
function memo(getDeps, fn, opts) {
  let deps = opts.initialDeps ?? [];
  let result;
  function memoizedFunction() {
    var _a, _b, _c, _d;
    let depTime;
    if (opts.key && ((_a = opts.debug) == null ? void 0 : _a.call(opts))) depTime = Date.now();
    const newDeps = getDeps();
    const depsChanged = newDeps.length !== deps.length || newDeps.some((dep, index) => deps[index] !== dep);
    if (!depsChanged) {
      return result;
    }
    deps = newDeps;
    let resultTime;
    if (opts.key && ((_b = opts.debug) == null ? void 0 : _b.call(opts))) resultTime = Date.now();
    result = fn(...newDeps);
    if (opts.key && ((_c = opts.debug) == null ? void 0 : _c.call(opts))) {
      const depEndTime = Math.round((Date.now() - depTime) * 100) / 100;
      const resultEndTime = Math.round((Date.now() - resultTime) * 100) / 100;
      const resultFpsPercentage = resultEndTime / 16;
      const pad = (str, num) => {
        str = String(str);
        while (str.length < num) {
          str = " " + str;
        }
        return str;
      };
      console.info(
        `%c⏱ ${pad(resultEndTime, 5)} /${pad(depEndTime, 5)} ms`,
        `
            font-size: .6rem;
            font-weight: bold;
            color: hsl(${Math.max(
          0,
          Math.min(120 - 120 * resultFpsPercentage, 120)
        )}deg 100% 31%);`,
        opts == null ? void 0 : opts.key
      );
    }
    (_d = opts == null ? void 0 : opts.onChange) == null ? void 0 : _d.call(opts, result);
    return result;
  }
  memoizedFunction.updateDeps = (newDeps) => {
    deps = newDeps;
  };
  return memoizedFunction;
}
function notUndefined(value, msg) {
  if (value === void 0) {
    throw new Error(`Unexpected undefined${msg ? `: ${msg}` : ""}`);
  } else {
    return value;
  }
}
var approxEqual = (a, b) => Math.abs(a - b) < 1.01;
var debounce = (targetWindow, fn, ms) => {
  let timeoutId;
  return function(...args) {
    targetWindow.clearTimeout(timeoutId);
    timeoutId = targetWindow.setTimeout(() => fn.apply(this, args), ms);
  };
};

// node_modules/@tanstack/virtual-core/dist/esm/index.js
var getRect = (element) => {
  const { offsetWidth, offsetHeight } = element;
  return { width: offsetWidth, height: offsetHeight };
};
var defaultKeyExtractor = (index) => index;
var defaultRangeExtractor = (range2) => {
  const start = Math.max(range2.startIndex - range2.overscan, 0);
  const end = Math.min(range2.endIndex + range2.overscan, range2.count - 1);
  const arr = [];
  for (let i = start; i <= end; i++) {
    arr.push(i);
  }
  return arr;
};
var observeElementRect = (instance, cb) => {
  const element = instance.scrollElement;
  if (!element) {
    return;
  }
  const targetWindow = instance.targetWindow;
  if (!targetWindow) {
    return;
  }
  const handler = (rect) => {
    const { width, height } = rect;
    cb({ width: Math.round(width), height: Math.round(height) });
  };
  handler(getRect(element));
  if (!targetWindow.ResizeObserver) {
    return () => {
    };
  }
  const observer = new targetWindow.ResizeObserver((entries) => {
    const run = () => {
      const entry = entries[0];
      if (entry == null ? void 0 : entry.borderBoxSize) {
        const box = entry.borderBoxSize[0];
        if (box) {
          handler({ width: box.inlineSize, height: box.blockSize });
          return;
        }
      }
      handler(getRect(element));
    };
    instance.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(run) : run();
  });
  observer.observe(element, { box: "border-box" });
  return () => {
    observer.unobserve(element);
  };
};
var addEventListenerOptions = {
  passive: true
};
var supportsScrollend = typeof window == "undefined" ? true : "onscrollend" in window;
var observeElementOffset = (instance, cb) => {
  const element = instance.scrollElement;
  if (!element) {
    return;
  }
  const targetWindow = instance.targetWindow;
  if (!targetWindow) {
    return;
  }
  let offset3 = 0;
  const fallback = instance.options.useScrollendEvent && supportsScrollend ? () => void 0 : debounce(
    targetWindow,
    () => {
      cb(offset3, false);
    },
    instance.options.isScrollingResetDelay
  );
  const createHandler = (isScrolling) => () => {
    const { horizontal, isRtl } = instance.options;
    offset3 = horizontal ? element["scrollLeft"] * (isRtl && -1 || 1) : element["scrollTop"];
    fallback();
    cb(offset3, isScrolling);
  };
  const handler = createHandler(true);
  const endHandler = createHandler(false);
  endHandler();
  element.addEventListener("scroll", handler, addEventListenerOptions);
  const registerScrollendEvent = instance.options.useScrollendEvent && supportsScrollend;
  if (registerScrollendEvent) {
    element.addEventListener("scrollend", endHandler, addEventListenerOptions);
  }
  return () => {
    element.removeEventListener("scroll", handler);
    if (registerScrollendEvent) {
      element.removeEventListener("scrollend", endHandler);
    }
  };
};
var measureElement = (element, entry, instance) => {
  if (entry == null ? void 0 : entry.borderBoxSize) {
    const box = entry.borderBoxSize[0];
    if (box) {
      const size3 = Math.round(
        box[instance.options.horizontal ? "inlineSize" : "blockSize"]
      );
      return size3;
    }
  }
  return element[instance.options.horizontal ? "offsetWidth" : "offsetHeight"];
};
var elementScroll = (offset3, {
  adjustments = 0,
  behavior
}, instance) => {
  var _a, _b;
  const toOffset = offset3 + adjustments;
  (_b = (_a = instance.scrollElement) == null ? void 0 : _a.scrollTo) == null ? void 0 : _b.call(_a, {
    [instance.options.horizontal ? "left" : "top"]: toOffset,
    behavior
  });
};
var Virtualizer = class {
  constructor(opts) {
    this.unsubs = [];
    this.scrollElement = null;
    this.targetWindow = null;
    this.isScrolling = false;
    this.measurementsCache = [];
    this.itemSizeCache = /* @__PURE__ */ new Map();
    this.pendingMeasuredCacheIndexes = [];
    this.scrollRect = null;
    this.scrollOffset = null;
    this.scrollDirection = null;
    this.scrollAdjustments = 0;
    this.elementsCache = /* @__PURE__ */ new Map();
    this.observer = /* @__PURE__ */ (() => {
      let _ro = null;
      const get = () => {
        if (_ro) {
          return _ro;
        }
        if (!this.targetWindow || !this.targetWindow.ResizeObserver) {
          return null;
        }
        return _ro = new this.targetWindow.ResizeObserver((entries) => {
          entries.forEach((entry) => {
            const run = () => {
              this._measureElement(entry.target, entry);
            };
            this.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(run) : run();
          });
        });
      };
      return {
        disconnect: () => {
          var _a;
          (_a = get()) == null ? void 0 : _a.disconnect();
          _ro = null;
        },
        observe: (target) => {
          var _a;
          return (_a = get()) == null ? void 0 : _a.observe(target, { box: "border-box" });
        },
        unobserve: (target) => {
          var _a;
          return (_a = get()) == null ? void 0 : _a.unobserve(target);
        }
      };
    })();
    this.range = null;
    this.setOptions = (opts2) => {
      Object.entries(opts2).forEach(([key, value]) => {
        if (typeof value === "undefined") delete opts2[key];
      });
      this.options = {
        debug: false,
        initialOffset: 0,
        overscan: 1,
        paddingStart: 0,
        paddingEnd: 0,
        scrollPaddingStart: 0,
        scrollPaddingEnd: 0,
        horizontal: false,
        getItemKey: defaultKeyExtractor,
        rangeExtractor: defaultRangeExtractor,
        onChange: () => {
        },
        measureElement,
        initialRect: { width: 0, height: 0 },
        scrollMargin: 0,
        gap: 0,
        indexAttribute: "data-index",
        initialMeasurementsCache: [],
        lanes: 1,
        isScrollingResetDelay: 150,
        enabled: true,
        isRtl: false,
        useScrollendEvent: false,
        useAnimationFrameWithResizeObserver: false,
        ...opts2
      };
    };
    this.notify = (sync) => {
      var _a, _b;
      (_b = (_a = this.options).onChange) == null ? void 0 : _b.call(_a, this, sync);
    };
    this.maybeNotify = memo(
      () => {
        this.calculateRange();
        return [
          this.isScrolling,
          this.range ? this.range.startIndex : null,
          this.range ? this.range.endIndex : null
        ];
      },
      (isScrolling) => {
        this.notify(isScrolling);
      },
      {
        key: "maybeNotify",
        debug: () => this.options.debug,
        initialDeps: [
          this.isScrolling,
          this.range ? this.range.startIndex : null,
          this.range ? this.range.endIndex : null
        ]
      }
    );
    this.cleanup = () => {
      this.unsubs.filter(Boolean).forEach((d) => d());
      this.unsubs = [];
      this.observer.disconnect();
      this.scrollElement = null;
      this.targetWindow = null;
    };
    this._didMount = () => {
      return () => {
        this.cleanup();
      };
    };
    this._willUpdate = () => {
      var _a;
      const scrollElement = this.options.enabled ? this.options.getScrollElement() : null;
      if (this.scrollElement !== scrollElement) {
        this.cleanup();
        if (!scrollElement) {
          this.maybeNotify();
          return;
        }
        this.scrollElement = scrollElement;
        if (this.scrollElement && "ownerDocument" in this.scrollElement) {
          this.targetWindow = this.scrollElement.ownerDocument.defaultView;
        } else {
          this.targetWindow = ((_a = this.scrollElement) == null ? void 0 : _a.window) ?? null;
        }
        this.elementsCache.forEach((cached) => {
          this.observer.observe(cached);
        });
        this._scrollToOffset(this.getScrollOffset(), {
          adjustments: void 0,
          behavior: void 0
        });
        this.unsubs.push(
          this.options.observeElementRect(this, (rect) => {
            this.scrollRect = rect;
            this.maybeNotify();
          })
        );
        this.unsubs.push(
          this.options.observeElementOffset(this, (offset3, isScrolling) => {
            this.scrollAdjustments = 0;
            this.scrollDirection = isScrolling ? this.getScrollOffset() < offset3 ? "forward" : "backward" : null;
            this.scrollOffset = offset3;
            this.isScrolling = isScrolling;
            this.maybeNotify();
          })
        );
      }
    };
    this.getSize = () => {
      if (!this.options.enabled) {
        this.scrollRect = null;
        return 0;
      }
      this.scrollRect = this.scrollRect ?? this.options.initialRect;
      return this.scrollRect[this.options.horizontal ? "width" : "height"];
    };
    this.getScrollOffset = () => {
      if (!this.options.enabled) {
        this.scrollOffset = null;
        return 0;
      }
      this.scrollOffset = this.scrollOffset ?? (typeof this.options.initialOffset === "function" ? this.options.initialOffset() : this.options.initialOffset);
      return this.scrollOffset;
    };
    this.getFurthestMeasurement = (measurements, index) => {
      const furthestMeasurementsFound = /* @__PURE__ */ new Map();
      const furthestMeasurements = /* @__PURE__ */ new Map();
      for (let m = index - 1; m >= 0; m--) {
        const measurement = measurements[m];
        if (furthestMeasurementsFound.has(measurement.lane)) {
          continue;
        }
        const previousFurthestMeasurement = furthestMeasurements.get(
          measurement.lane
        );
        if (previousFurthestMeasurement == null || measurement.end > previousFurthestMeasurement.end) {
          furthestMeasurements.set(measurement.lane, measurement);
        } else if (measurement.end < previousFurthestMeasurement.end) {
          furthestMeasurementsFound.set(measurement.lane, true);
        }
        if (furthestMeasurementsFound.size === this.options.lanes) {
          break;
        }
      }
      return furthestMeasurements.size === this.options.lanes ? Array.from(furthestMeasurements.values()).sort((a, b) => {
        if (a.end === b.end) {
          return a.index - b.index;
        }
        return a.end - b.end;
      })[0] : void 0;
    };
    this.getMeasurementOptions = memo(
      () => [
        this.options.count,
        this.options.paddingStart,
        this.options.scrollMargin,
        this.options.getItemKey,
        this.options.enabled
      ],
      (count3, paddingStart, scrollMargin, getItemKey, enabled) => {
        this.pendingMeasuredCacheIndexes = [];
        return {
          count: count3,
          paddingStart,
          scrollMargin,
          getItemKey,
          enabled
        };
      },
      {
        key: false
      }
    );
    this.getMeasurements = memo(
      () => [this.getMeasurementOptions(), this.itemSizeCache],
      ({ count: count3, paddingStart, scrollMargin, getItemKey, enabled }, itemSizeCache) => {
        if (!enabled) {
          this.measurementsCache = [];
          this.itemSizeCache.clear();
          return [];
        }
        if (this.measurementsCache.length === 0) {
          this.measurementsCache = this.options.initialMeasurementsCache;
          this.measurementsCache.forEach((item) => {
            this.itemSizeCache.set(item.key, item.size);
          });
        }
        const min2 = this.pendingMeasuredCacheIndexes.length > 0 ? Math.min(...this.pendingMeasuredCacheIndexes) : 0;
        this.pendingMeasuredCacheIndexes = [];
        const measurements = this.measurementsCache.slice(0, min2);
        for (let i = min2; i < count3; i++) {
          const key = getItemKey(i);
          const furthestMeasurement = this.options.lanes === 1 ? measurements[i - 1] : this.getFurthestMeasurement(measurements, i);
          const start = furthestMeasurement ? furthestMeasurement.end + this.options.gap : paddingStart + scrollMargin;
          const measuredSize = itemSizeCache.get(key);
          const size3 = typeof measuredSize === "number" ? measuredSize : this.options.estimateSize(i);
          const end = start + size3;
          const lane = furthestMeasurement ? furthestMeasurement.lane : i % this.options.lanes;
          measurements[i] = {
            index: i,
            start,
            size: size3,
            end,
            key,
            lane
          };
        }
        this.measurementsCache = measurements;
        return measurements;
      },
      {
        key: "getMeasurements",
        debug: () => this.options.debug
      }
    );
    this.calculateRange = memo(
      () => [
        this.getMeasurements(),
        this.getSize(),
        this.getScrollOffset(),
        this.options.lanes
      ],
      (measurements, outerSize, scrollOffset, lanes) => {
        return this.range = measurements.length > 0 && outerSize > 0 ? calculateRange({
          measurements,
          outerSize,
          scrollOffset,
          lanes
        }) : null;
      },
      {
        key: "calculateRange",
        debug: () => this.options.debug
      }
    );
    this.getVirtualIndexes = memo(
      () => {
        let startIndex = null;
        let endIndex = null;
        const range2 = this.calculateRange();
        if (range2) {
          startIndex = range2.startIndex;
          endIndex = range2.endIndex;
        }
        this.maybeNotify.updateDeps([this.isScrolling, startIndex, endIndex]);
        return [
          this.options.rangeExtractor,
          this.options.overscan,
          this.options.count,
          startIndex,
          endIndex
        ];
      },
      (rangeExtractor, overscan, count3, startIndex, endIndex) => {
        return startIndex === null || endIndex === null ? [] : rangeExtractor({
          startIndex,
          endIndex,
          overscan,
          count: count3
        });
      },
      {
        key: "getVirtualIndexes",
        debug: () => this.options.debug
      }
    );
    this.indexFromElement = (node) => {
      const attributeName = this.options.indexAttribute;
      const indexStr = node.getAttribute(attributeName);
      if (!indexStr) {
        console.warn(
          `Missing attribute name '${attributeName}={index}' on measured element.`
        );
        return -1;
      }
      return parseInt(indexStr, 10);
    };
    this._measureElement = (node, entry) => {
      const index = this.indexFromElement(node);
      const item = this.measurementsCache[index];
      if (!item) {
        return;
      }
      const key = item.key;
      const prevNode = this.elementsCache.get(key);
      if (prevNode !== node) {
        if (prevNode) {
          this.observer.unobserve(prevNode);
        }
        this.observer.observe(node);
        this.elementsCache.set(key, node);
      }
      if (node.isConnected) {
        this.resizeItem(index, this.options.measureElement(node, entry, this));
      }
    };
    this.resizeItem = (index, size3) => {
      const item = this.measurementsCache[index];
      if (!item) {
        return;
      }
      const itemSize = this.itemSizeCache.get(item.key) ?? item.size;
      const delta = size3 - itemSize;
      if (delta !== 0) {
        if (this.shouldAdjustScrollPositionOnItemSizeChange !== void 0 ? this.shouldAdjustScrollPositionOnItemSizeChange(item, delta, this) : item.start < this.getScrollOffset() + this.scrollAdjustments) {
          if (this.options.debug) {
            console.info("correction", delta);
          }
          this._scrollToOffset(this.getScrollOffset(), {
            adjustments: this.scrollAdjustments += delta,
            behavior: void 0
          });
        }
        this.pendingMeasuredCacheIndexes.push(item.index);
        this.itemSizeCache = new Map(this.itemSizeCache.set(item.key, size3));
        this.notify(false);
      }
    };
    this.measureElement = (node) => {
      if (!node) {
        this.elementsCache.forEach((cached, key) => {
          if (!cached.isConnected) {
            this.observer.unobserve(cached);
            this.elementsCache.delete(key);
          }
        });
        return;
      }
      this._measureElement(node, void 0);
    };
    this.getVirtualItems = memo(
      () => [this.getVirtualIndexes(), this.getMeasurements()],
      (indexes, measurements) => {
        const virtualItems = [];
        for (let k = 0, len = indexes.length; k < len; k++) {
          const i = indexes[k];
          const measurement = measurements[i];
          virtualItems.push(measurement);
        }
        return virtualItems;
      },
      {
        key: "getVirtualItems",
        debug: () => this.options.debug
      }
    );
    this.getVirtualItemForOffset = (offset3) => {
      const measurements = this.getMeasurements();
      if (measurements.length === 0) {
        return void 0;
      }
      return notUndefined(
        measurements[findNearestBinarySearch(
          0,
          measurements.length - 1,
          (index) => notUndefined(measurements[index]).start,
          offset3
        )]
      );
    };
    this.getOffsetForAlignment = (toOffset, align, itemSize = 0) => {
      const size3 = this.getSize();
      const scrollOffset = this.getScrollOffset();
      if (align === "auto") {
        align = toOffset >= scrollOffset + size3 ? "end" : "start";
      }
      if (align === "center") {
        toOffset += (itemSize - size3) / 2;
      } else if (align === "end") {
        toOffset -= size3;
      }
      const maxOffset = this.getTotalSize() + this.options.scrollMargin - size3;
      return Math.max(Math.min(maxOffset, toOffset), 0);
    };
    this.getOffsetForIndex = (index, align = "auto") => {
      index = Math.max(0, Math.min(index, this.options.count - 1));
      const item = this.measurementsCache[index];
      if (!item) {
        return void 0;
      }
      const size3 = this.getSize();
      const scrollOffset = this.getScrollOffset();
      if (align === "auto") {
        if (item.end >= scrollOffset + size3 - this.options.scrollPaddingEnd) {
          align = "end";
        } else if (item.start <= scrollOffset + this.options.scrollPaddingStart) {
          align = "start";
        } else {
          return [scrollOffset, align];
        }
      }
      const toOffset = align === "end" ? item.end + this.options.scrollPaddingEnd : item.start - this.options.scrollPaddingStart;
      return [
        this.getOffsetForAlignment(toOffset, align, item.size),
        align
      ];
    };
    this.isDynamicMode = () => this.elementsCache.size > 0;
    this.scrollToOffset = (toOffset, { align = "start", behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      this._scrollToOffset(this.getOffsetForAlignment(toOffset, align), {
        adjustments: void 0,
        behavior
      });
    };
    this.scrollToIndex = (index, { align: initialAlign = "auto", behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      index = Math.max(0, Math.min(index, this.options.count - 1));
      let attempts = 0;
      const maxAttempts = 10;
      const tryScroll = (currentAlign) => {
        if (!this.targetWindow) return;
        const offsetInfo = this.getOffsetForIndex(index, currentAlign);
        if (!offsetInfo) {
          console.warn("Failed to get offset for index:", index);
          return;
        }
        const [offset3, align] = offsetInfo;
        this._scrollToOffset(offset3, { adjustments: void 0, behavior });
        this.targetWindow.requestAnimationFrame(() => {
          const currentOffset = this.getScrollOffset();
          const afterInfo = this.getOffsetForIndex(index, align);
          if (!afterInfo) {
            console.warn("Failed to get offset for index:", index);
            return;
          }
          if (!approxEqual(afterInfo[0], currentOffset)) {
            scheduleRetry(align);
          }
        });
      };
      const scheduleRetry = (align) => {
        if (!this.targetWindow) return;
        attempts++;
        if (attempts < maxAttempts) {
          if (this.options.debug) {
            console.info("Schedule retry", attempts, maxAttempts);
          }
          this.targetWindow.requestAnimationFrame(() => tryScroll(align));
        } else {
          console.warn(
            `Failed to scroll to index ${index} after ${maxAttempts} attempts.`
          );
        }
      };
      tryScroll(initialAlign);
    };
    this.scrollBy = (delta, { behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      this._scrollToOffset(this.getScrollOffset() + delta, {
        adjustments: void 0,
        behavior
      });
    };
    this.getTotalSize = () => {
      var _a;
      const measurements = this.getMeasurements();
      let end;
      if (measurements.length === 0) {
        end = this.options.paddingStart;
      } else if (this.options.lanes === 1) {
        end = ((_a = measurements[measurements.length - 1]) == null ? void 0 : _a.end) ?? 0;
      } else {
        const endByLane = Array(this.options.lanes).fill(null);
        let endIndex = measurements.length - 1;
        while (endIndex >= 0 && endByLane.some((val) => val === null)) {
          const item = measurements[endIndex];
          if (endByLane[item.lane] === null) {
            endByLane[item.lane] = item.end;
          }
          endIndex--;
        }
        end = Math.max(...endByLane.filter((val) => val !== null));
      }
      return Math.max(
        end - this.options.scrollMargin + this.options.paddingEnd,
        0
      );
    };
    this._scrollToOffset = (offset3, {
      adjustments,
      behavior
    }) => {
      this.options.scrollToFn(offset3, { behavior, adjustments }, this);
    };
    this.measure = () => {
      this.itemSizeCache = /* @__PURE__ */ new Map();
      this.notify(false);
    };
    this.setOptions(opts);
  }
};
var findNearestBinarySearch = (low, high, getCurrentValue, value) => {
  while (low <= high) {
    const middle = (low + high) / 2 | 0;
    const currentValue = getCurrentValue(middle);
    if (currentValue < value) {
      low = middle + 1;
    } else if (currentValue > value) {
      high = middle - 1;
    } else {
      return middle;
    }
  }
  if (low > 0) {
    return low - 1;
  } else {
    return 0;
  }
};
function calculateRange({
  measurements,
  outerSize,
  scrollOffset,
  lanes
}) {
  const lastIndex = measurements.length - 1;
  const getOffset = (index) => measurements[index].start;
  if (measurements.length <= lanes) {
    return {
      startIndex: 0,
      endIndex: lastIndex
    };
  }
  let startIndex = findNearestBinarySearch(
    0,
    lastIndex,
    getOffset,
    scrollOffset
  );
  let endIndex = startIndex;
  if (lanes === 1) {
    while (endIndex < lastIndex && measurements[endIndex].end < scrollOffset + outerSize) {
      endIndex++;
    }
  } else if (lanes > 1) {
    const endPerLane = Array(lanes).fill(0);
    while (endIndex < lastIndex && endPerLane.some((pos) => pos < scrollOffset + outerSize)) {
      const item = measurements[endIndex];
      endPerLane[item.lane] = item.end;
      endIndex++;
    }
    const startPerLane = Array(lanes).fill(scrollOffset + outerSize);
    while (startIndex >= 0 && startPerLane.some((pos) => pos >= scrollOffset)) {
      const item = measurements[startIndex];
      startPerLane[item.lane] = item.start;
      startIndex--;
    }
    startIndex = Math.max(0, startIndex - startIndex % lanes);
    endIndex = Math.min(lastIndex, endIndex + (lanes - 1 - endIndex % lanes));
  }
  return { startIndex, endIndex };
}

// node_modules/@tanstack/vue-virtual/dist/esm/index.js
function useVirtualizerBase(options) {
  const virtualizer = new Virtualizer(unref(options));
  const state = shallowRef(virtualizer);
  const cleanup = virtualizer._didMount();
  watch(
    () => unref(options).getScrollElement(),
    (el) => {
      if (el) {
        virtualizer._willUpdate();
      }
    },
    {
      immediate: true
    }
  );
  watch(
    () => unref(options),
    (options2) => {
      virtualizer.setOptions({
        ...options2,
        onChange: (instance, sync) => {
          var _a;
          triggerRef(state);
          (_a = options2.onChange) == null ? void 0 : _a.call(options2, instance, sync);
        }
      });
      virtualizer._willUpdate();
      triggerRef(state);
    },
    {
      immediate: true
    }
  );
  onScopeDispose(cleanup);
  return state;
}
function useVirtualizer(options) {
  return useVirtualizerBase(
    computed(() => ({
      observeElementRect,
      observeElementOffset,
      scrollToFn: elementScroll,
      ...unref(options)
    }))
  );
}

// node_modules/reka-ui/dist/Listbox/ListboxVirtualizer.js
var ListboxVirtualizer_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ListboxVirtualizer",
  props: {
    options: {
      type: Array,
      required: true
    },
    overscan: {
      type: Number,
      required: false
    },
    estimateSize: {
      type: [Number, Function],
      required: false
    },
    textContent: {
      type: Function,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const slots = useSlots();
    const rootContext = injectListboxRootContext();
    const parentEl = useParentElement();
    const { getItems } = useCollection();
    rootContext.isVirtual.value = true;
    const padding = computed(() => {
      const el = parentEl.value;
      if (!el) return {
        start: 0,
        end: 0
      };
      else {
        const styles = window.getComputedStyle(el);
        return {
          start: Number.parseFloat(styles.paddingBlockStart || styles.paddingTop),
          end: Number.parseFloat(styles.paddingBlockEnd || styles.paddingBottom)
        };
      }
    });
    const virtualizer = useVirtualizer({
      get scrollPaddingStart() {
        return padding.value.start;
      },
      get scrollPaddingEnd() {
        return padding.value.end;
      },
      get count() {
        return props2.options.length;
      },
      get horizontal() {
        return rootContext.orientation.value === "horizontal";
      },
      estimateSize(index) {
        if (typeof props2.estimateSize === "function") return props2.estimateSize(index);
        return props2.estimateSize ?? 28;
      },
      getScrollElement() {
        return parentEl.value;
      },
      overscan: props2.overscan ?? 12
    });
    const virtualizedItems = computed(() => virtualizer.value.getVirtualItems().map((item) => {
      const defaultNode = slots.default({
        option: props2.options[item.index],
        virtualizer: virtualizer.value,
        virtualItem: item
      })[0];
      const targetNode = defaultNode.type === Fragment && Array.isArray(defaultNode.children) ? defaultNode.children[0] : defaultNode;
      return {
        item,
        is: cloneVNode(targetNode, {
          "key": `${item.key}`,
          "data-index": item.index,
          "aria-setsize": props2.options.length,
          "aria-posinset": item.index + 1,
          "style": {
            position: "absolute",
            top: 0,
            left: 0,
            transform: `translateY(${item.start}px)`,
            overflowAnchor: "none"
          }
        })
      };
    }));
    rootContext.virtualFocusHook.on((event) => {
      const index = props2.options.findIndex((option) => {
        if (Array.isArray(rootContext.modelValue.value)) return compare(option, rootContext.modelValue.value[0], rootContext.by);
        else return compare(option, rootContext.modelValue.value, rootContext.by);
      });
      if (index !== -1) {
        event?.preventDefault();
        virtualizer.value.scrollToIndex(index, { align: "start" });
        requestAnimationFrame(() => {
          const item = queryCheckedElement(parentEl.value);
          if (item) {
            rootContext.changeHighlight(item);
            if (event) item?.focus();
          }
        });
      } else rootContext.highlightFirstItem();
    });
    rootContext.virtualHighlightHook.on((value) => {
      const index = props2.options.findIndex((option) => {
        return compare(option, value, rootContext.by);
      });
      virtualizer.value.scrollToIndex(index, { align: "start" });
      requestAnimationFrame(() => {
        const item = queryCheckedElement(parentEl.value);
        if (item) rootContext.changeHighlight(item);
      });
    });
    const search = refAutoReset("", 1e3);
    const optionsWithMetadata = computed(() => {
      const parseTextContent = (option) => {
        if (props2.textContent) return props2.textContent(option);
        else return option?.toString().toLowerCase();
      };
      return props2.options.map((option, index) => ({
        index,
        textContent: parseTextContent(option)
      }));
    });
    function handleMultipleReplace(event, intent) {
      if (!rootContext.firstValue?.value || !rootContext.multiple.value || !Array.isArray(rootContext.modelValue.value)) return;
      const collection = getItems().filter((i) => i.ref.dataset.disabled !== "");
      const lastValue = collection.find((i) => i.ref === rootContext.highlightedElement.value)?.value;
      if (!lastValue) return;
      let value = null;
      switch (intent) {
        case "prev":
        case "next": {
          value = findValuesBetween(props2.options, rootContext.firstValue.value, lastValue);
          break;
        }
        case "first": {
          value = findValuesBetween(props2.options, rootContext.firstValue.value, props2.options?.[0]);
          break;
        }
        case "last": {
          value = findValuesBetween(props2.options, rootContext.firstValue.value, props2.options?.[props2.options.length - 1]);
          break;
        }
      }
      rootContext.modelValue.value = value;
    }
    rootContext.virtualKeydownHook.on((event) => {
      const isMetaKey = event.altKey || event.ctrlKey || event.metaKey;
      const isTabKey = event.key === "Tab" && !isMetaKey;
      if (isTabKey) return;
      let intent = MAP_KEY_TO_FOCUS_INTENT[event.key];
      if (isMetaKey && event.key === "a" && rootContext.multiple.value) {
        event.preventDefault();
        rootContext.modelValue.value = [...props2.options];
        intent = "last";
      } else if (event.shiftKey && intent) handleMultipleReplace(event, intent);
      if (["first", "last"].includes(intent)) {
        event.preventDefault();
        const index = intent === "first" ? 0 : props2.options.length - 1;
        virtualizer.value.scrollToIndex(index);
        requestAnimationFrame(() => {
          const items = getItems();
          const item = intent === "first" ? items[0] : items[items.length - 1];
          if (item) rootContext.changeHighlight(item.ref);
        });
      } else if (!intent && !isMetaKey) {
        search.value += event.key;
        const currentIndex = Number(getActiveElement()?.getAttribute("data-index"));
        const currentMatch = optionsWithMetadata.value[currentIndex].textContent;
        const filteredOptions = optionsWithMetadata.value.map((i) => i.textContent ?? "");
        const next = getNextMatch(filteredOptions, search.value, currentMatch);
        const nextMatch = optionsWithMetadata.value.find((option) => option.textContent === next);
        if (nextMatch) {
          virtualizer.value.scrollToIndex(nextMatch.index, { align: "start" });
          requestAnimationFrame(() => {
            const item = parentEl.value.querySelector(`[data-index="${nextMatch.index}"]`);
            if (item instanceof HTMLElement) rootContext.changeHighlight(item);
          });
        }
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        "data-reka-virtualizer": "",
        style: normalizeStyle({
          position: "relative",
          width: "100%",
          height: `${unref(virtualizer).getTotalSize()}px`
        })
      }, [(openBlock(true), createElementBlock(Fragment, null, renderList(virtualizedItems.value, ({ is, item }) => {
        return openBlock(), createBlock(resolveDynamicComponent(is), { key: item.index });
      }), 128))], 4);
    };
  }
});
var ListboxVirtualizer_default = ListboxVirtualizer_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxRoot.js
var [injectComboboxRootContext, provideComboboxRootContext] = createContext("ComboboxRoot");
var ComboboxRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxRoot",
  props: {
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    defaultOpen: {
      type: Boolean,
      required: false
    },
    resetSearchTermOnBlur: {
      type: Boolean,
      required: false,
      default: true
    },
    resetSearchTermOnSelect: {
      type: Boolean,
      required: false,
      default: true
    },
    openOnFocus: {
      type: Boolean,
      required: false,
      default: false
    },
    openOnClick: {
      type: Boolean,
      required: false,
      default: false
    },
    ignoreFilter: {
      type: Boolean,
      required: false
    },
    resetModelValueOnClear: {
      type: Boolean,
      required: false,
      default: false
    },
    modelValue: {
      type: null,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    },
    multiple: {
      type: Boolean,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    highlightOnHover: {
      type: Boolean,
      required: false,
      default: true
    },
    by: {
      type: [String, Function],
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "update:modelValue",
    "highlight",
    "update:open"
  ],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { primitiveElement, currentElement: parentElement } = usePrimitiveElement();
    const { multiple, disabled, ignoreFilter, resetSearchTermOnSelect, openOnFocus, openOnClick, dir: propDir, resetModelValueOnClear, highlightOnHover } = toRefs(props2);
    const dir = useDirection(propDir);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? (multiple.value ? [] : void 0),
      passive: props2.modelValue === void 0,
      deep: true
    });
    const open = useVModel(props2, "open", emits, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    async function onOpenChange(val) {
      open.value = val;
      filterSearch.value = "";
      if (val) {
        await nextTick();
        primitiveElement.value?.highlightSelected();
        isUserInputted.value = true;
        inputElement.value?.focus();
      } else {
        isUserInputted.value = false;
        setTimeout(() => {
          if (!val && props2.resetSearchTermOnBlur) resetSearchTerm.trigger();
        }, 1);
      }
    }
    const resetSearchTerm = createEventHook();
    const isUserInputted = ref(false);
    const isVirtual = ref(false);
    const inputElement = ref();
    const triggerElement = ref();
    const highlightedElement = computed(() => primitiveElement.value?.highlightedElement ?? void 0);
    const allItems = ref(/* @__PURE__ */ new Map());
    const allGroups = ref(/* @__PURE__ */ new Map());
    const { contains } = useFilter({ sensitivity: "base" });
    const filterSearch = ref("");
    const filterState = computed((oldValue) => {
      if (!filterSearch.value || props2.ignoreFilter || isVirtual.value) return {
        count: allItems.value.size,
        items: oldValue?.items ?? /* @__PURE__ */ new Map(),
        groups: oldValue?.groups ?? new Set(allGroups.value.keys())
      };
      let itemCount = 0;
      const filteredItems = /* @__PURE__ */ new Map();
      const filteredGroups = /* @__PURE__ */ new Set();
      for (const [id, value] of allItems.value) {
        const score = contains(value, filterSearch.value);
        filteredItems.set(id, score ? 1 : 0);
        if (score) itemCount++;
      }
      for (const [groupId, group] of allGroups.value) for (const itemId of group) if (filteredItems.get(itemId) > 0) {
        filteredGroups.add(groupId);
        break;
      }
      return {
        count: itemCount,
        items: filteredItems,
        groups: filteredGroups
      };
    });
    const inst = getCurrentInstance();
    onMounted(() => {
      if (inst?.exposed) {
        inst.exposed.highlightItem = primitiveElement.value?.highlightItem;
        inst.exposed.highlightFirstItem = primitiveElement.value?.highlightFirstItem;
        inst.exposed.highlightSelected = primitiveElement.value?.highlightSelected;
      }
    });
    __expose({
      filtered: filterState,
      highlightedElement,
      highlightItem: primitiveElement.value?.highlightItem,
      highlightFirstItem: primitiveElement.value?.highlightFirstItem,
      highlightSelected: primitiveElement.value?.highlightSelected
    });
    provideComboboxRootContext({
      modelValue,
      multiple,
      disabled,
      open,
      onOpenChange,
      contentId: "",
      isUserInputted,
      isVirtual,
      inputElement,
      highlightedElement,
      onInputElementChange: (val) => inputElement.value = val,
      triggerElement,
      onTriggerElementChange: (val) => triggerElement.value = val,
      parentElement,
      resetSearchTermOnSelect,
      onResetSearchTerm: resetSearchTerm.on,
      allItems,
      allGroups,
      filterSearch,
      filterState,
      ignoreFilter,
      openOnFocus,
      openOnClick,
      resetModelValueOnClear
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [createVNode(unref(ListboxRoot_default), mergeProps({
          ref_key: "primitiveElement",
          ref: primitiveElement
        }, _ctx.$attrs, {
          modelValue: unref(modelValue),
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => isRef(modelValue) ? modelValue.value = $event : null),
          style: { pointerEvents: unref(open) ? "auto" : void 0 },
          as: _ctx.as,
          "as-child": _ctx.asChild,
          dir: unref(dir),
          multiple: unref(multiple),
          name: _ctx.name,
          required: _ctx.required,
          disabled: unref(disabled),
          "highlight-on-hover": unref(highlightOnHover),
          by: props2.by,
          onHighlight: _cache[1] || (_cache[1] = ($event) => emits("highlight", $event))
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
            open: unref(open),
            modelValue: unref(modelValue)
          })]),
          _: 3
        }, 16, [
          "modelValue",
          "style",
          "as",
          "as-child",
          "dir",
          "multiple",
          "name",
          "required",
          "disabled",
          "highlight-on-hover",
          "by"
        ])]),
        _: 3
      });
    };
  }
});
var ComboboxRoot_default = ComboboxRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxContentImpl.js
var [injectComboboxContentContext, provideComboboxContentContext] = createContext("ComboboxContent");
var ComboboxContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxContentImpl",
  props: {
    position: {
      type: String,
      required: false,
      default: "inline"
    },
    bodyLock: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { position } = toRefs(props2);
    const rootContext = injectComboboxRootContext();
    const { forwardRef, currentElement } = useForwardExpose();
    useBodyScrollLock(props2.bodyLock);
    useHideOthers(rootContext.parentElement);
    const pickedProps = computed(() => {
      if (props2.position === "popper") return props2;
      else return {};
    });
    const forwardedProps = useForwardProps(pickedProps.value);
    const popperStyle = {
      "boxSizing": "border-box",
      "--reka-combobox-content-transform-origin": "var(--reka-popper-transform-origin)",
      "--reka-combobox-content-available-width": "var(--reka-popper-available-width)",
      "--reka-combobox-content-available-height": "var(--reka-popper-available-height)",
      "--reka-combobox-trigger-width": "var(--reka-popper-anchor-width)",
      "--reka-combobox-trigger-height": "var(--reka-popper-anchor-height)"
    };
    provideComboboxContentContext({ position });
    const isInputWithinContent = ref(false);
    onMounted(() => {
      if (rootContext.inputElement.value) {
        isInputWithinContent.value = currentElement.value.contains(rootContext.inputElement.value);
        if (isInputWithinContent.value) rootContext.inputElement.value.focus();
      }
    });
    onUnmounted(() => {
      const activeElement = getActiveElement();
      if (isInputWithinContent.value && (!activeElement || activeElement === document.body)) rootContext.triggerElement.value?.focus();
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ListboxContent_default), { "as-child": "" }, {
        default: withCtx(() => [createVNode(unref(DismissableLayer_default), {
          "as-child": "",
          "disable-outside-pointer-events": _ctx.disableOutsidePointerEvents,
          onDismiss: _cache[0] || (_cache[0] = ($event) => unref(rootContext).onOpenChange(false)),
          onFocusOutside: _cache[1] || (_cache[1] = (ev) => {
            if (unref(rootContext).parentElement.value?.contains(ev.target)) ev.preventDefault();
            emits("focusOutside", ev);
          }),
          onInteractOutside: _cache[2] || (_cache[2] = ($event) => emits("interactOutside", $event)),
          onEscapeKeyDown: _cache[3] || (_cache[3] = ($event) => emits("escapeKeyDown", $event)),
          onPointerDownOutside: _cache[4] || (_cache[4] = (ev) => {
            if (unref(rootContext).parentElement.value?.contains(ev.target)) ev.preventDefault();
            emits("pointerDownOutside", ev);
          })
        }, {
          default: withCtx(() => [(openBlock(), createBlock(resolveDynamicComponent(unref(position) === "popper" ? unref(PopperContent_default) : unref(Primitive)), mergeProps({
            ..._ctx.$attrs,
            ...unref(forwardedProps)
          }, {
            id: unref(rootContext).contentId,
            ref: unref(forwardRef),
            "data-state": unref(rootContext).open.value ? "open" : "closed",
            style: {
              display: "flex",
              flexDirection: "column",
              outline: "none",
              ...unref(position) === "popper" ? popperStyle : {}
            }
          }), {
            default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
            _: 3
          }, 16, [
            "id",
            "data-state",
            "style"
          ]))]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])]),
        _: 3
      });
    };
  }
});
var ComboboxContentImpl_default = ComboboxContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxArrow.js
var ComboboxArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectComboboxRootContext();
    const contentContext = injectComboboxContentContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return unref(rootContext).open.value && unref(contentContext).position.value === "popper" ? (openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(mergeProps({ key: 0 }, props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var ComboboxArrow_default = ComboboxArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxCancel.js
var ComboboxCancel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxCancel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectComboboxRootContext();
    function handleClick() {
      rootContext.filterSearch.value = "";
      if (rootContext.inputElement.value) {
        rootContext.inputElement.value.value = "";
        rootContext.inputElement.value.focus();
      }
      if (rootContext.resetModelValueOnClear?.value) rootContext.modelValue.value = rootContext.multiple.value ? [] : null;
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ type: _ctx.as === "button" ? "button" : void 0 }, props2, {
        tabindex: "-1",
        onClick: handleClick
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["type"]);
    };
  }
});
var ComboboxCancel_default = ComboboxCancel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxContent.js
var ComboboxContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    position: {
      type: String,
      required: false
    },
    bodyLock: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const { forwardRef } = useForwardExpose();
    const rootContext = injectComboboxRootContext();
    rootContext.contentId ||= useId2(void 0, "reka-combobox-content");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(rootContext).open.value }, {
        default: withCtx(() => [createVNode(ComboboxContentImpl_default, mergeProps({
          ...unref(forwarded),
          ..._ctx.$attrs
        }, { ref: unref(forwardRef) }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var ComboboxContent_default = ComboboxContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxEmpty.js
var ComboboxEmpty_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxEmpty",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectComboboxRootContext();
    const isRender = computed(() => rootContext.ignoreFilter.value ? rootContext.allItems.value.size === 0 : rootContext.filterState.value.count === 0);
    return (_ctx, _cache) => {
      return isRender.value ? (openBlock(), createBlock(unref(Primitive), normalizeProps(mergeProps({ key: 0 }, props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("No options"))])]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var ComboboxEmpty_default = ComboboxEmpty_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxGroup.js
var [injectComboboxGroupContext, provideComboboxGroupContext] = createContext("ComboboxGroup");
var ComboboxGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const id = useId2(void 0, "reka-combobox-group");
    const rootContext = injectComboboxRootContext();
    const isRender = computed(() => rootContext.ignoreFilter.value ? true : !rootContext.filterSearch.value ? true : rootContext.filterState.value.groups.has(id));
    const context2 = provideComboboxGroupContext({
      id,
      labelId: ""
    });
    onMounted(() => {
      if (!rootContext.allGroups.value.has(id)) rootContext.allGroups.value.set(id, /* @__PURE__ */ new Set());
    });
    onUnmounted(() => {
      rootContext.allGroups.value.delete(id);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ListboxGroup_default), mergeProps({
        id: unref(id),
        "aria-labelledby": unref(context2).labelId
      }, props2, { hidden: isRender.value ? void 0 : true }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "id",
        "aria-labelledby",
        "hidden"
      ]);
    };
  }
});
var ComboboxGroup_default = ComboboxGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxInput.js
var ComboboxInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxInput",
  props: {
    displayValue: {
      type: Function,
      required: false
    },
    modelValue: {
      type: String,
      required: false
    },
    autoFocus: {
      type: Boolean,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "input"
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectComboboxRootContext();
    const listboxContext = injectListboxRootContext();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const modelValue = useVModel(props2, "modelValue", emits, { passive: props2.modelValue === void 0 });
    onMounted(() => {
      if (currentElement.value) rootContext.onInputElementChange(currentElement.value);
    });
    function handleKeyDown(ev) {
      if (!rootContext.open.value) rootContext.onOpenChange(true);
    }
    function handleInput(event) {
      const target = event.target;
      if (!rootContext.open.value) {
        rootContext.onOpenChange(true);
        nextTick(() => {
          if (target.value) {
            rootContext.filterSearch.value = target.value;
            listboxContext.highlightFirstItem();
          }
        });
      } else rootContext.filterSearch.value = target.value;
    }
    function handleFocus() {
      if (rootContext.openOnFocus.value && !rootContext.open.value) rootContext.onOpenChange(true);
    }
    function handleClick() {
      if (rootContext.openOnClick.value && !rootContext.open.value) rootContext.onOpenChange(true);
    }
    function resetSearchTerm() {
      const rootModelValue = rootContext.modelValue.value;
      if (props2.displayValue) modelValue.value = props2.displayValue(rootModelValue);
      else if (!rootContext.multiple.value && rootModelValue && !Array.isArray(rootModelValue)) if (typeof rootModelValue !== "object") modelValue.value = rootModelValue.toString();
      else modelValue.value = "";
      else modelValue.value = "";
      nextTick(() => {
        modelValue.value = modelValue.value;
      });
    }
    rootContext.onResetSearchTerm(() => {
      resetSearchTerm();
    });
    watch(rootContext.modelValue, async () => {
      if (!rootContext.isUserInputted.value && rootContext.resetSearchTermOnSelect.value) resetSearchTerm();
    }, {
      immediate: true,
      deep: true
    });
    watch(rootContext.filterState, (_newValue, oldValue) => {
      if (!rootContext.isVirtual.value && oldValue.count === 0) listboxContext.highlightFirstItem();
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ListboxFilter_default), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        modelValue: unref(modelValue),
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => isRef(modelValue) ? modelValue.value = $event : null),
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "auto-focus": _ctx.autoFocus,
        disabled: _ctx.disabled,
        "aria-expanded": unref(rootContext).open.value,
        "aria-controls": unref(rootContext).contentId,
        "aria-autocomplete": "list",
        role: "combobox",
        autocomplete: "off",
        onClick: handleClick,
        onInput: handleInput,
        onKeydown: withKeys(withModifiers(handleKeyDown, ["prevent"]), ["down", "up"]),
        onFocus: handleFocus
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "modelValue",
        "as",
        "as-child",
        "auto-focus",
        "disabled",
        "aria-expanded",
        "aria-controls",
        "onKeydown"
      ]);
    };
  }
});
var ComboboxInput_default = ComboboxInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxItem.js
var ComboboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxItem",
  props: {
    textValue: {
      type: String,
      required: false
    },
    value: {
      type: null,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const id = useId2(void 0, "reka-combobox-item");
    const rootContext = injectComboboxRootContext();
    const groupContext = injectComboboxGroupContext(null);
    const { primitiveElement, currentElement } = usePrimitiveElement();
    if (props2.value === "") throw new Error("A <ComboboxItem /> must have a value prop that is not an empty string. This is because the Combobox value can be set to an empty string to clear the selection and show the placeholder.");
    const isRender = computed(() => {
      if (rootContext.isVirtual.value || rootContext.ignoreFilter.value || !rootContext.filterSearch.value) return true;
      else {
        const filteredCurrentItem = rootContext.filterState.value.items.get(id);
        if (filteredCurrentItem === void 0) return true;
        return filteredCurrentItem > 0;
      }
    });
    onMounted(() => {
      rootContext.allItems.value.set(id, props2.textValue || currentElement.value.textContent || currentElement.value.innerText);
      const groupId = groupContext?.id;
      if (groupId) if (!rootContext.allGroups.value.has(groupId)) rootContext.allGroups.value.set(groupId, /* @__PURE__ */ new Set([id]));
      else rootContext.allGroups.value.get(groupId)?.add(id);
    });
    onUnmounted(() => {
      rootContext.allItems.value.delete(id);
    });
    return (_ctx, _cache) => {
      return isRender.value ? (openBlock(), createBlock(unref(ListboxItem_default), mergeProps({ key: 0 }, props2, {
        id: unref(id),
        ref_key: "primitiveElement",
        ref: primitiveElement,
        disabled: unref(rootContext).disabled.value || _ctx.disabled,
        onSelect: _cache[0] || (_cache[0] = (event) => {
          emits("select", event);
          if (event.defaultPrevented) return;
          if (!unref(rootContext).multiple.value && !_ctx.disabled && !unref(rootContext).disabled.value) {
            event.preventDefault();
            unref(rootContext).onOpenChange(false);
            unref(rootContext).modelValue.value = props2.value;
          }
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [createTextVNode(toDisplayString(_ctx.value), 1)])]),
        _: 3
      }, 16, ["id", "disabled"])) : createCommentVNode("v-if", true);
    };
  }
});
var ComboboxItem_default = ComboboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxItemIndicator.js
var ComboboxItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxItemIndicator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ListboxItemIndicator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ComboboxItemIndicator_default = ComboboxItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxLabel.js
var ComboboxLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxLabel",
  props: {
    for: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const groupContext = injectComboboxGroupContext({
      id: "",
      labelId: ""
    });
    groupContext.labelId ||= useId2(void 0, "reka-combobox-group-label");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { id: unref(groupContext).labelId }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var ComboboxLabel_default = ComboboxLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxPortal.js
var ComboboxPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ComboboxPortal_default = ComboboxPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxSeparator.js
var ComboboxSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "aria-hidden": "true" }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ComboboxSeparator_default = ComboboxSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxTrigger.js
var ComboboxTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectComboboxRootContext();
    const disabled = computed(() => props2.disabled || rootContext.disabled.value || false);
    onMounted(() => {
      if (currentElement.value) rootContext.onTriggerElementChange(currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        ref: unref(forwardRef),
        type: _ctx.as === "button" ? "button" : void 0,
        tabindex: "-1",
        "aria-label": "Show popup",
        "aria-haspopup": "listbox",
        "aria-expanded": unref(rootContext).open.value,
        "aria-controls": unref(rootContext).contentId,
        "data-state": unref(rootContext).open.value ? "open" : "closed",
        disabled: disabled.value,
        "data-disabled": disabled.value ? "" : void 0,
        "aria-disabled": disabled.value ?? void 0,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).onOpenChange(!unref(rootContext).open.value))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "type",
        "aria-expanded",
        "aria-controls",
        "data-state",
        "disabled",
        "data-disabled",
        "aria-disabled"
      ]);
    };
  }
});
var ComboboxTrigger_default = ComboboxTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/shared/useNonce.js
function useNonce(nonce) {
  const context2 = injectConfigProviderContext({ nonce: ref() });
  return computed(() => nonce?.value || context2.nonce?.value);
}

// node_modules/reka-ui/dist/Combobox/ComboboxViewport.js
var ComboboxViewport_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxViewport",
  props: {
    nonce: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef } = useForwardExpose();
    const { nonce: propNonce } = toRefs(props2);
    const nonce = useNonce(propNonce);
    const rootContext = injectComboboxRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createVNode(unref(Primitive), mergeProps({
        ..._ctx.$attrs,
        ...props2
      }, {
        ref: unref(forwardRef),
        "data-reka-combobox-viewport": "",
        role: "presentation",
        style: {
          position: "relative",
          flex: unref(rootContext).isVirtual.value ? void 0 : 1,
          overflow: "auto"
        }
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["style"]), createVNode(unref(Primitive), {
        as: "style",
        nonce: unref(nonce)
      }, {
        default: withCtx(() => _cache[0] || (_cache[0] = [createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-reka-combobox-viewport] { scrollbar-width:none; -ms-overflow-style: none; -webkit-overflow-scrolling: touch; } [data-reka-combobox-viewport]::-webkit-scrollbar { display: none; } ")])),
        _: 1,
        __: [0]
      }, 8, ["nonce"])], 64);
    };
  }
});
var ComboboxViewport_default = ComboboxViewport_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Combobox/ComboboxVirtualizer.js
var ComboboxVirtualizer_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ComboboxVirtualizer",
  props: {
    options: {
      type: Array,
      required: true
    },
    overscan: {
      type: Number,
      required: false
    },
    estimateSize: {
      type: [Number, Function],
      required: false
    },
    textContent: {
      type: Function,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectComboboxRootContext();
    rootContext.isVirtual.value = true;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(ListboxVirtualizer_default, normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var ComboboxVirtualizer_default = ComboboxVirtualizer_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuAnchor.js
var MenuAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperAnchor_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuAnchor_default = MenuAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuArrow.js
var MenuArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuArrow",
  props: {
    width: {
      type: Number,
      required: false
    },
    height: {
      type: Number,
      required: false
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuArrow_default = MenuArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/shared/useIsUsingKeyboard.js
function useIsUsingKeyboardImpl() {
  const isUsingKeyboard = ref(false);
  onMounted(() => {
    useEventListener("keydown", () => {
      isUsingKeyboard.value = true;
    }, {
      capture: true,
      passive: true
    });
    useEventListener(["pointerdown", "pointermove"], () => {
      isUsingKeyboard.value = false;
    }, {
      capture: true,
      passive: true
    });
  });
  return isUsingKeyboard;
}
var useIsUsingKeyboard = createSharedComposable(useIsUsingKeyboardImpl);

// node_modules/reka-ui/dist/Menu/MenuRoot.js
var [injectMenuContext, provideMenuContext] = createContext(["MenuRoot", "MenuSub"], "MenuContext");
var [injectMenuRootContext, provideMenuRootContext] = createContext("MenuRoot");
var MenuRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuRoot",
  props: {
    open: {
      type: Boolean,
      required: false,
      default: false
    },
    dir: {
      type: String,
      required: false
    },
    modal: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { modal, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    const open = useVModel(props2, "open", emits);
    const content = ref();
    const isUsingKeyboardRef = useIsUsingKeyboard();
    provideMenuContext({
      open,
      onOpenChange: (value) => {
        open.value = value;
      },
      content,
      onContentChange: (element) => {
        content.value = element;
      }
    });
    provideMenuRootContext({
      onClose: () => {
        open.value = false;
      },
      isUsingKeyboardRef,
      dir,
      modal
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      });
    };
  }
});
var MenuRoot_default = MenuRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuContentImpl.js
var [injectMenuContentContext, provideMenuContentContext] = createContext("MenuContent");
var MenuContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuContentImpl",
  props: mergeDefaults({
    loop: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    disableOutsideScroll: {
      type: Boolean,
      required: false
    },
    trapFocus: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  }, { ...PopperContentPropsDefaultValue }),
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus",
    "dismiss"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const menuContext = injectMenuContext();
    const rootContext = injectMenuRootContext();
    const { trapFocus, disableOutsidePointerEvents, loop } = toRefs(props2);
    useFocusGuards();
    useBodyScrollLock(disableOutsidePointerEvents.value);
    const searchRef = ref("");
    const timerRef = ref(0);
    const pointerGraceTimerRef = ref(0);
    const pointerGraceIntentRef = ref(null);
    const pointerDirRef = ref("right");
    const lastPointerXRef = ref(0);
    const currentItemId = ref(null);
    const rovingFocusGroupRef = ref();
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    const { handleTypeaheadSearch } = useTypeahead();
    watch(contentElement, (el) => {
      menuContext.onContentChange(el);
    });
    onUnmounted(() => {
      window.clearTimeout(timerRef.value);
    });
    function isPointerMovingToSubmenu(event) {
      const isMovingTowards = pointerDirRef.value === pointerGraceIntentRef.value?.side;
      return isMovingTowards && isPointerInGraceArea(event, pointerGraceIntentRef.value?.area);
    }
    async function handleMountAutoFocus(event) {
      emits("openAutoFocus", event);
      if (event.defaultPrevented) return;
      event.preventDefault();
      contentElement.value?.focus({ preventScroll: true });
    }
    function handleKeyDown(event) {
      if (event.defaultPrevented) return;
      const target = event.target;
      const isKeyDownInside = target.closest("[data-reka-menu-content]") === event.currentTarget;
      const isModifierKey = event.ctrlKey || event.altKey || event.metaKey;
      const isCharacterKey = event.key.length === 1;
      const el = useArrowNavigation(event, getActiveElement(), contentElement.value, {
        loop: loop.value,
        arrowKeyOptions: "vertical",
        dir: rootContext?.dir.value,
        focus: true,
        attributeName: "[data-reka-collection-item]:not([data-disabled])"
      });
      if (el) return el?.focus();
      if (event.code === "Space") return;
      const collectionItems = rovingFocusGroupRef.value?.getItems() ?? [];
      if (isKeyDownInside) {
        if (event.key === "Tab") event.preventDefault();
        if (!isModifierKey && isCharacterKey) handleTypeaheadSearch(event.key, collectionItems);
      }
      if (event.target !== contentElement.value) return;
      if (!FIRST_LAST_KEYS.includes(event.key)) return;
      event.preventDefault();
      const candidateNodes = [...collectionItems.map((item) => item.ref)];
      if (LAST_KEYS.includes(event.key)) candidateNodes.reverse();
      focusFirst2(candidateNodes);
    }
    function handleBlur(event) {
      if (!event?.currentTarget?.contains?.(event.target)) {
        window.clearTimeout(timerRef.value);
        searchRef.value = "";
      }
    }
    function handlePointerMove2(event) {
      if (!isMouseEvent(event)) return;
      const target = event.target;
      const pointerXHasChanged = lastPointerXRef.value !== event.clientX;
      if (event?.currentTarget?.contains(target) && pointerXHasChanged) {
        const newDir = event.clientX > lastPointerXRef.value ? "right" : "left";
        pointerDirRef.value = newDir;
        lastPointerXRef.value = event.clientX;
      }
    }
    provideMenuContentContext({
      onItemEnter: (event) => {
        if (isPointerMovingToSubmenu(event)) return true;
        else return false;
      },
      onItemLeave: (event) => {
        if (isPointerMovingToSubmenu(event)) return;
        contentElement.value?.focus();
        currentItemId.value = null;
      },
      onTriggerLeave: (event) => {
        if (isPointerMovingToSubmenu(event)) return true;
        else return false;
      },
      searchRef,
      pointerGraceTimerRef,
      onPointerGraceIntentChange: (intent) => {
        pointerGraceIntentRef.value = intent;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(FocusScope_default), {
        "as-child": "",
        trapped: unref(trapFocus),
        onMountAutoFocus: handleMountAutoFocus,
        onUnmountAutoFocus: _cache[7] || (_cache[7] = ($event) => emits("closeAutoFocus", $event))
      }, {
        default: withCtx(() => [createVNode(unref(DismissableLayer_default), {
          "as-child": "",
          "disable-outside-pointer-events": unref(disableOutsidePointerEvents),
          onEscapeKeyDown: _cache[2] || (_cache[2] = ($event) => emits("escapeKeyDown", $event)),
          onPointerDownOutside: _cache[3] || (_cache[3] = ($event) => emits("pointerDownOutside", $event)),
          onFocusOutside: _cache[4] || (_cache[4] = ($event) => emits("focusOutside", $event)),
          onInteractOutside: _cache[5] || (_cache[5] = ($event) => emits("interactOutside", $event)),
          onDismiss: _cache[6] || (_cache[6] = ($event) => emits("dismiss"))
        }, {
          default: withCtx(() => [createVNode(unref(RovingFocusGroup_default), {
            ref_key: "rovingFocusGroupRef",
            ref: rovingFocusGroupRef,
            "current-tab-stop-id": currentItemId.value,
            "onUpdate:currentTabStopId": _cache[0] || (_cache[0] = ($event) => currentItemId.value = $event),
            "as-child": "",
            orientation: "vertical",
            dir: unref(rootContext).dir.value,
            loop: unref(loop),
            onEntryFocus: _cache[1] || (_cache[1] = (event) => {
              emits("entryFocus", event);
              if (!unref(rootContext).isUsingKeyboardRef.value) event.preventDefault();
            })
          }, {
            default: withCtx(() => [createVNode(unref(PopperContent_default), {
              ref: unref(forwardRef),
              role: "menu",
              as: _ctx.as,
              "as-child": _ctx.asChild,
              "aria-orientation": "vertical",
              "data-reka-menu-content": "",
              "data-state": unref(getOpenState)(unref(menuContext).open.value),
              dir: unref(rootContext).dir.value,
              side: _ctx.side,
              "side-offset": _ctx.sideOffset,
              align: _ctx.align,
              "align-offset": _ctx.alignOffset,
              "avoid-collisions": _ctx.avoidCollisions,
              "collision-boundary": _ctx.collisionBoundary,
              "collision-padding": _ctx.collisionPadding,
              "arrow-padding": _ctx.arrowPadding,
              "prioritize-position": _ctx.prioritizePosition,
              "position-strategy": _ctx.positionStrategy,
              "update-position-strategy": _ctx.updatePositionStrategy,
              sticky: _ctx.sticky,
              "hide-when-detached": _ctx.hideWhenDetached,
              reference: _ctx.reference,
              onKeydown: handleKeyDown,
              onBlur: handleBlur,
              onPointermove: handlePointerMove2
            }, {
              default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
              _: 3
            }, 8, [
              "as",
              "as-child",
              "data-state",
              "dir",
              "side",
              "side-offset",
              "align",
              "align-offset",
              "avoid-collisions",
              "collision-boundary",
              "collision-padding",
              "arrow-padding",
              "prioritize-position",
              "position-strategy",
              "update-position-strategy",
              "sticky",
              "hide-when-detached",
              "reference"
            ])]),
            _: 3
          }, 8, [
            "current-tab-stop-id",
            "dir",
            "loop"
          ])]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])]),
        _: 3
      }, 8, ["trapped"]);
    };
  }
});
var MenuContentImpl_default = MenuContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuItemImpl.js
var MenuItemImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "MenuItemImpl",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const contentContext = injectMenuContentContext();
    const { forwardRef } = useForwardExpose();
    const { CollectionItem } = useCollection();
    const isFocused = ref(false);
    async function handlePointerMove2(event) {
      if (event.defaultPrevented) return;
      if (!isMouseEvent(event)) return;
      if (props2.disabled) contentContext.onItemLeave(event);
      else {
        const defaultPrevented = contentContext.onItemEnter(event);
        if (!defaultPrevented) {
          const item = event.currentTarget;
          item?.focus({ preventScroll: true });
        }
      }
    }
    async function handlePointerLeave(event) {
      await nextTick();
      if (event.defaultPrevented) return;
      if (!isMouseEvent(event)) return;
      contentContext.onItemLeave(event);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), { value: { textValue: _ctx.textValue } }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          ref: unref(forwardRef),
          role: "menuitem",
          tabindex: "-1"
        }, _ctx.$attrs, {
          as: _ctx.as,
          "as-child": _ctx.asChild,
          "aria-disabled": _ctx.disabled || void 0,
          "data-disabled": _ctx.disabled ? "" : void 0,
          "data-highlighted": isFocused.value ? "" : void 0,
          onPointermove: handlePointerMove2,
          onPointerleave: handlePointerLeave,
          onFocus: _cache[0] || (_cache[0] = async (event) => {
            await nextTick();
            if (event.defaultPrevented || _ctx.disabled) return;
            isFocused.value = true;
          }),
          onBlur: _cache[1] || (_cache[1] = async (event) => {
            await nextTick();
            if (event.defaultPrevented) return;
            isFocused.value = false;
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "as",
          "as-child",
          "aria-disabled",
          "data-disabled",
          "data-highlighted"
        ])]),
        _: 3
      }, 8, ["value"]);
    };
  }
});
var MenuItemImpl_default = MenuItemImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuItem.js
var MenuItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuItem",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectMenuRootContext();
    const contentContext = injectMenuContentContext();
    const isPointerDownRef = ref(false);
    async function handleSelect2() {
      const menuItem = currentElement.value;
      if (!props2.disabled && menuItem) {
        const itemSelectEvent = new CustomEvent(ITEM_SELECT, {
          bubbles: true,
          cancelable: true
        });
        emits("select", itemSelectEvent);
        await nextTick();
        if (itemSelectEvent.defaultPrevented) isPointerDownRef.value = false;
        else rootContext.onClose();
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuItemImpl_default, mergeProps(props2, {
        ref: unref(forwardRef),
        onClick: handleSelect2,
        onPointerdown: _cache[0] || (_cache[0] = () => {
          isPointerDownRef.value = true;
        }),
        onPointerup: _cache[1] || (_cache[1] = async (event) => {
          await nextTick();
          if (event.defaultPrevented) return;
          if (!isPointerDownRef.value) event.currentTarget?.click();
        }),
        onKeydown: _cache[2] || (_cache[2] = async (event) => {
          const isTypingAhead = unref(contentContext).searchRef.value !== "";
          if (_ctx.disabled || isTypingAhead && event.key === " ") return;
          if (unref(SELECTION_KEYS).includes(event.key)) {
            event.currentTarget.click();
            event.preventDefault();
          }
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuItem_default = MenuItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuItemIndicator.js
var [injectMenuItemIndicatorContext, provideMenuItemIndicatorContext] = createContext(["MenuCheckboxItem", "MenuRadioItem"], "MenuItemIndicatorContext");
var MenuItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuItemIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const indicatorContext = injectMenuItemIndicatorContext({ modelValue: ref(false) });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(isIndeterminate)(unref(indicatorContext).modelValue.value) || unref(indicatorContext).modelValue.value === true }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          as: _ctx.as,
          "as-child": _ctx.asChild,
          "data-state": unref(getCheckedState)(unref(indicatorContext).modelValue.value)
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "as",
          "as-child",
          "data-state"
        ])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var MenuItemIndicator_default = MenuItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuCheckboxItem.js
var MenuCheckboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuCheckboxItem",
  props: {
    modelValue: {
      type: [Boolean, String],
      required: false,
      default: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const delegatedProps = reactiveOmit(props2, ["modelValue"]);
    const forwarded = useForwardProps(delegatedProps);
    const modelValue = useVModel(props2, "modelValue", emits);
    provideMenuItemIndicatorContext({ modelValue });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuItem_default, mergeProps({ role: "menuitemcheckbox" }, unref(forwarded), {
        "aria-checked": unref(isIndeterminate)(unref(modelValue)) ? "mixed" : unref(modelValue),
        "data-state": unref(getCheckedState)(unref(modelValue)),
        onSelect: _cache[0] || (_cache[0] = async (event) => {
          emits("select", event);
          if (unref(isIndeterminate)(unref(modelValue))) modelValue.value = true;
          else modelValue.value = !unref(modelValue);
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
        _: 3
      }, 16, ["aria-checked", "data-state"]);
    };
  }
});
var MenuCheckboxItem_default = MenuCheckboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuRootContentModal.js
var MenuRootContentModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuRootContentModal",
  props: {
    loop: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const menuContext = injectMenuContext();
    const { forwardRef, currentElement } = useForwardExpose();
    useHideOthers(currentElement);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuContentImpl_default, mergeProps(unref(forwarded), {
        ref: unref(forwardRef),
        "trap-focus": unref(menuContext).open.value,
        "disable-outside-pointer-events": unref(menuContext).open.value,
        "disable-outside-scroll": true,
        onDismiss: _cache[0] || (_cache[0] = ($event) => unref(menuContext).onOpenChange(false)),
        onFocusOutside: _cache[1] || (_cache[1] = withModifiers(($event) => emits("focusOutside", $event), ["prevent"]))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["trap-focus", "disable-outside-pointer-events"]);
    };
  }
});
var MenuRootContentModal_default = MenuRootContentModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuRootContentNonModal.js
var MenuRootContentNonModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuRootContentNonModal",
  props: {
    loop: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const menuContext = injectMenuContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuContentImpl_default, mergeProps(unref(forwarded), {
        "trap-focus": false,
        "disable-outside-pointer-events": false,
        "disable-outside-scroll": false,
        onDismiss: _cache[0] || (_cache[0] = ($event) => unref(menuContext).onOpenChange(false))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuRootContentNonModal_default = MenuRootContentNonModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuContent.js
var MenuContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const menuContext = injectMenuContext();
    const rootContext = injectMenuRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(menuContext).open.value }, {
        default: withCtx(() => [unref(rootContext).modal.value ? (openBlock(), createBlock(MenuRootContentModal_default, normalizeProps(mergeProps({ key: 0 }, {
          ..._ctx.$attrs,
          ...unref(forwarded)
        })), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)) : (openBlock(), createBlock(MenuRootContentNonModal_default, normalizeProps(mergeProps({ key: 1 }, {
          ..._ctx.$attrs,
          ...unref(forwarded)
        })), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16))]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var MenuContent_default = MenuContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuGroup.js
var MenuGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ role: "group" }, props2), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuGroup_default = MenuGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuLabel.js
var MenuLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuLabel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuLabel_default = MenuLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuPortal.js
var MenuPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuPortal_default = MenuPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuRadioGroup.js
var [injectMenuRadioGroupContext, provideMenuRadioGroupContext] = createContext("MenuRadioGroup");
var MenuRadioGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuRadioGroup",
  props: {
    modelValue: {
      type: String,
      required: false,
      default: ""
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const delegatedProps = reactiveOmit(props2, ["modelValue"]);
    const forwarded = useForwardProps(delegatedProps);
    const modelValue = useVModel(props2, "modelValue", emits);
    provideMenuRadioGroupContext({
      modelValue,
      onValueChange: (payload) => {
        modelValue.value = payload;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuGroup_default, normalizeProps(guardReactiveProps(unref(forwarded))), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
        _: 3
      }, 16);
    };
  }
});
var MenuRadioGroup_default = MenuRadioGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuRadioItem.js
var MenuRadioItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuRadioItem",
  props: {
    value: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const delegatedProps = reactiveOmit(props2, ["value"]);
    const forwarded = useForwardProps(delegatedProps);
    const { value } = toRefs(props2);
    const radioGroupContext = injectMenuRadioGroupContext();
    const modelValue = computed(() => radioGroupContext.modelValue.value === value?.value);
    provideMenuItemIndicatorContext({ modelValue });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuItem_default, mergeProps({ role: "menuitemradio" }, unref(forwarded), {
        "aria-checked": modelValue.value,
        "data-state": unref(getCheckedState)(modelValue.value),
        onSelect: _cache[0] || (_cache[0] = async (event) => {
          emits("select", event);
          unref(radioGroupContext).onValueChange(unref(value));
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["aria-checked", "data-state"]);
    };
  }
});
var MenuRadioItem_default = MenuRadioItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuSeparator.js
var MenuSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        role: "separator",
        "aria-orientation": "horizontal"
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenuSeparator_default = MenuSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuSub.js
var [injectMenuSubContext, provideMenuSubContext] = createContext("MenuSub");
var MenuSub_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuSub",
  props: { open: {
    type: Boolean,
    required: false,
    default: void 0
  } },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const open = useVModel(props2, "open", emits, {
      defaultValue: false,
      passive: props2.open === void 0
    });
    const parentMenuContext = injectMenuContext();
    const trigger = ref();
    const content = ref();
    watchEffect((cleanupFn) => {
      if (parentMenuContext?.open.value === false) open.value = false;
      cleanupFn(() => open.value = false);
    });
    provideMenuContext({
      open,
      onOpenChange: (value) => {
        open.value = value;
      },
      content,
      onContentChange: (element) => {
        content.value = element;
      }
    });
    provideMenuSubContext({
      triggerId: "",
      contentId: "",
      trigger,
      onTriggerChange: (element) => {
        trigger.value = element;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      });
    };
  }
});
var MenuSub_default = MenuSub_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuSubContent.js
var MenuSubContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuSubContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false,
      default: true
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const menuContext = injectMenuContext();
    const rootContext = injectMenuRootContext();
    const menuSubContext = injectMenuSubContext();
    const { forwardRef, currentElement: subContentElement } = useForwardExpose();
    menuSubContext.contentId ||= useId2(void 0, "reka-menu-sub-content");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(menuContext).open.value }, {
        default: withCtx(() => [createVNode(MenuContentImpl_default, mergeProps(unref(forwarded), {
          id: unref(menuSubContext).contentId,
          ref: unref(forwardRef),
          "aria-labelledby": unref(menuSubContext).triggerId,
          align: "start",
          side: unref(rootContext).dir.value === "rtl" ? "left" : "right",
          "disable-outside-pointer-events": false,
          "disable-outside-scroll": false,
          "trap-focus": false,
          onOpenAutoFocus: _cache[0] || (_cache[0] = withModifiers((event) => {
            if (unref(rootContext).isUsingKeyboardRef.value) unref(subContentElement)?.focus();
          }, ["prevent"])),
          onCloseAutoFocus: _cache[1] || (_cache[1] = withModifiers(() => {
          }, ["prevent"])),
          onFocusOutside: _cache[2] || (_cache[2] = (event) => {
            if (event.defaultPrevented) return;
            if (event.target !== unref(menuSubContext).trigger.value) unref(menuContext).onOpenChange(false);
          }),
          onEscapeKeyDown: _cache[3] || (_cache[3] = (event) => {
            unref(rootContext).onClose();
            event.preventDefault();
          }),
          onKeydown: _cache[4] || (_cache[4] = (event) => {
            const isKeyDownInside = event.currentTarget?.contains(event.target);
            const isCloseKey = unref(SUB_CLOSE_KEYS)[unref(rootContext).dir.value].includes(event.key);
            if (isKeyDownInside && isCloseKey) {
              unref(menuContext).onOpenChange(false);
              unref(menuSubContext).trigger.value?.focus();
              event.preventDefault();
            }
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "id",
          "aria-labelledby",
          "side"
        ])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var MenuSubContent_default = MenuSubContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menu/MenuSubTrigger.js
var MenuSubTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenuSubTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const menuContext = injectMenuContext();
    const rootContext = injectMenuRootContext();
    const subContext = injectMenuSubContext();
    const contentContext = injectMenuContentContext();
    const openTimerRef = ref(null);
    subContext.triggerId ||= useId2(void 0, "reka-menu-sub-trigger");
    function clearOpenTimer() {
      if (openTimerRef.value) window.clearTimeout(openTimerRef.value);
      openTimerRef.value = null;
    }
    onUnmounted(() => {
      clearOpenTimer();
    });
    function handlePointerMove2(event) {
      if (!isMouseEvent(event)) return;
      const defaultPrevented = contentContext.onItemEnter(event);
      if (defaultPrevented) return;
      if (!props2.disabled && !menuContext.open.value && !openTimerRef.value) {
        contentContext.onPointerGraceIntentChange(null);
        openTimerRef.value = window.setTimeout(() => {
          menuContext.onOpenChange(true);
          clearOpenTimer();
        }, 100);
      }
    }
    async function handlePointerLeave(event) {
      if (!isMouseEvent(event)) return;
      clearOpenTimer();
      const contentRect = menuContext.content.value?.getBoundingClientRect();
      if (contentRect?.width) {
        const side = menuContext.content.value?.dataset.side;
        const rightSide = side === "right";
        const bleed = rightSide ? -5 : 5;
        const contentNearEdge = contentRect[rightSide ? "left" : "right"];
        const contentFarEdge = contentRect[rightSide ? "right" : "left"];
        contentContext.onPointerGraceIntentChange({
          area: [
            {
              x: event.clientX + bleed,
              y: event.clientY
            },
            {
              x: contentNearEdge,
              y: contentRect.top
            },
            {
              x: contentFarEdge,
              y: contentRect.top
            },
            {
              x: contentFarEdge,
              y: contentRect.bottom
            },
            {
              x: contentNearEdge,
              y: contentRect.bottom
            }
          ],
          side
        });
        window.clearTimeout(contentContext.pointerGraceTimerRef.value);
        contentContext.pointerGraceTimerRef.value = window.setTimeout(() => contentContext.onPointerGraceIntentChange(null), 300);
      } else {
        const defaultPrevented = contentContext.onTriggerLeave(event);
        if (defaultPrevented) return;
        contentContext.onPointerGraceIntentChange(null);
      }
    }
    async function handleKeyDown(event) {
      const isTypingAhead = contentContext.searchRef.value !== "";
      if (props2.disabled || isTypingAhead && event.key === " ") return;
      if (SUB_OPEN_KEYS[rootContext.dir.value].includes(event.key)) {
        menuContext.onOpenChange(true);
        await nextTick();
        menuContext.content.value?.focus();
        event.preventDefault();
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(MenuAnchor_default, { "as-child": "" }, {
        default: withCtx(() => [createVNode(MenuItemImpl_default, mergeProps(props2, {
          id: unref(subContext).triggerId,
          ref: (vnode) => {
            unref(subContext)?.onTriggerChange(vnode?.$el);
            return void 0;
          },
          "aria-haspopup": "menu",
          "aria-expanded": unref(menuContext).open.value,
          "aria-controls": unref(subContext).contentId,
          "data-state": unref(getOpenState)(unref(menuContext).open.value),
          onClick: _cache[0] || (_cache[0] = async (event) => {
            if (props2.disabled || event.defaultPrevented) return;
            event.currentTarget.focus();
            if (!unref(menuContext).open.value) unref(menuContext).onOpenChange(true);
          }),
          onPointermove: handlePointerMove2,
          onPointerleave: handlePointerLeave,
          onKeydown: handleKeyDown
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "id",
          "aria-expanded",
          "aria-controls",
          "data-state"
        ])]),
        _: 3
      });
    };
  }
});
var MenuSubTrigger_default = MenuSubTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuArrow.js
var ContextMenuArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuArrow_default = ContextMenuArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuCheckboxItem.js
var ContextMenuCheckboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuCheckboxItem",
  props: {
    modelValue: {
      type: [Boolean, String],
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuCheckboxItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuCheckboxItem_default = ContextMenuCheckboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuRoot.js
var [injectContextMenuRootContext, provideContextMenuRootContext] = createContext("ContextMenuRoot");
var ContextMenuRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ContextMenuRoot",
  props: {
    pressOpenDelay: {
      type: Number,
      required: false,
      default: 700
    },
    dir: {
      type: String,
      required: false
    },
    modal: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { dir: propDir, modal, pressOpenDelay } = toRefs(props2);
    useForwardExpose();
    const dir = useDirection(propDir);
    const open = ref(false);
    const triggerElement = ref();
    provideContextMenuRootContext({
      open,
      onOpenChange: (value) => {
        open.value = value;
      },
      dir,
      modal,
      triggerElement,
      pressOpenDelay
    });
    watch(open, (value) => {
      emits("update:open", value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRoot_default), {
        open: open.value,
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => open.value = $event),
        dir: unref(dir),
        modal: unref(modal)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "open",
        "dir",
        "modal"
      ]);
    };
  }
});
var ContextMenuRoot_default = ContextMenuRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuContent.js
var ContextMenuContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false,
      default: 0
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false,
      default: true
    },
    collisionBoundary: {
      type: null,
      required: false,
      default: () => []
    },
    collisionPadding: {
      type: [Number, Object],
      required: false,
      default: 0
    },
    sticky: {
      type: String,
      required: false,
      default: "partial"
    },
    hideWhenDetached: {
      type: Boolean,
      required: false,
      default: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    const rootContext = injectContextMenuRootContext();
    const hasInteractedOutside = ref(false);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuContent_default), mergeProps(unref(forwarded), {
        side: "right",
        "side-offset": 2,
        align: "start",
        "update-position-strategy": "always",
        style: {
          "--reka-context-menu-content-transform-origin": "var(--reka-popper-transform-origin)",
          "--reka-context-menu-content-available-width": "var(--reka-popper-available-width)",
          "--reka-context-menu-content-available-height": "var(--reka-popper-available-height)",
          "--reka-context-menu-trigger-width": "var(--reka-popper-anchor-width)",
          "--reka-context-menu-trigger-height": "var(--reka-popper-anchor-height)"
        },
        onCloseAutoFocus: _cache[0] || (_cache[0] = (event) => {
          if (!event.defaultPrevented && hasInteractedOutside.value) event.preventDefault();
          hasInteractedOutside.value = false;
        }),
        onInteractOutside: _cache[1] || (_cache[1] = (event) => {
          const originalEvent = event.detail.originalEvent;
          if (originalEvent.button === 2 && event.target === unref(rootContext).triggerElement.value) event.preventDefault();
          if (!event.defaultPrevented && !unref(rootContext).modal.value) hasInteractedOutside.value = true;
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuContent_default = ContextMenuContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuGroup.js
var ContextMenuGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuGroup_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuGroup_default = ContextMenuGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuItem.js
var ContextMenuItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuItem",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuItem_default = ContextMenuItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuItemIndicator.js
var ContextMenuItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuItemIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItemIndicator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuItemIndicator_default = ContextMenuItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuLabel.js
var ContextMenuLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuLabel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuLabel_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuLabel_default = ContextMenuLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuPortal.js
var ContextMenuPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuPortal_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuPortal_default = ContextMenuPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuRadioGroup.js
var ContextMenuRadioGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuRadioGroup",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioGroup_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuRadioGroup_default = ContextMenuRadioGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuRadioItem.js
var ContextMenuRadioItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuRadioItem",
  props: {
    value: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuRadioItem_default = ContextMenuRadioItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuSeparator.js
var ContextMenuSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSeparator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuSeparator_default = ContextMenuSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuSub.js
var ContextMenuSub_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuSub",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    useForwardExpose();
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSub_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      }, 8, ["open"]);
    };
  }
});
var ContextMenuSub_default = ContextMenuSub_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuSubContent.js
var ContextMenuSubContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuSubContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubContent_default), mergeProps(unref(forwarded), { style: {
        "--reka-context-menu-content-transform-origin": "var(--reka-popper-transform-origin)",
        "--reka-context-menu-content-available-width": "var(--reka-popper-available-width)",
        "--reka-context-menu-content-available-height": "var(--reka-popper-available-height)",
        "--reka-context-menu-trigger-width": "var(--reka-popper-anchor-width)",
        "--reka-context-menu-trigger-height": "var(--reka-popper-anchor-height)"
      } }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuSubContent_default = ContextMenuSubContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/ContextMenuSubTrigger.js
var ContextMenuSubTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ContextMenuSubTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubTrigger_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var ContextMenuSubTrigger_default = ContextMenuSubTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ContextMenu/utils.js
function isTouchOrPen(event) {
  return event.pointerType !== "mouse";
}

// node_modules/reka-ui/dist/ContextMenu/ContextMenuTrigger.js
var ContextMenuTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ContextMenuTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { disabled } = toRefs(props2);
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectContextMenuRootContext();
    const point = ref({
      x: 0,
      y: 0
    });
    const virtualEl = computed(() => ({ getBoundingClientRect: () => ({
      width: 0,
      height: 0,
      left: point.value.x,
      right: point.value.x,
      top: point.value.y,
      bottom: point.value.y,
      ...point.value
    }) }));
    const longPressTimer = ref(0);
    function clearLongPress() {
      window.clearTimeout(longPressTimer.value);
    }
    function handleOpen(event) {
      point.value = {
        x: event.clientX,
        y: event.clientY
      };
      rootContext.onOpenChange(true);
    }
    async function handleContextMenu(event) {
      if (!disabled.value) {
        await nextTick();
        if (!event.defaultPrevented) {
          clearLongPress();
          handleOpen(event);
          event.preventDefault();
        }
      }
    }
    async function handlePointerDown2(event) {
      if (!disabled.value) {
        await nextTick();
        if (isTouchOrPen(event) && !event.defaultPrevented) {
          clearLongPress();
          longPressTimer.value = window.setTimeout(() => handleOpen(event), rootContext.pressOpenDelay.value);
        }
      }
    }
    async function handlePointerEvent(event) {
      if (!disabled.value) {
        await nextTick();
        if (isTouchOrPen(event) && !event.defaultPrevented) clearLongPress();
      }
    }
    onMounted(() => {
      if (currentElement.value) rootContext.triggerElement.value = currentElement.value;
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createVNode(unref(MenuAnchor_default), {
        as: "template",
        reference: virtualEl.value
      }, null, 8, ["reference"]), createVNode(unref(Primitive), mergeProps({
        ref: unref(forwardRef),
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "data-state": unref(rootContext).open.value ? "open" : "closed",
        "data-disabled": unref(disabled) ? "" : void 0,
        style: {
          WebkitTouchCallout: "none",
          pointerEvents: "auto"
        }
      }, _ctx.$attrs, {
        onContextmenu: handleContextMenu,
        onPointerdown: handlePointerDown2,
        onPointermove: handlePointerEvent,
        onPointercancel: handlePointerEvent,
        onPointerup: handlePointerEvent
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "data-state",
        "data-disabled"
      ])], 64);
    };
  }
});
var ContextMenuTrigger_default = ContextMenuTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateField/DateFieldRoot.js
var [injectDateFieldRootContext, provideDateFieldRootContext] = createContext("DateFieldRoot");
var DateFieldRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "DateFieldRoot",
  props: {
    defaultValue: {
      type: null,
      required: false,
      default: void 0
    },
    defaultPlaceholder: {
      type: null,
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    modelValue: {
      type: null,
      required: false
    },
    hourCycle: {
      type: null,
      required: false
    },
    step: {
      type: Object,
      required: false
    },
    granularity: {
      type: String,
      required: false
    },
    hideTimeZone: {
      type: Boolean,
      required: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    id: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, readonly, isDateUnavailable: propsIsDateUnavailable, granularity, defaultValue, dir: propDir, locale: propLocale } = toRefs(props2);
    const locale = useLocale(propLocale);
    const dir = useDirection(propDir);
    const formatter = useDateFormatter(locale.value, { hourCycle: normalizeHourCycle(props2.hourCycle) });
    const { primitiveElement, currentElement: parentElement } = usePrimitiveElement();
    const segmentElements = ref(/* @__PURE__ */ new Set());
    onMounted(() => {
      getSegmentElements(parentElement.value).forEach((item) => segmentElements.value.add(item));
    });
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: defaultValue.value,
      passive: props2.modelValue === void 0
    });
    const defaultDate = getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      granularity: granularity.value,
      defaultValue: modelValue.value,
      locale: props2.locale
    });
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.copy(),
      passive: props2.placeholder === void 0
    });
    const step = computed(() => normalizeDateStep(props2));
    const inferredGranularity = computed(() => {
      if (props2.granularity) return !hasTime(placeholder.value) ? "day" : props2.granularity;
      return hasTime(placeholder.value) ? "minute" : "day";
    });
    const isInvalid = computed(() => {
      if (!modelValue.value) return false;
      if (propsIsDateUnavailable.value?.(modelValue.value)) return true;
      if (props2.minValue && isBefore(modelValue.value, props2.minValue)) return true;
      if (props2.maxValue && isBefore(props2.maxValue, modelValue.value)) return true;
      return false;
    });
    const initialSegments = initializeSegmentValues(inferredGranularity.value);
    const segmentValues = ref(modelValue.value ? { ...syncSegmentValues({
      value: modelValue.value,
      formatter
    }) } : { ...initialSegments });
    const allSegmentContent = computed(() => createContent({
      granularity: inferredGranularity.value,
      dateRef: placeholder.value,
      formatter,
      hideTimeZone: props2.hideTimeZone,
      hourCycle: props2.hourCycle,
      segmentValues: segmentValues.value,
      locale
    }));
    const segmentContents = computed(() => allSegmentContent.value.arr);
    const editableSegmentContents = computed(() => segmentContents.value.filter(({ part }) => part !== "literal"));
    watch(locale, (value) => {
      if (formatter.getLocale() !== value) {
        formatter.setLocale(value);
        nextTick(() => {
          segmentElements.value.clear();
          getSegmentElements(parentElement.value).forEach((item) => segmentElements.value.add(item));
        });
      }
    });
    watch(modelValue, (_modelValue) => {
      if (!isNullish(_modelValue) && placeholder.value.compare(_modelValue) !== 0) placeholder.value = _modelValue.copy();
    });
    watch([modelValue, locale], ([_modelValue]) => {
      if (!isNullish(_modelValue)) segmentValues.value = { ...syncSegmentValues({
        value: _modelValue,
        formatter
      }) };
      else if (Object.values(segmentValues.value).every((value) => value !== null) && isNullish(_modelValue)) segmentValues.value = { ...initialSegments };
    });
    const currentFocusedElement = ref(null);
    const currentSegmentIndex = computed(() => Array.from(segmentElements.value).findIndex((el) => el.getAttribute("data-reka-date-field-segment") === currentFocusedElement.value?.getAttribute("data-reka-date-field-segment")));
    const nextFocusableSegment = computed(() => {
      const sign = dir.value === "rtl" ? -1 : 1;
      const nextCondition = sign < 0 ? currentSegmentIndex.value < 0 : currentSegmentIndex.value > segmentElements.value.size - 1;
      if (nextCondition) return null;
      const segmentToFocus = Array.from(segmentElements.value)[currentSegmentIndex.value + sign];
      return segmentToFocus;
    });
    const prevFocusableSegment = computed(() => {
      const sign = dir.value === "rtl" ? -1 : 1;
      const prevCondition = sign > 0 ? currentSegmentIndex.value < 0 : currentSegmentIndex.value > segmentElements.value.size - 1;
      if (prevCondition) return null;
      const segmentToFocus = Array.from(segmentElements.value)[currentSegmentIndex.value - sign];
      return segmentToFocus;
    });
    const kbd = useKbd();
    function handleKeydown(e) {
      if (!isSegmentNavigationKey(e.key)) return;
      if (e.key === kbd.ARROW_LEFT) prevFocusableSegment.value?.focus();
      if (e.key === kbd.ARROW_RIGHT) nextFocusableSegment.value?.focus();
    }
    function setFocusedElement(el) {
      currentFocusedElement.value = el;
    }
    provideDateFieldRootContext({
      isDateUnavailable: propsIsDateUnavailable.value,
      locale,
      modelValue,
      placeholder,
      disabled,
      formatter,
      hourCycle: props2.hourCycle,
      step,
      readonly,
      segmentValues,
      isInvalid,
      segmentContents: editableSegmentContents,
      elements: segmentElements,
      setFocusedElement,
      focusNext() {
        nextFocusableSegment.value?.focus();
      }
    });
    __expose({ setFocusedElement });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        role: "group",
        "aria-disabled": unref(disabled) ? true : void 0,
        "data-disabled": unref(disabled) ? "" : void 0,
        "data-readonly": unref(readonly) ? "" : void 0,
        "data-invalid": isInvalid.value ? "" : void 0,
        dir: unref(dir),
        onKeydown: withKeys(handleKeydown, ["left", "right"])
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          segments: segmentContents.value,
          isInvalid: isInvalid.value
        }), createVNode(unref(VisuallyHidden_default), {
          id: _ctx.id,
          as: "input",
          type: "date",
          feature: "focusable",
          tabindex: "-1",
          value: unref(modelValue) ? unref(modelValue).toString() : "",
          name: _ctx.name,
          disabled: unref(disabled),
          required: _ctx.required,
          max: _ctx.maxValue,
          min: _ctx.minValue,
          onFocus: _cache[0] || (_cache[0] = ($event) => Array.from(segmentElements.value)?.[0]?.focus())
        }, null, 8, [
          "id",
          "value",
          "name",
          "disabled",
          "required",
          "max",
          "min"
        ])]),
        _: 3
      }, 16, [
        "aria-disabled",
        "data-disabled",
        "data-readonly",
        "data-invalid",
        "dir"
      ]);
    };
  }
});
var DateFieldRoot_default = DateFieldRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateField/DateFieldInput.js
var DateFieldInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateFieldInput",
  props: {
    part: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDateFieldRootContext();
    const hasLeftFocus = ref(true);
    const lastKeyZero = ref(false);
    const { handleSegmentClick, handleSegmentKeydown, attributes } = useDateField({
      hasLeftFocus,
      lastKeyZero,
      placeholder: rootContext.placeholder,
      hourCycle: rootContext.hourCycle,
      step: rootContext.step,
      segmentValues: rootContext.segmentValues,
      formatter: rootContext.formatter,
      part: props2.part,
      disabled: rootContext.disabled,
      readonly: rootContext.readonly,
      focusNext: rootContext.focusNext,
      modelValue: rootContext.modelValue
    });
    const disabled = computed(() => rootContext.disabled.value);
    const readonly = computed(() => rootContext.readonly.value);
    const isInvalid = computed(() => rootContext.isInvalid.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, unref(attributes), {
        contenteditable: disabled.value || readonly.value ? false : _ctx.part !== "literal",
        "data-reka-date-field-segment": _ctx.part,
        "aria-disabled": disabled.value ? true : void 0,
        "aria-readonly": readonly.value ? true : void 0,
        "data-disabled": disabled.value ? "" : void 0,
        "data-invalid": isInvalid.value ? "" : void 0,
        "aria-invalid": isInvalid.value ? true : void 0
      }, toHandlers(_ctx.part !== "literal" ? {
        mousedown: unref(handleSegmentClick),
        keydown: unref(handleSegmentKeydown),
        focusout: () => {
          hasLeftFocus.value = true;
        },
        focusin: (e) => {
          unref(rootContext).setFocusedElement(e.target);
        }
      } : {})), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "contenteditable",
        "data-reka-date-field-segment",
        "aria-disabled",
        "aria-readonly",
        "data-disabled",
        "data-invalid",
        "aria-invalid"
      ]);
    };
  }
});
var DateFieldInput_default = DateFieldInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverRoot.js
var [injectPopoverRootContext, providePopoverRootContext] = createContext("PopoverRoot");
var PopoverRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverRoot",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    modal: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const { modal } = toRefs(props2);
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const triggerElement = ref();
    const hasCustomAnchor = ref(false);
    providePopoverRootContext({
      contentId: "",
      triggerId: "",
      modal,
      open,
      onOpenChange: (value) => {
        open.value = value;
      },
      onOpenToggle: () => {
        open.value = !open.value;
      },
      triggerElement,
      hasCustomAnchor
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          open: unref(open),
          close: () => open.value = false
        })]),
        _: 3
      });
    };
  }
});
var PopoverRoot_default = PopoverRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverAnchor.js
var PopoverAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPopoverRootContext();
    onBeforeMount(() => {
      rootContext.hasCustomAnchor.value = true;
    });
    onUnmounted(() => {
      rootContext.hasCustomAnchor.value = false;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperAnchor_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var PopoverAnchor_default = PopoverAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerAnchor.js
var DatePickerAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverAnchor_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerAnchor_default = DatePickerAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverArrow.js
var PopoverArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var PopoverArrow_default = PopoverArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerArrow.js
var DatePickerArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerArrow",
  props: {
    width: {
      type: Number,
      required: false
    },
    height: {
      type: Number,
      required: false
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerArrow_default = DatePickerArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerRoot.js
var [injectDatePickerRootContext, provideDatePickerRootContext] = createContext("DatePickerRoot");
var DatePickerRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "DatePickerRoot",
  props: {
    defaultValue: {
      type: null,
      required: false,
      default: void 0
    },
    defaultPlaceholder: {
      type: null,
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    modelValue: {
      type: null,
      required: false
    },
    hourCycle: {
      type: null,
      required: false
    },
    step: {
      type: Object,
      required: false
    },
    granularity: {
      type: String,
      required: false
    },
    hideTimeZone: {
      type: Boolean,
      required: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false,
      default: "en"
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    id: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    },
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    modal: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateDisabled: {
      type: Function,
      required: false,
      default: void 0
    },
    pagedNavigation: {
      type: Boolean,
      required: false,
      default: false
    },
    weekStartsOn: {
      type: Number,
      required: false,
      default: 0
    },
    weekdayFormat: {
      type: String,
      required: false,
      default: "narrow"
    },
    fixedWeeks: {
      type: Boolean,
      required: false,
      default: false
    },
    numberOfMonths: {
      type: Number,
      required: false,
      default: 1
    },
    preventDeselect: {
      type: Boolean,
      required: false,
      default: false
    },
    closeOnSelect: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: [
    "update:modelValue",
    "update:placeholder",
    "update:open"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { locale, disabled, readonly, pagedNavigation, weekStartsOn, weekdayFormat, fixedWeeks, numberOfMonths, preventDeselect, isDateDisabled: propsIsDateDisabled, isDateUnavailable: propsIsDateUnavailable, defaultOpen, modal, id, name, required, minValue, maxValue, granularity, hideTimeZone, hourCycle, defaultValue, dir: propDir, step, closeOnSelect } = toRefs(props2);
    const dir = useDirection(propDir);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: defaultValue.value,
      passive: props2.modelValue === void 0
    });
    const defaultDate = computed(() => getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      granularity: props2.granularity,
      defaultValue: modelValue.value,
      locale: props2.locale
    }));
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.value.copy(),
      passive: props2.placeholder === void 0
    });
    const open = useVModel(props2, "open", emits, {
      defaultValue: defaultOpen.value,
      passive: props2.open === void 0
    });
    const dateFieldRef = ref();
    watch(modelValue, (value) => {
      if (value && value.compare(placeholder.value) !== 0) placeholder.value = value.copy();
      if (closeOnSelect.value) open.value = false;
    });
    provideDatePickerRootContext({
      isDateUnavailable: propsIsDateUnavailable.value,
      isDateDisabled: propsIsDateDisabled.value,
      locale,
      disabled,
      pagedNavigation,
      weekStartsOn,
      weekdayFormat,
      fixedWeeks,
      numberOfMonths,
      readonly,
      preventDeselect,
      modelValue,
      placeholder,
      defaultOpen,
      modal,
      open,
      id,
      name,
      required,
      minValue,
      maxValue,
      granularity,
      hideTimeZone,
      hourCycle,
      dateFieldRef,
      dir,
      step,
      onDateChange(date) {
        if (!date || !modelValue.value) modelValue.value = date?.copy() ?? void 0;
        else if (!preventDeselect.value && date && modelValue.value.compare(date) === 0) modelValue.value = void 0;
        else modelValue.value = date.copy();
      },
      onPlaceholderChange(date) {
        placeholder.value = date.copy();
      },
      closeOnSelect
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverRoot_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null),
        "default-open": unref(defaultOpen),
        modal: unref(modal)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "open",
        "default-open",
        "modal"
      ]);
    };
  }
});
var DatePickerRoot_default = DatePickerRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerCalendar.js
var DatePickerCalendar_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerCalendar",
  setup(__props) {
    const rootContext = injectDatePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarRoot_default), mergeProps({
        isDateDisabled: unref(rootContext).isDateDisabled,
        isDateUnavailable: unref(rootContext).isDateUnavailable,
        minValue: unref(rootContext).minValue.value,
        maxValue: unref(rootContext).maxValue.value,
        locale: unref(rootContext).locale.value,
        disabled: unref(rootContext).disabled.value,
        pagedNavigation: unref(rootContext).pagedNavigation.value,
        weekStartsOn: unref(rootContext).weekStartsOn.value,
        weekdayFormat: unref(rootContext).weekdayFormat.value,
        fixedWeeks: unref(rootContext).fixedWeeks.value,
        numberOfMonths: unref(rootContext).numberOfMonths.value,
        readonly: unref(rootContext).readonly.value,
        preventDeselect: unref(rootContext).preventDeselect.value,
        dir: unref(rootContext).dir.value
      }, {
        "model-value": unref(rootContext).modelValue.value,
        placeholder: unref(rootContext).placeholder.value,
        multiple: false,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = (date) => {
          if (date && unref(rootContext).modelValue.value && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date, unref(rootContext).modelValue.value)) return;
          unref(rootContext).onDateChange(date);
        }),
        "onUpdate:placeholder": _cache[1] || (_cache[1] = (date) => {
          if (unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date, unref(rootContext).placeholder.value)) return;
          unref(rootContext).onPlaceholderChange(date);
        })
      }), {
        default: withCtx(({ weekDays, grid, date, weekStartsOn, locale, fixedWeeks }) => [renderSlot(_ctx.$slots, "default", {
          date,
          grid,
          weekDays,
          weekStartsOn,
          locale,
          fixedWeeks
        })]),
        _: 3
      }, 16, ["model-value", "placeholder"]);
    };
  }
});
var DatePickerCalendar_default = DatePickerCalendar_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerCell.js
var DatePickerCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerCell",
  props: {
    date: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarCell_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerCell_default = DatePickerCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerCellTrigger.js
var DatePickerCellTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerCellTrigger",
  props: {
    day: {
      type: null,
      required: true
    },
    month: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarCellTrigger_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerCellTrigger_default = DatePickerCellTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverClose.js
var PopoverClose_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverClose",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPopoverRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        type: _ctx.as === "button" ? "button" : void 0,
        as: _ctx.as,
        "as-child": props2.asChild,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).onOpenChange(false))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "type",
        "as",
        "as-child"
      ]);
    };
  }
});
var PopoverClose_default = PopoverClose_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerClose.js
var DatePickerClose_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerClose",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverClose_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerClose_default = DatePickerClose_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverContentImpl.js
var PopoverContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverContentImpl",
  props: {
    trapFocus: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardProps(reactiveOmit(props2, "trapFocus", "disableOutsidePointerEvents"));
    const { forwardRef } = useForwardExpose();
    const rootContext = injectPopoverRootContext();
    useFocusGuards();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(FocusScope_default), {
        "as-child": "",
        loop: "",
        trapped: _ctx.trapFocus,
        onMountAutoFocus: _cache[5] || (_cache[5] = ($event) => emits("openAutoFocus", $event)),
        onUnmountAutoFocus: _cache[6] || (_cache[6] = ($event) => emits("closeAutoFocus", $event))
      }, {
        default: withCtx(() => [createVNode(unref(DismissableLayer_default), {
          "as-child": "",
          "disable-outside-pointer-events": _ctx.disableOutsidePointerEvents,
          onPointerDownOutside: _cache[0] || (_cache[0] = ($event) => emits("pointerDownOutside", $event)),
          onInteractOutside: _cache[1] || (_cache[1] = ($event) => emits("interactOutside", $event)),
          onEscapeKeyDown: _cache[2] || (_cache[2] = ($event) => emits("escapeKeyDown", $event)),
          onFocusOutside: _cache[3] || (_cache[3] = ($event) => emits("focusOutside", $event)),
          onDismiss: _cache[4] || (_cache[4] = ($event) => unref(rootContext).onOpenChange(false))
        }, {
          default: withCtx(() => [createVNode(unref(PopperContent_default), mergeProps(unref(forwarded), {
            id: unref(rootContext).contentId,
            ref: unref(forwardRef),
            "data-state": unref(rootContext).open.value ? "open" : "closed",
            "aria-labelledby": unref(rootContext).triggerId,
            style: {
              "--reka-popover-content-transform-origin": "var(--reka-popper-transform-origin)",
              "--reka-popover-content-available-width": "var(--reka-popper-available-width)",
              "--reka-popover-content-available-height": "var(--reka-popper-available-height)",
              "--reka-popover-trigger-width": "var(--reka-popper-anchor-width)",
              "--reka-popover-trigger-height": "var(--reka-popper-anchor-height)"
            },
            role: "dialog"
          }), {
            default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
            _: 3
          }, 16, [
            "id",
            "data-state",
            "aria-labelledby"
          ])]),
          _: 3
        }, 8, ["disable-outside-pointer-events"])]),
        _: 3
      }, 8, ["trapped"]);
    };
  }
});
var PopoverContentImpl_default = PopoverContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverContentModal.js
var PopoverContentModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverContentModal",
  props: {
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectPopoverRootContext();
    const isRightClickOutsideRef = ref(false);
    useBodyScrollLock(true);
    const forwarded = useForwardPropsEmits(props2, emits);
    const { forwardRef, currentElement } = useForwardExpose();
    useHideOthers(currentElement);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(PopoverContentImpl_default, mergeProps(unref(forwarded), {
        ref: unref(forwardRef),
        "trap-focus": unref(rootContext).open.value,
        "disable-outside-pointer-events": "",
        onCloseAutoFocus: _cache[0] || (_cache[0] = withModifiers((event) => {
          emits("closeAutoFocus", event);
          if (!isRightClickOutsideRef.value) unref(rootContext).triggerElement.value?.focus();
        }, ["prevent"])),
        onPointerDownOutside: _cache[1] || (_cache[1] = (event) => {
          emits("pointerDownOutside", event);
          const originalEvent = event.detail.originalEvent;
          const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
          const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
          isRightClickOutsideRef.value = isRightClick;
        }),
        onFocusOutside: _cache[2] || (_cache[2] = withModifiers(() => {
        }, ["prevent"]))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["trap-focus"]);
    };
  }
});
var PopoverContentModal_default = PopoverContentModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverContentNonModal.js
var PopoverContentNonModal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverContentNonModal",
  props: {
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectPopoverRootContext();
    const hasInteractedOutsideRef = ref(false);
    const hasPointerDownOutsideRef = ref(false);
    const forwarded = useForwardPropsEmits(props2, emits);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(PopoverContentImpl_default, mergeProps(unref(forwarded), {
        "trap-focus": false,
        "disable-outside-pointer-events": false,
        onCloseAutoFocus: _cache[0] || (_cache[0] = (event) => {
          emits("closeAutoFocus", event);
          if (!event.defaultPrevented) {
            if (!hasInteractedOutsideRef.value) unref(rootContext).triggerElement.value?.focus();
            event.preventDefault();
          }
          hasInteractedOutsideRef.value = false;
          hasPointerDownOutsideRef.value = false;
        }),
        onInteractOutside: _cache[1] || (_cache[1] = async (event) => {
          emits("interactOutside", event);
          if (!event.defaultPrevented) {
            hasInteractedOutsideRef.value = true;
            if (event.detail.originalEvent.type === "pointerdown") hasPointerDownOutsideRef.value = true;
          }
          const target = event.target;
          const targetIsTrigger = unref(rootContext).triggerElement.value?.contains(target);
          if (targetIsTrigger) event.preventDefault();
          if (event.detail.originalEvent.type === "focusin" && hasPointerDownOutsideRef.value) event.preventDefault();
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var PopoverContentNonModal_default = PopoverContentNonModal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverContent.js
var PopoverContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectPopoverRootContext();
    const forwarded = useForwardPropsEmits(props2, emits);
    const { forwardRef } = useForwardExpose();
    rootContext.contentId ||= useId2(void 0, "reka-popover-content");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(rootContext).open.value }, {
        default: withCtx(() => [unref(rootContext).modal.value ? (openBlock(), createBlock(PopoverContentModal_default, mergeProps({ key: 0 }, unref(forwarded), { ref: unref(forwardRef) }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)) : (openBlock(), createBlock(PopoverContentNonModal_default, mergeProps({ key: 1 }, unref(forwarded), { ref: unref(forwardRef) }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16))]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var PopoverContent_default = PopoverContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverPortal.js
var PopoverPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var PopoverPortal_default = PopoverPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerContent.js
var DatePickerContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerContent",
  props: {
    portal: {
      type: Object,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const propsToForward = computed(() => ({
      ...props2,
      portal: void 0
    }));
    const forwarded = useForwardPropsEmits(propsToForward, emits);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverPortal_default), normalizeProps(guardReactiveProps(_ctx.portal)), {
        default: withCtx(() => [createVNode(unref(PopoverContent_default), mergeProps({
          ...unref(forwarded),
          ..._ctx.$attrs
        }, { onOpenAutoFocus: _cache[0] || (_cache[0] = (event) => {
          emits("openAutoFocus", event);
          if (!event.defaultPrevented && event.target) {
            unref(handleCalendarInitialFocus)(event.target);
            event.preventDefault();
          }
        }) }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerContent_default = DatePickerContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerField.js
var DatePickerField_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerField",
  setup(__props) {
    const rootContext = injectDatePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DateFieldRoot_default), mergeProps({
        ref: unref(rootContext).dateFieldRef,
        "model-value": unref(rootContext).modelValue.value,
        placeholder: unref(rootContext).placeholder.value
      }, {
        id: unref(rootContext).id.value,
        name: unref(rootContext).name.value,
        disabled: unref(rootContext).disabled.value,
        minValue: unref(rootContext).minValue.value,
        maxValue: unref(rootContext).maxValue.value,
        readonly: unref(rootContext).readonly.value,
        hourCycle: unref(rootContext).hourCycle.value,
        granularity: unref(rootContext).granularity.value,
        hideTimeZone: unref(rootContext).hideTimeZone.value,
        locale: unref(rootContext).locale.value,
        isDateUnavailable: unref(rootContext).isDateUnavailable,
        required: unref(rootContext).required.value,
        dir: unref(rootContext).dir.value,
        step: unref(rootContext).step.value
      }, {
        "onUpdate:modelValue": _cache[0] || (_cache[0] = (date) => {
          if (date && unref(rootContext).modelValue.value && date.compare(unref(rootContext).modelValue.value) === 0) return;
          unref(rootContext).onDateChange(date);
        }),
        "onUpdate:placeholder": _cache[1] || (_cache[1] = (date) => {
          if (date.compare(unref(rootContext).placeholder.value) === 0) return;
          unref(rootContext).onPlaceholderChange(date);
        })
      }), {
        default: withCtx(({ segments, modelValue }) => [renderSlot(_ctx.$slots, "default", {
          segments,
          modelValue
        })]),
        _: 3
      }, 16, ["model-value", "placeholder"]);
    };
  }
});
var DatePickerField_default = DatePickerField_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerGrid.js
var DatePickerGrid_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerGrid",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarGrid_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerGrid_default = DatePickerGrid_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerGridBody.js
var DatePickerGridBody_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerGridBody",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarGridBody_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerGridBody_default = DatePickerGridBody_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerGridHead.js
var DatePickerGridHead_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerGridHead",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarGridHead_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerGridHead_default = DatePickerGridHead_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerGridRow.js
var DatePickerGridRow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerGridRow",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarGridRow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerGridRow_default = DatePickerGridRow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerHeadCell.js
var DatePickerHeadCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerHeadCell",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarHeadCell_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerHeadCell_default = DatePickerHeadCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerHeader.js
var DatePickerHeader_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerHeader",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarHeader_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerHeader_default = DatePickerHeader_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerHeading.js
var DatePickerHeading_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerHeading",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarHeading_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(({ headingValue }) => [renderSlot(_ctx.$slots, "default", { headingValue }, () => [createTextVNode(toDisplayString(headingValue), 1)])]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerHeading_default = DatePickerHeading_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerInput.js
var DatePickerInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerInput",
  props: {
    part: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DateFieldInput_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerInput_default = DatePickerInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerNext.js
var DatePickerNext_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerNext",
  props: {
    nextPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarNext_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerNext_default = DatePickerNext_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerPrev.js
var DatePickerPrev_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerPrev",
  props: {
    prevPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CalendarPrev_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DatePickerPrev_default = DatePickerPrev_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Popover/PopoverTrigger.js
var PopoverTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PopoverTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectPopoverRootContext();
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    rootContext.triggerId ||= useId2(void 0, "reka-popover-trigger");
    onMounted(() => {
      rootContext.triggerElement.value = triggerElement.value;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(resolveDynamicComponent(unref(rootContext).hasCustomAnchor.value ? unref(Primitive) : unref(PopperAnchor_default)), { "as-child": "" }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          id: unref(rootContext).triggerId,
          ref: unref(forwardRef),
          type: _ctx.as === "button" ? "button" : void 0,
          "aria-haspopup": "dialog",
          "aria-expanded": unref(rootContext).open.value,
          "aria-controls": unref(rootContext).contentId,
          "data-state": unref(rootContext).open.value ? "open" : "closed",
          as: _ctx.as,
          "as-child": props2.asChild,
          onClick: unref(rootContext).onOpenToggle
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "id",
          "type",
          "aria-expanded",
          "aria-controls",
          "data-state",
          "as",
          "as-child",
          "onClick"
        ])]),
        _: 3
      });
    };
  }
});
var PopoverTrigger_default = PopoverTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DatePicker/DatePickerTrigger.js
var DatePickerTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DatePickerTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDatePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverTrigger_default), mergeProps({ "data-reka-date-field-segment": "trigger" }, props2, {
        disabled: unref(rootContext).disabled.value,
        onFocusin: _cache[0] || (_cache[0] = (e) => {
          unref(rootContext).dateFieldRef.value?.setFocusedElement(e.target);
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["disabled"]);
    };
  }
});
var DatePickerTrigger_default = DatePickerTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangeField/DateRangeFieldRoot.js
var [injectDateRangeFieldRootContext, provideDateRangeFieldRootContext] = createContext("DateRangeFieldRoot");
var DateRangeFieldRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "DateRangeFieldRoot",
  props: {
    defaultValue: {
      type: Object,
      required: false,
      default: void 0
    },
    defaultPlaceholder: {
      type: null,
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    modelValue: {
      type: [Object, null],
      required: false
    },
    hourCycle: {
      type: null,
      required: false
    },
    step: {
      type: Object,
      required: false
    },
    granularity: {
      type: String,
      required: false
    },
    hideTimeZone: {
      type: Boolean,
      required: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    id: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue", "update:placeholder"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, readonly, isDateUnavailable: propsIsDateUnavailable, dir: propDir, locale: propLocale } = toRefs(props2);
    const locale = useLocale(propLocale);
    const dir = useDirection(propDir);
    const formatter = useDateFormatter(locale.value, { hourCycle: normalizeHourCycle(props2.hourCycle) });
    const { primitiveElement, currentElement: parentElement } = usePrimitiveElement();
    const segmentElements = ref(/* @__PURE__ */ new Set());
    onMounted(() => {
      getSegmentElements(parentElement.value).forEach((item) => segmentElements.value.add(item));
    });
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? {
        start: void 0,
        end: void 0
      },
      passive: props2.modelValue === void 0
    });
    const defaultDate = getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      granularity: props2.granularity,
      defaultValue: modelValue.value?.start,
      locale: props2.locale
    });
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.copy(),
      passive: props2.placeholder === void 0
    });
    const step = computed(() => normalizeDateStep(props2));
    const inferredGranularity = computed(() => {
      if (props2.granularity) return !hasTime(placeholder.value) ? "day" : props2.granularity;
      return hasTime(placeholder.value) ? "minute" : "day";
    });
    const isStartInvalid = computed(() => {
      if (!modelValue.value?.start) return false;
      if (propsIsDateUnavailable.value?.(modelValue.value.start)) return true;
      if (props2.minValue && isBefore(modelValue.value.start, props2.minValue)) return true;
      if (props2.maxValue && isBefore(props2.maxValue, modelValue.value.start)) return true;
      return false;
    });
    const isEndInvalid = computed(() => {
      if (!modelValue.value?.end) return false;
      if (propsIsDateUnavailable.value?.(modelValue.value.end)) return true;
      if (props2.minValue && isBefore(modelValue.value.end, props2.minValue)) return true;
      if (props2.maxValue && isBefore(props2.maxValue, modelValue.value.end)) return true;
      return false;
    });
    const isInvalid = computed(() => {
      if (isStartInvalid.value || isEndInvalid.value) return true;
      if (!modelValue.value?.start || !modelValue.value?.end) return false;
      if (!isBeforeOrSame(modelValue.value.start, modelValue.value.end)) return true;
      if (propsIsDateUnavailable.value !== void 0) {
        const allValid = areAllDaysBetweenValid(modelValue.value.start, modelValue.value.end, propsIsDateUnavailable.value, void 0);
        if (!allValid) return true;
      }
      return false;
    });
    const initialSegments = initializeSegmentValues(inferredGranularity.value);
    const startSegmentValues = ref(modelValue.value?.start ? { ...syncSegmentValues({
      value: modelValue.value.start,
      formatter
    }) } : { ...initialSegments });
    const endSegmentValues = ref(modelValue.value?.end ? { ...syncSegmentValues({
      value: modelValue.value.end,
      formatter
    }) } : { ...initialSegments });
    const startSegmentContent = computed(() => createContent({
      granularity: inferredGranularity.value,
      dateRef: placeholder.value,
      formatter,
      hideTimeZone: props2.hideTimeZone,
      hourCycle: props2.hourCycle,
      segmentValues: startSegmentValues.value,
      locale
    }));
    const endSegmentContent = computed(() => createContent({
      granularity: inferredGranularity.value,
      dateRef: placeholder.value,
      formatter,
      hideTimeZone: props2.hideTimeZone,
      hourCycle: props2.hourCycle,
      segmentValues: endSegmentValues.value,
      locale
    }));
    const segmentContents = computed(() => ({
      start: startSegmentContent.value.arr,
      end: endSegmentContent.value.arr
    }));
    const editableSegmentContents = computed(() => ({
      start: segmentContents.value.start.filter(({ part }) => part !== "literal"),
      end: segmentContents.value.end.filter(({ part }) => part !== "literal")
    }));
    const startValue = ref(modelValue.value?.start?.copy());
    const endValue = ref(modelValue.value?.end?.copy());
    watch([startValue, endValue], ([_startValue, _endValue]) => {
      modelValue.value = {
        start: _startValue?.copy(),
        end: _endValue?.copy()
      };
    });
    watch(modelValue, (_modelValue) => {
      const isStartChanged = _modelValue?.start && startValue.value ? _modelValue.start.compare(startValue.value) !== 0 : _modelValue?.start !== startValue.value;
      if (isStartChanged) startValue.value = _modelValue?.start?.copy();
      const isEndChanged = _modelValue?.end && endValue.value ? _modelValue.end.compare(endValue.value) !== 0 : _modelValue?.end !== endValue.value;
      if (isEndChanged) endValue.value = _modelValue?.end?.copy();
    });
    watch([startValue, locale], ([_startValue]) => {
      if (_startValue !== void 0) startSegmentValues.value = { ...syncSegmentValues({
        value: _startValue,
        formatter
      }) };
      else if (Object.values(startSegmentValues.value).every((value) => value !== null) && _startValue === void 0) startSegmentValues.value = { ...initialSegments };
    });
    watch(locale, (value) => {
      if (formatter.getLocale() !== value) {
        formatter.setLocale(value);
        nextTick(() => {
          segmentElements.value.clear();
          getSegmentElements(parentElement.value).forEach((item) => segmentElements.value.add(item));
        });
      }
    });
    watch(modelValue, (_modelValue) => {
      if (_modelValue && _modelValue.start !== void 0 && placeholder.value.compare(_modelValue.start) !== 0) placeholder.value = _modelValue.start.copy();
    });
    watch([endValue, locale], ([_endValue]) => {
      if (_endValue !== void 0) endSegmentValues.value = { ...syncSegmentValues({
        value: _endValue,
        formatter
      }) };
      else if (Object.values(endSegmentValues.value).every((value) => value !== null) && _endValue === void 0) endSegmentValues.value = { ...initialSegments };
    });
    const currentFocusedElement = ref(null);
    const currentSegmentIndex = computed(() => Array.from(segmentElements.value).findIndex((el) => el.getAttribute("data-reka-date-field-segment") === currentFocusedElement.value?.getAttribute("data-reka-date-field-segment") && el.getAttribute("data-reka-date-range-field-segment-type") === currentFocusedElement.value?.getAttribute("data-reka-date-range-field-segment-type")));
    const nextFocusableSegment = computed(() => {
      const sign = dir.value === "rtl" ? -1 : 1;
      const nextCondition = sign < 0 ? currentSegmentIndex.value < 0 : currentSegmentIndex.value > segmentElements.value.size - 1;
      if (nextCondition) return null;
      const segmentToFocus = Array.from(segmentElements.value)[currentSegmentIndex.value + sign];
      return segmentToFocus;
    });
    const prevFocusableSegment = computed(() => {
      const sign = dir.value === "rtl" ? -1 : 1;
      const prevCondition = sign > 0 ? currentSegmentIndex.value < 0 : currentSegmentIndex.value > segmentElements.value.size - 1;
      if (prevCondition) return null;
      const segmentToFocus = Array.from(segmentElements.value)[currentSegmentIndex.value - sign];
      return segmentToFocus;
    });
    const kbd = useKbd();
    function handleKeydown(e) {
      if (!isSegmentNavigationKey(e.key)) return;
      if (e.key === kbd.ARROW_LEFT) prevFocusableSegment.value?.focus();
      if (e.key === kbd.ARROW_RIGHT) nextFocusableSegment.value?.focus();
    }
    function setFocusedElement(el) {
      currentFocusedElement.value = el;
    }
    provideDateRangeFieldRootContext({
      isDateUnavailable: propsIsDateUnavailable.value,
      locale,
      startValue,
      endValue,
      placeholder,
      disabled,
      formatter,
      hourCycle: props2.hourCycle,
      step,
      readonly,
      segmentValues: {
        start: startSegmentValues,
        end: endSegmentValues
      },
      isInvalid,
      segmentContents: editableSegmentContents,
      elements: segmentElements,
      setFocusedElement,
      focusNext() {
        nextFocusableSegment.value?.focus();
      }
    });
    __expose({ setFocusedElement });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        role: "group",
        "aria-disabled": unref(disabled) ? true : void 0,
        "data-disabled": unref(disabled) ? "" : void 0,
        "data-readonly": unref(readonly) ? "" : void 0,
        "data-invalid": isInvalid.value ? "" : void 0,
        dir: unref(dir),
        onKeydown: withKeys(handleKeydown, ["left", "right"])
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          segments: segmentContents.value,
          isInvalid: isInvalid.value
        }), createVNode(unref(VisuallyHidden_default), {
          id: _ctx.id,
          as: "input",
          feature: "focusable",
          tabindex: "-1",
          value: `${unref(modelValue)?.start?.toString()} - ${unref(modelValue)?.end?.toString()}`,
          name: _ctx.name,
          disabled: unref(disabled),
          required: _ctx.required,
          onFocus: _cache[0] || (_cache[0] = ($event) => Array.from(segmentElements.value)?.[0]?.focus())
        }, null, 8, [
          "id",
          "value",
          "name",
          "disabled",
          "required"
        ])]),
        _: 3
      }, 16, [
        "aria-disabled",
        "data-disabled",
        "data-readonly",
        "data-invalid",
        "dir"
      ]);
    };
  }
});
var DateRangeFieldRoot_default = DateRangeFieldRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangeField/DateRangeFieldInput.js
var DateRangeFieldInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangeFieldInput",
  props: {
    part: {
      type: null,
      required: true
    },
    type: {
      type: String,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDateRangeFieldRootContext();
    const hasLeftFocus = ref(true);
    const lastKeyZero = ref(false);
    const { handleSegmentClick, handleSegmentKeydown, attributes } = useDateField({
      hasLeftFocus,
      lastKeyZero,
      placeholder: rootContext.placeholder,
      hourCycle: rootContext.hourCycle,
      step: rootContext.step,
      segmentValues: rootContext.segmentValues[props2.type],
      formatter: rootContext.formatter,
      part: props2.part,
      disabled: rootContext.disabled,
      readonly: rootContext.readonly,
      focusNext: rootContext.focusNext,
      modelValue: props2.type === "start" ? rootContext.startValue : rootContext.endValue
    });
    const disabled = computed(() => rootContext.disabled.value);
    const readonly = computed(() => rootContext.readonly.value);
    const isInvalid = computed(() => rootContext.isInvalid.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, unref(attributes), {
        contenteditable: disabled.value || readonly.value ? false : _ctx.part !== "literal",
        "data-reka-date-field-segment": _ctx.part,
        "aria-disabled": disabled.value ? true : void 0,
        "aria-readonly": readonly.value ? true : void 0,
        "data-disabled": disabled.value ? "" : void 0,
        "data-reka-date-range-field-segment-type": _ctx.type,
        "data-invalid": isInvalid.value ? "" : void 0,
        "aria-invalid": isInvalid.value ? true : void 0
      }, toHandlers(_ctx.part !== "literal" ? {
        mousedown: unref(handleSegmentClick),
        keydown: unref(handleSegmentKeydown),
        focusout: () => {
          hasLeftFocus.value = true;
        },
        focusin: (e) => {
          unref(rootContext).setFocusedElement(e.target);
        }
      } : {})), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "contenteditable",
        "data-reka-date-field-segment",
        "aria-disabled",
        "aria-readonly",
        "data-disabled",
        "data-reka-date-range-field-segment-type",
        "data-invalid",
        "aria-invalid"
      ]);
    };
  }
});
var DateRangeFieldInput_default = DateRangeFieldInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerAnchor.js
var DateRangePickerAnchor_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerAnchor",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverAnchor_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerAnchor_default = DateRangePickerAnchor_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerArrow.js
var DateRangePickerArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerArrow",
  props: {
    width: {
      type: Number,
      required: false
    },
    height: {
      type: Number,
      required: false
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerArrow_default = DateRangePickerArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerRoot.js
var [injectDateRangePickerRootContext, provideDateRangePickerRootContext] = createContext("DateRangePickerRoot");
var DateRangePickerRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "DateRangePickerRoot",
  props: {
    defaultValue: {
      type: Object,
      required: false,
      default: () => ({
        start: void 0,
        end: void 0
      })
    },
    defaultPlaceholder: {
      type: null,
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    modelValue: {
      type: [Object, null],
      required: false
    },
    hourCycle: {
      type: null,
      required: false
    },
    step: {
      type: Object,
      required: false
    },
    granularity: {
      type: String,
      required: false
    },
    hideTimeZone: {
      type: Boolean,
      required: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false,
      default: "en"
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    id: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    },
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    modal: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateDisabled: {
      type: Function,
      required: false,
      default: void 0
    },
    pagedNavigation: {
      type: Boolean,
      required: false,
      default: false
    },
    weekStartsOn: {
      type: Number,
      required: false,
      default: 0
    },
    weekdayFormat: {
      type: String,
      required: false,
      default: "narrow"
    },
    fixedWeeks: {
      type: Boolean,
      required: false,
      default: false
    },
    numberOfMonths: {
      type: Number,
      required: false,
      default: 1
    },
    preventDeselect: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateHighlightable: {
      type: Function,
      required: false,
      default: void 0
    },
    allowNonContiguousRanges: {
      type: Boolean,
      required: false,
      default: false
    },
    fixedDate: {
      type: String,
      required: false
    },
    maximumDays: {
      type: Number,
      required: false,
      default: void 0
    },
    closeOnSelect: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: [
    "update:modelValue",
    "update:placeholder",
    "update:startValue",
    "update:open"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { locale, disabled, readonly, pagedNavigation, weekStartsOn, weekdayFormat, fixedWeeks, numberOfMonths, preventDeselect, isDateDisabled: propsIsDateDisabled, isDateUnavailable: propsIsDateUnavailable, isDateHighlightable: propsIsDateHighlightable, defaultOpen, modal, id, name, required, minValue, maxValue, granularity, hideTimeZone, hourCycle, dir: propsDir, allowNonContiguousRanges, fixedDate, maximumDays, step, closeOnSelect } = toRefs(props2);
    const dir = useDirection(propsDir);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? {
        start: void 0,
        end: void 0
      },
      passive: props2.modelValue === void 0
    });
    const defaultDate = getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      granularity: props2.granularity,
      defaultValue: modelValue.value?.start,
      locale: props2.locale
    });
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.copy(),
      passive: props2.placeholder === void 0
    });
    const open = useVModel(props2, "open", emits, {
      defaultValue: defaultOpen.value,
      passive: props2.open === void 0
    });
    const dateFieldRef = ref();
    watch(modelValue, (value) => {
      if (value && value.start && value.start.compare(placeholder.value) !== 0) placeholder.value = value.start.copy();
      if (value.start && value.end) {
        if (closeOnSelect.value) open.value = false;
      }
    });
    provideDateRangePickerRootContext({
      allowNonContiguousRanges,
      isDateUnavailable: propsIsDateUnavailable.value,
      isDateDisabled: propsIsDateDisabled.value,
      isDateHighlightable: propsIsDateHighlightable.value,
      locale,
      disabled,
      pagedNavigation,
      weekStartsOn,
      weekdayFormat,
      fixedWeeks,
      numberOfMonths,
      readonly,
      preventDeselect,
      modelValue,
      placeholder,
      defaultOpen,
      modal,
      open,
      id,
      name,
      required,
      minValue,
      maxValue,
      granularity,
      hideTimeZone,
      hourCycle,
      dateFieldRef,
      dir,
      fixedDate,
      maximumDays,
      step,
      onStartValueChange(date) {
        emits("update:startValue", date);
      },
      onDateChange(date) {
        modelValue.value = {
          start: date.start?.copy(),
          end: date.end?.copy()
        };
      },
      onPlaceholderChange(date) {
        placeholder.value = date.copy();
      },
      closeOnSelect
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverRoot_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null),
        "default-open": unref(defaultOpen),
        modal: unref(modal)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          open: unref(open)
        })]),
        _: 3
      }, 8, [
        "open",
        "default-open",
        "modal"
      ]);
    };
  }
});
var DateRangePickerRoot_default = DateRangePickerRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/useRangeCalendar.js
function useRangeCalendarState(props2) {
  const isStartInvalid = computed(() => {
    if (!props2.start.value) return false;
    if (props2.isDateDisabled(props2.start.value)) return true;
    return false;
  });
  const isEndInvalid = computed(() => {
    if (!props2.end.value) return false;
    if (props2.isDateDisabled(props2.end.value)) return true;
    return false;
  });
  const isInvalid = computed(() => {
    if (isStartInvalid.value || isEndInvalid.value) return false;
    if (props2.start.value && props2.end.value && isBefore(props2.end.value, props2.start.value)) return true;
    return false;
  });
  const isSelectionStart = (date) => {
    if (!props2.start.value) return false;
    return $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.start.value, date);
  };
  const isSelectionEnd = (date) => {
    if (!props2.end.value) return false;
    return $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.end.value, date);
  };
  const isSelected = (date) => {
    if (props2.start.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.start.value, date)) return true;
    if (props2.end.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.end.value, date)) return true;
    if (props2.end.value && props2.start.value) return isBetween(date, props2.start.value, props2.end.value);
    return false;
  };
  const rangeIsDateDisabled = (date) => {
    if (props2.isDateDisabled(date)) return true;
    if (props2.maximumDays?.value) {
      if (props2.start.value && props2.end.value) {
        if (props2.fixedDate.value) {
          const diff = getDaysBetween(props2.start.value, props2.end.value).length;
          if (diff <= props2.maximumDays.value) {
            const daysLeft = props2.maximumDays.value - diff - 1;
            const startLimit = props2.start.value.subtract({ days: daysLeft });
            const endLimit = props2.end.value.add({ days: daysLeft });
            return !isBetween(date, startLimit, endLimit);
          }
        }
        return false;
      }
      if (props2.start.value) {
        const maxDate = props2.start.value.add({ days: props2.maximumDays.value });
        const minDate = props2.start.value.subtract({ days: props2.maximumDays.value });
        return !isBetween(date, minDate, maxDate);
      }
    }
    if (!props2.start.value || props2.end.value || $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.start.value, date)) return false;
    return false;
  };
  const isDateHighlightable = (date) => {
    if (props2.isDateHighlightable?.(date)) return true;
    return false;
  };
  const highlightedRange = computed(() => {
    if (props2.start.value && props2.end.value && !props2.fixedDate.value) return null;
    if (!props2.start.value || !props2.focusedValue.value) return null;
    const isStartBeforeFocused = isBefore(props2.start.value, props2.focusedValue.value);
    const start = isStartBeforeFocused ? props2.start.value : props2.focusedValue.value;
    const end = isStartBeforeFocused ? props2.focusedValue.value : props2.start.value;
    if ($14e0f24ef4ac5c92$export$ea39ec197993aef0(start, end)) return {
      start,
      end
    };
    if (props2.maximumDays?.value && !props2.end.value) {
      const cappedEnd = isStartBeforeFocused ? start.add({ days: props2.maximumDays.value - 1 }) : start.subtract({ days: props2.maximumDays.value });
      return {
        start,
        end: cappedEnd
      };
    }
    const isValid = areAllDaysBetweenValid(start, end, props2.allowNonContiguousRanges.value ? () => false : props2.isDateUnavailable, rangeIsDateDisabled, props2.isDateHighlightable);
    if (isValid) return {
      start,
      end
    };
    return null;
  });
  const isHighlightedStart = (date) => {
    if (!highlightedRange.value || !highlightedRange.value.start) return false;
    return $14e0f24ef4ac5c92$export$ea39ec197993aef0(highlightedRange.value.start, date);
  };
  const isHighlightedEnd = (date) => {
    if (!highlightedRange.value || !highlightedRange.value.end) return false;
    return $14e0f24ef4ac5c92$export$ea39ec197993aef0(highlightedRange.value.end, date);
  };
  return {
    isInvalid,
    isSelected,
    isDateHighlightable,
    highlightedRange,
    isSelectionStart,
    isSelectionEnd,
    isHighlightedStart,
    isHighlightedEnd,
    isDateDisabled: rangeIsDateDisabled
  };
}

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarRoot.js
var _hoisted_13 = { style: {
  "border": "0px",
  "clip": "rect(0px, 0px, 0px, 0px)",
  "clip-path": "inset(50%)",
  "height": "1px",
  "margin": "-1px",
  "overflow": "hidden",
  "padding": "0px",
  "position": "absolute",
  "white-space": "nowrap",
  "width": "1px"
} };
var _hoisted_23 = {
  role: "heading",
  "aria-level": "2"
};
var [injectRangeCalendarRootContext, provideRangeCalendarRootContext] = createContext("RangeCalendarRoot");
var RangeCalendarRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarRoot",
  props: {
    defaultPlaceholder: {
      type: null,
      required: false
    },
    defaultValue: {
      type: Object,
      required: false,
      default: () => ({
        start: void 0,
        end: void 0
      })
    },
    modelValue: {
      type: [Object, null],
      required: false
    },
    placeholder: {
      type: null,
      required: false,
      default: void 0
    },
    allowNonContiguousRanges: {
      type: Boolean,
      required: false,
      default: false
    },
    pagedNavigation: {
      type: Boolean,
      required: false,
      default: false
    },
    preventDeselect: {
      type: Boolean,
      required: false,
      default: false
    },
    maximumDays: {
      type: Number,
      required: false,
      default: void 0
    },
    weekStartsOn: {
      type: Number,
      required: false,
      default: 0
    },
    weekdayFormat: {
      type: String,
      required: false,
      default: "narrow"
    },
    calendarLabel: {
      type: String,
      required: false
    },
    fixedWeeks: {
      type: Boolean,
      required: false,
      default: false
    },
    maxValue: {
      type: null,
      required: false
    },
    minValue: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false
    },
    numberOfMonths: {
      type: Number,
      required: false,
      default: 1
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false,
      default: false
    },
    initialFocus: {
      type: Boolean,
      required: false,
      default: false
    },
    isDateDisabled: {
      type: Function,
      required: false,
      default: void 0
    },
    isDateUnavailable: {
      type: Function,
      required: false,
      default: void 0
    },
    isDateHighlightable: {
      type: Function,
      required: false,
      default: void 0
    },
    dir: {
      type: String,
      required: false
    },
    nextPage: {
      type: Function,
      required: false
    },
    prevPage: {
      type: Function,
      required: false
    },
    disableDaysOutsideCurrentView: {
      type: Boolean,
      required: false,
      default: false
    },
    fixedDate: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  emits: [
    "update:modelValue",
    "update:validModelValue",
    "update:placeholder",
    "update:startValue"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, readonly, initialFocus, pagedNavigation, weekStartsOn, weekdayFormat, fixedWeeks, numberOfMonths, preventDeselect, isDateUnavailable: propsIsDateUnavailable, isDateHighlightable: propsIsDateHighlightable, isDateDisabled: propsIsDateDisabled, calendarLabel, maxValue, minValue, dir: propDir, locale: propLocale, nextPage: propsNextPage, prevPage: propsPrevPage, allowNonContiguousRanges, disableDaysOutsideCurrentView, fixedDate, maximumDays } = toRefs(props2);
    const { primitiveElement, currentElement: parentElement } = usePrimitiveElement();
    const dir = useDirection(propDir);
    const locale = useLocale(propLocale);
    const lastPressedDateValue = ref();
    const focusedValue = ref();
    const isEditing = ref(false);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? {
        start: void 0,
        end: void 0
      },
      passive: props2.modelValue === void 0
    });
    const validModelValue = ref(modelValue.value);
    watch(validModelValue, (value) => {
      emits("update:validModelValue", value);
    });
    const defaultDate = getDefaultDate({
      defaultPlaceholder: props2.placeholder,
      defaultValue: modelValue.value.start,
      locale: props2.locale
    });
    const startValue = ref(modelValue.value.start);
    const endValue = ref(modelValue.value.end);
    const placeholder = useVModel(props2, "placeholder", emits, {
      defaultValue: props2.defaultPlaceholder ?? defaultDate.copy(),
      passive: props2.placeholder === void 0
    });
    function onPlaceholderChange(value) {
      placeholder.value = value.copy();
    }
    const { fullCalendarLabel, headingValue, isDateDisabled, isDateUnavailable, isNextButtonDisabled, isPrevButtonDisabled, grid, weekdays, isOutsideVisibleView, nextPage, prevPage, formatter } = useCalendar({
      locale,
      placeholder,
      weekStartsOn,
      fixedWeeks,
      numberOfMonths,
      minValue,
      maxValue,
      disabled,
      weekdayFormat,
      pagedNavigation,
      isDateDisabled: propsIsDateDisabled.value,
      isDateUnavailable: propsIsDateUnavailable.value,
      calendarLabel,
      nextPage: propsNextPage,
      prevPage: propsPrevPage
    });
    const { isInvalid, isSelected, isDateHighlightable, highlightedRange, isSelectionStart, isSelectionEnd, isHighlightedStart, isHighlightedEnd, isDateDisabled: rangeIsDateDisabled } = useRangeCalendarState({
      start: startValue,
      end: endValue,
      isDateDisabled,
      isDateUnavailable,
      isDateHighlightable: propsIsDateHighlightable.value,
      focusedValue,
      allowNonContiguousRanges,
      fixedDate,
      maximumDays
    });
    watch(modelValue, (_modelValue, _prevValue) => {
      if (!_prevValue?.start && _modelValue?.start || !_modelValue || !_modelValue.start || startValue.value && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(_modelValue.start, startValue.value)) startValue.value = _modelValue?.start?.copy?.();
      if (!_prevValue?.end && _modelValue.end || !_modelValue || !_modelValue.end || endValue.value && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(_modelValue.end, endValue.value)) endValue.value = _modelValue?.end?.copy?.();
    });
    watch(startValue, (_startValue) => {
      if (_startValue && !$14e0f24ef4ac5c92$export$91b62ebf2ba703ee(_startValue, placeholder.value)) onPlaceholderChange(_startValue);
      emits("update:startValue", _startValue);
    });
    watch([startValue, endValue], ([_startValue, _endValue]) => {
      const value = modelValue.value;
      if (value && value.start && value.end && _startValue && _endValue && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(value.start, _startValue) && $14e0f24ef4ac5c92$export$91b62ebf2ba703ee(value.end, _endValue)) return;
      isEditing.value = true;
      if (_endValue && _startValue) {
        const nextValue = isBefore(_endValue, _startValue) ? {
          start: _endValue.copy(),
          end: _startValue.copy()
        } : {
          start: _startValue.copy(),
          end: _endValue.copy()
        };
        modelValue.value = {
          start: nextValue.start,
          end: nextValue.end
        };
        isEditing.value = false;
        validModelValue.value = {
          start: nextValue.start.copy(),
          end: nextValue.end.copy()
        };
      } else modelValue.value = _startValue ? {
        start: _startValue.copy(),
        end: void 0
      } : {
        start: _endValue?.copy(),
        end: void 0
      };
    });
    const kbd = useKbd();
    useEventListener("keydown", (ev) => {
      if (ev.key === kbd.ESCAPE && isEditing.value) {
        startValue.value = validModelValue.value.start?.copy();
        endValue.value = validModelValue.value.end?.copy();
      }
    });
    provideRangeCalendarRootContext({
      isDateUnavailable,
      isDateHighlightable,
      startValue,
      endValue,
      formatter,
      modelValue,
      placeholder,
      disabled,
      initialFocus,
      pagedNavigation,
      grid,
      weekDays: weekdays,
      weekStartsOn,
      weekdayFormat,
      fixedWeeks,
      numberOfMonths,
      readonly,
      preventDeselect,
      fullCalendarLabel,
      headingValue,
      isInvalid,
      isDateDisabled: rangeIsDateDisabled,
      allowNonContiguousRanges,
      highlightedRange,
      focusedValue,
      lastPressedDateValue,
      isSelected,
      isSelectionEnd,
      isSelectionStart,
      isNextButtonDisabled,
      isPrevButtonDisabled,
      isOutsideVisibleView,
      nextPage,
      prevPage,
      parentElement,
      onPlaceholderChange,
      locale,
      dir,
      isHighlightedStart,
      isHighlightedEnd,
      disableDaysOutsideCurrentView,
      fixedDate,
      maximumDays,
      minValue,
      maxValue
    });
    onMounted(() => {
      if (initialFocus.value) handleCalendarInitialFocus(parentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "aria-label": unref(fullCalendarLabel),
        "data-readonly": unref(readonly) ? "" : void 0,
        "data-disabled": unref(disabled) ? "" : void 0,
        "data-invalid": unref(isInvalid) ? "" : void 0,
        dir: unref(dir)
      }, {
        default: withCtx(() => [createBaseVNode("div", _hoisted_13, [createBaseVNode("div", _hoisted_23, toDisplayString(unref(fullCalendarLabel)), 1)]), renderSlot(_ctx.$slots, "default", {
          date: unref(placeholder),
          grid: unref(grid),
          weekDays: unref(weekdays),
          weekStartsOn: unref(weekStartsOn),
          locale: unref(locale),
          fixedWeeks: unref(fixedWeeks),
          modelValue: unref(modelValue)
        })]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-label",
        "data-readonly",
        "data-disabled",
        "data-invalid",
        "dir"
      ]);
    };
  }
});
var RangeCalendarRoot_default = RangeCalendarRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerCalendar.js
var DateRangePickerCalendar_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerCalendar",
  setup(__props) {
    const rootContext = injectDateRangePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarRoot_default), mergeProps({
        allowNonContiguousRanges: unref(rootContext).allowNonContiguousRanges.value,
        isDateDisabled: unref(rootContext).isDateDisabled,
        isDateUnavailable: unref(rootContext).isDateUnavailable,
        isDateHighlightable: unref(rootContext).isDateHighlightable,
        locale: unref(rootContext).locale.value,
        disabled: unref(rootContext).disabled.value,
        pagedNavigation: unref(rootContext).pagedNavigation.value,
        weekStartsOn: unref(rootContext).weekStartsOn.value,
        weekdayFormat: unref(rootContext).weekdayFormat.value,
        fixedWeeks: unref(rootContext).fixedWeeks.value,
        numberOfMonths: unref(rootContext).numberOfMonths.value,
        readonly: unref(rootContext).readonly.value,
        preventDeselect: unref(rootContext).preventDeselect.value,
        minValue: unref(rootContext).minValue.value,
        maxValue: unref(rootContext).maxValue.value,
        dir: unref(rootContext).dir.value,
        fixedDate: unref(rootContext).fixedDate.value,
        maximumDays: unref(rootContext).maximumDays?.value
      }, {
        "model-value": unref(rootContext).modelValue.value,
        placeholder: unref(rootContext).placeholder.value,
        "onUpdate:startValue": _cache[0] || (_cache[0] = (date) => {
          unref(rootContext).onStartValueChange(date);
        }),
        "onUpdate:modelValue": _cache[1] || (_cache[1] = (date) => {
          if (date.start && unref(rootContext).modelValue.value?.start && date.end && unref(rootContext).modelValue.value?.end && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date.start, unref(rootContext).modelValue.value?.start) && unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date.end, unref(rootContext).modelValue.value?.end)) return;
          unref(rootContext).onDateChange(date);
        }),
        "onUpdate:placeholder": _cache[2] || (_cache[2] = (date) => {
          if (unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date, unref(rootContext).placeholder.value)) return;
          unref(rootContext).onPlaceholderChange(date);
        })
      }), {
        default: withCtx(({ weekDays, grid, date, weekStartsOn, locale, fixedWeeks }) => [renderSlot(_ctx.$slots, "default", {
          date,
          grid,
          weekDays,
          weekStartsOn,
          locale,
          fixedWeeks
        })]),
        _: 3
      }, 16, ["model-value", "placeholder"]);
    };
  }
});
var DateRangePickerCalendar_default = DateRangePickerCalendar_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarCell.js
var RangeCalendarCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarCell",
  props: {
    date: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "td"
    }
  },
  setup(__props) {
    const rootContext = injectRangeCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        role: "gridcell",
        "aria-selected": unref(rootContext).isSelected(_ctx.date) ? true : void 0,
        "aria-disabled": unref(rootContext).isDateDisabled(_ctx.date) || unref(rootContext).isDateUnavailable?.(_ctx.date) || unref(rootContext).disableDaysOutsideCurrentView.value,
        "data-disabled": unref(rootContext).isDateDisabled(_ctx.date) || unref(rootContext).disableDaysOutsideCurrentView.value ? "" : void 0
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-selected",
        "aria-disabled",
        "data-disabled"
      ]);
    };
  }
});
var RangeCalendarCell_default = RangeCalendarCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerCell.js
var DateRangePickerCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerCell",
  props: {
    date: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarCell_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerCell_default = DateRangePickerCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarCellTrigger.js
var RangeCalendarCellTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarCellTrigger",
  props: {
    day: {
      type: null,
      required: true
    },
    month: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectRangeCalendarRootContext();
    const kbd = useKbd();
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const labelText = computed(() => rootContext.formatter.custom(toDate(props2.day), {
      weekday: "long",
      month: "long",
      day: "numeric",
      year: "numeric"
    }));
    const isUnavailable = computed(() => rootContext.isDateUnavailable?.(props2.day) ?? false);
    const isSelectedDate = computed(() => rootContext.isSelected(props2.day));
    const isSelectionStart = computed(() => rootContext.isSelectionStart(props2.day));
    const isSelectionEnd = computed(() => rootContext.isSelectionEnd(props2.day));
    const isHighlightStart = computed(() => rootContext.isHighlightedStart(props2.day));
    const isHighlightEnd = computed(() => rootContext.isHighlightedEnd(props2.day));
    const isHighlighted = computed(() => rootContext.highlightedRange.value ? isBetweenInclusive(props2.day, rootContext.highlightedRange.value.start, rootContext.highlightedRange.value.end) : false);
    const allowNonContiguousRanges = computed(() => rootContext.allowNonContiguousRanges.value);
    const isDateToday = computed(() => {
      return $14e0f24ef4ac5c92$export$629b0a497aa65267(props2.day, $14e0f24ef4ac5c92$export$aa8b41735afcabd2());
    });
    const isOutsideView = computed(() => {
      return !$14e0f24ef4ac5c92$export$a18c89cbd24170ff(props2.day, props2.month);
    });
    const isOutsideVisibleView = computed(() => rootContext.isOutsideVisibleView(props2.day));
    const isDisabled = computed(() => rootContext.isDateDisabled(props2.day) || rootContext.disableDaysOutsideCurrentView.value && isOutsideView.value);
    const dayValue = computed(() => props2.day.day.toLocaleString(rootContext.locale.value));
    const isFocusedDate = computed(() => {
      return !rootContext.disabled.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(props2.day, rootContext.placeholder.value);
    });
    function changeDate(e, date) {
      if (rootContext.readonly.value) return;
      if (rootContext.isDateDisabled(date) || rootContext.isDateUnavailable?.(date)) return;
      rootContext.lastPressedDateValue.value = date.copy();
      if (rootContext.startValue.value && rootContext.highlightedRange.value === null) {
        if ($14e0f24ef4ac5c92$export$ea39ec197993aef0(date, rootContext.startValue.value) && !rootContext.preventDeselect.value && !rootContext.endValue.value) {
          rootContext.startValue.value = void 0;
          rootContext.onPlaceholderChange(date);
          return;
        } else if (!rootContext.endValue.value) {
          e.preventDefault();
          if (rootContext.lastPressedDateValue.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(rootContext.lastPressedDateValue.value, date)) rootContext.startValue.value = date.copy();
          return;
        }
      }
      if (rootContext.startValue.value && rootContext.endValue.value && $14e0f24ef4ac5c92$export$ea39ec197993aef0(rootContext.startValue.value, rootContext.endValue.value) && $14e0f24ef4ac5c92$export$ea39ec197993aef0(rootContext.startValue.value, date) && !rootContext.preventDeselect.value) {
        rootContext.startValue.value = void 0;
        rootContext.endValue.value = void 0;
        rootContext.onPlaceholderChange(date);
        return;
      }
      if (!rootContext.startValue.value) rootContext.startValue.value = date.copy();
      else if (!rootContext.endValue.value) rootContext.endValue.value = date.copy();
      else if (rootContext.endValue.value && rootContext.startValue.value) {
        if (!rootContext.fixedDate.value) {
          rootContext.endValue.value = void 0;
          rootContext.startValue.value = date.copy();
        } else if (rootContext.fixedDate.value === "start") if (date.compare(rootContext.startValue.value) < 0) rootContext.startValue.value = date.copy();
        else rootContext.endValue.value = date.copy();
        else if (rootContext.fixedDate.value === "end") if (date.compare(rootContext.endValue.value) > 0) rootContext.endValue.value = date.copy();
        else rootContext.startValue.value = date.copy();
      }
    }
    function handleClick(e) {
      if (isDisabled.value) return;
      changeDate(e, props2.day);
    }
    function handleFocus() {
      if (isDisabled.value || rootContext.isDateUnavailable?.(props2.day)) return;
      rootContext.focusedValue.value = props2.day.copy();
    }
    function handleArrowKey(e) {
      if (isDisabled.value) return;
      e.preventDefault();
      e.stopPropagation();
      const parentElement = rootContext.parentElement.value;
      const indexIncrementation = 7;
      const sign = rootContext.dir.value === "rtl" ? -1 : 1;
      switch (e.code) {
        case kbd.ARROW_RIGHT:
          shiftFocus(props2.day, sign);
          break;
        case kbd.ARROW_LEFT:
          shiftFocus(props2.day, -sign);
          break;
        case kbd.ARROW_UP:
          shiftFocus(props2.day, -indexIncrementation);
          break;
        case kbd.ARROW_DOWN:
          shiftFocus(props2.day, indexIncrementation);
          break;
        case kbd.ENTER:
        case kbd.SPACE_CODE:
          changeDate(e, props2.day);
      }
      function shiftFocus(day, add) {
        const candidateDayValue = day.add({ days: add });
        if (rootContext.minValue.value && candidateDayValue.compare(rootContext.minValue.value) < 0 || rootContext.maxValue.value && candidateDayValue.compare(rootContext.maxValue.value) > 0) return;
        const candidateDay = parentElement.querySelector(`[data-value='${candidateDayValue.toString()}']:not([data-outside-view])`);
        if (!candidateDay) {
          if (add > 0) {
            if (rootContext.isNextButtonDisabled()) return;
            rootContext.nextPage();
          } else {
            if (rootContext.isPrevButtonDisabled()) return;
            rootContext.prevPage();
          }
          nextTick(() => {
            shiftFocus(day, add);
          });
          return;
        }
        if (candidateDay && candidateDay.hasAttribute("data-disabled")) return shiftFocus(candidateDayValue, add);
        rootContext.onPlaceholderChange(candidateDayValue);
        candidateDay?.focus();
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        role: "button",
        "aria-label": labelText.value,
        "data-reka-calendar-cell-trigger": "",
        "aria-pressed": isSelectedDate.value && (allowNonContiguousRanges.value || !isUnavailable.value) ? true : void 0,
        "aria-disabled": isDisabled.value || isUnavailable.value ? true : void 0,
        "data-highlighted": isHighlighted.value && (allowNonContiguousRanges.value || !isUnavailable.value) ? "" : void 0,
        "data-selection-start": isSelectionStart.value ? true : void 0,
        "data-selection-end": isSelectionEnd.value ? true : void 0,
        "data-highlighted-start": isHighlightStart.value ? true : void 0,
        "data-highlighted-end": isHighlightEnd.value ? true : void 0,
        "data-selected": isSelectedDate.value && (allowNonContiguousRanges.value || !isUnavailable.value) ? true : void 0,
        "data-outside-visible-view": isOutsideVisibleView.value ? "" : void 0,
        "data-value": _ctx.day.toString(),
        "data-disabled": isDisabled.value ? "" : void 0,
        "data-unavailable": isUnavailable.value ? "" : void 0,
        "data-today": isDateToday.value ? "" : void 0,
        "data-outside-view": isOutsideView.value ? "" : void 0,
        "data-focused": isFocusedDate.value ? "" : void 0,
        tabindex: isFocusedDate.value ? 0 : isOutsideView.value || isDisabled.value ? void 0 : -1,
        onClick: handleClick,
        onFocusin: handleFocus,
        onMouseenter: handleFocus,
        onKeydown: withKeys(handleArrowKey, [
          "up",
          "down",
          "left",
          "right",
          "enter",
          "space"
        ])
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          dayValue: dayValue.value,
          disabled: isDisabled.value,
          today: isDateToday.value,
          selected: isSelectedDate.value,
          outsideView: isOutsideView.value,
          outsideVisibleView: isOutsideVisibleView.value,
          unavailable: isUnavailable.value,
          highlighted: isHighlighted.value && (allowNonContiguousRanges.value || !isUnavailable.value),
          highlightedStart: isHighlightStart.value,
          highlightedEnd: isHighlightEnd.value,
          selectionStart: isSelectionStart.value,
          selectionEnd: isSelectionEnd.value
        }, () => [createTextVNode(toDisplayString(dayValue.value), 1)])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "aria-label",
        "aria-pressed",
        "aria-disabled",
        "data-highlighted",
        "data-selection-start",
        "data-selection-end",
        "data-highlighted-start",
        "data-highlighted-end",
        "data-selected",
        "data-outside-visible-view",
        "data-value",
        "data-disabled",
        "data-unavailable",
        "data-today",
        "data-outside-view",
        "data-focused",
        "tabindex"
      ]);
    };
  }
});
var RangeCalendarCellTrigger_default = RangeCalendarCellTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerCellTrigger.js
var DateRangePickerCellTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerCellTrigger",
  props: {
    day: {
      type: null,
      required: true
    },
    month: {
      type: null,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarCellTrigger_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerCellTrigger_default = DateRangePickerCellTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerClose.js
var DateRangePickerClose_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerClose",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverClose_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerClose_default = DateRangePickerClose_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerContent.js
var DateRangePickerContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerContent",
  props: {
    portal: {
      type: Object,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const propsToForward = computed(() => ({
      ...props2,
      portal: void 0
    }));
    const forwarded = useForwardPropsEmits(propsToForward, emits);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverPortal_default), normalizeProps(guardReactiveProps(_ctx.portal)), {
        default: withCtx(() => [createVNode(unref(PopoverContent_default), mergeProps({
          ...unref(forwarded),
          ..._ctx.$attrs
        }, { onOpenAutoFocus: _cache[0] || (_cache[0] = (event) => {
          emits("openAutoFocus", event);
          if (!event.defaultPrevented && event.target) {
            unref(handleCalendarInitialFocus)(event.target);
            event.preventDefault();
          }
        }) }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerContent_default = DateRangePickerContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerField.js
var DateRangePickerField_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerField",
  setup(__props) {
    const rootContext = injectDateRangePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DateRangeFieldRoot_default), mergeProps({
        ref: unref(rootContext).dateFieldRef,
        "model-value": unref(rootContext).modelValue.value,
        placeholder: unref(rootContext).placeholder.value
      }, {
        id: unref(rootContext).id.value,
        name: unref(rootContext).name.value,
        disabled: unref(rootContext).disabled.value,
        minValue: unref(rootContext).minValue.value,
        maxValue: unref(rootContext).maxValue.value,
        readonly: unref(rootContext).readonly.value,
        hourCycle: unref(rootContext).hourCycle.value,
        granularity: unref(rootContext).granularity.value,
        hideTimeZone: unref(rootContext).hideTimeZone.value,
        locale: unref(rootContext).locale.value,
        isDateUnavailable: unref(rootContext).isDateUnavailable,
        required: unref(rootContext).required.value,
        dir: unref(rootContext).dir.value,
        step: unref(rootContext).step.value
      }, {
        "onUpdate:modelValue": _cache[0] || (_cache[0] = (date) => {
          if (date.start && unref(rootContext).modelValue.value.start && date.end && unref(rootContext).modelValue.value.end && date.start.compare(unref(rootContext).modelValue.value.start) === 0 && date.end.compare(unref(rootContext).modelValue.value.end) === 0) return;
          unref(rootContext).onDateChange(date);
        }),
        "onUpdate:placeholder": _cache[1] || (_cache[1] = (date) => {
          if (unref($14e0f24ef4ac5c92$export$91b62ebf2ba703ee)(date, unref(rootContext).placeholder.value) && date.compare(unref(rootContext).placeholder.value) === 0) return;
          unref(rootContext).onPlaceholderChange(date);
        })
      }), {
        default: withCtx(({ segments, modelValue }) => [renderSlot(_ctx.$slots, "default", {
          segments,
          modelValue
        })]),
        _: 3
      }, 16, ["model-value", "placeholder"]);
    };
  }
});
var DateRangePickerField_default = DateRangePickerField_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarGrid.js
var RangeCalendarGrid_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarGrid",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "table"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectRangeCalendarRootContext();
    const disabled = computed(() => rootContext.disabled.value ? true : void 0);
    const readonly = computed(() => rootContext.readonly.value ? true : void 0);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        tabindex: "-1",
        role: "grid",
        "aria-readonly": readonly.value,
        "aria-disabled": disabled.value,
        "data-readonly": readonly.value && "",
        "data-disabled": disabled.value && ""
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "aria-readonly",
        "aria-disabled",
        "data-readonly",
        "data-disabled"
      ]);
    };
  }
});
var RangeCalendarGrid_default = RangeCalendarGrid_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerGrid.js
var DateRangePickerGrid_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerGrid",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarGrid_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerGrid_default = DateRangePickerGrid_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarGridBody.js
var RangeCalendarGridBody_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarGridBody",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "tbody"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var RangeCalendarGridBody_default = RangeCalendarGridBody_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerGridBody.js
var DateRangePickerGridBody_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerGridBody",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarGridBody_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerGridBody_default = DateRangePickerGridBody_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarGridHead.js
var RangeCalendarGridHead_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarGridHead",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "thead"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "aria-hidden": "true" }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var RangeCalendarGridHead_default = RangeCalendarGridHead_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerGridHead.js
var DateRangePickerGridHead_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerGridHead",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarGridHead_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerGridHead_default = DateRangePickerGridHead_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarGridRow.js
var RangeCalendarGridRow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarGridRow",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "tr"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var RangeCalendarGridRow_default = RangeCalendarGridRow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerGridRow.js
var DateRangePickerGridRow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerGridRow",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarGridRow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerGridRow_default = DateRangePickerGridRow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarHeadCell.js
var RangeCalendarHeadCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarHeadCell",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "th"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var RangeCalendarHeadCell_default = RangeCalendarHeadCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerHeadCell.js
var DateRangePickerHeadCell_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerHeadCell",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarHeadCell_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerHeadCell_default = DateRangePickerHeadCell_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarHeader.js
var RangeCalendarHeader_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarHeader",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var RangeCalendarHeader_default = RangeCalendarHeader_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerHeader.js
var DateRangePickerHeader_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerHeader",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarHeader_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerHeader_default = DateRangePickerHeader_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarHeading.js
var RangeCalendarHeading_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarHeading",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectRangeCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "data-disabled": unref(rootContext).disabled.value ? "" : void 0 }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { headingValue: unref(rootContext).headingValue.value }, () => [createTextVNode(toDisplayString(unref(rootContext).headingValue.value), 1)])]),
        _: 3
      }, 16, ["data-disabled"]);
    };
  }
});
var RangeCalendarHeading_default = RangeCalendarHeading_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerHeading.js
var DateRangePickerHeading_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerHeading",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarHeading_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(({ headingValue }) => [renderSlot(_ctx.$slots, "default", { headingValue }, () => [createTextVNode(toDisplayString(headingValue), 1)])]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerHeading_default = DateRangePickerHeading_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerInput.js
var DateRangePickerInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerInput",
  props: {
    part: {
      type: null,
      required: true
    },
    type: {
      type: String,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DateRangeFieldInput_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerInput_default = DateRangePickerInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarNext.js
var RangeCalendarNext_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarNext",
  props: {
    nextPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const disabled = computed(() => rootContext.disabled.value || rootContext.isNextButtonDisabled(props2.nextPage));
    const rootContext = injectRangeCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "aria-label": "Next page",
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-disabled": disabled.value || void 0,
        "data-disabled": disabled.value || void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).nextPage(props2.nextPage))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { disabled: disabled.value }, () => [_cache[1] || (_cache[1] = createTextVNode(" Next page "))])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "type",
        "aria-disabled",
        "data-disabled",
        "disabled"
      ]);
    };
  }
});
var RangeCalendarNext_default = RangeCalendarNext_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerNext.js
var DateRangePickerNext_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerNext",
  props: {
    nextPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarNext_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerNext_default = DateRangePickerNext_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RangeCalendar/RangeCalendarPrev.js
var RangeCalendarPrev_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RangeCalendarPrev",
  props: {
    prevPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const disabled = computed(() => rootContext.disabled.value || rootContext.isPrevButtonDisabled(props2.prevPage));
    const rootContext = injectRangeCalendarRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "aria-label": "Previous page",
        type: _ctx.as === "button" ? "button" : void 0,
        "aria-disabled": disabled.value || void 0,
        "data-disabled": disabled.value || void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => unref(rootContext).prevPage(props2.prevPage))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { disabled: disabled.value }, () => [_cache[1] || (_cache[1] = createTextVNode(" Prev page "))])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "type",
        "aria-disabled",
        "data-disabled",
        "disabled"
      ]);
    };
  }
});
var RangeCalendarPrev_default = RangeCalendarPrev_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerPrev.js
var DateRangePickerPrev_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerPrev",
  props: {
    prevPage: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RangeCalendarPrev_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx((slotProps) => [renderSlot(_ctx.$slots, "default", normalizeProps(guardReactiveProps(slotProps)))]),
        _: 3
      }, 16);
    };
  }
});
var DateRangePickerPrev_default = DateRangePickerPrev_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DateRangePicker/DateRangePickerTrigger.js
var DateRangePickerTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DateRangePickerTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDateRangePickerRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopoverTrigger_default), mergeProps({ "data-reka-date-field-segment": "trigger" }, props2, {
        disabled: unref(rootContext).disabled.value,
        onFocusin: _cache[0] || (_cache[0] = (e) => {
          unref(rootContext).dateFieldRef.value?.setFocusedElement(e.target);
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["disabled"]);
    };
  }
});
var DateRangePickerTrigger_default = DateRangePickerTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuArrow.js
var DropdownMenuArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuArrow_default = DropdownMenuArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuCheckboxItem.js
var DropdownMenuCheckboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuCheckboxItem",
  props: {
    modelValue: {
      type: [Boolean, String],
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuCheckboxItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuCheckboxItem_default = DropdownMenuCheckboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuRoot.js
var [injectDropdownMenuRootContext, provideDropdownMenuRootContext] = createContext("DropdownMenuRoot");
var DropdownMenuRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuRoot",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    dir: {
      type: String,
      required: false
    },
    modal: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    useForwardExpose();
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const triggerElement = ref();
    const { modal, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    provideDropdownMenuRootContext({
      open,
      onOpenChange: (value) => {
        open.value = value;
      },
      onOpenToggle: () => {
        open.value = !open.value;
      },
      triggerId: "",
      triggerElement,
      contentId: "",
      modal,
      dir
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRoot_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null),
        dir: unref(dir),
        modal: unref(modal)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      }, 8, [
        "open",
        "dir",
        "modal"
      ]);
    };
  }
});
var DropdownMenuRoot_default = DropdownMenuRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuContent.js
var DropdownMenuContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    const rootContext = injectDropdownMenuRootContext();
    const hasInteractedOutsideRef = ref(false);
    function handleCloseAutoFocus(event) {
      if (event.defaultPrevented) return;
      if (!hasInteractedOutsideRef.value) setTimeout(() => {
        rootContext.triggerElement.value?.focus();
      }, 0);
      hasInteractedOutsideRef.value = false;
      event.preventDefault();
    }
    rootContext.contentId ||= useId2(void 0, "reka-dropdown-menu-content");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuContent_default), mergeProps(unref(forwarded), {
        id: unref(rootContext).contentId,
        "aria-labelledby": unref(rootContext)?.triggerId,
        style: {
          "--reka-dropdown-menu-content-transform-origin": "var(--reka-popper-transform-origin)",
          "--reka-dropdown-menu-content-available-width": "var(--reka-popper-available-width)",
          "--reka-dropdown-menu-content-available-height": "var(--reka-popper-available-height)",
          "--reka-dropdown-menu-trigger-width": "var(--reka-popper-anchor-width)",
          "--reka-dropdown-menu-trigger-height": "var(--reka-popper-anchor-height)"
        },
        onCloseAutoFocus: handleCloseAutoFocus,
        onInteractOutside: _cache[0] || (_cache[0] = (event) => {
          if (event.defaultPrevented) return;
          const originalEvent = event.detail.originalEvent;
          const ctrlLeftClick = originalEvent.button === 0 && originalEvent.ctrlKey === true;
          const isRightClick = originalEvent.button === 2 || ctrlLeftClick;
          if (!unref(rootContext).modal.value || isRightClick) hasInteractedOutsideRef.value = true;
          if (unref(rootContext).triggerElement.value?.contains(event.target)) event.preventDefault();
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id", "aria-labelledby"]);
    };
  }
});
var DropdownMenuContent_default = DropdownMenuContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuGroup.js
var DropdownMenuGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuGroup_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuGroup_default = DropdownMenuGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuItem.js
var DropdownMenuItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuItem",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuItem_default = DropdownMenuItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuItemIndicator.js
var DropdownMenuItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuItemIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItemIndicator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuItemIndicator_default = DropdownMenuItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuLabel.js
var DropdownMenuLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuLabel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuLabel_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuLabel_default = DropdownMenuLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuPortal.js
var DropdownMenuPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuPortal_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuPortal_default = DropdownMenuPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuRadioGroup.js
var DropdownMenuRadioGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuRadioGroup",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioGroup_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuRadioGroup_default = DropdownMenuRadioGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuRadioItem.js
var DropdownMenuRadioItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuRadioItem",
  props: {
    value: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioItem_default), normalizeProps(guardReactiveProps(unref(forwarded))), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuRadioItem_default = DropdownMenuRadioItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuSeparator.js
var DropdownMenuSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSeparator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuSeparator_default = DropdownMenuSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuSub.js
var DropdownMenuSub_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuSub",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const open = useVModel(props2, "open", emit, {
      passive: props2.open === void 0,
      defaultValue: props2.defaultOpen ?? false
    });
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSub_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      }, 8, ["open"]);
    };
  }
});
var DropdownMenuSub_default = DropdownMenuSub_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuSubContent.js
var DropdownMenuSubContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuSubContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubContent_default), mergeProps(unref(forwarded), { style: {
        "--reka-dropdown-menu-content-transform-origin": "var(--reka-popper-transform-origin)",
        "--reka-dropdown-menu-content-available-width": "var(--reka-popper-available-width)",
        "--reka-dropdown-menu-content-available-height": "var(--reka-popper-available-height)",
        "--reka-dropdown-menu-trigger-width": "var(--reka-popper-anchor-width)",
        "--reka-dropdown-menu-trigger-height": "var(--reka-popper-anchor-height)"
      } }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuSubContent_default = DropdownMenuSubContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuSubTrigger.js
var DropdownMenuSubTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuSubTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubTrigger_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var DropdownMenuSubTrigger_default = DropdownMenuSubTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/DropdownMenu/DropdownMenuTrigger.js
var DropdownMenuTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "DropdownMenuTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectDropdownMenuRootContext();
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    onMounted(() => {
      rootContext.triggerElement = triggerElement;
    });
    rootContext.triggerId ||= useId2(void 0, "reka-dropdown-menu-trigger");
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuAnchor_default), { "as-child": "" }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          id: unref(rootContext).triggerId,
          ref: unref(forwardRef),
          type: _ctx.as === "button" ? "button" : void 0,
          "as-child": props2.asChild,
          as: _ctx.as,
          "aria-haspopup": "menu",
          "aria-expanded": unref(rootContext).open.value,
          "aria-controls": unref(rootContext).open.value ? unref(rootContext).contentId : void 0,
          "data-disabled": _ctx.disabled ? "" : void 0,
          disabled: _ctx.disabled,
          "data-state": unref(rootContext).open.value ? "open" : "closed",
          onClick: _cache[0] || (_cache[0] = async (event) => {
            if (!_ctx.disabled && event.button === 0 && event.ctrlKey === false) {
              unref(rootContext)?.onOpenToggle();
              await nextTick();
              if (unref(rootContext).open.value) event.preventDefault();
            }
          }),
          onKeydown: _cache[1] || (_cache[1] = withKeys((event) => {
            if (_ctx.disabled) return;
            if (["Enter", " "].includes(event.key)) unref(rootContext).onOpenToggle();
            if (event.key === "ArrowDown") unref(rootContext).onOpenChange(true);
            if ([
              "Enter",
              " ",
              "ArrowDown"
            ].includes(event.key)) event.preventDefault();
          }, [
            "enter",
            "space",
            "arrow-down"
          ]))
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "id",
          "type",
          "as-child",
          "as",
          "aria-expanded",
          "aria-controls",
          "data-disabled",
          "disabled",
          "data-state"
        ])]),
        _: 3
      });
    };
  }
});
var DropdownMenuTrigger_default = DropdownMenuTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableRoot.js
var [injectEditableRootContext, provideEditableRootContext] = createContext("EditableRoot");
var EditableRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "EditableRoot",
  props: {
    defaultValue: {
      type: String,
      required: false
    },
    modelValue: {
      type: [String, null],
      required: false
    },
    placeholder: {
      type: [String, Object],
      required: false,
      default: "Enter text..."
    },
    dir: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    readonly: {
      type: Boolean,
      required: false
    },
    activationMode: {
      type: String,
      required: false,
      default: "focus"
    },
    selectOnFocus: {
      type: Boolean,
      required: false,
      default: false
    },
    submitMode: {
      type: String,
      required: false,
      default: "blur"
    },
    startWithEditMode: {
      type: Boolean,
      required: false
    },
    maxLength: {
      type: Number,
      required: false
    },
    autoResize: {
      type: Boolean,
      required: false,
      default: false
    },
    id: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: [
    "update:modelValue",
    "submit",
    "update:state"
  ],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { id, name, defaultValue, startWithEditMode, placeholder: propPlaceholder, maxLength, disabled, dir: propDir, submitMode, activationMode, selectOnFocus, readonly, autoResize, required } = toRefs(props2);
    const inputRef = ref();
    const dir = useDirection(propDir);
    const isEditing = ref(startWithEditMode.value ?? false);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: defaultValue.value ?? "",
      passive: props2.modelValue === void 0
    });
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const isFormControl = useFormControl(currentElement);
    const placeholder = computed(() => {
      return typeof propPlaceholder.value === "string" ? {
        edit: propPlaceholder.value,
        preview: propPlaceholder.value
      } : propPlaceholder.value;
    });
    const inputValue = ref(modelValue.value);
    watch(() => modelValue.value, () => {
      inputValue.value = modelValue.value;
    }, {
      immediate: true,
      deep: true
    });
    function cancel() {
      isEditing.value = false;
      emits("update:state", "cancel");
    }
    function edit() {
      isEditing.value = true;
      inputValue.value = modelValue.value;
      emits("update:state", "edit");
    }
    function submit() {
      modelValue.value = inputValue.value;
      isEditing.value = false;
      emits("update:state", "submit");
      emits("submit", inputValue.value);
    }
    function handleDismiss() {
      if (isEditing.value) if (submitMode.value === "blur" || submitMode.value === "both") submit();
      else cancel();
    }
    const pointerDownOutside = usePointerDownOutside(() => handleDismiss(), currentElement, isEditing);
    const focusOutside = useFocusOutside(() => handleDismiss(), currentElement, isEditing);
    const isEmpty = computed(() => modelValue.value === "");
    __expose({
      submit,
      cancel,
      edit
    });
    provideEditableRootContext({
      id,
      name,
      disabled,
      isEditing,
      maxLength,
      modelValue,
      inputValue,
      placeholder,
      edit,
      cancel,
      submit,
      activationMode,
      submitMode,
      selectOnFocus,
      inputRef,
      startWithEditMode,
      isEmpty,
      readonly,
      autoResize
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        as: _ctx.as,
        "as-child": _ctx.asChild,
        dir: unref(dir),
        "data-dismissable-layer": "",
        onFocusCapture: unref(focusOutside).onFocusCapture,
        onBlurCapture: unref(focusOutside).onBlurCapture,
        onPointerdownCapture: unref(pointerDownOutside).onPointerDownCapture
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          isEditing: isEditing.value,
          isEmpty: isEmpty.value,
          submit,
          cancel,
          edit
        }), unref(isFormControl) && unref(name) ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          type: "text",
          value: unref(modelValue),
          name: unref(name),
          disabled: unref(disabled),
          required: unref(required)
        }, null, 8, [
          "value",
          "name",
          "disabled",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "dir",
        "onFocusCapture",
        "onBlurCapture",
        "onPointerdownCapture"
      ]);
    };
  }
});
var EditableRoot_default = EditableRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableArea.js
var EditableArea_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditableArea",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectEditableRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "data-placeholder-shown": unref(context2).isEditing.value ? void 0 : "",
        "data-focus": unref(context2).isEditing.value ? "" : void 0,
        "data-focused": unref(context2).isEditing.value ? "" : void 0,
        "data-empty": unref(context2).isEmpty.value ? "" : void 0,
        "data-readonly": unref(context2).readonly.value ? "" : void 0,
        "data-disabled": unref(context2).disabled.value ? "" : void 0,
        style: unref(context2).autoResize.value ? { display: "inline-grid" } : void 0
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "data-placeholder-shown",
        "data-focus",
        "data-focused",
        "data-empty",
        "data-readonly",
        "data-disabled",
        "style"
      ]);
    };
  }
});
var EditableArea_default = EditableArea_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableCancelTrigger.js
var EditableCancelTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditableCancelTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectEditableRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "cancel",
        "aria-disabled": unref(context2).disabled.value ? "" : void 0,
        "data-disabled": unref(context2).disabled.value ? "" : void 0,
        disabled: unref(context2).disabled.value,
        type: _ctx.as === "button" ? "button" : void 0,
        hidden: unref(context2).isEditing.value ? void 0 : "",
        onClick: unref(context2).cancel
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("Cancel"))])]),
        _: 3
      }, 16, [
        "aria-disabled",
        "data-disabled",
        "disabled",
        "type",
        "hidden",
        "onClick"
      ]);
    };
  }
});
var EditableCancelTrigger_default = EditableCancelTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableEditTrigger.js
var EditableEditTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditableEditTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectEditableRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "edit",
        "aria-disabled": unref(context2).disabled.value ? "" : void 0,
        "data-disabled": unref(context2).disabled.value ? "" : void 0,
        disabled: unref(context2).disabled.value,
        type: _ctx.as === "button" ? "button" : void 0,
        hidden: unref(context2).isEditing.value ? "" : void 0,
        onClick: unref(context2).edit
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("Edit"))])]),
        _: 3
      }, 16, [
        "aria-disabled",
        "data-disabled",
        "disabled",
        "type",
        "hidden",
        "onClick"
      ]);
    };
  }
});
var EditableEditTrigger_default = EditableEditTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableInput.js
var EditableInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditableInput",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "input"
    }
  },
  setup(__props) {
    const props2 = __props;
    const kbd = useKbd();
    const context2 = injectEditableRootContext();
    const disabled = computed(() => context2.disabled.value);
    const placeholder = computed(() => context2.placeholder.value?.edit);
    const { primitiveElement, currentElement: inputRef } = usePrimitiveElement();
    onMounted(() => {
      context2.inputRef.value = inputRef.value;
      if (context2.startWithEditMode.value) {
        context2.inputRef.value?.focus({ preventScroll: true });
        if (context2.selectOnFocus.value) context2.inputRef.value?.select();
      }
    });
    watch(context2.isEditing, (value) => {
      if (value) nextTick(() => {
        context2.inputRef.value?.focus({ preventScroll: true });
        if (context2.selectOnFocus.value) context2.inputRef.value?.select();
      });
    });
    function handleSubmitKeyDown(event) {
      if ((context2.submitMode.value === "enter" || context2.submitMode.value === "both") && event.key === kbd.ENTER && !event.shiftKey && !event.metaKey) context2.submit();
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        ref_key: "primitiveElement",
        ref: primitiveElement
      }, props2, {
        value: unref(context2).inputValue.value,
        placeholder: placeholder.value,
        disabled: disabled.value,
        maxlength: unref(context2).maxLength.value,
        "data-disabled": disabled.value ? "" : void 0,
        "data-readonly": unref(context2).readonly.value ? "" : void 0,
        readonly: unref(context2).readonly.value,
        "aria-label": "editable input",
        hidden: unref(context2).autoResize.value ? void 0 : !unref(context2).isEditing.value,
        style: unref(context2).autoResize.value ? {
          all: "unset",
          gridArea: "1 / 1 / auto / auto",
          visibility: !unref(context2).isEditing.value ? "hidden" : void 0
        } : void 0,
        onInput: _cache[0] || (_cache[0] = ($event) => unref(context2).inputValue.value = $event.target.value),
        onKeydown: [withKeys(handleSubmitKeyDown, ["enter", "space"]), withKeys(unref(context2).cancel, ["esc"])]
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "value",
        "placeholder",
        "disabled",
        "maxlength",
        "data-disabled",
        "data-readonly",
        "readonly",
        "hidden",
        "style",
        "onKeydown"
      ]);
    };
  }
});
var EditableInput_default = EditableInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditablePreview.js
var EditablePreview_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditablePreview",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectEditableRootContext();
    const placeholder = computed(() => context2.placeholder.value?.preview);
    function handleFocus() {
      if (context2.activationMode.value === "focus") context2.edit();
    }
    function handleDoubleClick() {
      if (context2.activationMode.value === "dblclick") context2.edit();
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        tabindex: "0",
        "data-placeholder-shown": unref(context2).isEditing.value ? void 0 : "",
        hidden: unref(context2).autoResize.value ? void 0 : unref(context2).isEditing.value,
        style: unref(context2).autoResize.value ? {
          whiteSpace: "pre",
          userSelect: "none",
          gridArea: "1 / 1 / auto / auto",
          visibility: unref(context2).isEditing.value ? "hidden" : void 0,
          overflow: "hidden",
          textOverflow: "ellipsis"
        } : void 0,
        onFocusin: handleFocus,
        onDblclick: handleDoubleClick
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [createTextVNode(toDisplayString(unref(context2).modelValue.value || placeholder.value), 1)])]),
        _: 3
      }, 16, [
        "data-placeholder-shown",
        "hidden",
        "style"
      ]);
    };
  }
});
var EditablePreview_default = EditablePreview_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Editable/EditableSubmitTrigger.js
var EditableSubmitTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "EditableSubmitTrigger",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectEditableRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "submit",
        "aria-disabled": unref(context2).disabled.value ? "" : void 0,
        "data-disabled": unref(context2).disabled.value ? "" : void 0,
        disabled: unref(context2).disabled.value,
        type: _ctx.as === "button" ? "button" : void 0,
        hidden: unref(context2).isEditing.value ? void 0 : "",
        onClick: unref(context2).submit
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("Submit"))])]),
        _: 3
      }, 16, [
        "aria-disabled",
        "data-disabled",
        "disabled",
        "type",
        "hidden",
        "onClick"
      ]);
    };
  }
});
var EditableSubmitTrigger_default = EditableSubmitTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/HoverCardArrow.js
var HoverCardArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var HoverCardArrow_default = HoverCardArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/HoverCardRoot.js
var [injectHoverCardRootContext, provideHoverCardRootContext] = createContext("HoverCardRoot");
var HoverCardRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardRoot",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false,
      default: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    openDelay: {
      type: Number,
      required: false,
      default: 700
    },
    closeDelay: {
      type: Number,
      required: false,
      default: 300
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const { openDelay, closeDelay } = toRefs(props2);
    useForwardExpose();
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const openTimerRef = ref(0);
    const closeTimerRef = ref(0);
    const hasSelectionRef = ref(false);
    const isPointerDownOnContentRef = ref(false);
    const isPointerInTransitRef = ref(false);
    const triggerElement = ref();
    function handleOpen() {
      clearTimeout(closeTimerRef.value);
      openTimerRef.value = window.setTimeout(() => open.value = true, openDelay.value);
    }
    function handleClose() {
      clearTimeout(openTimerRef.value);
      if (!hasSelectionRef.value && !isPointerDownOnContentRef.value) closeTimerRef.value = window.setTimeout(() => open.value = false, closeDelay.value);
    }
    function handleDismiss() {
      open.value = false;
    }
    provideHoverCardRootContext({
      open,
      onOpenChange(value) {
        open.value = value;
      },
      onOpen: handleOpen,
      onClose: handleClose,
      onDismiss: handleDismiss,
      hasSelectionRef,
      isPointerDownOnContentRef,
      isPointerInTransitRef,
      triggerElement
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      });
    };
  }
});
var HoverCardRoot_default = HoverCardRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/utils.js
function excludeTouch(eventHandler) {
  return (event) => event.pointerType === "touch" ? void 0 : eventHandler();
}
function getTabbableNodes(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, { acceptNode: (node) => {
    return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
  } });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}

// node_modules/reka-ui/dist/HoverCard/HoverCardContentImpl.js
var HoverCardContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardContentImpl",
  props: {
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardProps(props2);
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    const rootContext = injectHoverCardRootContext();
    const { isPointerInTransit, onPointerExit } = useGraceArea(rootContext.triggerElement, contentElement);
    syncRef(rootContext.isPointerInTransitRef, isPointerInTransit, { direction: "rtl" });
    onPointerExit(() => {
      rootContext.onClose();
    });
    const containSelection = ref(false);
    let originalBodyUserSelect;
    watchEffect((cleanupFn) => {
      if (containSelection.value) {
        const body = document.body;
        originalBodyUserSelect = body.style.userSelect || body.style.webkitUserSelect;
        body.style.userSelect = "none";
        body.style.webkitUserSelect = "none";
        cleanupFn(() => {
          body.style.userSelect = originalBodyUserSelect;
          body.style.webkitUserSelect = originalBodyUserSelect;
        });
      }
    });
    function handlePointerUp2() {
      containSelection.value = false;
      rootContext.isPointerDownOnContentRef.value = false;
      nextTick(() => {
        const hasSelection = document.getSelection()?.toString() !== "";
        if (hasSelection) rootContext.hasSelectionRef.value = true;
      });
    }
    onMounted(() => {
      if (contentElement.value) {
        document.addEventListener("pointerup", handlePointerUp2);
        const tabbables = getTabbableNodes(contentElement.value);
        tabbables.forEach((tabbable) => tabbable.setAttribute("tabindex", "-1"));
      }
    });
    onUnmounted(() => {
      document.removeEventListener("pointerup", handlePointerUp2);
      rootContext.hasSelectionRef.value = false;
      rootContext.isPointerDownOnContentRef.value = false;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DismissableLayer_default), {
        "as-child": "",
        "disable-outside-pointer-events": false,
        onEscapeKeyDown: _cache[1] || (_cache[1] = ($event) => emits("escapeKeyDown", $event)),
        onPointerDownOutside: _cache[2] || (_cache[2] = ($event) => emits("pointerDownOutside", $event)),
        onFocusOutside: _cache[3] || (_cache[3] = withModifiers(($event) => emits("focusOutside", $event), ["prevent"])),
        onDismiss: unref(rootContext).onDismiss
      }, {
        default: withCtx(() => [createVNode(unref(PopperContent_default), mergeProps({
          ...unref(forwarded),
          ..._ctx.$attrs
        }, {
          ref: unref(forwardRef),
          "data-state": unref(rootContext).open.value ? "open" : "closed",
          style: {
            "userSelect": containSelection.value ? "text" : void 0,
            "WebkitUserSelect": containSelection.value ? "text" : void 0,
            "--reka-hover-card-content-transform-origin": "var(--reka-popper-transform-origin)",
            "--reka-hover-card-content-available-width": "var(--reka-popper-available-width)",
            "--reka-hover-card-content-available-height": "var(--reka-popper-available-height)",
            "--reka-hover-card-trigger-width": "var(--reka-popper-anchor-width)",
            "--reka-hover-card-trigger-height": "var(--reka-popper-anchor-height)"
          },
          onPointerdown: _cache[0] || (_cache[0] = (event) => {
            if (event.currentTarget.contains(event.target)) containSelection.value = true;
            unref(rootContext).hasSelectionRef.value = false;
            unref(rootContext).isPointerDownOnContentRef.value = true;
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["data-state", "style"])]),
        _: 3
      }, 8, ["onDismiss"]);
    };
  }
});
var HoverCardContentImpl_default = HoverCardContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/HoverCardContent.js
var HoverCardContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const { forwardRef } = useForwardExpose();
    const rootContext = injectHoverCardRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(rootContext).open.value }, {
        default: withCtx(() => [createVNode(HoverCardContentImpl_default, mergeProps(unref(forwarded), {
          ref: unref(forwardRef),
          onPointerenter: _cache[0] || (_cache[0] = ($event) => unref(excludeTouch)(unref(rootContext).onOpen)($event))
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var HoverCardContent_default = HoverCardContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/HoverCardPortal.js
var HoverCardPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var HoverCardPortal_default = HoverCardPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/HoverCard/HoverCardTrigger.js
var HoverCardTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "HoverCardTrigger",
  props: {
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "a"
    }
  },
  setup(__props) {
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectHoverCardRootContext();
    rootContext.triggerElement = currentElement;
    function handleLeave() {
      setTimeout(() => {
        if (!rootContext.isPointerInTransitRef.value && !rootContext.open.value) rootContext.onClose();
      }, 0);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperAnchor_default), {
        "as-child": "",
        reference: _ctx.reference
      }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          "as-child": _ctx.asChild,
          as: _ctx.as,
          "data-state": unref(rootContext).open.value ? "open" : "closed",
          "data-grace-area-trigger": "",
          onPointerenter: _cache[0] || (_cache[0] = ($event) => unref(excludeTouch)(unref(rootContext).onOpen)($event)),
          onPointerleave: _cache[1] || (_cache[1] = ($event) => unref(excludeTouch)(handleLeave)($event)),
          onFocus: _cache[2] || (_cache[2] = ($event) => unref(rootContext).onOpen()),
          onBlur: _cache[3] || (_cache[3] = ($event) => unref(rootContext).onClose())
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "as-child",
          "as",
          "data-state"
        ])]),
        _: 3
      }, 8, ["reference"]);
    };
  }
});
var HoverCardTrigger_default = HoverCardTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Label/Label.js
var Label_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "Label",
  props: {
    for: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "label"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { onMousedown: _cache[0] || (_cache[0] = (event) => {
        if (!event.defaultPrevented && event.detail > 1) event.preventDefault();
      }) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var Label_default = Label_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarArrow.js
var MenubarArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuArrow_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarArrow_default = MenubarArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarCheckboxItem.js
var MenubarCheckboxItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarCheckboxItem",
  props: {
    modelValue: {
      type: [Boolean, String],
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select", "update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuCheckboxItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarCheckboxItem_default = MenubarCheckboxItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarRoot.js
var [injectMenubarRootContext, provideMenubarRootContext] = createContext("MenubarRoot");
var MenubarRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarRoot",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    defaultValue: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    loop: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const { forwardRef } = useForwardExpose();
    const { CollectionSlot } = useCollection({
      key: "Menubar",
      isProvider: true
    });
    const modelValue = useVModel(props2, "modelValue", emit, {
      defaultValue: props2.defaultValue ?? "",
      passive: props2.modelValue === void 0
    });
    const currentTabStopId = ref(null);
    const { dir: propDir, loop } = toRefs(props2);
    const dir = useDirection(propDir);
    provideMenubarRootContext({
      modelValue,
      dir,
      loop,
      onMenuOpen: (value) => {
        modelValue.value = value;
        currentTabStopId.value = value;
      },
      onMenuClose: () => {
        modelValue.value = "";
      },
      onMenuToggle: (value) => {
        modelValue.value = modelValue.value ? "" : value;
        currentTabStopId.value = value;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(RovingFocusGroup_default), {
          "current-tab-stop-id": currentTabStopId.value,
          "onUpdate:currentTabStopId": _cache[0] || (_cache[0] = ($event) => currentTabStopId.value = $event),
          orientation: "horizontal",
          loop: unref(loop),
          dir: unref(dir),
          "as-child": ""
        }, {
          default: withCtx(() => [createVNode(unref(Primitive), {
            ref: unref(forwardRef),
            role: "menubar"
          }, {
            default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
            _: 3
          }, 512)]),
          _: 3
        }, 8, [
          "current-tab-stop-id",
          "loop",
          "dir"
        ])]),
        _: 3
      });
    };
  }
});
var MenubarRoot_default = MenubarRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarMenu.js
var [injectMenubarMenuContext, provideMenubarMenuContext] = createContext("MenubarMenu");
var MenubarMenu_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarMenu",
  props: { value: {
    type: String,
    required: false
  } },
  setup(__props) {
    const props2 = __props;
    const value = useId2(props2.value);
    const rootContext = injectMenubarRootContext();
    useForwardExpose();
    const triggerElement = ref();
    const wasKeyboardTriggerOpenRef = ref(false);
    const open = computed(() => rootContext.modelValue.value === value);
    watch(open, () => {
      if (!open.value) wasKeyboardTriggerOpenRef.value = false;
    });
    provideMenubarMenuContext({
      value,
      triggerElement,
      triggerId: value,
      contentId: "",
      wasKeyboardTriggerOpenRef
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRoot_default), {
        open: open.value,
        modal: false,
        dir: unref(rootContext).dir.value,
        "onUpdate:open": _cache[0] || (_cache[0] = (value$1) => {
          if (!value$1) unref(rootContext).onMenuClose();
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["open", "dir"]);
    };
  }
});
var MenubarMenu_default = MenubarMenu_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarContent.js
var MenubarContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false,
      default: "start"
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    const rootContext = injectMenubarRootContext();
    const menuContext = injectMenubarMenuContext();
    menuContext.contentId ||= useId2(void 0, "reka-menubar-content");
    const { getItems } = useCollection({ key: "Menubar" });
    const hasInteractedOutsideRef = ref(false);
    function handleArrowNavigation(event) {
      const target = event.target;
      const targetIsSubTrigger = target.hasAttribute("data-reka-menubar-subtrigger");
      const prevMenuKey = rootContext.dir.value === "rtl" ? "ArrowRight" : "ArrowLeft";
      const isPrevKey = prevMenuKey === event.key;
      const isNextKey = !isPrevKey;
      if (isNextKey && targetIsSubTrigger) return;
      let candidateValues = getItems().filter((i) => i.ref.dataset.disabled !== "").map((i) => i.ref.dataset.value);
      if (isPrevKey) candidateValues.reverse();
      const currentIndex = candidateValues.indexOf(menuContext.value);
      candidateValues = rootContext.loop.value ? wrapArray(candidateValues, currentIndex + 1) : candidateValues.slice(currentIndex + 1);
      const [nextValue] = candidateValues;
      if (nextValue) rootContext.onMenuOpen(nextValue);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuContent_default), mergeProps(unref(forwarded), {
        id: unref(menuContext).contentId,
        "data-reka-menubar-content": "",
        "aria-labelledby": unref(menuContext).triggerId,
        style: {
          "--reka-menubar-content-transform-origin": "var(--reka-popper-transform-origin)",
          "--reka-menubar-content-available-width": "var(--reka-popper-available-width)",
          "--reka-menubar-content-available-height": "var(--reka-popper-available-height)",
          "--reka-menubar-trigger-width": "var(--reka-popper-anchor-width)",
          "--reka-menubar-trigger-height": "var(--reka-popper-anchor-height)"
        },
        onCloseAutoFocus: _cache[0] || (_cache[0] = (event) => {
          const menubarOpen = Boolean(unref(rootContext).modelValue.value);
          if (!menubarOpen && !hasInteractedOutsideRef.value) unref(menuContext).triggerElement.value?.focus();
          hasInteractedOutsideRef.value = false;
          event.preventDefault();
        }),
        onFocusOutside: _cache[1] || (_cache[1] = (event) => {
          const target = event.target;
          const isMenubarTrigger = unref(getItems)().filter((i) => i.ref.dataset.disabled !== "").some((i) => i.ref.contains(target));
          if (isMenubarTrigger) event.preventDefault();
        }),
        onInteractOutside: _cache[2] || (_cache[2] = (event) => {
          hasInteractedOutsideRef.value = true;
        }),
        onEntryFocus: _cache[3] || (_cache[3] = (event) => {
          if (!unref(menuContext).wasKeyboardTriggerOpenRef.value) event.preventDefault();
        }),
        onKeydown: withKeys(handleArrowNavigation, ["arrow-right", "arrow-left"])
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id", "aria-labelledby"]);
    };
  }
});
var MenubarContent_default = MenubarContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarGroup.js
var MenubarGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuGroup_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarGroup_default = MenubarGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarItem.js
var MenubarItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarItem",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItem_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarItem_default = MenubarItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarItemIndicator.js
var MenubarItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarItemIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuItemIndicator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarItemIndicator_default = MenubarItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarLabel.js
var MenubarLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarLabel",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuLabel_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarLabel_default = MenubarLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarPortal.js
var MenubarPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuPortal_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarPortal_default = MenubarPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarRadioGroup.js
var MenubarRadioGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarRadioGroup",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const emitsAsProps = useEmitAsProps(emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioGroup_default), normalizeProps(guardReactiveProps({
        ...props2,
        ...unref(emitsAsProps)
      })), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarRadioGroup_default = MenubarRadioGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarRadioItem.js
var MenubarRadioItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarRadioItem",
  props: {
    value: {
      type: String,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuRadioItem_default), normalizeProps(guardReactiveProps(unref(forwarded))), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarRadioItem_default = MenubarRadioItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarSeparator.js
var MenubarSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSeparator_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarSeparator_default = MenubarSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarSub.js
var MenubarSub_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarSub",
  props: {
    defaultOpen: {
      type: Boolean,
      required: false
    },
    open: {
      type: Boolean,
      required: false,
      default: void 0
    }
  },
  emits: ["update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    useForwardExpose();
    const open = useVModel(props2, "open", emit, {
      defaultValue: props2.defaultOpen ?? false,
      passive: props2.open === void 0
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSub_default), {
        open: unref(open),
        "onUpdate:open": _cache[0] || (_cache[0] = ($event) => isRef(open) ? open.value = $event : null)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { open: unref(open) })]),
        _: 3
      }, 8, ["open"]);
    };
  }
});
var MenubarSub_default = MenubarSub_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarSubContent.js
var MenubarSubContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarSubContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    loop: {
      type: Boolean,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside",
    "entryFocus",
    "openAutoFocus",
    "closeAutoFocus"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    useForwardExpose();
    const { getItems } = useCollection({ key: "Menubar" });
    const rootContext = injectMenubarRootContext();
    const menuContext = injectMenubarMenuContext();
    function handleArrowNavigation(event) {
      const target = event.target;
      const targetIsSubTrigger = target.hasAttribute("data-reka-menubar-subtrigger");
      if (targetIsSubTrigger) return;
      let candidateValues = getItems().filter((i) => i.ref.dataset.disabled !== "").map((i) => i.ref.dataset.value);
      const currentIndex = candidateValues.indexOf(menuContext.value);
      candidateValues = rootContext.loop.value ? wrapArray(candidateValues, currentIndex + 1) : candidateValues.slice(currentIndex + 1);
      const [nextValue] = candidateValues;
      if (nextValue) rootContext.onMenuOpen(nextValue);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubContent_default), mergeProps(unref(forwarded), {
        "data-reka-menubar-content": "",
        style: {
          "--reka-menubar-content-transform-origin": "var(--reka-popper-transform-origin)",
          "--reka-menubar-content-available-width": "var(--reka-popper-available-width)",
          "--reka-menubar-content-available-height": "var(--reka-popper-available-height)",
          "--reka-menubar-trigger-width": "var(--reka-popper-anchor-width)",
          "--reka-menubar-trigger-height": "var(--reka-popper-anchor-height)"
        },
        onKeydown: withKeys(handleArrowNavigation, ["arrow-right"])
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarSubContent_default = MenubarSubContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarSubTrigger.js
var MenubarSubTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarSubTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(MenuSubTrigger_default), mergeProps(props2, { "data-reka-menubar-subtrigger": "" }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var MenubarSubTrigger_default = MenubarSubTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Menubar/MenubarTrigger.js
var MenubarTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "MenubarTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const rootContext = injectMenubarRootContext();
    const menuContext = injectMenubarMenuContext();
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    const { CollectionItem } = useCollection({ key: "Menubar" });
    const isFocused = ref(false);
    const open = computed(() => rootContext.modelValue.value === menuContext.value);
    onMounted(() => {
      menuContext.triggerElement = triggerElement;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RovingFocusItem_default), {
        "as-child": "",
        focusable: !_ctx.disabled,
        "tab-stop-id": unref(menuContext).value
      }, {
        default: withCtx(() => [createVNode(unref(CollectionItem), null, {
          default: withCtx(() => [createVNode(unref(MenuAnchor_default), { "as-child": "" }, {
            default: withCtx(() => [createVNode(unref(Primitive), {
              id: unref(menuContext).triggerId,
              ref: unref(forwardRef),
              as: _ctx.as,
              "as-child": _ctx.asChild,
              type: _ctx.as === "button" ? "button" : void 0,
              role: "menuitem",
              "aria-haspopup": "menu",
              "aria-expanded": open.value,
              "aria-controls": open.value ? unref(menuContext).contentId : void 0,
              "data-highlighted": isFocused.value ? "" : void 0,
              "data-state": open.value ? "open" : "closed",
              "data-disabled": _ctx.disabled ? "" : void 0,
              disabled: _ctx.disabled,
              "data-value": unref(menuContext).value,
              onPointerdown: _cache[0] || (_cache[0] = (event) => {
                if (!_ctx.disabled && event.button === 0 && event.ctrlKey === false) {
                  unref(rootContext).onMenuOpen(unref(menuContext).value);
                  if (!open.value) event.preventDefault();
                }
              }),
              onPointerenter: _cache[1] || (_cache[1] = () => {
                const menubarOpen = Boolean(unref(rootContext).modelValue.value);
                if (menubarOpen && !open.value) {
                  unref(rootContext).onMenuOpen(unref(menuContext).value);
                  unref(triggerElement)?.focus();
                }
              }),
              onKeydown: _cache[2] || (_cache[2] = withKeys((event) => {
                if (_ctx.disabled) return;
                if (["Enter", " "].includes(event.key)) unref(rootContext).onMenuToggle(unref(menuContext).value);
                if (event.key === "ArrowDown") unref(rootContext).onMenuOpen(unref(menuContext).value);
                if ([
                  "Enter",
                  " ",
                  "ArrowDown"
                ].includes(event.key)) {
                  unref(menuContext).wasKeyboardTriggerOpenRef.value = true;
                  event.preventDefault();
                }
              }, [
                "enter",
                "space",
                "arrow-down"
              ])),
              onFocus: _cache[3] || (_cache[3] = ($event) => isFocused.value = true),
              onBlur: _cache[4] || (_cache[4] = ($event) => isFocused.value = false)
            }, {
              default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
              _: 3
            }, 8, [
              "id",
              "as",
              "as-child",
              "type",
              "aria-expanded",
              "aria-controls",
              "data-highlighted",
              "data-state",
              "data-disabled",
              "disabled",
              "data-value"
            ])]),
            _: 3
          })]),
          _: 3
        })]),
        _: 3
      }, 8, ["focusable", "tab-stop-id"]);
    };
  }
});
var MenubarTrigger_default = MenubarTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuRoot.js
var [injectNavigationMenuContext, provideNavigationMenuContext] = createContext(["NavigationMenuRoot", "NavigationMenuSub"], "NavigationMenuContext");
var NavigationMenuRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NavigationMenuRoot",
  props: {
    modelValue: {
      type: String,
      required: false,
      default: void 0
    },
    defaultValue: {
      type: String,
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    orientation: {
      type: String,
      required: false,
      default: "horizontal"
    },
    delayDuration: {
      type: Number,
      required: false,
      default: 200
    },
    skipDelayDuration: {
      type: Number,
      required: false,
      default: 300
    },
    disableClickTrigger: {
      type: Boolean,
      required: false,
      default: false
    },
    disableHoverTrigger: {
      type: Boolean,
      required: false,
      default: false
    },
    disablePointerLeaveClose: {
      type: Boolean,
      required: false
    },
    unmountOnHide: {
      type: Boolean,
      required: false,
      default: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "nav"
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? "",
      passive: props2.modelValue === void 0
    });
    const previousValue = ref("");
    const { forwardRef, currentElement: rootNavigationMenu } = useForwardExpose();
    const indicatorTrack = ref();
    const viewport = ref();
    const activeTrigger = ref();
    const { getItems, CollectionSlot } = useCollection({
      key: "NavigationMenu",
      isProvider: true
    });
    const { delayDuration, skipDelayDuration, dir: propDir, disableClickTrigger, disableHoverTrigger, unmountOnHide } = toRefs(props2);
    const dir = useDirection(propDir);
    const isDelaySkipped = refAutoReset(false, skipDelayDuration);
    const computedDelay = computed(() => {
      const isOpen = modelValue.value !== "";
      if (isOpen || isDelaySkipped.value) return 150;
      else return delayDuration.value;
    });
    const debouncedFn = useDebounceFn((val) => {
      if (typeof val === "string") {
        previousValue.value = modelValue.value;
        modelValue.value = val;
      }
    }, computedDelay);
    watchEffect(() => {
      if (!modelValue.value) return;
      const items = getItems().map((i) => i.ref);
      activeTrigger.value = items.find((item) => item.id.includes(modelValue.value));
    });
    provideNavigationMenuContext({
      isRootMenu: true,
      modelValue,
      previousValue,
      baseId: useId2(void 0, "reka-navigation-menu"),
      disableClickTrigger,
      disableHoverTrigger,
      dir,
      unmountOnHide,
      orientation: props2.orientation,
      rootNavigationMenu,
      indicatorTrack,
      activeTrigger,
      onIndicatorTrackChange: (val) => {
        indicatorTrack.value = val;
      },
      viewport,
      onViewportChange: (val) => {
        viewport.value = val;
      },
      onTriggerEnter: (val) => {
        debouncedFn(val);
      },
      onTriggerLeave: () => {
        isDelaySkipped.value = true;
        debouncedFn("");
      },
      onContentEnter: () => {
        debouncedFn();
      },
      onContentLeave: () => {
        if (!props2.disablePointerLeaveClose) debouncedFn("");
      },
      onItemSelect: (val) => {
        previousValue.value = modelValue.value;
        modelValue.value = val;
      },
      onItemDismiss: () => {
        previousValue.value = modelValue.value;
        modelValue.value = "";
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          "aria-label": "Main",
          as: _ctx.as,
          "as-child": _ctx.asChild,
          "data-orientation": _ctx.orientation,
          dir: unref(dir),
          "data-reka-navigation-menu": ""
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
          _: 3
        }, 8, [
          "as",
          "as-child",
          "data-orientation",
          "dir"
        ])]),
        _: 3
      });
    };
  }
});
var NavigationMenuRoot_default = NavigationMenuRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/utils.js
function getOpenState2(open) {
  return open ? "open" : "closed";
}
function makeTriggerId(baseId, value) {
  return `${baseId}-trigger-${value}`;
}
function makeContentId(baseId, value) {
  return `${baseId}-content-${value}`;
}
var LINK_SELECT = "navigationMenu.linkSelect";
var EVENT_ROOT_CONTENT_DISMISS = "navigationMenu.rootContentDismiss";
function getTabbableCandidates2(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, { acceptNode: (node) => {
    const isHiddenInput = node.tagName === "INPUT" && node.type === "hidden";
    if (node.disabled || node.hidden || isHiddenInput) return NodeFilter.FILTER_SKIP;
    return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
  } });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}
function focusFirst4(candidates) {
  const previouslyFocusedElement = getActiveElement();
  return candidates.some((candidate) => {
    if (candidate === previouslyFocusedElement) return true;
    candidate.focus();
    return getActiveElement() !== previouslyFocusedElement;
  });
}
function removeFromTabOrder(candidates) {
  candidates.forEach((candidate) => {
    candidate.dataset.tabindex = candidate.getAttribute("tabindex") || "";
    candidate.setAttribute("tabindex", "-1");
  });
  return () => {
    candidates.forEach((candidate) => {
      const prevTabIndex = candidate.dataset.tabindex;
      candidate.setAttribute("tabindex", prevTabIndex);
    });
  };
}
function whenMouse(handler) {
  return (event) => event.pointerType === "mouse" ? handler(event) : void 0;
}

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuItem.js
var [injectNavigationMenuItemContext, provideNavigationMenuItemContext] = createContext("NavigationMenuItem");
var NavigationMenuItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NavigationMenuItem",
  props: {
    value: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "li"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const { getItems } = useCollection({ key: "NavigationMenu" });
    const context2 = injectNavigationMenuContext();
    const value = useId2(props2.value);
    const triggerRef2 = ref();
    const focusProxyRef = ref();
    const contentId = makeContentId(context2.baseId, value);
    let restoreContentTabOrderRef = () => ({});
    const wasEscapeCloseRef = ref(false);
    async function handleContentEntry(side = "start") {
      const el = document.getElementById(contentId);
      if (el) {
        restoreContentTabOrderRef();
        const candidates = getTabbableCandidates2(el);
        if (candidates.length) focusFirst4(side === "start" ? candidates : candidates.reverse());
      }
    }
    function handleContentExit() {
      const el = document.getElementById(contentId);
      if (el) {
        const candidates = getTabbableCandidates2(el);
        if (candidates.length) restoreContentTabOrderRef = removeFromTabOrder(candidates);
      }
    }
    provideNavigationMenuItemContext({
      value,
      contentId,
      triggerRef: triggerRef2,
      focusProxyRef,
      wasEscapeCloseRef,
      onEntryKeyDown: handleContentEntry,
      onFocusProxyEnter: handleContentEntry,
      onContentFocusOutside: handleContentExit,
      onRootContentClose: handleContentExit
    });
    function handleClose() {
      context2.onItemDismiss();
      triggerRef2.value?.focus();
    }
    function handleKeydown(ev) {
      const currentFocus = getActiveElement();
      if (ev.keyCode === 32 || ev.key === "Enter") if (context2.modelValue.value === value) {
        handleClose();
        ev.preventDefault();
        return;
      } else {
        ev.target.click();
        ev.preventDefault();
        return;
      }
      const itemsArray = getItems().filter((i) => i.ref.parentElement?.hasAttribute("data-menu-item")).map((i) => i.ref);
      if (!itemsArray.includes(currentFocus)) return;
      const newSelectedElement = useArrowNavigation(ev, currentFocus, void 0, {
        itemsArray,
        loop: false
      });
      if (newSelectedElement) newSelectedElement?.focus();
      ev.preventDefault();
      ev.stopPropagation();
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "as-child": _ctx.asChild,
        as: _ctx.as,
        "data-menu-item": "",
        onKeydown: withKeys(handleKeydown, [
          "up",
          "down",
          "left",
          "right",
          "home",
          "end",
          "space"
        ])
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as-child", "as"]);
    };
  }
});
var NavigationMenuItem_default = NavigationMenuItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuContentImpl.js
var NavigationMenuContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NavigationMenuContentImpl",
  props: {
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { getItems } = useCollection({ key: "NavigationMenu" });
    const { forwardRef, currentElement } = useForwardExpose();
    const menuContext = injectNavigationMenuContext();
    const itemContext = injectNavigationMenuItemContext();
    const triggerId = makeTriggerId(menuContext.baseId, itemContext.value);
    const contentId = makeContentId(menuContext.baseId, itemContext.value);
    const prevMotionAttributeRef = ref(null);
    const motionAttribute = computed(() => {
      const values = getItems().map((i) => i.ref.id.split("trigger-")[1]);
      if (menuContext.dir.value === "rtl") values.reverse();
      const index = values.indexOf(menuContext.modelValue.value);
      const prevIndex = values.indexOf(menuContext.previousValue.value);
      const isSelected = itemContext.value === menuContext.modelValue.value;
      const wasSelected = prevIndex === values.indexOf(itemContext.value);
      if (!isSelected && !wasSelected) return prevMotionAttributeRef.value;
      const attribute = (() => {
        if (index !== prevIndex) {
          if (isSelected && prevIndex !== -1) return index > prevIndex ? "from-end" : "from-start";
          if (wasSelected && index !== -1) return index > prevIndex ? "to-start" : "to-end";
        }
        return null;
      })();
      prevMotionAttributeRef.value = attribute;
      return attribute;
    });
    function handleFocusOutside(ev) {
      emits("focusOutside", ev);
      emits("interactOutside", ev);
      const target = ev.detail.originalEvent.target;
      if (target.hasAttribute("data-navigation-menu-trigger")) ev.preventDefault();
      if (!ev.defaultPrevented) {
        itemContext.onContentFocusOutside();
        const target$1 = ev.target;
        if (menuContext.rootNavigationMenu?.value?.contains(target$1)) ev.preventDefault();
      }
    }
    function handlePointerDownOutside(ev) {
      emits("pointerDownOutside", ev);
      if (!ev.defaultPrevented) {
        const target = ev.target;
        const isTrigger = getItems().some((i) => i.ref.contains(target));
        const isRootViewport = menuContext.isRootMenu && menuContext.viewport.value?.contains(target);
        if (isTrigger || isRootViewport || !menuContext.isRootMenu) ev.preventDefault();
      }
    }
    watchEffect((cleanupFn) => {
      const content = currentElement.value;
      if (menuContext.isRootMenu && content) {
        const handleClose = () => {
          menuContext.onItemDismiss();
          itemContext.onRootContentClose();
          if (content.contains(getActiveElement())) itemContext.triggerRef.value?.focus();
        };
        content.addEventListener(EVENT_ROOT_CONTENT_DISMISS, handleClose);
        cleanupFn(() => content.removeEventListener(EVENT_ROOT_CONTENT_DISMISS, handleClose));
      }
    });
    function handleEscapeKeyDown(ev) {
      emits("escapeKeyDown", ev);
      if (!ev.defaultPrevented) {
        menuContext.onItemDismiss();
        itemContext.triggerRef?.value?.focus();
        itemContext.wasEscapeCloseRef.value = true;
      }
    }
    function handleKeydown(ev) {
      if (ev.target.closest("[data-reka-navigation-menu]") !== menuContext.rootNavigationMenu.value) return;
      const isMetaKey = ev.altKey || ev.ctrlKey || ev.metaKey;
      const isTabKey = ev.key === "Tab" && !isMetaKey;
      const candidates = getTabbableCandidates2(ev.currentTarget);
      if (isTabKey) {
        const focusedElement = getActiveElement();
        const index = candidates.findIndex((candidate) => candidate === focusedElement);
        const isMovingBackwards = ev.shiftKey;
        const nextCandidates = isMovingBackwards ? candidates.slice(0, index).reverse() : candidates.slice(index + 1, candidates.length);
        if (focusFirst4(nextCandidates)) ev.preventDefault();
        else {
          itemContext.focusProxyRef.value?.focus();
          return;
        }
      }
      const newSelectedElement = useArrowNavigation(ev, getActiveElement(), void 0, {
        itemsArray: candidates,
        loop: false,
        enableIgnoredElement: true
      });
      newSelectedElement?.focus();
    }
    function handleDismiss() {
      const rootContentDismissEvent = new Event(EVENT_ROOT_CONTENT_DISMISS, {
        bubbles: true,
        cancelable: true
      });
      currentElement.value?.dispatchEvent(rootContentDismissEvent);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(DismissableLayer_default), mergeProps({
        id: unref(contentId),
        ref: unref(forwardRef),
        "aria-labelledby": unref(triggerId),
        "data-motion": motionAttribute.value,
        "data-state": unref(getOpenState2)(unref(menuContext).modelValue.value === unref(itemContext).value),
        "data-orientation": unref(menuContext).orientation
      }, props2, {
        onKeydown: handleKeydown,
        onEscapeKeyDown: handleEscapeKeyDown,
        onPointerDownOutside: handlePointerDownOutside,
        onFocusOutside: handleFocusOutside,
        onDismiss: handleDismiss
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "id",
        "aria-labelledby",
        "data-motion",
        "data-state",
        "data-orientation"
      ]);
    };
  }
});
var NavigationMenuContentImpl_default = NavigationMenuContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuContent.js
var NavigationMenuContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: [
    "escapeKeyDown",
    "pointerDownOutside",
    "focusOutside",
    "interactOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(reactiveOmit(props2, "forceMount"), emits);
    const { forwardRef } = useForwardExpose();
    const menuContext = injectNavigationMenuContext();
    const itemContext = injectNavigationMenuItemContext();
    const open = computed(() => itemContext.value === menuContext.modelValue.value);
    const isLastActiveValue = computed(() => {
      if (menuContext.viewport.value) {
        if (!menuContext.modelValue.value && menuContext.previousValue.value) return menuContext.previousValue.value === itemContext.value;
      }
      return false;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Teleport, {
        to: unref(isClient) && unref(menuContext).viewport.value ? unref(menuContext).viewport.value : "body",
        disabled: unref(isClient) && unref(menuContext).viewport.value ? !unref(menuContext).viewport.value : true
      }, [createVNode(unref(Presence_default), {
        present: _ctx.forceMount || open.value || isLastActiveValue.value,
        "force-mount": !unref(menuContext).unmountOnHide.value
      }, {
        default: withCtx(({ present }) => [createVNode(NavigationMenuContentImpl_default, mergeProps({
          ref: unref(forwardRef),
          "data-state": unref(getOpenState2)(open.value),
          style: { pointerEvents: !open.value && unref(menuContext).isRootMenu ? "none" : void 0 }
        }, {
          ..._ctx.$attrs,
          ...unref(forwarded)
        }, {
          hidden: !present,
          onPointerenter: _cache[0] || (_cache[0] = ($event) => unref(menuContext).onContentEnter(unref(itemContext).value)),
          onPointerleave: _cache[1] || (_cache[1] = ($event) => unref(whenMouse)(() => unref(menuContext).onContentLeave())($event)),
          onPointerDownOutside: _cache[2] || (_cache[2] = ($event) => emits("pointerDownOutside", $event)),
          onFocusOutside: _cache[3] || (_cache[3] = ($event) => emits("focusOutside", $event)),
          onInteractOutside: _cache[4] || (_cache[4] = ($event) => emits("interactOutside", $event))
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 2
        }, 1040, [
          "data-state",
          "style",
          "hidden"
        ])]),
        _: 3
      }, 8, ["present", "force-mount"])], 8, ["to", "disabled"]);
    };
  }
});
var NavigationMenuContent_default = NavigationMenuContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuIndicator.js
var NavigationMenuIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef } = useForwardExpose();
    const menuContext = injectNavigationMenuContext();
    const indicatorStyle = ref();
    const isHorizontal = computed(() => menuContext.orientation === "horizontal");
    const isVisible = computed(() => !!menuContext.modelValue.value);
    const { activeTrigger } = menuContext;
    function handlePositionChange() {
      if (!activeTrigger.value) return;
      indicatorStyle.value = {
        size: isHorizontal.value ? activeTrigger.value.offsetWidth : activeTrigger.value.offsetHeight,
        position: isHorizontal.value ? activeTrigger.value.offsetLeft : activeTrigger.value.offsetTop
      };
    }
    watchEffect(() => {
      if (!menuContext.modelValue.value) return;
      handlePositionChange();
    });
    useResizeObserver(activeTrigger, handlePositionChange);
    useResizeObserver(menuContext.indicatorTrack, handlePositionChange);
    return (_ctx, _cache) => {
      return unref(menuContext).indicatorTrack.value ? (openBlock(), createBlock(Teleport, {
        key: 0,
        to: unref(menuContext).indicatorTrack.value
      }, [createVNode(unref(Presence_default), { present: _ctx.forceMount || isVisible.value }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          ref: unref(forwardRef),
          "aria-hidden": "true",
          "data-state": isVisible.value ? "visible" : "hidden",
          "data-orientation": unref(menuContext).orientation,
          "as-child": props2.asChild,
          as: _ctx.as,
          style: { ...indicatorStyle.value ? {
            "--reka-navigation-menu-indicator-size": `${indicatorStyle.value.size}px`,
            "--reka-navigation-menu-indicator-position": `${indicatorStyle.value.position}px`
          } : {} }
        }, _ctx.$attrs), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "data-state",
          "data-orientation",
          "as-child",
          "as",
          "style"
        ])]),
        _: 3
      }, 8, ["present"])], 8, ["to"])) : createCommentVNode("v-if", true);
    };
  }
});
var NavigationMenuIndicator_default = NavigationMenuIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuLink.js
var NavigationMenuLink_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NavigationMenuLink",
  props: {
    active: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "a"
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { CollectionItem } = useCollection({ key: "NavigationMenu" });
    useForwardExpose();
    async function handleClick(ev) {
      const linkSelectEvent = new CustomEvent(LINK_SELECT, {
        bubbles: true,
        cancelable: true,
        detail: { originalEvent: ev }
      });
      emits("select", linkSelectEvent);
      if (!linkSelectEvent.defaultPrevented && !ev.metaKey) {
        const rootContentDismissEvent = new CustomEvent(EVENT_ROOT_CONTENT_DISMISS, {
          bubbles: true,
          cancelable: true
        });
        ev.target?.dispatchEvent(rootContentDismissEvent);
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          as: _ctx.as,
          "data-active": _ctx.active ? "" : void 0,
          "aria-current": _ctx.active ? "page" : void 0,
          "as-child": props2.asChild,
          onClick: handleClick
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "as",
          "data-active",
          "aria-current",
          "as-child"
        ])]),
        _: 3
      });
    };
  }
});
var NavigationMenuLink_default = NavigationMenuLink_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuList.js
var NavigationMenuList_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuList",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "ul"
    }
  },
  setup(__props) {
    const props2 = __props;
    const menuContext = injectNavigationMenuContext();
    const { forwardRef, currentElement } = useForwardExpose();
    onMounted(() => {
      menuContext.onIndicatorTrackChange(currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        style: { "position": "relative" }
      }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps(_ctx.$attrs, {
          "as-child": props2.asChild,
          as: _ctx.as,
          "data-orientation": unref(menuContext).orientation
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "as-child",
          "as",
          "data-orientation"
        ])]),
        _: 3
      }, 512);
    };
  }
});
var NavigationMenuList_default = NavigationMenuList_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuSub.js
var NavigationMenuSub_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NavigationMenuSub",
  props: {
    modelValue: {
      type: String,
      required: false
    },
    defaultValue: {
      type: String,
      required: false
    },
    orientation: {
      type: String,
      required: false,
      default: "horizontal"
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? "",
      passive: props2.modelValue === void 0
    });
    const previousValue = ref("");
    const menuContext = injectNavigationMenuContext();
    const { forwardRef, currentElement } = useForwardExpose();
    const indicatorTrack = ref();
    const viewport = ref();
    const activeTrigger = ref();
    const { getItems, CollectionSlot } = useCollection({
      key: "NavigationMenu",
      isProvider: true
    });
    watchEffect(() => {
      if (!modelValue.value) return;
      const items = getItems().map((i) => i.ref);
      activeTrigger.value = items.find((item) => item.id.includes(modelValue.value));
    });
    provideNavigationMenuContext({
      ...menuContext,
      isRootMenu: false,
      modelValue,
      previousValue,
      activeTrigger,
      orientation: props2.orientation,
      rootNavigationMenu: currentElement,
      indicatorTrack,
      onIndicatorTrackChange: (val) => {
        indicatorTrack.value = val;
      },
      viewport,
      onViewportChange: (val) => {
        viewport.value = val;
      },
      onTriggerEnter: (val) => {
        modelValue.value = val;
      },
      onTriggerLeave: () => {
      },
      onContentEnter: () => {
      },
      onContentLeave: () => {
      },
      onItemSelect: (val) => {
        modelValue.value = val;
      },
      onItemDismiss: () => {
        modelValue.value = "";
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          "data-orientation": _ctx.orientation,
          "as-child": props2.asChild,
          as: _ctx.as,
          "data-reka-navigation-menu": ""
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
          _: 3
        }, 8, [
          "data-orientation",
          "as-child",
          "as"
        ])]),
        _: 3
      });
    };
  }
});
var NavigationMenuSub_default = NavigationMenuSub_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuTrigger.js
var _hoisted_14 = ["aria-owns"];
var NavigationMenuTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const menuContext = injectNavigationMenuContext();
    const itemContext = injectNavigationMenuItemContext();
    const { CollectionItem } = useCollection({ key: "NavigationMenu" });
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    const triggerId = ref("");
    const contentId = ref("");
    const hasPointerMoveOpenedRef = refAutoReset(false, 300);
    const wasClickCloseRef = ref(false);
    const open = computed(() => itemContext.value === menuContext.modelValue.value);
    onMounted(() => {
      itemContext.triggerRef = triggerElement;
      triggerId.value = makeTriggerId(menuContext.baseId, itemContext.value);
      contentId.value = makeContentId(menuContext.baseId, itemContext.value);
    });
    function handlePointerEnter() {
      if (menuContext.disableHoverTrigger.value) return;
      wasClickCloseRef.value = false;
      itemContext.wasEscapeCloseRef.value = false;
    }
    function handlePointerMove2(ev) {
      if (menuContext.disableHoverTrigger.value) return;
      if (ev.pointerType === "mouse") {
        if (props2.disabled || wasClickCloseRef.value || itemContext.wasEscapeCloseRef.value || hasPointerMoveOpenedRef.value) return;
        menuContext.onTriggerEnter(itemContext.value);
        hasPointerMoveOpenedRef.value = true;
      }
    }
    function handlePointerLeave(ev) {
      if (menuContext.disableHoverTrigger.value) return;
      if (ev.pointerType === "mouse") {
        if (props2.disabled) return;
        menuContext.onTriggerLeave();
        hasPointerMoveOpenedRef.value = false;
      }
    }
    function handleClick(event) {
      if ((!("pointerType" in event) || event.pointerType === "mouse") && menuContext.disableClickTrigger.value) return;
      if (hasPointerMoveOpenedRef.value) return;
      if (open.value) menuContext.onItemSelect("");
      else menuContext.onItemSelect(itemContext.value);
      wasClickCloseRef.value = open.value;
    }
    function handleKeydown(ev) {
      const verticalEntryKey = menuContext.dir.value === "rtl" ? "ArrowLeft" : "ArrowRight";
      const entryKey = {
        horizontal: "ArrowDown",
        vertical: verticalEntryKey
      }[menuContext.orientation];
      if (open.value && ev.key === entryKey) {
        itemContext.onEntryKeyDown();
        ev.preventDefault();
        ev.stopPropagation();
      }
    }
    function setFocusProxyRef(node) {
      itemContext.focusProxyRef.value = unrefElement(node);
      return void 0;
    }
    function handleVisuallyHiddenFocus(ev) {
      const content = document.getElementById(itemContext.contentId);
      const prevFocusedElement = ev.relatedTarget;
      const wasTriggerFocused = prevFocusedElement === triggerElement.value;
      const wasFocusFromContent = content?.contains(prevFocusedElement);
      if (wasTriggerFocused || !wasFocusFromContent) itemContext.onFocusProxyEnter(wasTriggerFocused ? "start" : "end");
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createVNode(unref(CollectionItem), null, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          id: triggerId.value,
          ref: unref(forwardRef),
          disabled: _ctx.disabled,
          "data-disabled": _ctx.disabled ? "" : void 0,
          "data-state": unref(getOpenState2)(open.value),
          "data-navigation-menu-trigger": "",
          "aria-expanded": open.value,
          "aria-controls": contentId.value,
          "as-child": props2.asChild,
          as: _ctx.as
        }, _ctx.$attrs, {
          onPointerenter: handlePointerEnter,
          onPointermove: handlePointerMove2,
          onPointerleave: handlePointerLeave,
          onClick: handleClick,
          onKeydown: handleKeydown
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "id",
          "disabled",
          "data-disabled",
          "data-state",
          "aria-expanded",
          "aria-controls",
          "as-child",
          "as"
        ])]),
        _: 3
      }), open.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [createVNode(unref(VisuallyHidden_default), {
        ref: setFocusProxyRef,
        "aria-hidden": "true",
        tabindex: 0,
        onFocus: handleVisuallyHiddenFocus
      }), unref(menuContext).viewport ? (openBlock(), createElementBlock("span", {
        key: 0,
        "aria-owns": contentId.value
      }, null, 8, _hoisted_14)) : createCommentVNode("v-if", true)], 64)) : createCommentVNode("v-if", true)], 64);
    };
  }
});
var NavigationMenuTrigger_default = NavigationMenuTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NavigationMenu/NavigationMenuViewport.js
var NavigationMenuViewport_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NavigationMenuViewport",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    align: {
      type: String,
      required: false,
      default: "center"
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef, currentElement } = useForwardExpose();
    const menuContext = injectNavigationMenuContext();
    const { activeTrigger, rootNavigationMenu, modelValue } = menuContext;
    const size3 = ref();
    const position = ref();
    const open = computed(() => !!menuContext.modelValue.value);
    watch(currentElement, () => {
      menuContext.onViewportChange(currentElement.value);
    });
    const content = ref();
    watch([modelValue, open], () => {
      nextTick(() => {
        if (!currentElement.value) return;
        requestAnimationFrame(() => {
          const el = currentElement.value?.querySelector("[data-state=open]");
          content.value = el;
        });
      });
    }, { immediate: true });
    function updatePosition() {
      if (content.value && activeTrigger.value && rootNavigationMenu.value) {
        const bodyWidth = document.documentElement.offsetWidth;
        const bodyHeight = document.documentElement.offsetHeight;
        const rootRect = rootNavigationMenu.value.getBoundingClientRect();
        const rect = activeTrigger.value.getBoundingClientRect();
        const { offsetWidth, offsetHeight } = content.value;
        const startPositionLeft = rect.left - rootRect.left;
        const startPositionTop = rect.top - rootRect.top;
        let posLeft = null;
        let posTop = null;
        switch (props2.align) {
          case "start":
            posLeft = startPositionLeft;
            posTop = startPositionTop;
            break;
          case "end":
            posLeft = startPositionLeft - offsetWidth + rect.width;
            posTop = startPositionTop - offsetHeight + rect.height;
            break;
          default:
            posLeft = startPositionLeft - offsetWidth / 2 + rect.width / 2;
            posTop = startPositionTop - offsetHeight / 2 + rect.height / 2;
        }
        const screenOffset = 10;
        if (posLeft + rootRect.left < screenOffset) posLeft = screenOffset - rootRect.left;
        const rightOffset = posLeft + rootRect.left + offsetWidth;
        if (rightOffset > bodyWidth - screenOffset) {
          posLeft -= rightOffset - bodyWidth + screenOffset;
          if (posLeft < screenOffset - rootRect.left) posLeft = screenOffset - rootRect.left;
        }
        if (posTop + rootRect.top < screenOffset) posTop = screenOffset - rootRect.top;
        const bottomOffset = posTop + rootRect.top + offsetHeight;
        if (bottomOffset > bodyHeight - screenOffset) {
          posTop -= bottomOffset - bodyHeight + screenOffset;
          if (posTop < screenOffset - rootRect.top) posTop = screenOffset - rootRect.top;
        }
        posLeft = Math.round(posLeft);
        posTop = Math.round(posTop);
        position.value = {
          left: posLeft,
          top: posTop
        };
      }
    }
    useResizeObserver(content, () => {
      if (content.value) {
        size3.value = {
          width: content.value.offsetWidth,
          height: content.value.offsetHeight
        };
        updatePosition();
      }
    });
    useResizeObserver([globalThis.document?.body, rootNavigationMenu], () => {
      updatePosition();
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), {
        present: _ctx.forceMount || open.value,
        "force-mount": !unref(menuContext).unmountOnHide.value,
        onAfterLeave: _cache[2] || (_cache[2] = () => {
          size3.value = void 0;
          position.value = void 0;
        })
      }, {
        default: withCtx(({ present }) => [createVNode(unref(Primitive), mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          as: _ctx.as,
          "as-child": _ctx.asChild,
          "data-state": unref(getOpenState2)(open.value),
          "data-orientation": unref(menuContext).orientation,
          style: {
            pointerEvents: !open.value && unref(menuContext).isRootMenu ? "none" : void 0,
            ["--reka-navigation-menu-viewport-width"]: size3.value ? `${size3.value?.width}px` : void 0,
            ["--reka-navigation-menu-viewport-height"]: size3.value ? `${size3.value?.height}px` : void 0,
            ["--reka-navigation-menu-viewport-left"]: position.value ? `${position.value?.left}px` : void 0,
            ["--reka-navigation-menu-viewport-top"]: position.value ? `${position.value?.top}px` : void 0
          },
          hidden: !present,
          onPointerenter: _cache[0] || (_cache[0] = ($event) => unref(menuContext).onContentEnter(unref(menuContext).modelValue.value)),
          onPointerleave: _cache[1] || (_cache[1] = ($event) => unref(whenMouse)(() => unref(menuContext).onContentLeave())($event))
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 2
        }, 1040, [
          "as",
          "as-child",
          "data-state",
          "data-orientation",
          "style",
          "hidden"
        ])]),
        _: 3
      }, 8, ["present", "force-mount"]);
    };
  }
});
var NavigationMenuViewport_default = NavigationMenuViewport_vue_vue_type_script_setup_true_lang_default;

// node_modules/@internationalized/number/dist/NumberFormatter.mjs
var $488c6ddbf4ef74c2$var$formatterCache = /* @__PURE__ */ new Map();
var $488c6ddbf4ef74c2$var$supportsSignDisplay = false;
try {
  $488c6ddbf4ef74c2$var$supportsSignDisplay = new Intl.NumberFormat("de-DE", {
    signDisplay: "exceptZero"
  }).resolvedOptions().signDisplay === "exceptZero";
} catch {
}
var $488c6ddbf4ef74c2$var$supportsUnit = false;
try {
  $488c6ddbf4ef74c2$var$supportsUnit = new Intl.NumberFormat("de-DE", {
    style: "unit",
    unit: "degree"
  }).resolvedOptions().style === "unit";
} catch {
}
var $488c6ddbf4ef74c2$var$UNITS = {
  degree: {
    narrow: {
      default: "°",
      "ja-JP": " 度",
      "zh-TW": "度",
      "sl-SI": " °"
    }
  }
};
var $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5 = class {
  /** Formats a number value as a string, according to the locale and options provided to the constructor. */
  format(value) {
    let res = "";
    if (!$488c6ddbf4ef74c2$var$supportsSignDisplay && this.options.signDisplay != null) res = $488c6ddbf4ef74c2$export$711b50b3c525e0f2(this.numberFormatter, this.options.signDisplay, value);
    else res = this.numberFormatter.format(value);
    if (this.options.style === "unit" && !$488c6ddbf4ef74c2$var$supportsUnit) {
      var _UNITS_unit;
      let { unit, unitDisplay = "short", locale } = this.resolvedOptions();
      if (!unit) return res;
      let values = (_UNITS_unit = $488c6ddbf4ef74c2$var$UNITS[unit]) === null || _UNITS_unit === void 0 ? void 0 : _UNITS_unit[unitDisplay];
      res += values[locale] || values.default;
    }
    return res;
  }
  /** Formats a number to an array of parts such as separators, digits, punctuation, and more. */
  formatToParts(value) {
    return this.numberFormatter.formatToParts(value);
  }
  /** Formats a number range as a string. */
  formatRange(start, end) {
    if (typeof this.numberFormatter.formatRange === "function") return this.numberFormatter.formatRange(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    return `${this.format(start)} – ${this.format(end)}`;
  }
  /** Formats a number range as an array of parts. */
  formatRangeToParts(start, end) {
    if (typeof this.numberFormatter.formatRangeToParts === "function") return this.numberFormatter.formatRangeToParts(start, end);
    if (end < start) throw new RangeError("End date must be >= start date");
    let startParts = this.numberFormatter.formatToParts(start);
    let endParts = this.numberFormatter.formatToParts(end);
    return [
      ...startParts.map((p) => ({
        ...p,
        source: "startRange"
      })),
      {
        type: "literal",
        value: " – ",
        source: "shared"
      },
      ...endParts.map((p) => ({
        ...p,
        source: "endRange"
      }))
    ];
  }
  /** Returns the resolved formatting options based on the values passed to the constructor. */
  resolvedOptions() {
    let options = this.numberFormatter.resolvedOptions();
    if (!$488c6ddbf4ef74c2$var$supportsSignDisplay && this.options.signDisplay != null) options = {
      ...options,
      signDisplay: this.options.signDisplay
    };
    if (!$488c6ddbf4ef74c2$var$supportsUnit && this.options.style === "unit") options = {
      ...options,
      style: "unit",
      unit: this.options.unit,
      unitDisplay: this.options.unitDisplay
    };
    return options;
  }
  constructor(locale, options = {}) {
    this.numberFormatter = $488c6ddbf4ef74c2$var$getCachedNumberFormatter(locale, options);
    this.options = options;
  }
};
function $488c6ddbf4ef74c2$var$getCachedNumberFormatter(locale, options = {}) {
  let { numberingSystem } = options;
  if (numberingSystem && locale.includes("-nu-")) {
    if (!locale.includes("-u-")) locale += "-u-";
    locale += `-nu-${numberingSystem}`;
  }
  if (options.style === "unit" && !$488c6ddbf4ef74c2$var$supportsUnit) {
    var _UNITS_unit;
    let { unit, unitDisplay = "short" } = options;
    if (!unit) throw new Error('unit option must be provided with style: "unit"');
    if (!((_UNITS_unit = $488c6ddbf4ef74c2$var$UNITS[unit]) === null || _UNITS_unit === void 0 ? void 0 : _UNITS_unit[unitDisplay])) throw new Error(`Unsupported unit ${unit} with unitDisplay = ${unitDisplay}`);
    options = {
      ...options,
      style: "decimal"
    };
  }
  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : "");
  if ($488c6ddbf4ef74c2$var$formatterCache.has(cacheKey)) return $488c6ddbf4ef74c2$var$formatterCache.get(cacheKey);
  let numberFormatter = new Intl.NumberFormat(locale, options);
  $488c6ddbf4ef74c2$var$formatterCache.set(cacheKey, numberFormatter);
  return numberFormatter;
}
function $488c6ddbf4ef74c2$export$711b50b3c525e0f2(numberFormat, signDisplay, num) {
  if (signDisplay === "auto") return numberFormat.format(num);
  else if (signDisplay === "never") return numberFormat.format(Math.abs(num));
  else {
    let needsPositiveSign = false;
    if (signDisplay === "always") needsPositiveSign = num > 0 || Object.is(num, 0);
    else if (signDisplay === "exceptZero") {
      if (Object.is(num, -0) || Object.is(num, 0)) num = Math.abs(num);
      else needsPositiveSign = num > 0;
    }
    if (needsPositiveSign) {
      let negative = numberFormat.format(-num);
      let noSign = numberFormat.format(num);
      let minus = negative.replace(noSign, "").replace(/\u200e|\u061C/, "");
      if ([
        ...minus
      ].length !== 1) console.warn("@react-aria/i18n polyfill for NumberFormat signDisplay: Unsupported case");
      let positive = negative.replace(noSign, "!!!").replace(minus, "+").replace("!!!", noSign);
      return positive;
    } else return numberFormat.format(num);
  }
}

// node_modules/@internationalized/number/dist/NumberParser.mjs
var $6c7bd7858deea686$var$CURRENCY_SIGN_REGEX = new RegExp("^.*\\(.*\\).*$");
var $6c7bd7858deea686$var$NUMBERING_SYSTEMS = [
  "latn",
  "arab",
  "hanidec",
  "deva",
  "beng",
  "fullwide"
];
var $6c7bd7858deea686$export$cd11ab140839f11d = class {
  /**
  * Parses the given string to a number. Returns NaN if a valid number could not be parsed.
  */
  parse(value) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).parse(value);
  }
  /**
  * Returns whether the given string could potentially be a valid number. This should be used to
  * validate user input as the user types. If a `minValue` or `maxValue` is provided, the validity
  * of the minus/plus sign characters can be checked.
  */
  isValidPartialNumber(value, minValue, maxValue) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).isValidPartialNumber(value, minValue, maxValue);
  }
  /**
  * Returns a numbering system for which the given string is valid in the current locale.
  * If no numbering system could be detected, the default numbering system for the current
  * locale is returned.
  */
  getNumberingSystem(value) {
    return $6c7bd7858deea686$var$getNumberParserImpl(this.locale, this.options, value).options.numberingSystem;
  }
  constructor(locale, options = {}) {
    this.locale = locale;
    this.options = options;
  }
};
var $6c7bd7858deea686$var$numberParserCache = /* @__PURE__ */ new Map();
function $6c7bd7858deea686$var$getNumberParserImpl(locale, options, value) {
  let defaultParser = $6c7bd7858deea686$var$getCachedNumberParser(locale, options);
  if (!locale.includes("-nu-") && !defaultParser.isValidPartialNumber(value)) {
    for (let numberingSystem of $6c7bd7858deea686$var$NUMBERING_SYSTEMS) if (numberingSystem !== defaultParser.options.numberingSystem) {
      let parser = $6c7bd7858deea686$var$getCachedNumberParser(locale + (locale.includes("-u-") ? "-nu-" : "-u-nu-") + numberingSystem, options);
      if (parser.isValidPartialNumber(value)) return parser;
    }
  }
  return defaultParser;
}
function $6c7bd7858deea686$var$getCachedNumberParser(locale, options) {
  let cacheKey = locale + (options ? Object.entries(options).sort((a, b) => a[0] < b[0] ? -1 : 1).join() : "");
  let parser = $6c7bd7858deea686$var$numberParserCache.get(cacheKey);
  if (!parser) {
    parser = new $6c7bd7858deea686$var$NumberParserImpl(locale, options);
    $6c7bd7858deea686$var$numberParserCache.set(cacheKey, parser);
  }
  return parser;
}
var $6c7bd7858deea686$var$NumberParserImpl = class {
  parse(value) {
    let fullySanitizedValue = this.sanitize(value);
    if (this.symbols.group)
      fullySanitizedValue = $6c7bd7858deea686$var$replaceAll(fullySanitizedValue, this.symbols.group, "");
    if (this.symbols.decimal) fullySanitizedValue = fullySanitizedValue.replace(this.symbols.decimal, ".");
    if (this.symbols.minusSign) fullySanitizedValue = fullySanitizedValue.replace(this.symbols.minusSign, "-");
    fullySanitizedValue = fullySanitizedValue.replace(this.symbols.numeral, this.symbols.index);
    if (this.options.style === "percent") {
      let isNegative = fullySanitizedValue.indexOf("-");
      fullySanitizedValue = fullySanitizedValue.replace("-", "");
      fullySanitizedValue = fullySanitizedValue.replace("+", "");
      let index = fullySanitizedValue.indexOf(".");
      if (index === -1) index = fullySanitizedValue.length;
      fullySanitizedValue = fullySanitizedValue.replace(".", "");
      if (index - 2 === 0) fullySanitizedValue = `0.${fullySanitizedValue}`;
      else if (index - 2 === -1) fullySanitizedValue = `0.0${fullySanitizedValue}`;
      else if (index - 2 === -2) fullySanitizedValue = "0.00";
      else fullySanitizedValue = `${fullySanitizedValue.slice(0, index - 2)}.${fullySanitizedValue.slice(index - 2)}`;
      if (isNegative > -1) fullySanitizedValue = `-${fullySanitizedValue}`;
    }
    let newValue = fullySanitizedValue ? +fullySanitizedValue : NaN;
    if (isNaN(newValue)) return NaN;
    if (this.options.style === "percent") {
      var _this_options_minimumFractionDigits, _this_options_maximumFractionDigits;
      let options = {
        ...this.options,
        style: "decimal",
        minimumFractionDigits: Math.min(((_this_options_minimumFractionDigits = this.options.minimumFractionDigits) !== null && _this_options_minimumFractionDigits !== void 0 ? _this_options_minimumFractionDigits : 0) + 2, 20),
        maximumFractionDigits: Math.min(((_this_options_maximumFractionDigits = this.options.maximumFractionDigits) !== null && _this_options_maximumFractionDigits !== void 0 ? _this_options_maximumFractionDigits : 0) + 2, 20)
      };
      return new $6c7bd7858deea686$export$cd11ab140839f11d(this.locale, options).parse(new (0, $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5)(this.locale, options).format(newValue));
    }
    if (this.options.currencySign === "accounting" && $6c7bd7858deea686$var$CURRENCY_SIGN_REGEX.test(value)) newValue = -1 * newValue;
    return newValue;
  }
  sanitize(value) {
    value = value.replace(this.symbols.literals, "");
    if (this.symbols.minusSign) value = value.replace("-", this.symbols.minusSign);
    if (this.options.numberingSystem === "arab") {
      if (this.symbols.decimal) {
        value = value.replace(",", this.symbols.decimal);
        value = value.replace(String.fromCharCode(1548), this.symbols.decimal);
      }
      if (this.symbols.group) value = $6c7bd7858deea686$var$replaceAll(value, ".", this.symbols.group);
    }
    if (this.symbols.group === "’" && value.includes("'")) value = $6c7bd7858deea686$var$replaceAll(value, "'", this.symbols.group);
    if (this.options.locale === "fr-FR" && this.symbols.group) {
      value = $6c7bd7858deea686$var$replaceAll(value, " ", this.symbols.group);
      value = $6c7bd7858deea686$var$replaceAll(value, /\u00A0/g, this.symbols.group);
    }
    return value;
  }
  isValidPartialNumber(value, minValue = -Infinity, maxValue = Infinity) {
    value = this.sanitize(value);
    if (this.symbols.minusSign && value.startsWith(this.symbols.minusSign) && minValue < 0) value = value.slice(this.symbols.minusSign.length);
    else if (this.symbols.plusSign && value.startsWith(this.symbols.plusSign) && maxValue > 0) value = value.slice(this.symbols.plusSign.length);
    if (this.symbols.group && value.startsWith(this.symbols.group)) return false;
    if (this.symbols.decimal && value.indexOf(this.symbols.decimal) > -1 && this.options.maximumFractionDigits === 0) return false;
    if (this.symbols.group) value = $6c7bd7858deea686$var$replaceAll(value, this.symbols.group, "");
    value = value.replace(this.symbols.numeral, "");
    if (this.symbols.decimal) value = value.replace(this.symbols.decimal, "");
    return value.length === 0;
  }
  constructor(locale, options = {}) {
    this.locale = locale;
    if (options.roundingIncrement !== 1 && options.roundingIncrement != null) {
      if (options.maximumFractionDigits == null && options.minimumFractionDigits == null) {
        options.maximumFractionDigits = 0;
        options.minimumFractionDigits = 0;
      } else if (options.maximumFractionDigits == null) options.maximumFractionDigits = options.minimumFractionDigits;
      else if (options.minimumFractionDigits == null) options.minimumFractionDigits = options.maximumFractionDigits;
    }
    this.formatter = new Intl.NumberFormat(locale, options);
    this.options = this.formatter.resolvedOptions();
    this.symbols = $6c7bd7858deea686$var$getSymbols(locale, this.formatter, this.options, options);
    var _this_options_minimumFractionDigits, _this_options_maximumFractionDigits;
    if (this.options.style === "percent" && (((_this_options_minimumFractionDigits = this.options.minimumFractionDigits) !== null && _this_options_minimumFractionDigits !== void 0 ? _this_options_minimumFractionDigits : 0) > 18 || ((_this_options_maximumFractionDigits = this.options.maximumFractionDigits) !== null && _this_options_maximumFractionDigits !== void 0 ? _this_options_maximumFractionDigits : 0) > 18)) console.warn("NumberParser cannot handle percentages with greater than 18 decimal places, please reduce the number in your options.");
  }
};
var $6c7bd7858deea686$var$nonLiteralParts = /* @__PURE__ */ new Set([
  "decimal",
  "fraction",
  "integer",
  "minusSign",
  "plusSign",
  "group"
]);
var $6c7bd7858deea686$var$pluralNumbers = [
  0,
  4,
  2,
  1,
  11,
  20,
  3,
  7,
  100,
  21,
  0.1,
  1.1
];
function $6c7bd7858deea686$var$getSymbols(locale, formatter, intlOptions, originalOptions) {
  var _allParts_find, _posAllParts_find, _decimalParts_find, _allParts_find1;
  let symbolFormatter = new Intl.NumberFormat(locale, {
    ...intlOptions,
    // Resets so we get the full range of symbols
    minimumSignificantDigits: 1,
    maximumSignificantDigits: 21,
    roundingIncrement: 1,
    roundingPriority: "auto",
    roundingMode: "halfExpand"
  });
  let allParts = symbolFormatter.formatToParts(-10000.111);
  let posAllParts = symbolFormatter.formatToParts(10000.111);
  let pluralParts = $6c7bd7858deea686$var$pluralNumbers.map((n) => symbolFormatter.formatToParts(n));
  var _allParts_find_value;
  let minusSign = (_allParts_find_value = (_allParts_find = allParts.find((p) => p.type === "minusSign")) === null || _allParts_find === void 0 ? void 0 : _allParts_find.value) !== null && _allParts_find_value !== void 0 ? _allParts_find_value : "-";
  let plusSign = (_posAllParts_find = posAllParts.find((p) => p.type === "plusSign")) === null || _posAllParts_find === void 0 ? void 0 : _posAllParts_find.value;
  if (!plusSign && ((originalOptions === null || originalOptions === void 0 ? void 0 : originalOptions.signDisplay) === "exceptZero" || (originalOptions === null || originalOptions === void 0 ? void 0 : originalOptions.signDisplay) === "always")) plusSign = "+";
  let decimalParts = new Intl.NumberFormat(locale, {
    ...intlOptions,
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
  }).formatToParts(1e-3);
  let decimal = (_decimalParts_find = decimalParts.find((p) => p.type === "decimal")) === null || _decimalParts_find === void 0 ? void 0 : _decimalParts_find.value;
  let group = (_allParts_find1 = allParts.find((p) => p.type === "group")) === null || _allParts_find1 === void 0 ? void 0 : _allParts_find1.value;
  let allPartsLiterals = allParts.filter((p) => !$6c7bd7858deea686$var$nonLiteralParts.has(p.type)).map((p) => $6c7bd7858deea686$var$escapeRegex(p.value));
  let pluralPartsLiterals = pluralParts.flatMap((p) => p.filter((p2) => !$6c7bd7858deea686$var$nonLiteralParts.has(p2.type)).map((p2) => $6c7bd7858deea686$var$escapeRegex(p2.value)));
  let sortedLiterals = [
    .../* @__PURE__ */ new Set([
      ...allPartsLiterals,
      ...pluralPartsLiterals
    ])
  ].sort((a, b) => b.length - a.length);
  let literals = sortedLiterals.length === 0 ? new RegExp("[\\p{White_Space}]", "gu") : new RegExp(`${sortedLiterals.join("|")}|[\\p{White_Space}]`, "gu");
  let numerals = [
    ...new Intl.NumberFormat(intlOptions.locale, {
      useGrouping: false
    }).format(9876543210)
  ].reverse();
  let indexes = new Map(numerals.map((d, i) => [
    d,
    i
  ]));
  let numeral = new RegExp(`[${numerals.join("")}]`, "g");
  let index = (d) => String(indexes.get(d));
  return {
    minusSign,
    plusSign,
    decimal,
    group,
    literals,
    numeral,
    index
  };
}
function $6c7bd7858deea686$var$replaceAll(str, find, replace) {
  if (str.replaceAll) return str.replaceAll(find, replace);
  return str.split(find).join(replace);
}
function $6c7bd7858deea686$var$escapeRegex(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}

// node_modules/reka-ui/dist/NumberField/utils.js
function usePressedHold(options) {
  const { disabled } = options;
  const timeout = ref();
  const triggerHook = createEventHook();
  const resetTimeout = () => window.clearTimeout(timeout.value);
  const onIncrementPressStart = (delay) => {
    resetTimeout();
    if (disabled.value) return;
    triggerHook.trigger();
    timeout.value = window.setTimeout(() => {
      onIncrementPressStart(60);
    }, delay);
  };
  const handlePressStart = () => {
    onIncrementPressStart(400);
  };
  const handlePressEnd = () => {
    resetTimeout();
  };
  const isPressed = ref(false);
  const target = computed(() => unrefElement(options.target));
  const onPressStart = (event) => {
    if (event.button !== 0 || isPressed.value) return;
    event.preventDefault();
    isPressed.value = true;
    handlePressStart();
  };
  const onPressRelease = () => {
    isPressed.value = false;
    handlePressEnd();
  };
  if (isClient) {
    useEventListener(target || window, "pointerdown", onPressStart);
    useEventListener(window, "pointerup", onPressRelease);
    useEventListener(window, "pointercancel", onPressRelease);
  }
  return {
    isPressed,
    onTrigger: triggerHook.on
  };
}
function useNumberFormatter(locale, options = ref({})) {
  return reactiveComputed(() => new $488c6ddbf4ef74c2$export$cc77c4ff7e8673c5(locale.value, options.value));
}
function useNumberParser(locale, options = ref({})) {
  return reactiveComputed(() => new $6c7bd7858deea686$export$cd11ab140839f11d(locale.value, options.value));
}
function handleDecimalOperation(operator, value1, value2) {
  let result = operator === "+" ? value1 + value2 : value1 - value2;
  if (value1 % 1 !== 0 || value2 % 1 !== 0) {
    const value1Decimal = value1.toString().split(".");
    const value2Decimal = value2.toString().split(".");
    const value1DecimalLength = value1Decimal[1] && value1Decimal[1].length || 0;
    const value2DecimalLength = value2Decimal[1] && value2Decimal[1].length || 0;
    const multiplier = 10 ** Math.max(value1DecimalLength, value2DecimalLength);
    value1 = Math.round(value1 * multiplier);
    value2 = Math.round(value2 * multiplier);
    result = operator === "+" ? value1 + value2 : value1 - value2;
    result /= multiplier;
  }
  return result;
}

// node_modules/reka-ui/dist/NumberField/NumberFieldRoot.js
var [injectNumberFieldRootContext, provideNumberFieldRootContext] = createContext("NumberFieldRoot");
var NumberFieldRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "NumberFieldRoot",
  props: {
    defaultValue: {
      type: Number,
      required: false,
      default: void 0
    },
    modelValue: {
      type: [Number, null],
      required: false
    },
    min: {
      type: Number,
      required: false
    },
    max: {
      type: Number,
      required: false
    },
    step: {
      type: Number,
      required: false,
      default: 1
    },
    stepSnapping: {
      type: Boolean,
      required: false,
      default: true
    },
    formatOptions: {
      type: null,
      required: false
    },
    locale: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    readonly: {
      type: Boolean,
      required: false
    },
    disableWheelChange: {
      type: Boolean,
      required: false
    },
    invertWheelChange: {
      type: Boolean,
      required: false
    },
    id: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled, readonly, disableWheelChange, invertWheelChange, min: min2, max: max2, step, stepSnapping, formatOptions, id, locale: propLocale } = toRefs(props2);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue,
      passive: props2.modelValue === void 0
    });
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const locale = useLocale(propLocale);
    const isFormControl = useFormControl(currentElement);
    const inputEl = ref();
    const isDecreaseDisabled = computed(() => !isNullish(modelValue.value) && (clampInputValue(modelValue.value) === min2.value || min2.value && !isNaN(modelValue.value) ? handleDecimalOperation("-", modelValue.value, step.value) < min2.value : false));
    const isIncreaseDisabled = computed(() => !isNullish(modelValue.value) && (clampInputValue(modelValue.value) === max2.value || max2.value && !isNaN(modelValue.value) ? handleDecimalOperation("+", modelValue.value, step.value) > max2.value : false));
    function handleChangingValue(type, multiplier = 1) {
      inputEl.value?.focus();
      if (props2.disabled || props2.readonly) return;
      const currentInputValue = numberParser.parse(inputEl.value?.value ?? "");
      if (isNaN(currentInputValue)) modelValue.value = min2.value ?? 0;
      else if (type === "increase") modelValue.value = clampInputValue(currentInputValue + (step.value ?? 1) * multiplier);
      else modelValue.value = clampInputValue(currentInputValue - (step.value ?? 1) * multiplier);
    }
    function handleIncrease(multiplier = 1) {
      handleChangingValue("increase", multiplier);
    }
    function handleDecrease(multiplier = 1) {
      handleChangingValue("decrease", multiplier);
    }
    function handleMinMaxValue(type) {
      if (type === "min" && min2.value !== void 0) modelValue.value = clampInputValue(min2.value);
      else if (type === "max" && max2.value !== void 0) modelValue.value = clampInputValue(max2.value);
    }
    const numberFormatter = useNumberFormatter(locale, formatOptions);
    const numberParser = useNumberParser(locale, formatOptions);
    const inputMode = computed(() => {
      const hasDecimals = numberFormatter.resolvedOptions().maximumFractionDigits > 0;
      return hasDecimals ? "decimal" : "numeric";
    });
    const textValueFormatter = useNumberFormatter(locale, formatOptions);
    const textValue = computed(() => isNullish(modelValue.value) || isNaN(modelValue.value) ? "" : textValueFormatter.format(modelValue.value));
    function validate(val) {
      return numberParser.isValidPartialNumber(val, min2.value, max2.value);
    }
    function setInputValue(val) {
      if (inputEl.value) inputEl.value.value = val;
    }
    function clampInputValue(val) {
      let clampedValue;
      if (step.value === void 0 || isNaN(step.value) || !stepSnapping.value) clampedValue = clamp(val, min2.value, max2.value);
      else clampedValue = snapValueToStep(val, min2.value, max2.value, step.value);
      clampedValue = numberParser.parse(numberFormatter.format(clampedValue));
      return clampedValue;
    }
    function applyInputValue(val) {
      const parsedValue = numberParser.parse(val);
      modelValue.value = isNaN(parsedValue) ? void 0 : clampInputValue(parsedValue);
      if (!val.length) return setInputValue(val);
      if (isNaN(parsedValue)) return setInputValue(textValue.value);
      return setInputValue(textValue.value);
    }
    provideNumberFieldRootContext({
      modelValue,
      handleDecrease,
      handleIncrease,
      handleMinMaxValue,
      inputMode,
      inputEl,
      onInputElement: (el) => inputEl.value = el,
      textValue,
      validate,
      applyInputValue,
      disabled,
      readonly,
      disableWheelChange,
      invertWheelChange,
      max: max2,
      min: min2,
      isDecreaseDisabled,
      isIncreaseDisabled,
      id
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        role: "group",
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "data-disabled": unref(disabled) ? "" : void 0,
        "data-readonly": unref(readonly) ? "" : void 0
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          textValue: textValue.value
        }), unref(isFormControl) && _ctx.name ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          type: "text",
          value: unref(modelValue),
          name: _ctx.name,
          disabled: unref(disabled),
          readonly: unref(readonly),
          required: _ctx.required
        }, null, 8, [
          "value",
          "name",
          "disabled",
          "readonly",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "data-disabled",
        "data-readonly"
      ]);
    };
  }
});
var NumberFieldRoot_default = NumberFieldRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NumberField/NumberFieldDecrement.js
var NumberFieldDecrement_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NumberFieldDecrement",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectNumberFieldRootContext();
    const isDisabled = computed(() => rootContext.disabled?.value || rootContext.readonly.value || props2.disabled || rootContext.isDecreaseDisabled.value);
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const { isPressed, onTrigger } = usePressedHold({
      target: currentElement,
      disabled: isDisabled
    });
    onTrigger(() => {
      rootContext.handleDecrease();
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        tabindex: "-1",
        "aria-label": "Decrease",
        type: _ctx.as === "button" ? "button" : void 0,
        style: { userSelect: unref(isPressed) ? "none" : void 0 },
        disabled: isDisabled.value ? "" : void 0,
        "data-disabled": isDisabled.value ? "" : void 0,
        "data-pressed": unref(isPressed) ? "true" : void 0,
        onContextmenu: _cache[0] || (_cache[0] = withModifiers(() => {
        }, ["prevent"]))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "type",
        "style",
        "disabled",
        "data-disabled",
        "data-pressed"
      ]);
    };
  }
});
var NumberFieldDecrement_default = NumberFieldDecrement_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NumberField/NumberFieldIncrement.js
var NumberFieldIncrement_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NumberFieldIncrement",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectNumberFieldRootContext();
    const isDisabled = computed(() => rootContext.disabled?.value || rootContext.readonly.value || props2.disabled || rootContext.isIncreaseDisabled.value);
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const { isPressed, onTrigger } = usePressedHold({
      target: currentElement,
      disabled: isDisabled
    });
    onTrigger(() => {
      rootContext.handleIncrease();
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        tabindex: "-1",
        "aria-label": "Increase",
        type: _ctx.as === "button" ? "button" : void 0,
        style: { userSelect: unref(isPressed) ? "none" : void 0 },
        disabled: isDisabled.value ? "" : void 0,
        "data-disabled": isDisabled.value ? "" : void 0,
        "data-pressed": unref(isPressed) ? "true" : void 0,
        onContextmenu: _cache[0] || (_cache[0] = withModifiers(() => {
        }, ["prevent"]))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "type",
        "style",
        "disabled",
        "data-disabled",
        "data-pressed"
      ]);
    };
  }
});
var NumberFieldIncrement_default = NumberFieldIncrement_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/NumberField/NumberFieldInput.js
var NumberFieldInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "NumberFieldInput",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "input"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { primitiveElement, currentElement } = usePrimitiveElement();
    const rootContext = injectNumberFieldRootContext();
    function handleWheelEvent(event) {
      if (rootContext.disableWheelChange.value) return;
      if (event.target !== getActiveElement()) return;
      if (Math.abs(event.deltaY) <= Math.abs(event.deltaX)) return;
      event.preventDefault();
      if (event.deltaY > 0) rootContext.invertWheelChange.value ? rootContext.handleDecrease() : rootContext.handleIncrease();
      else if (event.deltaY < 0) rootContext.invertWheelChange.value ? rootContext.handleIncrease() : rootContext.handleDecrease();
    }
    onMounted(() => {
      rootContext.onInputElement(currentElement.value);
    });
    const inputValue = ref(rootContext.textValue.value);
    watch(() => rootContext.textValue.value, () => {
      inputValue.value = rootContext.textValue.value;
    }, {
      immediate: true,
      deep: true
    });
    function handleChange() {
      requestAnimationFrame(() => {
        inputValue.value = rootContext.textValue.value;
      });
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        id: unref(rootContext).id.value,
        ref_key: "primitiveElement",
        ref: primitiveElement,
        value: inputValue.value,
        role: "spinbutton",
        type: "text",
        tabindex: "0",
        inputmode: unref(rootContext).inputMode.value,
        disabled: unref(rootContext).disabled.value ? "" : void 0,
        "data-disabled": unref(rootContext).disabled.value ? "" : void 0,
        readonly: unref(rootContext).readonly.value ? "" : void 0,
        "data-readonly": unref(rootContext).readonly.value ? "" : void 0,
        autocomplete: "off",
        autocorrect: "off",
        spellcheck: "false",
        "aria-roledescription": "Number field",
        "aria-valuenow": unref(rootContext).modelValue.value,
        "aria-valuemin": unref(rootContext).min.value,
        "aria-valuemax": unref(rootContext).max.value,
        onKeydown: [
          _cache[0] || (_cache[0] = withKeys(withModifiers(($event) => unref(rootContext).handleIncrease(), ["prevent"]), ["up"])),
          _cache[1] || (_cache[1] = withKeys(withModifiers(($event) => unref(rootContext).handleDecrease(), ["prevent"]), ["down"])),
          _cache[2] || (_cache[2] = withKeys(withModifiers(($event) => unref(rootContext).handleIncrease(10), ["prevent"]), ["page-up"])),
          _cache[3] || (_cache[3] = withKeys(withModifiers(($event) => unref(rootContext).handleDecrease(10), ["prevent"]), ["page-down"])),
          _cache[4] || (_cache[4] = withKeys(withModifiers(($event) => unref(rootContext).handleMinMaxValue("min"), ["prevent"]), ["home"])),
          _cache[5] || (_cache[5] = withKeys(withModifiers(($event) => unref(rootContext).handleMinMaxValue("max"), ["prevent"]), ["end"])),
          _cache[8] || (_cache[8] = withKeys(($event) => unref(rootContext).applyInputValue($event.target?.value), ["enter"]))
        ],
        onWheel: handleWheelEvent,
        onBeforeinput: _cache[6] || (_cache[6] = (event) => {
          const target = event.target;
          let nextValue = target.value.slice(0, target.selectionStart ?? void 0) + (event.data ?? "") + target.value.slice(target.selectionEnd ?? void 0);
          if (!unref(rootContext).validate(nextValue)) event.preventDefault();
        }),
        onInput: _cache[7] || (_cache[7] = (event) => {
          const target = event.target;
          inputValue.value = target.value;
        }),
        onChange: handleChange,
        onBlur: _cache[9] || (_cache[9] = ($event) => unref(rootContext).applyInputValue($event.target?.value))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "id",
        "value",
        "inputmode",
        "disabled",
        "data-disabled",
        "readonly",
        "data-readonly",
        "aria-valuenow",
        "aria-valuemin",
        "aria-valuemax"
      ]);
    };
  }
});
var NumberFieldInput_default = NumberFieldInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationEllipsis.js
var PaginationEllipsis_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationEllipsis",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { "data-type": "ellipsis" }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("…"))])]),
        _: 3
      }, 16);
    };
  }
});
var PaginationEllipsis_default = PaginationEllipsis_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationRoot.js
var [injectPaginationRootContext, providePaginationRootContext] = createContext("PaginationRoot");
var PaginationRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationRoot",
  props: {
    page: {
      type: Number,
      required: false
    },
    defaultPage: {
      type: Number,
      required: false,
      default: 1
    },
    itemsPerPage: {
      type: Number,
      required: true
    },
    total: {
      type: Number,
      required: false,
      default: 0
    },
    siblingCount: {
      type: Number,
      required: false,
      default: 2
    },
    disabled: {
      type: Boolean,
      required: false
    },
    showEdges: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "nav"
    }
  },
  emits: ["update:page"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { siblingCount, disabled, showEdges } = toRefs(props2);
    useForwardExpose();
    const page = useVModel(props2, "page", emits, {
      defaultValue: props2.defaultPage,
      passive: props2.page === void 0
    });
    const pageCount = computed(() => Math.max(1, Math.ceil(props2.total / (props2.itemsPerPage || 1))));
    providePaginationRootContext({
      page,
      onPageChange(value) {
        page.value = value;
      },
      pageCount,
      siblingCount,
      disabled,
      showEdges
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          page: unref(page),
          pageCount: pageCount.value
        })]),
        _: 3
      }, 8, ["as", "as-child"]);
    };
  }
});
var PaginationRoot_default = PaginationRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationFirst.js
var PaginationFirst_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationFirst",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectPaginationRootContext();
    useForwardExpose();
    const disabled = computed(() => rootContext.page.value === 1 || rootContext.disabled.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "First Page",
        type: _ctx.as === "button" ? "button" : void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => !disabled.value && unref(rootContext).onPageChange(1))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[1] || (_cache[1] = createTextVNode("First page"))])]),
        _: 3
      }, 16, ["type", "disabled"]);
    };
  }
});
var PaginationFirst_default = PaginationFirst_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationLast.js
var PaginationLast_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationLast",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectPaginationRootContext();
    useForwardExpose();
    const disabled = computed(() => rootContext.page.value === rootContext.pageCount.value || rootContext.disabled.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "Last Page",
        type: _ctx.as === "button" ? "button" : void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => !disabled.value && unref(rootContext).onPageChange(unref(rootContext).pageCount.value))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[1] || (_cache[1] = createTextVNode("Last page"))])]),
        _: 3
      }, 16, ["type", "disabled"]);
    };
  }
});
var PaginationLast_default = PaginationLast_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/utils.js
function range(start, end) {
  const length = end - start + 1;
  return Array.from({ length }, (_, idx) => idx + start);
}
function transform(items) {
  return items.map((value) => {
    if (typeof value === "number") return {
      type: "page",
      value
    };
    return { type: "ellipsis" };
  });
}
var ELLIPSIS = "ellipsis";
function getRange(currentPage, pageCount, siblingCount, showEdges) {
  const firstPageIndex = 1;
  const lastPageIndex = pageCount;
  const leftSiblingIndex = Math.max(currentPage - siblingCount, firstPageIndex);
  const rightSiblingIndex = Math.min(currentPage + siblingCount, lastPageIndex);
  if (showEdges) {
    const totalPageNumbers = Math.min(2 * siblingCount + 5, pageCount);
    const itemCount = totalPageNumbers - 2;
    const showLeftEllipsis = leftSiblingIndex > firstPageIndex + 2 && Math.abs(lastPageIndex - itemCount - firstPageIndex + 1) > 2 && Math.abs(leftSiblingIndex - firstPageIndex) > 2;
    const showRightEllipsis = rightSiblingIndex < lastPageIndex - 2 && Math.abs(lastPageIndex - itemCount) > 2 && Math.abs(lastPageIndex - rightSiblingIndex) > 2;
    if (!showLeftEllipsis && showRightEllipsis) {
      const leftRange = range(1, itemCount);
      return [
        ...leftRange,
        ELLIPSIS,
        lastPageIndex
      ];
    }
    if (showLeftEllipsis && !showRightEllipsis) {
      const rightRange = range(lastPageIndex - itemCount + 1, lastPageIndex);
      return [
        firstPageIndex,
        ELLIPSIS,
        ...rightRange
      ];
    }
    if (showLeftEllipsis && showRightEllipsis) {
      const middleRange = range(leftSiblingIndex, rightSiblingIndex);
      return [
        firstPageIndex,
        ELLIPSIS,
        ...middleRange,
        ELLIPSIS,
        lastPageIndex
      ];
    }
    const fullRange = range(firstPageIndex, lastPageIndex);
    return fullRange;
  } else {
    const itemCount = siblingCount * 2 + 1;
    if (pageCount < itemCount) return range(1, lastPageIndex);
    else if (currentPage <= siblingCount + 1) return range(firstPageIndex, itemCount);
    else if (pageCount - currentPage <= siblingCount) return range(pageCount - itemCount + 1, lastPageIndex);
    else return range(leftSiblingIndex, rightSiblingIndex);
  }
}

// node_modules/reka-ui/dist/Pagination/PaginationList.js
var PaginationList_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationList",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPaginationRootContext();
    const transformedRange = computed(() => {
      return transform(getRange(rootContext.page.value, rootContext.pageCount.value, rootContext.siblingCount.value, rootContext.showEdges.value));
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { items: transformedRange.value })]),
        _: 3
      }, 16);
    };
  }
});
var PaginationList_default = PaginationList_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationListItem.js
var PaginationListItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationListItem",
  props: {
    value: {
      type: Number,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPaginationRootContext();
    const isSelected = computed(() => rootContext.page.value === props2.value);
    const disabled = computed(() => rootContext.disabled.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "data-type": "page",
        "aria-label": `Page ${_ctx.value}`,
        "aria-current": isSelected.value ? "page" : void 0,
        "data-selected": isSelected.value ? "true" : void 0,
        disabled: disabled.value,
        type: _ctx.as === "button" ? "button" : void 0,
        onClick: _cache[0] || (_cache[0] = ($event) => !disabled.value && unref(rootContext).onPageChange(_ctx.value))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [createTextVNode(toDisplayString(_ctx.value), 1)])]),
        _: 3
      }, 16, [
        "aria-label",
        "aria-current",
        "data-selected",
        "disabled",
        "type"
      ]);
    };
  }
});
var PaginationListItem_default = PaginationListItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationNext.js
var PaginationNext_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationNext",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPaginationRootContext();
    const disabled = computed(() => rootContext.page.value === rootContext.pageCount.value || rootContext.disabled.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "Next Page",
        type: _ctx.as === "button" ? "button" : void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => !disabled.value && unref(rootContext).onPageChange(unref(rootContext).page.value + 1))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[1] || (_cache[1] = createTextVNode("Next page"))])]),
        _: 3
      }, 16, ["type", "disabled"]);
    };
  }
});
var PaginationNext_default = PaginationNext_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Pagination/PaginationPrev.js
var PaginationPrev_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PaginationPrev",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    useForwardExpose();
    const rootContext = injectPaginationRootContext();
    const disabled = computed(() => rootContext.page.value === 1 || rootContext.disabled.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "aria-label": "Previous Page",
        type: _ctx.as === "button" ? "button" : void 0,
        disabled: disabled.value,
        onClick: _cache[0] || (_cache[0] = ($event) => !disabled.value && unref(rootContext).onPageChange(unref(rootContext).page.value - 1))
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[1] || (_cache[1] = createTextVNode("Prev page"))])]),
        _: 3
      }, 16, ["type", "disabled"]);
    };
  }
});
var PaginationPrev_default = PaginationPrev_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/PinInput/PinInputRoot.js
var [injectPinInputRootContext, providePinInputRootContext] = createContext("PinInputRoot");
var PinInputRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "PinInputRoot",
  props: {
    modelValue: {
      type: null,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    },
    placeholder: {
      type: String,
      required: false,
      default: ""
    },
    mask: {
      type: Boolean,
      required: false
    },
    otp: {
      type: Boolean,
      required: false
    },
    type: {
      type: null,
      required: false,
      default: "text"
    },
    dir: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    id: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue", "complete"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { mask, otp, placeholder, type, disabled, dir: propDir } = toRefs(props2);
    const { forwardRef } = useForwardExpose();
    const dir = useDirection(propDir);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? [],
      passive: true,
      deep: true
    });
    const currentModelValue = computed(() => Array.isArray(modelValue.value) ? [...modelValue.value] : []);
    const inputElements = ref(/* @__PURE__ */ new Set());
    function onInputElementChange(el) {
      inputElements.value.add(el);
    }
    const isNumericMode = computed(() => props2.type === "number");
    const isCompleted = computed(() => {
      const modelValues = currentModelValue.value.filter((i) => !!i || isNumericMode.value && i === 0);
      return modelValues.length === inputElements.value.size;
    });
    watch(modelValue, () => {
      if (isCompleted.value) emits("complete", modelValue.value);
    }, { deep: true });
    providePinInputRootContext({
      modelValue,
      currentModelValue,
      mask,
      otp,
      placeholder,
      type,
      dir,
      disabled,
      isCompleted,
      inputElements,
      onInputElementChange,
      isNumericMode
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        ref: unref(forwardRef),
        dir: unref(dir),
        "data-complete": isCompleted.value ? "" : void 0,
        "data-disabled": unref(disabled) ? "" : void 0
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) }), createVNode(VisuallyHiddenInput_default, {
          id: _ctx.id,
          as: "input",
          feature: "focusable",
          tabindex: "-1",
          value: currentModelValue.value.join(""),
          name: _ctx.name ?? "",
          disabled: unref(disabled),
          required: _ctx.required,
          onFocus: _cache[0] || (_cache[0] = ($event) => Array.from(inputElements.value)?.[0]?.focus())
        }, null, 8, [
          "id",
          "value",
          "name",
          "disabled",
          "required"
        ])]),
        _: 3
      }, 16, [
        "dir",
        "data-complete",
        "data-disabled"
      ]);
    };
  }
});
var PinInputRoot_default = PinInputRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/PinInput/PinInputInput.js
var PinInputInput_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "PinInputInput",
  props: {
    index: {
      type: Number,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "input"
    }
  },
  setup(__props) {
    const props2 = __props;
    const context2 = injectPinInputRootContext();
    const inputElements = computed(() => Array.from(context2.inputElements.value));
    const currentValue = computed(() => context2.currentModelValue.value[props2.index]);
    const disabled = computed(() => props2.disabled || context2.disabled.value);
    const isOtpMode = computed(() => context2.otp.value);
    const isPasswordMode = computed(() => context2.mask.value);
    const { primitiveElement, currentElement } = usePrimitiveElement();
    function handleInput(event) {
      const target = event.target;
      if ((event.data?.length ?? 0) > 1) {
        handleMultipleCharacter(target.value);
        return;
      }
      if (context2.isNumericMode.value && !/^\d*$/.test(target.value)) {
        target.value = target.value.replace(/\D/g, "");
        return;
      }
      target.value = event.data || target.value.slice(-1);
      updateModelValueAt(props2.index, target.value);
      const nextEl = inputElements.value[props2.index + 1];
      if (nextEl) nextEl.focus();
    }
    function resetPlaceholder() {
      const target = currentElement.value;
      nextTick(() => {
        if (target && !target.value) target.placeholder = context2.placeholder.value;
      });
    }
    function handleKeydown(event) {
      useArrowNavigation(event, getActiveElement(), void 0, {
        itemsArray: inputElements.value,
        focus: true,
        loop: false,
        arrowKeyOptions: "horizontal",
        dir: context2.dir.value
      });
    }
    function handleBackspace(event) {
      event.preventDefault();
      const target = event.target;
      const value = target.value;
      if (value) updateModelValueAt(props2.index, "");
      else {
        const prevEl = inputElements.value[props2.index - 1];
        if (prevEl) {
          prevEl.focus();
          updateModelValueAt(props2.index - 1, "");
        }
      }
    }
    function handleDelete(event) {
      if (event.key === "Delete") {
        event.preventDefault();
        updateModelValueAt(props2.index, "");
      }
    }
    function handleFocus(event) {
      const target = event.target;
      target.setSelectionRange(1, 1);
      if (!target.value) target.placeholder = "";
      setTimeout(() => {
        if (!target.value) target.placeholder = "";
      });
    }
    function handleBlur(event) {
      resetPlaceholder();
    }
    function handlePaste(event) {
      event.preventDefault();
      const clipboardData = event.clipboardData;
      if (!clipboardData) return;
      const values = clipboardData.getData("text");
      handleMultipleCharacter(values);
    }
    function handleMultipleCharacter(values) {
      const tempModelValue = [...context2.currentModelValue.value];
      const initialIndex = values.length >= inputElements.value.length ? 0 : props2.index;
      const lastIndex = Math.min(initialIndex + values.length, inputElements.value.length);
      for (let i = initialIndex; i < lastIndex; i++) {
        const input = inputElements.value[i];
        const value = values[i - initialIndex];
        if (context2.isNumericMode.value && !/^\d*$/.test(value)) continue;
        tempModelValue[i] = value;
        input.focus();
      }
      context2.modelValue.value = tempModelValue;
      inputElements.value[lastIndex]?.focus();
    }
    function removeTrailingEmptyStrings(input) {
      let i = input.length - 1;
      while (i >= 0 && input[i] === "") {
        input.pop();
        i--;
      }
      return input;
    }
    function updateModelValueAt(index, value) {
      const tempModelValue = [...context2.currentModelValue.value];
      if (context2.isNumericMode.value) {
        const num = +value;
        if (value === "" || isNaN(num)) delete tempModelValue[index];
        else tempModelValue[index] = num;
      } else tempModelValue[index] = value;
      context2.modelValue.value = removeTrailingEmptyStrings(tempModelValue);
    }
    watch(currentValue, () => {
      if (!currentValue.value) resetPlaceholder();
    });
    onMounted(() => {
      context2.onInputElementChange(currentElement.value);
    });
    onUnmounted(() => {
      context2.inputElements?.value.delete(currentElement.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref_key: "primitiveElement",
        ref: primitiveElement,
        autocapitalize: "none",
        as: _ctx.as,
        "as-child": _ctx.asChild,
        autocomplete: isOtpMode.value ? "one-time-code" : "false",
        type: isPasswordMode.value ? "password" : "text",
        inputmode: unref(context2).isNumericMode.value ? "numeric" : "text",
        pattern: unref(context2).isNumericMode.value ? "[0-9]*" : void 0,
        placeholder: unref(context2).placeholder.value,
        value: currentValue.value,
        disabled: disabled.value,
        "data-disabled": disabled.value ? "" : void 0,
        "data-complete": unref(context2).isCompleted.value ? "" : void 0,
        "aria-label": `pin input ${_ctx.index + 1} of ${inputElements.value.length}`,
        onInput: _cache[0] || (_cache[0] = ($event) => handleInput($event)),
        onKeydown: [
          withKeys(handleKeydown, [
            "left",
            "right",
            "up",
            "down",
            "home",
            "end"
          ]),
          withKeys(handleBackspace, ["backspace"]),
          withKeys(handleDelete, ["delete"])
        ],
        onFocus: handleFocus,
        onBlur: handleBlur,
        onPaste: handlePaste
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "autocomplete",
        "type",
        "inputmode",
        "pattern",
        "placeholder",
        "value",
        "disabled",
        "data-disabled",
        "data-complete",
        "aria-label"
      ]);
    };
  }
});
var PinInputInput_default = PinInputInput_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Progress/ProgressRoot.js
var DEFAULT_MAX = 100;
var [injectProgressRootContext, provideProgressRootContext] = createContext("ProgressRoot");
var isNumber = (v) => typeof v === "number";
function validateValue(value, max2) {
  const isValidValueError = isNullish(value) || isNumber(value) && !Number.isNaN(value) && value <= max2 && value >= 0;
  if (isValidValueError) return value;
  console.error(`Invalid prop \`value\` of value \`${value}\` supplied to \`ProgressRoot\`. The \`value\` prop must be:
  - a positive number
  - less than the value passed to \`max\` (or ${DEFAULT_MAX} if no \`max\` prop is set)
  - \`null\`  or \`undefined\` if the progress is indeterminate.

Defaulting to \`null\`.`);
  return null;
}
function validateMax(max2) {
  const isValidMaxError = isNumber(max2) && !Number.isNaN(max2) && max2 > 0;
  if (isValidMaxError) return max2;
  console.error(`Invalid prop \`max\` of value \`${max2}\` supplied to \`ProgressRoot\`. Only numbers greater than 0 are valid max values. Defaulting to \`${DEFAULT_MAX}\`.`);
  return DEFAULT_MAX;
}
var ProgressRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ProgressRoot",
  props: {
    modelValue: {
      type: [Number, null],
      required: false
    },
    max: {
      type: Number,
      required: false,
      default: DEFAULT_MAX
    },
    getValueLabel: {
      type: Function,
      required: false,
      default: (value, max2) => isNumber(value) ? `${Math.round(value / max2 * DEFAULT_MAX)}%` : void 0
    },
    getValueText: {
      type: Function,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["update:modelValue", "update:max"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    useForwardExpose();
    const modelValue = useVModel(props2, "modelValue", emit, { passive: props2.modelValue === void 0 });
    const max2 = useVModel(props2, "max", emit, { passive: props2.max === void 0 });
    watch(() => modelValue.value, async (value) => {
      const correctedValue = validateValue(value, props2.max);
      if (correctedValue !== value) {
        await nextTick();
        modelValue.value = correctedValue;
      }
    }, { immediate: true });
    watch(() => props2.max, (newMax) => {
      const correctedMax = validateMax(props2.max);
      if (correctedMax !== newMax) max2.value = correctedMax;
    }, { immediate: true });
    const progressState = computed(() => {
      if (isNullish(modelValue.value)) return "indeterminate";
      if (modelValue.value === max2.value) return "complete";
      return "loading";
    });
    provideProgressRootContext({
      modelValue,
      max: max2,
      progressState
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "as-child": _ctx.asChild,
        as: _ctx.as,
        "aria-valuemax": unref(max2),
        "aria-valuemin": 0,
        "aria-valuenow": isNumber(unref(modelValue)) ? unref(modelValue) : void 0,
        "aria-valuetext": _ctx.getValueText?.(unref(modelValue), unref(max2)),
        "aria-label": _ctx.getValueLabel(unref(modelValue), unref(max2)),
        role: "progressbar",
        "data-state": progressState.value,
        "data-value": unref(modelValue) ?? void 0,
        "data-max": unref(max2)
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) })]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "aria-valuemax",
        "aria-valuenow",
        "aria-valuetext",
        "aria-label",
        "data-state",
        "data-value",
        "data-max"
      ]);
    };
  }
});
var ProgressRoot_default = ProgressRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Progress/ProgressIndicator.js
var ProgressIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ProgressIndicator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectProgressRootContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, {
        "data-state": unref(rootContext).progressState.value,
        "data-value": unref(rootContext).modelValue?.value ?? void 0,
        "data-max": unref(rootContext).max.value
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "data-state",
        "data-value",
        "data-max"
      ]);
    };
  }
});
var ProgressIndicator_default = ProgressIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RadioGroup/utils.js
var RADIO_SELECT = "radio.select";
function handleSelect(event, value, callback) {
  const eventDetail = {
    originalEvent: event,
    value
  };
  handleAndDispatchCustomEvent(RADIO_SELECT, callback, eventDetail);
}

// node_modules/reka-ui/dist/RadioGroup/Radio.js
var Radio_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "Radio",
  props: {
    id: {
      type: String,
      required: false
    },
    value: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    checked: {
      type: Boolean,
      required: false,
      default: void 0
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:checked", "select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const checked = useVModel(props2, "checked", emits, { passive: props2.checked === void 0 });
    const { value } = toRefs(props2);
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    const isFormControl = useFormControl(triggerElement);
    const ariaLabel = computed(() => props2.id && triggerElement.value ? document.querySelector(`[for="${props2.id}"]`)?.innerText ?? props2.value : void 0);
    function handleClick(event) {
      if (props2.disabled) return;
      handleSelect(event, props2.value, (ev) => {
        emits("select", ev);
        if (ev?.defaultPrevented) return;
        checked.value = true;
        if (isFormControl.value) ev.stopPropagation();
      });
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(_ctx.$attrs, {
        id: _ctx.id,
        ref: unref(forwardRef),
        role: "radio",
        type: _ctx.as === "button" ? "button" : void 0,
        as: _ctx.as,
        "aria-checked": unref(checked),
        "aria-label": ariaLabel.value,
        "as-child": _ctx.asChild,
        disabled: _ctx.disabled ? "" : void 0,
        "data-state": unref(checked) ? "checked" : "unchecked",
        "data-disabled": _ctx.disabled ? "" : void 0,
        value: unref(value),
        required: _ctx.required,
        name: _ctx.name,
        onClick: withModifiers(handleClick, ["stop"])
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", { checked: unref(checked) }), unref(isFormControl) && _ctx.name ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
          key: 0,
          type: "radio",
          tabindex: "-1",
          value: unref(value),
          checked: !!unref(checked),
          name: _ctx.name,
          disabled: _ctx.disabled,
          required: _ctx.required
        }, null, 8, [
          "value",
          "checked",
          "name",
          "disabled",
          "required"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      }, 16, [
        "id",
        "type",
        "as",
        "aria-checked",
        "aria-label",
        "as-child",
        "disabled",
        "data-state",
        "data-disabled",
        "value",
        "required",
        "name"
      ]);
    };
  }
});
var Radio_default = Radio_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RadioGroup/RadioGroupRoot.js
var [injectRadioGroupRootContext, provideRadioGroupRootContext] = createContext("RadioGroupRoot");
var RadioGroupRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RadioGroupRoot",
  props: {
    modelValue: {
      type: null,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    orientation: {
      type: String,
      required: false,
      default: void 0
    },
    dir: {
      type: String,
      required: false
    },
    loop: {
      type: Boolean,
      required: false,
      default: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  emits: ["update:modelValue"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { forwardRef, currentElement } = useForwardExpose();
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue,
      passive: props2.modelValue === void 0
    });
    const { disabled, loop, orientation, name, required, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    const isFormControl = useFormControl(currentElement);
    provideRadioGroupRootContext({
      modelValue,
      changeModelValue: (value) => {
        modelValue.value = value;
      },
      disabled,
      loop,
      orientation,
      name: name?.value,
      required
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RovingFocusGroup_default), {
        "as-child": "",
        orientation: unref(orientation),
        dir: unref(dir),
        loop: unref(loop)
      }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          role: "radiogroup",
          "data-disabled": unref(disabled) ? "" : void 0,
          "as-child": _ctx.asChild,
          as: _ctx.as,
          "aria-orientation": unref(orientation),
          "aria-required": unref(required),
          dir: unref(dir)
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) }), unref(isFormControl) && unref(name) ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
            key: 0,
            required: unref(required),
            disabled: unref(disabled),
            value: unref(modelValue),
            name: unref(name)
          }, null, 8, [
            "required",
            "disabled",
            "value",
            "name"
          ])) : createCommentVNode("v-if", true)]),
          _: 3
        }, 8, [
          "data-disabled",
          "as-child",
          "as",
          "aria-orientation",
          "aria-required",
          "dir"
        ])]),
        _: 3
      }, 8, [
        "orientation",
        "dir",
        "loop"
      ]);
    };
  }
});
var RadioGroupRoot_default = RadioGroupRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RadioGroup/RadioGroupItem.js
var [injectRadioGroupItemContext, provideRadiogroupItemContext] = createContext("RadioGroupItem");
var RadioGroupItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "RadioGroupItem",
  props: {
    id: {
      type: String,
      required: false
    },
    value: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectRadioGroupRootContext();
    const disabled = computed(() => rootContext.disabled.value || props2.disabled);
    const required = computed(() => rootContext.required.value || props2.required);
    const checked = computed(() => isEqual(rootContext.modelValue?.value, props2.value));
    provideRadiogroupItemContext({
      disabled,
      checked
    });
    const isArrowKeyPressed = ref(false);
    const ARROW_KEYS2 = [
      "ArrowUp",
      "ArrowDown",
      "ArrowLeft",
      "ArrowRight"
    ];
    useEventListener("keydown", (event) => {
      if (ARROW_KEYS2.includes(event.key)) isArrowKeyPressed.value = true;
    });
    useEventListener("keyup", () => {
      isArrowKeyPressed.value = false;
    });
    function handleFocus() {
      setTimeout(() => {
        if (isArrowKeyPressed.value) currentElement.value?.click();
      }, 0);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(RovingFocusItem_default), {
        checked: checked.value,
        disabled: disabled.value,
        "as-child": "",
        focusable: !disabled.value,
        active: checked.value
      }, {
        default: withCtx(() => [createVNode(Radio_default, mergeProps({
          ..._ctx.$attrs,
          ...props2
        }, {
          ref: unref(forwardRef),
          checked: checked.value,
          required: required.value,
          disabled: disabled.value,
          "onUpdate:checked": _cache[0] || (_cache[0] = ($event) => unref(rootContext).changeModelValue(_ctx.value)),
          onSelect: _cache[1] || (_cache[1] = ($event) => emits("select", $event)),
          onKeydown: _cache[2] || (_cache[2] = withKeys(withModifiers(() => {
          }, ["prevent"]), ["enter"])),
          onFocus: handleFocus
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
            checked: checked.value,
            required: required.value,
            disabled: disabled.value
          })]),
          _: 3
        }, 16, [
          "checked",
          "required",
          "disabled"
        ])]),
        _: 3
      }, 8, [
        "checked",
        "disabled",
        "focusable",
        "active"
      ]);
    };
  }
});
var RadioGroupItem_default = RadioGroupItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/RadioGroup/RadioGroupIndicator.js
var RadioGroupIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "RadioGroupIndicator",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const { forwardRef } = useForwardExpose();
    const itemContext = injectRadioGroupItemContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || unref(itemContext).checked.value }, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps({
          ref: unref(forwardRef),
          "data-state": unref(itemContext).checked.value ? "checked" : "unchecked",
          "data-disabled": unref(itemContext).disabled.value ? "" : void 0,
          "as-child": _ctx.asChild,
          as: _ctx.as
        }, _ctx.$attrs), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "data-state",
          "data-disabled",
          "as-child",
          "as"
        ])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var RadioGroupIndicator_default = RadioGroupIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaRoot.js
var [injectScrollAreaRootContext, provideScrollAreaRootContext] = createContext("ScrollAreaRoot");
var ScrollAreaRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaRoot",
  props: {
    type: {
      type: String,
      required: false,
      default: "hover"
    },
    dir: {
      type: String,
      required: false
    },
    scrollHideDelay: {
      type: Number,
      required: false,
      default: 600
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props, { expose: __expose }) {
    const props2 = __props;
    const cornerWidth = ref(0);
    const cornerHeight = ref(0);
    const viewport = ref();
    const content = ref();
    const scrollbarX = ref();
    const scrollbarY = ref();
    const scrollbarXEnabled = ref(false);
    const scrollbarYEnabled = ref(false);
    const { type, dir: propDir, scrollHideDelay } = toRefs(props2);
    const dir = useDirection(propDir);
    function scrollTop() {
      viewport.value?.scrollTo({ top: 0 });
    }
    function scrollTopLeft() {
      viewport.value?.scrollTo({
        top: 0,
        left: 0
      });
    }
    __expose({
      viewport,
      scrollTop,
      scrollTopLeft
    });
    const { forwardRef, currentElement: scrollArea } = useForwardExpose();
    provideScrollAreaRootContext({
      type,
      dir,
      scrollHideDelay,
      scrollArea,
      viewport,
      onViewportChange: (el) => {
        viewport.value = el || void 0;
      },
      content,
      onContentChange: (el) => {
        content.value = el;
      },
      scrollbarX,
      scrollbarXEnabled,
      scrollbarY,
      scrollbarYEnabled,
      onScrollbarXChange: (scrollbar) => {
        scrollbarX.value = scrollbar || void 0;
      },
      onScrollbarYChange: (scrollbar) => {
        scrollbarY.value = scrollbar || void 0;
      },
      onScrollbarXEnabledChange: (rendered) => {
        scrollbarXEnabled.value = rendered;
      },
      onScrollbarYEnabledChange: (rendered) => {
        scrollbarYEnabled.value = rendered;
      },
      onCornerWidthChange: (width) => {
        cornerWidth.value = width;
      },
      onCornerHeightChange: (height) => {
        cornerHeight.value = height;
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        "as-child": props2.asChild,
        as: _ctx.as,
        dir: unref(dir),
        style: normalizeStyle({
          position: "relative",
          ["--reka-scroll-area-corner-width"]: `${cornerWidth.value}px`,
          ["--reka-scroll-area-corner-height"]: `${cornerHeight.value}px`
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "dir",
        "style"
      ]);
    };
  }
});
var ScrollAreaRoot_default = ScrollAreaRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaCornerImpl.js
var ScrollAreaCornerImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaCornerImpl",
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const width = ref(0);
    const height = ref(0);
    const hasSize = computed(() => !!width.value && !!height.value);
    function setCornerHeight() {
      const offsetHeight = rootContext.scrollbarX.value?.offsetHeight || 0;
      rootContext.onCornerHeightChange(offsetHeight);
      height.value = offsetHeight;
    }
    function setCornerWidth() {
      const offsetWidth = rootContext.scrollbarY.value?.offsetWidth || 0;
      rootContext.onCornerWidthChange(offsetWidth);
      width.value = offsetWidth;
    }
    useResizeObserver(rootContext.scrollbarX.value, setCornerHeight);
    useResizeObserver(rootContext.scrollbarY.value, setCornerWidth);
    watch(() => rootContext.scrollbarX.value, setCornerHeight);
    watch(() => rootContext.scrollbarY.value, setCornerWidth);
    return (_ctx, _cache) => {
      return hasSize.value ? (openBlock(), createBlock(unref(Primitive), mergeProps({
        key: 0,
        style: {
          width: `${width.value}px`,
          height: `${height.value}px`,
          position: "absolute",
          right: unref(rootContext).dir.value === "ltr" ? 0 : void 0,
          left: unref(rootContext).dir.value === "rtl" ? 0 : void 0,
          bottom: 0
        }
      }, _ctx.$parent?.$props), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["style"])) : createCommentVNode("v-if", true);
    };
  }
});
var ScrollAreaCornerImpl_default = ScrollAreaCornerImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaCorner.js
var ScrollAreaCorner_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaCorner",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef } = useForwardExpose();
    const rootContext = injectScrollAreaRootContext();
    const hasBothScrollbarsVisible = computed(() => !!rootContext.scrollbarX.value && !!rootContext.scrollbarY.value);
    const hasCorner = computed(() => rootContext.type.value !== "scroll" && hasBothScrollbarsVisible.value);
    return (_ctx, _cache) => {
      return hasCorner.value ? (openBlock(), createBlock(ScrollAreaCornerImpl_default, mergeProps({ key: 0 }, props2, { ref: unref(forwardRef) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var ScrollAreaCorner_default = ScrollAreaCorner_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/utils.js
function linearScale(input, output) {
  return (value) => {
    if (input[0] === input[1] || output[0] === output[1]) return output[0];
    const ratio = (output[1] - output[0]) / (input[1] - input[0]);
    return output[0] + ratio * (value - input[0]);
  };
}
function getThumbSize(sizes) {
  const ratio = getThumbRatio(sizes.viewport, sizes.content);
  const scrollbarPadding = sizes.scrollbar.paddingStart + sizes.scrollbar.paddingEnd;
  const thumbSize = (sizes.scrollbar.size - scrollbarPadding) * ratio;
  return Math.max(thumbSize, 18);
}
function getThumbRatio(viewportSize, contentSize) {
  const ratio = viewportSize / contentSize;
  return Number.isNaN(ratio) ? 0 : ratio;
}
function addUnlinkedScrollListener(node, handler = () => {
}) {
  let prevPosition = {
    left: node.scrollLeft,
    top: node.scrollTop
  };
  let rAF = 0;
  (function loop() {
    const position = {
      left: node.scrollLeft,
      top: node.scrollTop
    };
    const isHorizontalScroll = prevPosition.left !== position.left;
    const isVerticalScroll = prevPosition.top !== position.top;
    if (isHorizontalScroll || isVerticalScroll) handler();
    prevPosition = position;
    rAF = window.requestAnimationFrame(loop);
  })();
  return () => window.cancelAnimationFrame(rAF);
}
function getThumbOffsetFromScroll(scrollPos, sizes, dir = "ltr") {
  const thumbSizePx = getThumbSize(sizes);
  const scrollbarPadding = sizes.scrollbar.paddingStart + sizes.scrollbar.paddingEnd;
  const scrollbar = sizes.scrollbar.size - scrollbarPadding;
  const maxScrollPos = sizes.content - sizes.viewport;
  const maxThumbPos = scrollbar - thumbSizePx;
  const scrollClampRange = dir === "ltr" ? [0, maxScrollPos] : [maxScrollPos * -1, 0];
  const scrollWithoutMomentum = clamp(scrollPos, scrollClampRange[0], scrollClampRange[1]);
  const interpolate = linearScale([0, maxScrollPos], [0, maxThumbPos]);
  return interpolate(scrollWithoutMomentum);
}
function toInt(value) {
  return value ? Number.parseInt(value, 10) : 0;
}
function getScrollPositionFromPointer(pointerPos, pointerOffset, sizes, dir = "ltr") {
  const thumbSizePx = getThumbSize(sizes);
  const thumbCenter = thumbSizePx / 2;
  const offset3 = pointerOffset || thumbCenter;
  const thumbOffsetFromEnd = thumbSizePx - offset3;
  const minPointerPos = sizes.scrollbar.paddingStart + offset3;
  const maxPointerPos = sizes.scrollbar.size - sizes.scrollbar.paddingEnd - thumbOffsetFromEnd;
  const maxScrollPos = sizes.content - sizes.viewport;
  const scrollRange = dir === "ltr" ? [0, maxScrollPos] : [maxScrollPos * -1, 0];
  const interpolate = linearScale([minPointerPos, maxPointerPos], scrollRange);
  return interpolate(pointerPos);
}
function isScrollingWithinScrollbarBounds(scrollPos, maxScrollPos) {
  return scrollPos > 0 && scrollPos < maxScrollPos;
}

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarX.js
var ScrollAreaScrollbarX_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarX",
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const scrollbarVisibleContext = injectScrollAreaScrollbarVisibleContext();
    const { forwardRef, currentElement: scrollbarElement } = useForwardExpose();
    onMounted(() => {
      if (scrollbarElement.value) rootContext.onScrollbarXChange(scrollbarElement.value);
    });
    const sizes = computed(() => scrollbarVisibleContext.sizes.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(ScrollAreaScrollbarImpl_default, {
        ref: unref(forwardRef),
        "is-horizontal": true,
        "data-orientation": "horizontal",
        style: normalizeStyle({
          bottom: 0,
          left: unref(rootContext).dir.value === "rtl" ? "var(--reka-scroll-area-corner-width)" : 0,
          right: unref(rootContext).dir.value === "ltr" ? "var(--reka-scroll-area-corner-width)" : 0,
          ["--reka-scroll-area-thumb-width"]: sizes.value ? `${unref(getThumbSize)(sizes.value)}px` : void 0
        }),
        onOnDragScroll: _cache[0] || (_cache[0] = ($event) => unref(scrollbarVisibleContext).onDragScroll($event.x))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["style"]);
    };
  }
});
var ScrollAreaScrollbarX_default = ScrollAreaScrollbarX_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarY.js
var ScrollAreaScrollbarY_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarY",
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const scrollbarVisibleContext = injectScrollAreaScrollbarVisibleContext();
    const { forwardRef, currentElement: scrollbarElement } = useForwardExpose();
    onMounted(() => {
      if (scrollbarElement.value) rootContext.onScrollbarYChange(scrollbarElement.value);
    });
    const sizes = computed(() => scrollbarVisibleContext.sizes.value);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(ScrollAreaScrollbarImpl_default, {
        ref: unref(forwardRef),
        "is-horizontal": false,
        "data-orientation": "vertical",
        style: normalizeStyle({
          top: 0,
          right: unref(rootContext).dir.value === "ltr" ? 0 : void 0,
          left: unref(rootContext).dir.value === "rtl" ? 0 : void 0,
          bottom: "var(--reka-scroll-area-corner-height)",
          ["--reka-scroll-area-thumb-height"]: sizes.value ? `${unref(getThumbSize)(sizes.value)}px` : void 0
        }),
        onOnDragScroll: _cache[0] || (_cache[0] = ($event) => unref(scrollbarVisibleContext).onDragScroll($event.y))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["style"]);
    };
  }
});
var ScrollAreaScrollbarY_default = ScrollAreaScrollbarY_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarAuto.js
var ScrollAreaScrollbarAuto_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarAuto",
  props: { forceMount: {
    type: Boolean,
    required: false
  } },
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const scrollbarContext = injectScrollAreaScrollbarContext();
    const { forwardRef } = useForwardExpose();
    const visible = ref(false);
    const handleResize = useDebounceFn(() => {
      if (rootContext.viewport.value) {
        const isOverflowX = rootContext.viewport.value.offsetWidth < rootContext.viewport.value.scrollWidth;
        const isOverflowY = rootContext.viewport.value.offsetHeight < rootContext.viewport.value.scrollHeight;
        visible.value = scrollbarContext.isHorizontal.value ? isOverflowX : isOverflowY;
      }
    }, 10);
    onMounted(() => handleResize());
    useResizeObserver(rootContext.viewport, handleResize);
    useResizeObserver(rootContext.content, handleResize);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || visible.value }, {
        default: withCtx(() => [createVNode(ScrollAreaScrollbarVisible_default, mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          "data-state": visible.value ? "visible" : "hidden"
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["data-state"])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var ScrollAreaScrollbarAuto_default = ScrollAreaScrollbarAuto_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarHover.js
var ScrollAreaScrollbarHover_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaScrollbarHover",
  props: { forceMount: {
    type: Boolean,
    required: false
  } },
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const { forwardRef } = useForwardExpose();
    let timeout;
    const visible = ref(false);
    function handlePointerEnter() {
      window.clearTimeout(timeout);
      visible.value = true;
    }
    function handlePointerLeave() {
      timeout = window.setTimeout(() => {
        visible.value = false;
      }, rootContext.scrollHideDelay.value);
    }
    onMounted(() => {
      const scrollArea = rootContext.scrollArea.value;
      if (scrollArea) {
        scrollArea.addEventListener("pointerenter", handlePointerEnter);
        scrollArea.addEventListener("pointerleave", handlePointerLeave);
      }
    });
    onUnmounted(() => {
      const scrollArea = rootContext.scrollArea.value;
      if (scrollArea) {
        window.clearTimeout(timeout);
        scrollArea.removeEventListener("pointerenter", handlePointerEnter);
        scrollArea.removeEventListener("pointerleave", handlePointerLeave);
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || visible.value }, {
        default: withCtx(() => [createVNode(ScrollAreaScrollbarAuto_default, mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          "data-state": visible.value ? "visible" : "hidden"
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["data-state"])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var ScrollAreaScrollbarHover_default = ScrollAreaScrollbarHover_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarScroll.js
var ScrollAreaScrollbarScroll_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarScroll",
  props: { forceMount: {
    type: Boolean,
    required: false
  } },
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const scrollbarContext = injectScrollAreaScrollbarContext();
    const { forwardRef } = useForwardExpose();
    const { state, dispatch } = useStateMachine("hidden", {
      hidden: { SCROLL: "scrolling" },
      scrolling: {
        SCROLL_END: "idle",
        POINTER_ENTER: "interacting"
      },
      interacting: {
        SCROLL: "interacting",
        POINTER_LEAVE: "idle"
      },
      idle: {
        HIDE: "hidden",
        SCROLL: "scrolling",
        POINTER_ENTER: "interacting"
      }
    });
    const visible = computed(() => state.value !== "hidden");
    watchEffect((onCleanup) => {
      if (state.value === "idle") {
        const timeId = window.setTimeout(() => dispatch("HIDE"), rootContext.scrollHideDelay.value);
        onCleanup(() => {
          window.clearTimeout(timeId);
        });
      }
    });
    const debounceScrollEnd = useDebounceFn(() => dispatch("SCROLL_END"), 100);
    watchEffect((onCleanup) => {
      const viewport = rootContext.viewport.value;
      const scrollDirection = scrollbarContext.isHorizontal.value ? "scrollLeft" : "scrollTop";
      if (viewport) {
        let prevScrollPos = viewport[scrollDirection];
        const handleScroll = () => {
          const scrollPos = viewport[scrollDirection];
          const hasScrollInDirectionChanged = prevScrollPos !== scrollPos;
          if (hasScrollInDirectionChanged) {
            dispatch("SCROLL");
            debounceScrollEnd();
          }
          prevScrollPos = scrollPos;
        };
        viewport.addEventListener("scroll", handleScroll);
        onCleanup(() => {
          viewport.removeEventListener("scroll", handleScroll);
        });
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Presence_default), { present: _ctx.forceMount || visible.value }, {
        default: withCtx(() => [createVNode(ScrollAreaScrollbarVisible_default, mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          "data-state": visible.value ? "visible" : "hidden"
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, ["data-state"])]),
        _: 3
      }, 8, ["present"]);
    };
  }
});
var ScrollAreaScrollbarScroll_default = ScrollAreaScrollbarScroll_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbar.js
var [injectScrollAreaScrollbarContext, provideScrollAreaScrollbarContext] = createContext("ScrollAreaScrollbar");
var ScrollAreaScrollbar_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaScrollbar",
  props: {
    orientation: {
      type: String,
      required: false,
      default: "vertical"
    },
    forceMount: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef } = useForwardExpose();
    const rootContext = injectScrollAreaRootContext();
    const isHorizontal = computed(() => props2.orientation === "horizontal");
    watch(isHorizontal, () => {
      if (isHorizontal.value) rootContext.onScrollbarXEnabledChange(true);
      else rootContext.onScrollbarYEnabledChange(true);
    }, { immediate: true });
    onUnmounted(() => {
      rootContext.onScrollbarXEnabledChange(false);
      rootContext.onScrollbarYEnabledChange(false);
    });
    const { orientation, forceMount, asChild, as } = toRefs(props2);
    provideScrollAreaScrollbarContext({
      orientation,
      forceMount,
      isHorizontal,
      as,
      asChild
    });
    return (_ctx, _cache) => {
      return unref(rootContext).type.value === "hover" ? (openBlock(), createBlock(ScrollAreaScrollbarHover_default, mergeProps({ key: 0 }, _ctx.$attrs, {
        ref: unref(forwardRef),
        "force-mount": unref(forceMount)
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["force-mount"])) : unref(rootContext).type.value === "scroll" ? (openBlock(), createBlock(ScrollAreaScrollbarScroll_default, mergeProps({ key: 1 }, _ctx.$attrs, {
        ref: unref(forwardRef),
        "force-mount": unref(forceMount)
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["force-mount"])) : unref(rootContext).type.value === "auto" ? (openBlock(), createBlock(ScrollAreaScrollbarAuto_default, mergeProps({ key: 2 }, _ctx.$attrs, {
        ref: unref(forwardRef),
        "force-mount": unref(forceMount)
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["force-mount"])) : unref(rootContext).type.value === "always" ? (openBlock(), createBlock(ScrollAreaScrollbarVisible_default, mergeProps({ key: 3 }, _ctx.$attrs, {
        ref: unref(forwardRef),
        "data-state": "visible"
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var ScrollAreaScrollbar_default = ScrollAreaScrollbar_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarVisible.js
var [injectScrollAreaScrollbarVisibleContext, provideScrollAreaScrollbarVisibleContext] = createContext("ScrollAreaScrollbarVisible");
var ScrollAreaScrollbarVisible_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarVisible",
  setup(__props) {
    const rootContext = injectScrollAreaRootContext();
    const scrollbarContext = injectScrollAreaScrollbarContext();
    const { forwardRef } = useForwardExpose();
    const sizes = ref({
      content: 0,
      viewport: 0,
      scrollbar: {
        size: 0,
        paddingStart: 0,
        paddingEnd: 0
      }
    });
    const hasThumb = computed(() => {
      const thumbRatio = getThumbRatio(sizes.value.viewport, sizes.value.content);
      return Boolean(thumbRatio > 0 && thumbRatio < 1);
    });
    const thumbRef = ref();
    const pointerOffset = ref(0);
    function handleWheelScroll(event, payload) {
      if (isShowingScrollbarX.value) {
        const scrollPos = rootContext.viewport.value.scrollLeft + event.deltaY;
        rootContext.viewport.value.scrollLeft = scrollPos;
        if (isScrollingWithinScrollbarBounds(scrollPos, payload)) event.preventDefault();
      } else {
        const scrollPos = rootContext.viewport.value.scrollTop + event.deltaY;
        rootContext.viewport.value.scrollTop = scrollPos;
        if (isScrollingWithinScrollbarBounds(scrollPos, payload)) event.preventDefault();
      }
    }
    function handleThumbDown(event, payload) {
      if (isShowingScrollbarX.value) pointerOffset.value = payload.x;
      else pointerOffset.value = payload.y;
    }
    function handleThumbUp(event) {
      pointerOffset.value = 0;
    }
    function handleSizeChange(payload) {
      sizes.value = payload;
    }
    function getScrollPosition(pointerPos, dir) {
      return getScrollPositionFromPointer(pointerPos, pointerOffset.value, sizes.value, dir);
    }
    const isShowingScrollbarX = computed(() => scrollbarContext.isHorizontal.value);
    function onDragScroll(payload) {
      if (isShowingScrollbarX.value) rootContext.viewport.value.scrollLeft = getScrollPosition(payload, rootContext.dir.value);
      else rootContext.viewport.value.scrollTop = getScrollPosition(payload);
    }
    function onThumbPositionChange() {
      if (isShowingScrollbarX.value) {
        if (rootContext.viewport.value && thumbRef.value) {
          const scrollPos = rootContext.viewport.value.scrollLeft;
          const offset3 = getThumbOffsetFromScroll(scrollPos, sizes.value, rootContext.dir.value);
          thumbRef.value.style.transform = `translate3d(${offset3}px, 0, 0)`;
        }
      } else if (rootContext.viewport.value && thumbRef.value) {
        const scrollPos = rootContext.viewport.value.scrollTop;
        const offset3 = getThumbOffsetFromScroll(scrollPos, sizes.value);
        thumbRef.value.style.transform = `translate3d(0, ${offset3}px, 0)`;
      }
    }
    function onThumbChange(element) {
      thumbRef.value = element;
    }
    provideScrollAreaScrollbarVisibleContext({
      sizes,
      hasThumb,
      handleWheelScroll,
      handleThumbDown,
      handleThumbUp,
      handleSizeChange,
      onThumbPositionChange,
      onThumbChange,
      onDragScroll
    });
    return (_ctx, _cache) => {
      return isShowingScrollbarX.value ? (openBlock(), createBlock(ScrollAreaScrollbarX_default, mergeProps({ key: 0 }, _ctx.$attrs, { ref: unref(forwardRef) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : (openBlock(), createBlock(ScrollAreaScrollbarY_default, mergeProps({ key: 1 }, _ctx.$attrs, { ref: unref(forwardRef) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16));
    };
  }
});
var ScrollAreaScrollbarVisible_default = ScrollAreaScrollbarVisible_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaScrollbarImpl.js
var ScrollAreaScrollbarImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaScrollbarImpl",
  props: { isHorizontal: {
    type: Boolean,
    required: true
  } },
  emits: [
    "onDragScroll",
    "onWheelScroll",
    "onThumbPointerDown"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emit = __emit;
    const rootContext = injectScrollAreaRootContext();
    const scrollbarVisibleContext = injectScrollAreaScrollbarVisibleContext();
    const scrollbarContext = injectScrollAreaScrollbarContext();
    const { forwardRef, currentElement: scrollbar } = useForwardExpose();
    const prevWebkitUserSelectRef = ref("");
    const rectRef = ref();
    function handleDragScroll(event) {
      if (rectRef.value) {
        const x = event.clientX - rectRef.value?.left;
        const y = event.clientY - rectRef.value?.top;
        emit("onDragScroll", {
          x,
          y
        });
      }
    }
    function handlePointerDown2(event) {
      const mainPointer = 0;
      if (event.button === mainPointer) {
        const element = event.target;
        element.setPointerCapture(event.pointerId);
        rectRef.value = scrollbar.value.getBoundingClientRect();
        prevWebkitUserSelectRef.value = document.body.style.webkitUserSelect;
        document.body.style.webkitUserSelect = "none";
        if (rootContext.viewport) rootContext.viewport.value.style.scrollBehavior = "auto";
        handleDragScroll(event);
      }
    }
    function handlePointerMove2(event) {
      handleDragScroll(event);
    }
    function handlePointerUp2(event) {
      const element = event.target;
      if (element.hasPointerCapture(event.pointerId)) element.releasePointerCapture(event.pointerId);
      document.body.style.webkitUserSelect = prevWebkitUserSelectRef.value;
      if (rootContext.viewport) rootContext.viewport.value.style.scrollBehavior = "";
      rectRef.value = void 0;
    }
    function handleWheel(event) {
      const element = event.target;
      const isScrollbarWheel = scrollbar.value?.contains(element);
      const maxScrollPos = scrollbarVisibleContext.sizes.value.content - scrollbarVisibleContext.sizes.value.viewport;
      if (isScrollbarWheel) scrollbarVisibleContext.handleWheelScroll(event, maxScrollPos);
    }
    onMounted(() => {
      document.addEventListener("wheel", handleWheel, { passive: false });
    });
    onUnmounted(() => {
      document.removeEventListener("wheel", handleWheel);
    });
    function handleSizeChange() {
      if (!scrollbar.value) return;
      if (props2.isHorizontal) scrollbarVisibleContext.handleSizeChange({
        content: rootContext.viewport.value?.scrollWidth ?? 0,
        viewport: rootContext.viewport.value?.offsetWidth ?? 0,
        scrollbar: {
          size: scrollbar.value.clientWidth ?? 0,
          paddingStart: toInt(getComputedStyle(scrollbar.value).paddingLeft),
          paddingEnd: toInt(getComputedStyle(scrollbar.value).paddingRight)
        }
      });
      else scrollbarVisibleContext.handleSizeChange({
        content: rootContext.viewport.value?.scrollHeight ?? 0,
        viewport: rootContext.viewport.value?.offsetHeight ?? 0,
        scrollbar: {
          size: scrollbar.value?.clientHeight ?? 0,
          paddingStart: toInt(getComputedStyle(scrollbar.value).paddingTop),
          paddingEnd: toInt(getComputedStyle(scrollbar.value).paddingBottom)
        }
      });
      scrollbarVisibleContext.onThumbPositionChange();
    }
    useResizeObserver(scrollbar, handleSizeChange);
    useResizeObserver(rootContext.content, handleSizeChange);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        style: { "position": "absolute" },
        "data-scrollbarimpl": "",
        as: unref(scrollbarContext).as.value,
        "as-child": unref(scrollbarContext).asChild.value,
        onPointerdown: handlePointerDown2,
        onPointermove: handlePointerMove2,
        onPointerup: handlePointerUp2
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["as", "as-child"]);
    };
  }
});
var ScrollAreaScrollbarImpl_default = ScrollAreaScrollbarImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaThumb.js
var ScrollAreaThumb_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "ScrollAreaThumb",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectScrollAreaRootContext();
    const scrollbarContextVisible = injectScrollAreaScrollbarVisibleContext();
    function handlePointerDown2(event) {
      const thumb = event.target;
      const thumbRect = thumb.getBoundingClientRect();
      const x = event.clientX - thumbRect.left;
      const y = event.clientY - thumbRect.top;
      scrollbarContextVisible.handleThumbDown(event, {
        x,
        y
      });
    }
    function handlePointerUp2(event) {
      scrollbarContextVisible.handleThumbUp(event);
    }
    const { forwardRef, currentElement: thumbElement } = useForwardExpose();
    const removeUnlinkedScrollListenerRef = ref();
    const viewport = computed(() => rootContext.viewport.value);
    function handleScroll() {
      if (!removeUnlinkedScrollListenerRef.value) {
        const listener = addUnlinkedScrollListener(viewport.value, scrollbarContextVisible.onThumbPositionChange);
        removeUnlinkedScrollListenerRef.value = listener;
        scrollbarContextVisible.onThumbPositionChange();
      }
    }
    const sizes = computed(() => scrollbarContextVisible.sizes.value);
    watchOnce(sizes, () => {
      scrollbarContextVisible.onThumbChange(thumbElement.value);
      if (viewport.value) {
        scrollbarContextVisible.onThumbPositionChange();
        viewport.value.addEventListener("scroll", handleScroll);
      }
    });
    onUnmounted(() => {
      viewport.value.removeEventListener("scroll", handleScroll);
      rootContext.viewport.value?.removeEventListener("scroll", handleScroll);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        "data-state": unref(scrollbarContextVisible).hasThumb ? "visible" : "hidden",
        style: {
          width: "var(--reka-scroll-area-thumb-width)",
          height: "var(--reka-scroll-area-thumb-height)"
        },
        "as-child": props2.asChild,
        as: _ctx.as,
        onPointerdown: handlePointerDown2,
        onPointerup: handlePointerUp2
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "data-state",
        "as-child",
        "as"
      ]);
    };
  }
});
var ScrollAreaThumb_default = ScrollAreaThumb_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/ScrollArea/ScrollAreaViewport.js
var ScrollAreaViewport_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "ScrollAreaViewport",
  props: {
    nonce: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props, { expose: __expose }) {
    const props2 = __props;
    const { nonce: propNonce } = toRefs(props2);
    const nonce = useNonce(propNonce);
    const rootContext = injectScrollAreaRootContext();
    const viewportElement = ref();
    onMounted(() => {
      rootContext.onViewportChange(viewportElement.value);
      rootContext.onContentChange(contentElement.value);
    });
    __expose({ viewportElement });
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createBaseVNode("div", mergeProps({
        ref_key: "viewportElement",
        ref: viewportElement,
        "data-reka-scroll-area-viewport": "",
        style: {
          overflowX: unref(rootContext).scrollbarXEnabled.value ? "scroll" : "hidden",
          overflowY: unref(rootContext).scrollbarYEnabled.value ? "scroll" : "hidden"
        }
      }, _ctx.$attrs, { tabindex: 0 }), [createVNode(unref(Primitive), {
        ref: unref(forwardRef),
        style: normalizeStyle({ minWidth: unref(rootContext).scrollbarXEnabled.value ? "fit-content" : void 0 }),
        "as-child": props2.asChild,
        as: _ctx.as
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "style",
        "as-child",
        "as"
      ])], 16), createVNode(unref(Primitive), {
        as: "style",
        nonce: unref(nonce)
      }, {
        default: withCtx(() => _cache[0] || (_cache[0] = [createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-reka-scroll-area-viewport] { scrollbar-width:none; -ms-overflow-style:none; -webkit-overflow-scrolling:touch; } [data-reka-scroll-area-viewport]::-webkit-scrollbar { display:none; } ")])),
        _: 1,
        __: [0]
      }, 8, ["nonce"])], 64);
    };
  }
});
var ScrollAreaViewport_default = ScrollAreaViewport_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/utils.js
var OPEN_KEYS = [
  " ",
  "Enter",
  "ArrowUp",
  "ArrowDown"
];
var SELECTION_KEYS2 = [" ", "Enter"];
var CONTENT_MARGIN = 10;
function valueComparator2(value, currentValue, comparator) {
  if (value === void 0) return false;
  else if (Array.isArray(value)) return value.some((val) => compare2(val, currentValue, comparator));
  else return compare2(value, currentValue, comparator);
}
function compare2(value, currentValue, comparator) {
  if (value === void 0 || currentValue === void 0) return false;
  if (typeof value === "string") return value === currentValue;
  if (typeof comparator === "function") return comparator(value, currentValue);
  if (typeof comparator === "string") return value?.[comparator] === currentValue?.[comparator];
  return isEqual(value, currentValue);
}
function shouldShowPlaceholder(value) {
  return value === void 0 || value === null || value === "" || Array.isArray(value) && value.length === 0;
}

// node_modules/reka-ui/dist/Select/SelectRoot.js
var _hoisted_15 = {
  key: 0,
  value: ""
};
var [injectSelectRootContext, provideSelectRootContext] = createContext("SelectRoot");
var SelectRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SelectRoot",
  props: {
    open: {
      type: Boolean,
      required: false,
      default: void 0
    },
    defaultOpen: {
      type: Boolean,
      required: false
    },
    defaultValue: {
      type: null,
      required: false
    },
    modelValue: {
      type: null,
      required: false,
      default: void 0
    },
    by: {
      type: [String, Function],
      required: false
    },
    dir: {
      type: String,
      required: false
    },
    multiple: {
      type: Boolean,
      required: false
    },
    autocomplete: {
      type: String,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue", "update:open"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { required, disabled, multiple, dir: propDir } = toRefs(props2);
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue ?? (multiple.value ? [] : void 0),
      passive: props2.modelValue === void 0,
      deep: true
    });
    const open = useVModel(props2, "open", emits, {
      defaultValue: props2.defaultOpen,
      passive: props2.open === void 0
    });
    const triggerElement = ref();
    const valueElement = ref();
    const triggerPointerDownPosRef = ref({
      x: 0,
      y: 0
    });
    const isEmptyModelValue = computed(() => {
      if (multiple.value && Array.isArray(modelValue.value)) return modelValue.value?.length === 0;
      else return isNullish(modelValue.value);
    });
    useCollection({ isProvider: true });
    const dir = useDirection(propDir);
    const isFormControl = useFormControl(triggerElement);
    const optionsSet = ref(/* @__PURE__ */ new Set());
    const nativeSelectKey = computed(() => {
      return Array.from(optionsSet.value).map((option) => option.value).join(";");
    });
    function handleValueChange(value) {
      if (multiple.value) {
        const array = Array.isArray(modelValue.value) ? [...modelValue.value] : [];
        const index = array.findIndex((i) => compare2(i, value, props2.by));
        index === -1 ? array.push(value) : array.splice(index, 1);
        modelValue.value = [...array];
      } else modelValue.value = value;
    }
    function getOption(value) {
      return Array.from(optionsSet.value).find((option) => valueComparator2(value, option.value, props2.by));
    }
    provideSelectRootContext({
      triggerElement,
      onTriggerChange: (node) => {
        triggerElement.value = node;
      },
      valueElement,
      onValueElementChange: (node) => {
        valueElement.value = node;
      },
      contentId: "",
      modelValue,
      onValueChange: handleValueChange,
      by: props2.by,
      open,
      multiple,
      required,
      onOpenChange: (value) => {
        open.value = value;
      },
      dir,
      triggerPointerDownPosRef,
      disabled,
      isEmptyModelValue,
      optionsSet,
      onOptionAdd: (option) => {
        const existingOption = getOption(option.value);
        if (existingOption) optionsSet.value.delete(existingOption);
        optionsSet.value.add(option);
      },
      onOptionRemove: (option) => {
        const existingOption = getOption(option.value);
        if (existingOption) optionsSet.value.delete(existingOption);
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperRoot_default), null, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          modelValue: unref(modelValue),
          open: unref(open)
        }), unref(isFormControl) ? (openBlock(), createBlock(BubbleSelect_default, {
          key: nativeSelectKey.value,
          "aria-hidden": "true",
          tabindex: "-1",
          multiple: unref(multiple),
          required: unref(required),
          name: _ctx.name,
          autocomplete: _ctx.autocomplete,
          disabled: unref(disabled),
          value: unref(modelValue)
        }, {
          default: withCtx(() => [unref(isNullish)(unref(modelValue)) ? (openBlock(), createElementBlock("option", _hoisted_15)) : createCommentVNode("v-if", true), (openBlock(true), createElementBlock(Fragment, null, renderList(Array.from(optionsSet.value), (option) => {
            return openBlock(), createElementBlock("option", mergeProps({ key: option.value ?? "" }, { ref_for: true }, option), null, 16);
          }), 128))]),
          _: 1
        }, 8, [
          "multiple",
          "required",
          "name",
          "autocomplete",
          "disabled",
          "value"
        ])) : createCommentVNode("v-if", true)]),
        _: 3
      });
    };
  }
});
var SelectRoot_default = SelectRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/BubbleSelect.js
var BubbleSelect_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "BubbleSelect",
  props: {
    autocomplete: {
      type: String,
      required: false
    },
    autofocus: {
      type: Boolean,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    form: {
      type: String,
      required: false
    },
    multiple: {
      type: Boolean,
      required: false
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    },
    size: {
      type: Number,
      required: false
    },
    value: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const selectElement = ref();
    const rootContext = injectSelectRootContext();
    watch(() => props2.value, (cur, prev) => {
      const selectProto = window.HTMLSelectElement.prototype;
      const descriptor = Object.getOwnPropertyDescriptor(selectProto, "value");
      const setValue = descriptor.set;
      if (cur !== prev && setValue && selectElement.value) {
        const event = new Event("change", { bubbles: true });
        setValue.call(selectElement.value, cur);
        selectElement.value.dispatchEvent(event);
      }
    });
    function handleInput(event) {
      rootContext.onValueChange(event.target.value);
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(VisuallyHidden_default), { "as-child": "" }, {
        default: withCtx(() => [createBaseVNode("select", mergeProps({
          ref_key: "selectElement",
          ref: selectElement
        }, props2, { onInput: handleInput }), [renderSlot(_ctx.$slots, "default")], 16)]),
        _: 3
      });
    };
  }
});
var BubbleSelect_default = BubbleSelect_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectPopperPosition.js
var SelectPopperPosition_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectPopperPosition",
  props: {
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false,
      default: "start"
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false,
      default: CONTENT_MARGIN
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const forwarded = useForwardProps(props2);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperContent_default), mergeProps(unref(forwarded), { style: {
        "boxSizing": "border-box",
        "--reka-select-content-transform-origin": "var(--reka-popper-transform-origin)",
        "--reka-select-content-available-width": "var(--reka-popper-available-width)",
        "--reka-select-content-available-height": "var(--reka-popper-available-height)",
        "--reka-select-trigger-width": "var(--reka-popper-anchor-width)",
        "--reka-select-trigger-height": "var(--reka-popper-anchor-height)"
      } }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var SelectPopperPosition_default = SelectPopperPosition_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectContentImpl.js
var SelectContentDefaultContextValue = {
  onViewportChange: () => {
  },
  itemTextRefCallback: () => {
  },
  itemRefCallback: () => {
  }
};
var [injectSelectContentContext, provideSelectContentContext] = createContext("SelectContent");
var SelectContentImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectContentImpl",
  props: {
    position: {
      type: String,
      required: false,
      default: "item-aligned"
    },
    bodyLock: {
      type: Boolean,
      required: false,
      default: true
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false,
      default: "start"
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  emits: [
    "closeAutoFocus",
    "escapeKeyDown",
    "pointerDownOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectSelectRootContext();
    useFocusGuards();
    useBodyScrollLock(props2.bodyLock);
    const { CollectionSlot, getItems } = useCollection();
    const content = ref();
    useHideOthers(content);
    const { search, handleTypeaheadSearch } = useTypeahead();
    const viewport = ref();
    const selectedItem = ref();
    const selectedItemText = ref();
    const isPositioned = ref(false);
    const firstValidItemFoundRef = ref(false);
    const firstSelectedItemInArrayFoundRef = ref(false);
    function focusSelectedItem() {
      if (selectedItem.value && content.value) focusFirst2([selectedItem.value, content.value]);
    }
    watch(isPositioned, () => {
      focusSelectedItem();
    });
    const { onOpenChange, triggerPointerDownPosRef } = rootContext;
    watchEffect((cleanupFn) => {
      if (!content.value) return;
      let pointerMoveDelta = {
        x: 0,
        y: 0
      };
      const handlePointerMove2 = (event) => {
        pointerMoveDelta = {
          x: Math.abs(Math.round(event.pageX) - (triggerPointerDownPosRef.value?.x ?? 0)),
          y: Math.abs(Math.round(event.pageY) - (triggerPointerDownPosRef.value?.y ?? 0))
        };
      };
      const handlePointerUp2 = (event) => {
        if (event.pointerType === "touch") return;
        if (pointerMoveDelta.x <= 10 && pointerMoveDelta.y <= 10) event.preventDefault();
        else if (!content.value?.contains(event.target)) onOpenChange(false);
        document.removeEventListener("pointermove", handlePointerMove2);
        triggerPointerDownPosRef.value = null;
      };
      if (triggerPointerDownPosRef.value !== null) {
        document.addEventListener("pointermove", handlePointerMove2);
        document.addEventListener("pointerup", handlePointerUp2, {
          capture: true,
          once: true
        });
      }
      cleanupFn(() => {
        document.removeEventListener("pointermove", handlePointerMove2);
        document.removeEventListener("pointerup", handlePointerUp2, { capture: true });
      });
    });
    function handleKeyDown(event) {
      const isModifierKey = event.ctrlKey || event.altKey || event.metaKey;
      if (event.key === "Tab") event.preventDefault();
      if (!isModifierKey && event.key.length === 1) handleTypeaheadSearch(event.key, getItems());
      if ([
        "ArrowUp",
        "ArrowDown",
        "Home",
        "End"
      ].includes(event.key)) {
        const collectionItems = getItems().map((i) => i.ref);
        let candidateNodes = [...collectionItems];
        if (["ArrowUp", "End"].includes(event.key)) candidateNodes = candidateNodes.slice().reverse();
        if (["ArrowUp", "ArrowDown"].includes(event.key)) {
          const currentElement = event.target;
          const currentIndex = candidateNodes.indexOf(currentElement);
          candidateNodes = candidateNodes.slice(currentIndex + 1);
        }
        setTimeout(() => focusFirst2(candidateNodes));
        event.preventDefault();
      }
    }
    const pickedProps = computed(() => {
      if (props2.position === "popper") return props2;
      else return {};
    });
    const forwardedProps = useForwardProps(pickedProps.value);
    provideSelectContentContext({
      content,
      viewport,
      onViewportChange: (node) => {
        viewport.value = node;
      },
      itemRefCallback: (node, value, disabled) => {
        const isFirstValidItem = !firstValidItemFoundRef.value && !disabled;
        const isSelectedItem = valueComparator2(rootContext.modelValue.value, value, rootContext.by);
        if (rootContext.multiple.value) {
          if (firstSelectedItemInArrayFoundRef.value) return;
          if (isSelectedItem || isFirstValidItem) {
            selectedItem.value = node;
            if (isSelectedItem) firstSelectedItemInArrayFoundRef.value = true;
          }
        } else if (isSelectedItem || isFirstValidItem) selectedItem.value = node;
        if (isFirstValidItem) firstValidItemFoundRef.value = true;
      },
      selectedItem,
      selectedItemText,
      onItemLeave: () => {
        content.value?.focus();
      },
      itemTextRefCallback: (node, value, disabled) => {
        const isFirstValidItem = !firstValidItemFoundRef.value && !disabled;
        const isSelectedItem = valueComparator2(rootContext.modelValue.value, value, rootContext.by);
        if (isSelectedItem || isFirstValidItem) selectedItemText.value = node;
      },
      focusSelectedItem,
      position: props2.position,
      isPositioned,
      searchRef: search
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [createVNode(unref(FocusScope_default), {
          "as-child": "",
          onMountAutoFocus: _cache[6] || (_cache[6] = withModifiers(() => {
          }, ["prevent"])),
          onUnmountAutoFocus: _cache[7] || (_cache[7] = (event) => {
            emits("closeAutoFocus", event);
            if (event.defaultPrevented) return;
            unref(rootContext).triggerElement.value?.focus({ preventScroll: true });
            event.preventDefault();
          })
        }, {
          default: withCtx(() => [createVNode(unref(DismissableLayer_default), {
            "as-child": "",
            "disable-outside-pointer-events": _ctx.disableOutsidePointerEvents,
            onFocusOutside: _cache[2] || (_cache[2] = withModifiers(() => {
            }, ["prevent"])),
            onDismiss: _cache[3] || (_cache[3] = ($event) => unref(rootContext).onOpenChange(false)),
            onEscapeKeyDown: _cache[4] || (_cache[4] = ($event) => emits("escapeKeyDown", $event)),
            onPointerDownOutside: _cache[5] || (_cache[5] = ($event) => emits("pointerDownOutside", $event))
          }, {
            default: withCtx(() => [(openBlock(), createBlock(resolveDynamicComponent(_ctx.position === "popper" ? SelectPopperPosition_default : SelectItemAlignedPosition_default), mergeProps({
              ..._ctx.$attrs,
              ...unref(forwardedProps)
            }, {
              id: unref(rootContext).contentId,
              ref: (vnode) => {
                const el = unref(unrefElement)(vnode);
                if (el?.hasAttribute("data-reka-popper-content-wrapper")) content.value = el.firstElementChild;
                else content.value = el;
                return void 0;
              },
              role: "listbox",
              "data-state": unref(rootContext).open.value ? "open" : "closed",
              dir: unref(rootContext).dir.value,
              style: {
                display: "flex",
                flexDirection: "column",
                outline: "none"
              },
              onContextmenu: _cache[0] || (_cache[0] = withModifiers(() => {
              }, ["prevent"])),
              onPlaced: _cache[1] || (_cache[1] = ($event) => isPositioned.value = true),
              onKeydown: handleKeyDown
            }), {
              default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
              _: 3
            }, 16, [
              "id",
              "data-state",
              "dir",
              "onKeydown"
            ]))]),
            _: 3
          }, 8, ["disable-outside-pointer-events"])]),
          _: 3
        })]),
        _: 3
      });
    };
  }
});
var SelectContentImpl_default = SelectContentImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectItemAlignedPosition.js
var [injectSelectItemAlignedPositionContext, provideSelectItemAlignedPositionContext] = createContext("SelectItemAlignedPosition");
var SelectItemAlignedPosition_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SelectItemAlignedPosition",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["placed"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { getItems } = useCollection();
    const rootContext = injectSelectRootContext();
    const contentContext = injectSelectContentContext();
    const shouldExpandOnScrollRef = ref(false);
    const shouldRepositionRef = ref(true);
    const contentWrapperElement = ref();
    const { forwardRef, currentElement: contentElement } = useForwardExpose();
    const { viewport, selectedItem, selectedItemText, focusSelectedItem } = contentContext;
    function position() {
      if (rootContext.triggerElement.value && rootContext.valueElement.value && contentWrapperElement.value && contentElement.value && viewport?.value && selectedItem?.value && selectedItemText?.value) {
        const triggerRect = rootContext.triggerElement.value.getBoundingClientRect();
        const contentRect = contentElement.value.getBoundingClientRect();
        const valueNodeRect = rootContext.valueElement.value.getBoundingClientRect();
        const itemTextRect = selectedItemText.value.getBoundingClientRect();
        if (rootContext.dir.value !== "rtl") {
          const itemTextOffset = itemTextRect.left - contentRect.left;
          const left = valueNodeRect.left - itemTextOffset;
          const leftDelta = triggerRect.left - left;
          const minContentWidth = triggerRect.width + leftDelta;
          const contentWidth = Math.max(minContentWidth, contentRect.width);
          const rightEdge = window.innerWidth - CONTENT_MARGIN;
          const clampedLeft = clamp(left, CONTENT_MARGIN, Math.max(CONTENT_MARGIN, rightEdge - contentWidth));
          contentWrapperElement.value.style.minWidth = `${minContentWidth}px`;
          contentWrapperElement.value.style.left = `${clampedLeft}px`;
        } else {
          const itemTextOffset = contentRect.right - itemTextRect.right;
          const right = window.innerWidth - valueNodeRect.right - itemTextOffset;
          const rightDelta = window.innerWidth - triggerRect.right - right;
          const minContentWidth = triggerRect.width + rightDelta;
          const contentWidth = Math.max(minContentWidth, contentRect.width);
          const leftEdge = window.innerWidth - CONTENT_MARGIN;
          const clampedRight = clamp(right, CONTENT_MARGIN, Math.max(CONTENT_MARGIN, leftEdge - contentWidth));
          contentWrapperElement.value.style.minWidth = `${minContentWidth}px`;
          contentWrapperElement.value.style.right = `${clampedRight}px`;
        }
        const items = getItems().map((i) => i.ref);
        const availableHeight = window.innerHeight - CONTENT_MARGIN * 2;
        const itemsHeight = viewport.value.scrollHeight;
        const contentStyles = window.getComputedStyle(contentElement.value);
        const contentBorderTopWidth = Number.parseInt(contentStyles.borderTopWidth, 10);
        const contentPaddingTop = Number.parseInt(contentStyles.paddingTop, 10);
        const contentBorderBottomWidth = Number.parseInt(contentStyles.borderBottomWidth, 10);
        const contentPaddingBottom = Number.parseInt(contentStyles.paddingBottom, 10);
        const fullContentHeight = contentBorderTopWidth + contentPaddingTop + itemsHeight + contentPaddingBottom + contentBorderBottomWidth;
        const minContentHeight = Math.min(selectedItem.value.offsetHeight * 5, fullContentHeight);
        const viewportStyles = window.getComputedStyle(viewport.value);
        const viewportPaddingTop = Number.parseInt(viewportStyles.paddingTop, 10);
        const viewportPaddingBottom = Number.parseInt(viewportStyles.paddingBottom, 10);
        const topEdgeToTriggerMiddle = triggerRect.top + triggerRect.height / 2 - CONTENT_MARGIN;
        const triggerMiddleToBottomEdge = availableHeight - topEdgeToTriggerMiddle;
        const selectedItemHalfHeight = selectedItem.value.offsetHeight / 2;
        const itemOffsetMiddle = selectedItem.value.offsetTop + selectedItemHalfHeight;
        const contentTopToItemMiddle = contentBorderTopWidth + contentPaddingTop + itemOffsetMiddle;
        const itemMiddleToContentBottom = fullContentHeight - contentTopToItemMiddle;
        const willAlignWithoutTopOverflow = contentTopToItemMiddle <= topEdgeToTriggerMiddle;
        if (willAlignWithoutTopOverflow) {
          const isLastItem = selectedItem.value === items[items.length - 1];
          contentWrapperElement.value.style.bottom = `0px`;
          const viewportOffsetBottom = contentElement.value.clientHeight - viewport.value.offsetTop - viewport.value.offsetHeight;
          const clampedTriggerMiddleToBottomEdge = Math.max(triggerMiddleToBottomEdge, selectedItemHalfHeight + (isLastItem ? viewportPaddingBottom : 0) + viewportOffsetBottom + contentBorderBottomWidth);
          const height = contentTopToItemMiddle + clampedTriggerMiddleToBottomEdge;
          contentWrapperElement.value.style.height = `${height}px`;
        } else {
          const isFirstItem = selectedItem.value === items[0];
          contentWrapperElement.value.style.top = `0px`;
          const clampedTopEdgeToTriggerMiddle = Math.max(topEdgeToTriggerMiddle, contentBorderTopWidth + viewport.value.offsetTop + (isFirstItem ? viewportPaddingTop : 0) + selectedItemHalfHeight);
          const height = clampedTopEdgeToTriggerMiddle + itemMiddleToContentBottom;
          contentWrapperElement.value.style.height = `${height}px`;
          viewport.value.scrollTop = contentTopToItemMiddle - topEdgeToTriggerMiddle + viewport.value.offsetTop;
        }
        contentWrapperElement.value.style.margin = `${CONTENT_MARGIN}px 0`;
        contentWrapperElement.value.style.minHeight = `${minContentHeight}px`;
        contentWrapperElement.value.style.maxHeight = `${availableHeight}px`;
        emits("placed");
        requestAnimationFrame(() => shouldExpandOnScrollRef.value = true);
      }
    }
    const contentZIndex = ref("");
    onMounted(async () => {
      await nextTick();
      position();
      if (contentElement.value) contentZIndex.value = window.getComputedStyle(contentElement.value).zIndex;
    });
    function handleScrollButtonChange(node) {
      if (node && shouldRepositionRef.value === true) {
        position();
        focusSelectedItem?.();
        shouldRepositionRef.value = false;
      }
    }
    useResizeObserver(rootContext.triggerElement, () => {
      position();
    });
    provideSelectItemAlignedPositionContext({
      contentWrapper: contentWrapperElement,
      shouldExpandOnScrollRef,
      onScrollButtonChange: handleScrollButtonChange
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "contentWrapperElement",
        ref: contentWrapperElement,
        style: normalizeStyle({
          display: "flex",
          flexDirection: "column",
          position: "fixed",
          zIndex: contentZIndex.value
        })
      }, [createVNode(unref(Primitive), mergeProps({
        ref: unref(forwardRef),
        style: {
          boxSizing: "border-box",
          maxHeight: "100%"
        }
      }, {
        ..._ctx.$attrs,
        ...props2
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)], 4);
    };
  }
});
var SelectItemAlignedPosition_default = SelectItemAlignedPosition_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectArrow.js
var SelectArrow_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectArrow",
  props: {
    width: {
      type: Number,
      required: false,
      default: 10
    },
    height: {
      type: Number,
      required: false,
      default: 5
    },
    rounded: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "svg"
    }
  },
  setup(__props) {
    const props2 = __props;
    const contentContext = injectSelectContentContext(SelectContentDefaultContextValue);
    return (_ctx, _cache) => {
      return unref(contentContext).position === "popper" ? (openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(mergeProps({ key: 0 }, props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var SelectArrow_default = SelectArrow_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectProvider.js
var SelectProvider_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SelectProvider",
  props: { context: {
    type: Object,
    required: true
  } },
  setup(__props) {
    const props2 = __props;
    provideSelectRootContext(props2.context);
    provideSelectContentContext(SelectContentDefaultContextValue);
    return (_ctx, _cache) => {
      return renderSlot(_ctx.$slots, "default");
    };
  }
});
var SelectProvider_default = SelectProvider_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectContent.js
var _hoisted_16 = { key: 1 };
var SelectContent_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SelectContent",
  props: {
    forceMount: {
      type: Boolean,
      required: false
    },
    position: {
      type: String,
      required: false
    },
    bodyLock: {
      type: Boolean,
      required: false
    },
    side: {
      type: null,
      required: false
    },
    sideOffset: {
      type: Number,
      required: false
    },
    sideFlip: {
      type: Boolean,
      required: false
    },
    align: {
      type: null,
      required: false
    },
    alignOffset: {
      type: Number,
      required: false
    },
    alignFlip: {
      type: Boolean,
      required: false
    },
    avoidCollisions: {
      type: Boolean,
      required: false
    },
    collisionBoundary: {
      type: null,
      required: false
    },
    collisionPadding: {
      type: [Number, Object],
      required: false
    },
    arrowPadding: {
      type: Number,
      required: false
    },
    sticky: {
      type: String,
      required: false
    },
    hideWhenDetached: {
      type: Boolean,
      required: false
    },
    positionStrategy: {
      type: String,
      required: false
    },
    updatePositionStrategy: {
      type: String,
      required: false
    },
    disableUpdateOnLayoutShift: {
      type: Boolean,
      required: false
    },
    prioritizePosition: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    },
    disableOutsidePointerEvents: {
      type: Boolean,
      required: false
    }
  },
  emits: [
    "closeAutoFocus",
    "escapeKeyDown",
    "pointerDownOutside"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const forwarded = useForwardPropsEmits(props2, emits);
    const rootContext = injectSelectRootContext();
    const fragment = ref();
    onMounted(() => {
      fragment.value = new DocumentFragment();
    });
    const presenceRef = ref();
    const present = computed(() => props2.forceMount || rootContext.open.value);
    const renderPresence = ref(present.value);
    watch(present, () => {
      setTimeout(() => renderPresence.value = present.value);
    });
    return (_ctx, _cache) => {
      return present.value || renderPresence.value || presenceRef.value?.present ? (openBlock(), createBlock(unref(Presence_default), {
        key: 0,
        ref_key: "presenceRef",
        ref: presenceRef,
        present: present.value
      }, {
        default: withCtx(() => [createVNode(SelectContentImpl_default, normalizeProps(guardReactiveProps({
          ...unref(forwarded),
          ..._ctx.$attrs
        })), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16)]),
        _: 3
      }, 8, ["present"])) : fragment.value ? (openBlock(), createElementBlock("div", _hoisted_16, [(openBlock(), createBlock(Teleport, { to: fragment.value }, [createVNode(SelectProvider_default, { context: unref(rootContext) }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["context"])], 8, ["to"]))])) : createCommentVNode("v-if", true);
    };
  }
});
var SelectContent_default = SelectContent_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectGroup.js
var [injectSelectGroupContext, provideSelectGroupContext] = createContext("SelectGroup");
var SelectGroup_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectGroup",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const id = useId2(void 0, "reka-select-group");
    provideSelectGroupContext({ id });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ role: "group" }, props2, { "aria-labelledby": unref(id) }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["aria-labelledby"]);
    };
  }
});
var SelectGroup_default = SelectGroup_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectIcon.js
var SelectIcon_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectIcon",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "aria-hidden": "true",
        as: _ctx.as,
        "as-child": _ctx.asChild
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {}, () => [_cache[0] || (_cache[0] = createTextVNode("▼"))])]),
        _: 3
      }, 8, ["as", "as-child"]);
    };
  }
});
var SelectIcon_default = SelectIcon_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectItem.js
var [injectSelectItemContext, provideSelectItemContext] = createContext("SelectItem");
var SelectItem_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectItem",
  props: {
    value: {
      type: null,
      required: true
    },
    disabled: {
      type: Boolean,
      required: false
    },
    textValue: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  emits: ["select"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { disabled } = toRefs(props2);
    const rootContext = injectSelectRootContext();
    const contentContext = injectSelectContentContext();
    const { forwardRef, currentElement } = useForwardExpose();
    const { CollectionItem } = useCollection();
    const isSelected = computed(() => valueComparator2(rootContext.modelValue?.value, props2.value, rootContext.by));
    const isFocused = ref(false);
    const textValue = ref(props2.textValue ?? "");
    const textId = useId2(void 0, "reka-select-item-text");
    const SELECT_SELECT = "select.select";
    async function handleSelectCustomEvent(ev) {
      if (ev.defaultPrevented) return;
      const eventDetail = {
        originalEvent: ev,
        value: props2.value
      };
      handleAndDispatchCustomEvent(SELECT_SELECT, handleSelect2, eventDetail);
    }
    async function handleSelect2(ev) {
      await nextTick();
      emits("select", ev);
      if (ev.defaultPrevented) return;
      if (!disabled.value) {
        rootContext.onValueChange(props2.value);
        if (!rootContext.multiple.value) rootContext.onOpenChange(false);
      }
    }
    async function handlePointerMove2(event) {
      await nextTick();
      if (event.defaultPrevented) return;
      if (disabled.value) contentContext.onItemLeave?.();
      else event.currentTarget?.focus({ preventScroll: true });
    }
    async function handlePointerLeave(event) {
      await nextTick();
      if (event.defaultPrevented) return;
      if (event.currentTarget === getActiveElement()) contentContext.onItemLeave?.();
    }
    async function handleKeyDown(event) {
      await nextTick();
      if (event.defaultPrevented) return;
      const isTypingAhead = contentContext.searchRef?.value !== "";
      if (isTypingAhead && event.key === " ") return;
      if (SELECTION_KEYS2.includes(event.key)) handleSelectCustomEvent(event);
      if (event.key === " ") event.preventDefault();
    }
    if (props2.value === "") throw new Error("A <SelectItem /> must have a value prop that is not an empty string. This is because the Select value can be set to an empty string to clear the selection and show the placeholder.");
    onMounted(() => {
      if (!currentElement.value) return;
      contentContext.itemRefCallback(currentElement.value, props2.value, props2.disabled);
    });
    provideSelectItemContext({
      value: props2.value,
      disabled,
      textId,
      isSelected,
      onItemTextChange: (node) => {
        textValue.value = ((textValue.value || node?.textContent) ?? "").trim();
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), { value: { textValue: textValue.value } }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          role: "option",
          "aria-labelledby": unref(textId),
          "data-highlighted": isFocused.value ? "" : void 0,
          "aria-selected": isSelected.value,
          "data-state": isSelected.value ? "checked" : "unchecked",
          "aria-disabled": unref(disabled) || void 0,
          "data-disabled": unref(disabled) ? "" : void 0,
          tabindex: unref(disabled) ? void 0 : -1,
          as: _ctx.as,
          "as-child": _ctx.asChild,
          onFocus: _cache[0] || (_cache[0] = ($event) => isFocused.value = true),
          onBlur: _cache[1] || (_cache[1] = ($event) => isFocused.value = false),
          onPointerup: handleSelectCustomEvent,
          onPointerdown: _cache[2] || (_cache[2] = (event) => {
            event.currentTarget.focus({ preventScroll: true });
          }),
          onTouchend: _cache[3] || (_cache[3] = withModifiers(() => {
          }, ["prevent", "stop"])),
          onPointermove: handlePointerMove2,
          onPointerleave: handlePointerLeave,
          onKeydown: handleKeyDown
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "aria-labelledby",
          "data-highlighted",
          "aria-selected",
          "data-state",
          "aria-disabled",
          "data-disabled",
          "tabindex",
          "as",
          "as-child"
        ])]),
        _: 3
      }, 8, ["value"]);
    };
  }
});
var SelectItem_default = SelectItem_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectItemIndicator.js
var SelectItemIndicator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectItemIndicator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const itemContext = injectSelectItemContext();
    return (_ctx, _cache) => {
      return unref(itemContext).isSelected.value ? (openBlock(), createBlock(unref(Primitive), mergeProps({
        key: 0,
        "aria-hidden": "true"
      }, props2), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16)) : createCommentVNode("v-if", true);
    };
  }
});
var SelectItemIndicator_default = SelectItemIndicator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectItemText.js
var SelectItemText_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SelectItemText",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectSelectRootContext();
    const contentContext = injectSelectContentContext();
    const itemContext = injectSelectItemContext();
    const { forwardRef, currentElement: itemTextElement } = useForwardExpose();
    const optionProps = computed(() => {
      return {
        value: itemContext.value,
        disabled: itemContext.disabled.value,
        textContent: itemTextElement.value?.textContent ?? itemContext.value?.toString() ?? ""
      };
    });
    onMounted(() => {
      if (!itemTextElement.value) return;
      itemContext.onItemTextChange(itemTextElement.value);
      contentContext.itemTextRefCallback(itemTextElement.value, itemContext.value, itemContext.disabled.value);
      rootContext.onOptionAdd(optionProps.value);
    });
    onUnmounted(() => {
      rootContext.onOptionRemove(optionProps.value);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        id: unref(itemContext).textId,
        ref: unref(forwardRef)
      }, {
        ...props2,
        ..._ctx.$attrs
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var SelectItemText_default = SelectItemText_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectLabel.js
var SelectLabel_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectLabel",
  props: {
    for: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "div"
    }
  },
  setup(__props) {
    const props2 = __props;
    const groupContext = injectSelectGroupContext({ id: "" });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps(props2, { id: unref(groupContext).id }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["id"]);
    };
  }
});
var SelectLabel_default = SelectLabel_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectPortal.js
var SelectPortal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectPortal",
  props: {
    to: {
      type: null,
      required: false
    },
    disabled: {
      type: Boolean,
      required: false
    },
    defer: {
      type: Boolean,
      required: false
    },
    forceMount: {
      type: Boolean,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Teleport_default), normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var SelectPortal_default = SelectPortal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectScrollButtonImpl.js
var SelectScrollButtonImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectScrollButtonImpl",
  emits: ["autoScroll"],
  setup(__props, { emit: __emit }) {
    const emits = __emit;
    const { getItems } = useCollection();
    const contentContext = injectSelectContentContext();
    const autoScrollTimerRef = ref(null);
    function clearAutoScrollTimer() {
      if (autoScrollTimerRef.value !== null) {
        window.clearInterval(autoScrollTimerRef.value);
        autoScrollTimerRef.value = null;
      }
    }
    watchEffect(() => {
      const activeItem = getItems().map((i) => i.ref).find((item) => item === getActiveElement());
      activeItem?.scrollIntoView({ block: "nearest" });
    });
    function handlePointerDown2() {
      if (autoScrollTimerRef.value === null) autoScrollTimerRef.value = window.setInterval(() => {
        emits("autoScroll");
      }, 50);
    }
    function handlePointerMove2() {
      contentContext.onItemLeave?.();
      if (autoScrollTimerRef.value === null) autoScrollTimerRef.value = window.setInterval(() => {
        emits("autoScroll");
      }, 50);
    }
    onBeforeUnmount(() => clearAutoScrollTimer());
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        "aria-hidden": "true",
        style: { flexShrink: 0 }
      }, _ctx.$parent?.$props, {
        onPointerdown: handlePointerDown2,
        onPointermove: handlePointerMove2,
        onPointerleave: _cache[0] || (_cache[0] = () => {
          clearAutoScrollTimer();
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var SelectScrollButtonImpl_default = SelectScrollButtonImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectScrollDownButton.js
var SelectScrollDownButton_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectScrollDownButton",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const contentContext = injectSelectContentContext();
    const alignedPositionContext = contentContext.position === "item-aligned" ? injectSelectItemAlignedPositionContext() : void 0;
    const { forwardRef, currentElement } = useForwardExpose();
    const canScrollDown = ref(false);
    watchEffect((cleanupFn) => {
      if (contentContext.viewport?.value && contentContext.isPositioned?.value) {
        let handleScroll = function() {
          const maxScroll = viewport.scrollHeight - viewport.clientHeight;
          canScrollDown.value = Math.ceil(viewport.scrollTop) < maxScroll;
        };
        const viewport = contentContext.viewport.value;
        handleScroll();
        viewport.addEventListener("scroll", handleScroll);
        cleanupFn(() => viewport.removeEventListener("scroll", handleScroll));
      }
    });
    watch(currentElement, () => {
      if (currentElement.value) alignedPositionContext?.onScrollButtonChange(currentElement.value);
    });
    return (_ctx, _cache) => {
      return canScrollDown.value ? (openBlock(), createBlock(SelectScrollButtonImpl_default, {
        key: 0,
        ref: unref(forwardRef),
        onAutoScroll: _cache[0] || (_cache[0] = () => {
          const { viewport, selectedItem } = unref(contentContext);
          if (viewport?.value && selectedItem?.value) viewport.value.scrollTop = viewport.value.scrollTop + selectedItem.value.offsetHeight;
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 512)) : createCommentVNode("v-if", true);
    };
  }
});
var SelectScrollDownButton_default = SelectScrollDownButton_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectScrollUpButton.js
var SelectScrollUpButton_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectScrollUpButton",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const contentContext = injectSelectContentContext();
    const alignedPositionContext = contentContext.position === "item-aligned" ? injectSelectItemAlignedPositionContext() : void 0;
    const { forwardRef, currentElement } = useForwardExpose();
    const canScrollUp = ref(false);
    watchEffect((cleanupFn) => {
      if (contentContext.viewport?.value && contentContext.isPositioned?.value) {
        let handleScroll = function() {
          canScrollUp.value = viewport.scrollTop > 0;
        };
        const viewport = contentContext.viewport.value;
        handleScroll();
        viewport.addEventListener("scroll", handleScroll);
        cleanupFn(() => viewport.removeEventListener("scroll", handleScroll));
      }
    });
    watch(currentElement, () => {
      if (currentElement.value) alignedPositionContext?.onScrollButtonChange(currentElement.value);
    });
    return (_ctx, _cache) => {
      return canScrollUp.value ? (openBlock(), createBlock(SelectScrollButtonImpl_default, {
        key: 0,
        ref: unref(forwardRef),
        onAutoScroll: _cache[0] || (_cache[0] = () => {
          const { viewport, selectedItem } = unref(contentContext);
          if (viewport?.value && selectedItem?.value) viewport.value.scrollTop = viewport.value.scrollTop - selectedItem.value.offsetHeight;
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 512)) : createCommentVNode("v-if", true);
    };
  }
});
var SelectScrollUpButton_default = SelectScrollUpButton_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectSeparator.js
var SelectSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectSeparator",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ "aria-hidden": "true" }, props2), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var SelectSeparator_default = SelectSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectTrigger.js
var SelectTrigger_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectTrigger",
  props: {
    disabled: {
      type: Boolean,
      required: false
    },
    reference: {
      type: null,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "button"
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectSelectRootContext();
    const { forwardRef, currentElement: triggerElement } = useForwardExpose();
    const isDisabled = computed(() => rootContext.disabled?.value || props2.disabled);
    rootContext.contentId ||= useId2(void 0, "reka-select-content");
    onMounted(() => {
      rootContext.onTriggerChange(triggerElement.value);
    });
    const { getItems } = useCollection();
    const { search, handleTypeaheadSearch, resetTypeahead } = useTypeahead();
    function handleOpen() {
      if (!isDisabled.value) {
        rootContext.onOpenChange(true);
        resetTypeahead();
      }
    }
    function handlePointerOpen(event) {
      handleOpen();
      rootContext.triggerPointerDownPosRef.value = {
        x: Math.round(event.pageX),
        y: Math.round(event.pageY)
      };
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(PopperAnchor_default), {
        "as-child": "",
        reference: _ctx.reference
      }, {
        default: withCtx(() => [createVNode(unref(Primitive), {
          ref: unref(forwardRef),
          role: "combobox",
          type: _ctx.as === "button" ? "button" : void 0,
          "aria-controls": unref(rootContext).contentId,
          "aria-expanded": unref(rootContext).open.value || false,
          "aria-required": unref(rootContext).required?.value,
          "aria-autocomplete": "none",
          disabled: isDisabled.value,
          dir: unref(rootContext)?.dir.value,
          "data-state": unref(rootContext)?.open.value ? "open" : "closed",
          "data-disabled": isDisabled.value ? "" : void 0,
          "data-placeholder": unref(shouldShowPlaceholder)(unref(rootContext).modelValue?.value) ? "" : void 0,
          "as-child": _ctx.asChild,
          as: _ctx.as,
          onClick: _cache[0] || (_cache[0] = (event) => {
            event?.currentTarget?.focus();
          }),
          onPointerdown: _cache[1] || (_cache[1] = (event) => {
            if (event.pointerType === "touch") return event.preventDefault();
            const target = event.target;
            if (target.hasPointerCapture(event.pointerId)) target.releasePointerCapture(event.pointerId);
            if (event.button === 0 && event.ctrlKey === false) {
              handlePointerOpen(event);
              event.preventDefault();
            }
          }),
          onPointerup: _cache[2] || (_cache[2] = withModifiers((event) => {
            if (event.pointerType === "touch") handlePointerOpen(event);
          }, ["prevent"])),
          onKeydown: _cache[3] || (_cache[3] = (event) => {
            const isTypingAhead = unref(search) !== "";
            const isModifierKey = event.ctrlKey || event.altKey || event.metaKey;
            if (!isModifierKey && event.key.length === 1) {
              if (isTypingAhead && event.key === " ") return;
            }
            unref(handleTypeaheadSearch)(event.key, unref(getItems)());
            if (unref(OPEN_KEYS).includes(event.key)) {
              handleOpen();
              event.preventDefault();
            }
          })
        }, {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 8, [
          "type",
          "aria-controls",
          "aria-expanded",
          "aria-required",
          "disabled",
          "dir",
          "data-state",
          "data-disabled",
          "data-placeholder",
          "as-child",
          "as"
        ])]),
        _: 3
      }, 8, ["reference"]);
    };
  }
});
var SelectTrigger_default = SelectTrigger_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectValue.js
var SelectValue_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectValue",
  props: {
    placeholder: {
      type: String,
      required: false,
      default: ""
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { forwardRef, currentElement } = useForwardExpose();
    const rootContext = injectSelectRootContext();
    onMounted(() => {
      rootContext.valueElement = currentElement;
    });
    const selectedLabel = computed(() => {
      let list = [];
      const options = Array.from(rootContext.optionsSet.value);
      const getOption = (value) => options.find((option) => valueComparator2(value, option.value, rootContext.by));
      if (Array.isArray(rootContext.modelValue.value)) list = rootContext.modelValue.value.map((value) => getOption(value)?.textContent ?? "");
      else list = [getOption(rootContext.modelValue.value)?.textContent ?? ""];
      return list.filter(Boolean);
    });
    const slotText = computed(() => {
      return selectedLabel.value.length ? selectedLabel.value.join(", ") : props2.placeholder;
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        ref: unref(forwardRef),
        as: _ctx.as,
        "as-child": _ctx.asChild,
        style: { pointerEvents: "none" },
        "data-placeholder": selectedLabel.value.length ? void 0 : props2.placeholder
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default", {
          selectedLabel: selectedLabel.value,
          modelValue: unref(rootContext).modelValue.value
        }, () => [createTextVNode(toDisplayString(slotText.value), 1)])]),
        _: 3
      }, 8, [
        "as",
        "as-child",
        "data-placeholder"
      ]);
    };
  }
});
var SelectValue_default = SelectValue_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Select/SelectViewport.js
var SelectViewport_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SelectViewport",
  props: {
    nonce: {
      type: String,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const { nonce: propNonce } = toRefs(props2);
    const nonce = useNonce(propNonce);
    const contentContext = injectSelectContentContext();
    const alignedPositionContext = contentContext.position === "item-aligned" ? injectSelectItemAlignedPositionContext() : void 0;
    const { forwardRef, currentElement } = useForwardExpose();
    onMounted(() => {
      contentContext?.onViewportChange(currentElement.value);
    });
    const prevScrollTopRef = ref(0);
    function handleScroll(event) {
      const viewport = event.currentTarget;
      const { shouldExpandOnScrollRef, contentWrapper } = alignedPositionContext ?? {};
      if (shouldExpandOnScrollRef?.value && contentWrapper?.value) {
        const scrolledBy = Math.abs(prevScrollTopRef.value - viewport.scrollTop);
        if (scrolledBy > 0) {
          const availableHeight = window.innerHeight - CONTENT_MARGIN * 2;
          const cssMinHeight = Number.parseFloat(contentWrapper.value.style.minHeight);
          const cssHeight = Number.parseFloat(contentWrapper.value.style.height);
          const prevHeight = Math.max(cssMinHeight, cssHeight);
          if (prevHeight < availableHeight) {
            const nextHeight = prevHeight + scrolledBy;
            const clampedNextHeight = Math.min(availableHeight, nextHeight);
            const heightDiff = nextHeight - clampedNextHeight;
            contentWrapper.value.style.height = `${clampedNextHeight}px`;
            if (contentWrapper.value.style.bottom === "0px") {
              viewport.scrollTop = heightDiff > 0 ? heightDiff : 0;
              contentWrapper.value.style.justifyContent = "flex-end";
            }
          }
        }
      }
      prevScrollTopRef.value = viewport.scrollTop;
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [createVNode(unref(Primitive), mergeProps({
        ref: unref(forwardRef),
        "data-reka-select-viewport": "",
        role: "presentation"
      }, {
        ..._ctx.$attrs,
        ...props2
      }, {
        style: {
          position: "relative",
          flex: 1,
          overflow: "hidden auto"
        },
        onScroll: handleScroll
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16), createVNode(unref(Primitive), {
        as: "style",
        nonce: unref(nonce)
      }, {
        default: withCtx(() => _cache[0] || (_cache[0] = [createTextVNode(" /* Hide scrollbars cross-browser and enable momentum scroll for touch devices */ [data-reka-select-viewport] { scrollbar-width:none; -ms-overflow-style: none; -webkit-overflow-scrolling: touch; } [data-reka-select-viewport]::-webkit-scrollbar { display: none; } ")])),
        _: 1,
        __: [0]
      }, 8, ["nonce"])], 64);
    };
  }
});
var SelectViewport_default = SelectViewport_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/component/BaseSeparator.js
var BaseSeparator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "BaseSeparator",
  props: {
    orientation: {
      type: String,
      required: false,
      default: "horizontal"
    },
    decorative: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const ORIENTATIONS = ["horizontal", "vertical"];
    function isValidOrientation(orientation) {
      return ORIENTATIONS.includes(orientation);
    }
    const computedOrientation = computed(() => isValidOrientation(props2.orientation) ? props2.orientation : "horizontal");
    const ariaOrientation = computed(() => computedOrientation.value === "vertical" ? props2.orientation : void 0);
    const semanticProps = computed(() => props2.decorative ? { role: "none" } : {
      "aria-orientation": ariaOrientation.value,
      "role": "separator"
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({
        as: _ctx.as,
        "as-child": _ctx.asChild,
        "data-orientation": computedOrientation.value
      }, semanticProps.value), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, [
        "as",
        "as-child",
        "data-orientation"
      ]);
    };
  }
});
var BaseSeparator_default = BaseSeparator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Separator/Separator.js
var Separator_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "Separator",
  props: {
    orientation: {
      type: String,
      required: false,
      default: "horizontal"
    },
    decorative: {
      type: Boolean,
      required: false
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    return (_ctx, _cache) => {
      return openBlock(), createBlock(BaseSeparator_default, normalizeProps(guardReactiveProps(props2)), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var Separator_default = Separator_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/utils.js
function getNextSortedValues(prevValues = [], nextValue, atIndex) {
  const nextValues = [...prevValues];
  nextValues[atIndex] = nextValue;
  return nextValues.sort((a, b) => a - b);
}
function convertValueToPercentage(value, min2, max2) {
  const maxSteps = max2 - min2;
  const percentPerStep = 100 / maxSteps;
  const percentage = percentPerStep * (value - min2);
  return clamp(percentage, 0, 100);
}
function getLabel(index, totalValues) {
  if (totalValues > 2) return `Value ${index + 1} of ${totalValues}`;
  else if (totalValues === 2) return ["Minimum", "Maximum"][index];
  else return void 0;
}
function getClosestValueIndex(values, nextValue) {
  if (values.length === 1) return 0;
  const distances = values.map((value) => Math.abs(value - nextValue));
  const closestDistance = Math.min(...distances);
  return distances.indexOf(closestDistance);
}
function getThumbInBoundsOffset(width, left, direction) {
  const halfWidth = width / 2;
  const halfPercent = 50;
  const offset3 = linearScale2([0, halfPercent], [0, halfWidth]);
  return (halfWidth - offset3(left) * direction) * direction;
}
function getStepsBetweenValues(values) {
  return values.slice(0, -1).map((value, index) => values[index + 1] - value);
}
function hasMinStepsBetweenValues(values, minStepsBetweenValues) {
  if (minStepsBetweenValues > 0) {
    const stepsBetweenValues = getStepsBetweenValues(values);
    const actualMinStepsBetweenValues = Math.min(...stepsBetweenValues);
    return actualMinStepsBetweenValues >= minStepsBetweenValues;
  }
  return true;
}
function linearScale2(input, output) {
  return (value) => {
    if (input[0] === input[1] || output[0] === output[1]) return output[0];
    const ratio = (output[1] - output[0]) / (input[1] - input[0]);
    return output[0] + ratio * (value - input[0]);
  };
}
function getDecimalCount(value) {
  return (String(value).split(".")[1] || "").length;
}
function roundValue(value, decimalCount) {
  const rounder = 10 ** decimalCount;
  return Math.round(value * rounder) / rounder;
}
var PAGE_KEYS = ["PageUp", "PageDown"];
var ARROW_KEYS = [
  "ArrowUp",
  "ArrowDown",
  "ArrowLeft",
  "ArrowRight"
];
var BACK_KEYS = {
  "from-left": [
    "Home",
    "PageDown",
    "ArrowDown",
    "ArrowLeft"
  ],
  "from-right": [
    "Home",
    "PageDown",
    "ArrowDown",
    "ArrowRight"
  ],
  "from-bottom": [
    "Home",
    "PageDown",
    "ArrowDown",
    "ArrowLeft"
  ],
  "from-top": [
    "Home",
    "PageUp",
    "ArrowUp",
    "ArrowLeft"
  ]
};
var [injectSliderOrientationContext, provideSliderOrientationContext] = createContext(["SliderVertical", "SliderHorizontal"]);

// node_modules/reka-ui/dist/Slider/SliderHorizontal.js
var SliderHorizontal_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderHorizontal",
  props: {
    dir: {
      type: String,
      required: false
    },
    min: {
      type: Number,
      required: true
    },
    max: {
      type: Number,
      required: true
    },
    inverted: {
      type: Boolean,
      required: true
    }
  },
  emits: [
    "slideEnd",
    "slideStart",
    "slideMove",
    "homeKeyDown",
    "endKeyDown",
    "stepKeyDown"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { max: max2, min: min2, dir, inverted } = toRefs(props2);
    const { forwardRef, currentElement: sliderElement } = useForwardExpose();
    const rootContext = injectSliderRootContext();
    const offsetPosition = ref();
    const rectRef = ref();
    const isSlidingFromLeft = computed(() => dir?.value !== "rtl" && !inverted.value || dir?.value !== "ltr" && inverted.value);
    function getValueFromPointerEvent(event, slideStart) {
      const rect = rectRef.value || sliderElement.value.getBoundingClientRect();
      const thumb = [...rootContext.thumbElements.value][rootContext.valueIndexToChangeRef.value];
      const thumbWidth = rootContext.thumbAlignment.value === "contain" ? thumb.clientWidth : 0;
      if (!offsetPosition.value && !slideStart && rootContext.thumbAlignment.value === "contain") offsetPosition.value = event.clientX - thumb.getBoundingClientRect().left;
      const input = [0, rect.width - thumbWidth];
      const output = isSlidingFromLeft.value ? [min2.value, max2.value] : [max2.value, min2.value];
      const value = linearScale2(input, output);
      rectRef.value = rect;
      const position = slideStart ? event.clientX - rect.left - thumbWidth / 2 : event.clientX - rect.left - (offsetPosition.value ?? 0);
      return value(position);
    }
    const startEdge = computed(() => isSlidingFromLeft.value ? "left" : "right");
    const endEdge = computed(() => isSlidingFromLeft.value ? "right" : "left");
    const direction = computed(() => isSlidingFromLeft.value ? 1 : -1);
    provideSliderOrientationContext({
      startEdge,
      endEdge,
      direction,
      size: "width"
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(SliderImpl_default, {
        ref: unref(forwardRef),
        dir: unref(dir),
        "data-orientation": "horizontal",
        style: normalizeStyle({ ["--reka-slider-thumb-transform"]: !isSlidingFromLeft.value && unref(rootContext).thumbAlignment.value === "overflow" ? "translateX(50%)" : "translateX(-50%)" }),
        onSlideStart: _cache[0] || (_cache[0] = (event) => {
          const value = getValueFromPointerEvent(event, true);
          emits("slideStart", value);
        }),
        onSlideMove: _cache[1] || (_cache[1] = (event) => {
          const value = getValueFromPointerEvent(event);
          emits("slideMove", value);
        }),
        onSlideEnd: _cache[2] || (_cache[2] = () => {
          rectRef.value = void 0;
          offsetPosition.value = void 0;
          emits("slideEnd");
        }),
        onStepKeyDown: _cache[3] || (_cache[3] = (event) => {
          const slideDirection = isSlidingFromLeft.value ? "from-left" : "from-right";
          const isBackKey = unref(BACK_KEYS)[slideDirection].includes(event.key);
          emits("stepKeyDown", event, isBackKey ? -1 : 1);
        }),
        onEndKeyDown: _cache[4] || (_cache[4] = ($event) => emits("endKeyDown", $event)),
        onHomeKeyDown: _cache[5] || (_cache[5] = ($event) => emits("homeKeyDown", $event))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["dir", "style"]);
    };
  }
});
var SliderHorizontal_default = SliderHorizontal_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderVertical.js
var SliderVertical_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderVertical",
  props: {
    min: {
      type: Number,
      required: true
    },
    max: {
      type: Number,
      required: true
    },
    inverted: {
      type: Boolean,
      required: true
    }
  },
  emits: [
    "slideEnd",
    "slideStart",
    "slideMove",
    "homeKeyDown",
    "endKeyDown",
    "stepKeyDown"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { max: max2, min: min2, inverted } = toRefs(props2);
    const rootContext = injectSliderRootContext();
    const { forwardRef, currentElement: sliderElement } = useForwardExpose();
    const offsetPosition = ref();
    const rectRef = ref();
    const isSlidingFromBottom = computed(() => !inverted.value);
    function getValueFromPointerEvent(event, slideStart) {
      const rect = rectRef.value || sliderElement.value.getBoundingClientRect();
      const thumb = [...rootContext.thumbElements.value][rootContext.valueIndexToChangeRef.value];
      const thumbHeight = rootContext.thumbAlignment.value === "contain" ? thumb.clientHeight : 0;
      if (!offsetPosition.value && !slideStart && rootContext.thumbAlignment.value === "contain") offsetPosition.value = event.clientY - thumb.getBoundingClientRect().top;
      const input = [0, rect.height - thumbHeight];
      const output = isSlidingFromBottom.value ? [max2.value, min2.value] : [min2.value, max2.value];
      const value = linearScale2(input, output);
      const position = slideStart ? event.clientY - rect.top - thumbHeight / 2 : event.clientY - rect.top - (offsetPosition.value ?? 0);
      rectRef.value = rect;
      return value(position);
    }
    const startEdge = computed(() => isSlidingFromBottom.value ? "bottom" : "top");
    const endEdge = computed(() => isSlidingFromBottom.value ? "top" : "bottom");
    const direction = computed(() => isSlidingFromBottom.value ? 1 : -1);
    provideSliderOrientationContext({
      startEdge,
      endEdge,
      direction,
      size: "height"
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(SliderImpl_default, {
        ref: unref(forwardRef),
        "data-orientation": "vertical",
        style: normalizeStyle({ ["--reka-slider-thumb-transform"]: !isSlidingFromBottom.value && unref(rootContext).thumbAlignment.value === "overflow" ? "translateY(-50%)" : "translateY(50%)" }),
        onSlideStart: _cache[0] || (_cache[0] = (event) => {
          const value = getValueFromPointerEvent(event, true);
          emits("slideStart", value);
        }),
        onSlideMove: _cache[1] || (_cache[1] = (event) => {
          const value = getValueFromPointerEvent(event);
          emits("slideMove", value);
        }),
        onSlideEnd: _cache[2] || (_cache[2] = () => {
          rectRef.value = void 0;
          offsetPosition.value = void 0;
          emits("slideEnd");
        }),
        onStepKeyDown: _cache[3] || (_cache[3] = (event) => {
          const slideDirection = isSlidingFromBottom.value ? "from-bottom" : "from-top";
          const isBackKey = unref(BACK_KEYS)[slideDirection].includes(event.key);
          emits("stepKeyDown", event, isBackKey ? -1 : 1);
        }),
        onEndKeyDown: _cache[4] || (_cache[4] = ($event) => emits("endKeyDown", $event)),
        onHomeKeyDown: _cache[5] || (_cache[5] = ($event) => emits("homeKeyDown", $event))
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, ["style"]);
    };
  }
});
var SliderVertical_default = SliderVertical_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderRoot.js
var [injectSliderRootContext, provideSliderRootContext] = createContext("SliderRoot");
var SliderRoot_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SliderRoot",
  props: {
    defaultValue: {
      type: Array,
      required: false,
      default: () => [0]
    },
    modelValue: {
      type: [Array, null],
      required: false
    },
    disabled: {
      type: Boolean,
      required: false,
      default: false
    },
    orientation: {
      type: String,
      required: false,
      default: "horizontal"
    },
    dir: {
      type: String,
      required: false
    },
    inverted: {
      type: Boolean,
      required: false,
      default: false
    },
    min: {
      type: Number,
      required: false,
      default: 0
    },
    max: {
      type: Number,
      required: false,
      default: 100
    },
    step: {
      type: Number,
      required: false,
      default: 1
    },
    minStepsBetweenThumbs: {
      type: Number,
      required: false,
      default: 0
    },
    thumbAlignment: {
      type: String,
      required: false,
      default: "contain"
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    },
    name: {
      type: String,
      required: false
    },
    required: {
      type: Boolean,
      required: false
    }
  },
  emits: ["update:modelValue", "valueCommit"],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const { min: min2, max: max2, step, minStepsBetweenThumbs, orientation, disabled, thumbAlignment, dir: propDir } = toRefs(props2);
    const dir = useDirection(propDir);
    const { forwardRef, currentElement } = useForwardExpose();
    const isFormControl = useFormControl(currentElement);
    const { CollectionSlot } = useCollection({ isProvider: true });
    const modelValue = useVModel(props2, "modelValue", emits, {
      defaultValue: props2.defaultValue,
      passive: props2.modelValue === void 0
    });
    const currentModelValue = computed(() => Array.isArray(modelValue.value) ? [...modelValue.value] : []);
    const valueIndexToChangeRef = ref(0);
    const valuesBeforeSlideStartRef = ref(currentModelValue.value);
    function handleSlideStart(value) {
      const closestIndex = getClosestValueIndex(currentModelValue.value, value);
      updateValues(value, closestIndex);
    }
    function handleSlideMove(value) {
      updateValues(value, valueIndexToChangeRef.value);
    }
    function handleSlideEnd() {
      const prevValue = valuesBeforeSlideStartRef.value[valueIndexToChangeRef.value];
      const nextValue = currentModelValue.value[valueIndexToChangeRef.value];
      const hasChanged = nextValue !== prevValue;
      if (hasChanged) emits("valueCommit", toRaw(currentModelValue.value));
    }
    function updateValues(value, atIndex, { commit } = { commit: false }) {
      const decimalCount = getDecimalCount(step.value);
      const snapToStep = roundValue(Math.round((value - min2.value) / step.value) * step.value + min2.value, decimalCount);
      const nextValue = clamp(snapToStep, min2.value, max2.value);
      const nextValues = getNextSortedValues(currentModelValue.value, nextValue, atIndex);
      if (hasMinStepsBetweenValues(nextValues, minStepsBetweenThumbs.value * step.value)) {
        valueIndexToChangeRef.value = nextValues.indexOf(nextValue);
        const hasChanged = String(nextValues) !== String(modelValue.value);
        if (hasChanged && commit) emits("valueCommit", nextValues);
        if (hasChanged) {
          thumbElements.value[valueIndexToChangeRef.value]?.focus();
          modelValue.value = nextValues;
        }
      }
    }
    const thumbElements = ref([]);
    provideSliderRootContext({
      modelValue,
      currentModelValue,
      valueIndexToChangeRef,
      thumbElements,
      orientation,
      min: min2,
      max: max2,
      disabled,
      thumbAlignment
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionSlot), null, {
        default: withCtx(() => [(openBlock(), createBlock(resolveDynamicComponent(unref(orientation) === "horizontal" ? SliderHorizontal_default : SliderVertical_default), mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          "as-child": _ctx.asChild,
          as: _ctx.as,
          min: unref(min2),
          max: unref(max2),
          dir: unref(dir),
          inverted: _ctx.inverted,
          "aria-disabled": unref(disabled),
          "data-disabled": unref(disabled) ? "" : void 0,
          onPointerdown: _cache[0] || (_cache[0] = () => {
            if (!unref(disabled)) valuesBeforeSlideStartRef.value = currentModelValue.value;
          }),
          onSlideStart: _cache[1] || (_cache[1] = ($event) => !unref(disabled) && handleSlideStart($event)),
          onSlideMove: _cache[2] || (_cache[2] = ($event) => !unref(disabled) && handleSlideMove($event)),
          onSlideEnd: _cache[3] || (_cache[3] = ($event) => !unref(disabled) && handleSlideEnd()),
          onHomeKeyDown: _cache[4] || (_cache[4] = ($event) => !unref(disabled) && updateValues(unref(min2), 0, { commit: true })),
          onEndKeyDown: _cache[5] || (_cache[5] = ($event) => !unref(disabled) && updateValues(unref(max2), currentModelValue.value.length - 1, { commit: true })),
          onStepKeyDown: _cache[6] || (_cache[6] = (event, direction) => {
            if (!unref(disabled)) {
              const isPageKey = unref(PAGE_KEYS).includes(event.key);
              const isSkipKey = isPageKey || event.shiftKey && unref(ARROW_KEYS).includes(event.key);
              const multiplier = isSkipKey ? 10 : 1;
              const atIndex = valueIndexToChangeRef.value;
              const value = currentModelValue.value[atIndex];
              const stepInDirection = unref(step) * multiplier * direction;
              updateValues(value + stepInDirection, atIndex, { commit: true });
            }
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default", { modelValue: unref(modelValue) }), unref(isFormControl) && _ctx.name ? (openBlock(), createBlock(unref(VisuallyHiddenInput_default), {
            key: 0,
            type: "number",
            value: unref(modelValue),
            name: _ctx.name,
            required: _ctx.required,
            disabled: unref(disabled),
            step: unref(step)
          }, null, 8, [
            "value",
            "name",
            "required",
            "disabled",
            "step"
          ])) : createCommentVNode("v-if", true)]),
          _: 3
        }, 16, [
          "as-child",
          "as",
          "min",
          "max",
          "dir",
          "inverted",
          "aria-disabled",
          "data-disabled"
        ]))]),
        _: 3
      });
    };
  }
});
var SliderRoot_default = SliderRoot_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderImpl.js
var SliderImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderImpl",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  emits: [
    "slideStart",
    "slideMove",
    "slideEnd",
    "homeKeyDown",
    "endKeyDown",
    "stepKeyDown"
  ],
  setup(__props, { emit: __emit }) {
    const props2 = __props;
    const emits = __emit;
    const rootContext = injectSliderRootContext();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), mergeProps({ "data-slider-impl": "" }, props2, {
        onKeydown: _cache[0] || (_cache[0] = (event) => {
          if (event.key === "Home") {
            emits("homeKeyDown", event);
            event.preventDefault();
          } else if (event.key === "End") {
            emits("endKeyDown", event);
            event.preventDefault();
          } else if (unref(PAGE_KEYS).concat(unref(ARROW_KEYS)).includes(event.key)) {
            emits("stepKeyDown", event);
            event.preventDefault();
          }
        }),
        onPointerdown: _cache[1] || (_cache[1] = (event) => {
          const target = event.target;
          target.setPointerCapture(event.pointerId);
          event.preventDefault();
          if (unref(rootContext).thumbElements.value.includes(target)) target.focus();
          else emits("slideStart", event);
        }),
        onPointermove: _cache[2] || (_cache[2] = (event) => {
          const target = event.target;
          if (target.hasPointerCapture(event.pointerId)) emits("slideMove", event);
        }),
        onPointerup: _cache[3] || (_cache[3] = (event) => {
          const target = event.target;
          if (target.hasPointerCapture(event.pointerId)) {
            target.releasePointerCapture(event.pointerId);
            emits("slideEnd", event);
          }
        })
      }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16);
    };
  }
});
var SliderImpl_default = SliderImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderRange.js
var SliderRange_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderRange",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const rootContext = injectSliderRootContext();
    const orientation = injectSliderOrientationContext();
    useForwardExpose();
    const percentages = computed(() => rootContext.currentModelValue.value.map((value) => convertValueToPercentage(value, rootContext.min.value, rootContext.max.value)));
    const offsetStart = computed(() => rootContext.currentModelValue.value.length > 1 ? Math.min(...percentages.value) : 0);
    const offsetEnd = computed(() => 100 - Math.max(...percentages.value, 0));
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "data-disabled": unref(rootContext).disabled.value ? "" : void 0,
        "data-orientation": unref(rootContext).orientation.value,
        "as-child": _ctx.asChild,
        as: _ctx.as,
        style: normalizeStyle({
          [unref(orientation).startEdge.value]: `${offsetStart.value}%`,
          [unref(orientation).endEdge.value]: `${offsetEnd.value}%`
        })
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "data-disabled",
        "data-orientation",
        "as-child",
        "as",
        "style"
      ]);
    };
  }
});
var SliderRange_default = SliderRange_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderThumbImpl.js
var SliderThumbImpl_vue_vue_type_script_setup_true_lang_default = defineComponent({
  inheritAttrs: false,
  __name: "SliderThumbImpl",
  props: {
    index: {
      type: Number,
      required: true
    },
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false
    }
  },
  setup(__props) {
    const props2 = __props;
    const rootContext = injectSliderRootContext();
    const orientation = injectSliderOrientationContext();
    const { forwardRef, currentElement: thumbElement } = useForwardExpose();
    const { CollectionItem } = useCollection();
    const value = computed(() => rootContext.modelValue?.value?.[props2.index]);
    const percent = computed(() => value.value === void 0 ? 0 : convertValueToPercentage(value.value, rootContext.min.value ?? 0, rootContext.max.value ?? 100));
    const label = computed(() => getLabel(props2.index, rootContext.modelValue?.value?.length ?? 0));
    const size3 = useSize(thumbElement);
    const orientationSize = computed(() => size3[orientation.size].value);
    const thumbInBoundsOffset = computed(() => {
      if (rootContext.thumbAlignment.value === "overflow" || !orientationSize.value) return 0;
      else return getThumbInBoundsOffset(orientationSize.value, percent.value, orientation.direction.value);
    });
    const isMounted = useMounted();
    onMounted(() => {
      rootContext.thumbElements.value.push(thumbElement.value);
    });
    onUnmounted(() => {
      const i = rootContext.thumbElements.value.findIndex((i$1) => i$1 === thumbElement.value) ?? -1;
      rootContext.thumbElements.value.splice(i, 1);
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(CollectionItem), null, {
        default: withCtx(() => [createVNode(unref(Primitive), mergeProps(_ctx.$attrs, {
          ref: unref(forwardRef),
          role: "slider",
          tabindex: unref(rootContext).disabled.value ? void 0 : 0,
          "aria-label": _ctx.$attrs["aria-label"] || label.value,
          "data-disabled": unref(rootContext).disabled.value ? "" : void 0,
          "data-orientation": unref(rootContext).orientation.value,
          "aria-valuenow": value.value,
          "aria-valuemin": unref(rootContext).min.value,
          "aria-valuemax": unref(rootContext).max.value,
          "aria-orientation": unref(rootContext).orientation.value,
          "as-child": _ctx.asChild,
          as: _ctx.as,
          style: {
            transform: "var(--reka-slider-thumb-transform)",
            position: "absolute",
            [unref(orientation).startEdge.value]: `calc(${percent.value}% + ${thumbInBoundsOffset.value}px)`,
            display: !unref(isMounted) && value.value === void 0 ? "none" : void 0
          },
          onFocus: _cache[0] || (_cache[0] = () => {
            unref(rootContext).valueIndexToChangeRef.value = _ctx.index;
          })
        }), {
          default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
          _: 3
        }, 16, [
          "tabindex",
          "aria-label",
          "data-disabled",
          "data-orientation",
          "aria-valuenow",
          "aria-valuemin",
          "aria-valuemax",
          "aria-orientation",
          "as-child",
          "as",
          "style"
        ])]),
        _: 3
      });
    };
  }
});
var SliderThumbImpl_default = SliderThumbImpl_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderThumb.js
var SliderThumb_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderThumb",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const props2 = __props;
    const { getItems } = useCollection();
    const { forwardRef, currentElement: thumbElement } = useForwardExpose();
    const index = computed(() => thumbElement.value ? getItems(true).findIndex((i) => i.ref === thumbElement.value) : -1);
    return (_ctx, _cache) => {
      return openBlock(), createBlock(SliderThumbImpl_default, mergeProps({ ref: unref(forwardRef) }, props2, { index: index.value }), {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 16, ["index"]);
    };
  }
});
var SliderThumb_default = SliderThumb_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/Slider/SliderTrack.js
var SliderTrack_vue_vue_type_script_setup_true_lang_default = defineComponent({
  __name: "SliderTrack",
  props: {
    asChild: {
      type: Boolean,
      required: false
    },
    as: {
      type: null,
      required: false,
      default: "span"
    }
  },
  setup(__props) {
    const rootContext = injectSliderRootContext();
    useForwardExpose();
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(Primitive), {
        "as-child": _ctx.asChild,
        as: _ctx.as,
        "data-disabled": unref(rootContext).disabled.value ? "" : void 0,
        "data-orientation": unref(rootContext).orientation.value
      }, {
        default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
        _: 3
      }, 8, [
        "as-child",
        "as",
        "data-disabled",
        "data-orientation"
      ]);
    };
  }
});
var SliderTrack_default = SliderTrack_vue_vue_type_script_setup_true_lang_default;

// node_modules/reka-ui/dist/utils/assert.js
function assert(expectedCondition, message = "Assertion failed!") {
  if (!expectedCondition) {
    console.error(message);
    throw new Error(message);
  }
}

// node_modules/reka-ui/dist/utils/dom.js
function getPanelGroupElement(id, rootElement = document) {
  if (!isBrowser) return null;
  if (rootElement instanceof HTMLElement && rootElement?.dataset?.panelGroupId === id) return rootElement;
  const element = rootElement.querySelector(`[data-panel-group][data-panel-group-id="${id}"]`);
  if (element) return element;
  return null;
}
function getResizeHandleElement(id, scope = document) {
  if (!isBrowser) return null;
  const element = scope.querySelector(`[data-panel-resize-handle-id="${id}"]`);
  if (element) return element;
  return null;
}
function getResizeHandleElementIndex(groupId, id, scope = document) {
  if (!isBrowser) return null;
  const handles = getResizeHandleElementsForGroup(groupId, scope);
  const index = handles.findIndex((handle) => handle.getAttribute("data-panel-resize-handle-id") === id);
  return index ?? null;
}
function getResizeHandleElementsForGroup(groupId, scope = document) {
  if (!isBrowser) return [];
  return Array.from(scope.querySelectorAll(`[data-panel-resize-handle-id][data-panel-group-id="${groupId}"]`));
}
function getResizeHandlePanelIds(groupId, handleId, panelsArray, scope = document) {
  const handle = getResizeHandleElement(handleId, scope);
  const handles = getResizeHandleElementsForGroup(groupId, scope);
  const index = handle ? handles.indexOf(handle) : -1;
  const idBefore = panelsArray[index]?.id ?? null;
  const idAfter = panelsArray[index + 1]?.id ?? null;
  return [idBefore, idAfter];
}

// node_modules/reka-ui/dist/utils/events.js
function isKeyDown(event) {
  return event.type === "keydown";
}
function isMouseEvent2(event) {
  return event.type.startsWith("mouse");
}
function isTouchEvent(event) {
  return event.type.startsWith("touch");
}
function getResizeEventCoordinates(event) {
  if (isMouseEvent2(event)) return {
    x: event.clientX,
    y: event.clientY
  };
  else if (isTouchEvent(event)) {
    const touch = event.touches[0];
    if (touch && touch.clientX && touch.clientY) return {
      x: touch.clientX,
      y: touch.clientY
    };
  }
  return {
    x: Number.POSITIVE_INFINITY,
    y: Number.POSITIVE_INFINITY
  };
}
function getResizeEventCursorPosition(direction, event) {
  const isHorizontal = direction === "horizontal";
  const { x, y } = getResizeEventCoordinates(event);
  return isHorizontal ? x : y;
}

// node_modules/reka-ui/dist/utils/calculate.js
function calculateDragOffsetPercentage(event, dragHandleId, direction, initialDragState, panelGroupElement) {
  const isHorizontal = direction === "horizontal";
  const handleElement = getResizeHandleElement(dragHandleId, panelGroupElement);
  assert(handleElement);
  const groupId = handleElement.getAttribute("data-panel-group-id");
  assert(groupId);
  const { initialCursorPosition } = initialDragState;
  const cursorPosition = getResizeEventCursorPosition(direction, event);
  const groupElement = getPanelGroupElement(groupId, panelGroupElement);
  assert(groupElement);
  const groupRect = groupElement.getBoundingClientRect();
  const groupSizeInPixels = isHorizontal ? groupRect.width : groupRect.height;
  const offsetPixels = cursorPosition - initialCursorPosition;
  const offsetPercentage = offsetPixels / groupSizeInPixels * 100;
  return offsetPercentage;
}
function calculateDeltaPercentage(event, dragHandleId, direction, initialDragState, keyboardResizeBy, panelGroupElement) {
  if (isKeyDown(event)) {
    const isHorizontal = direction === "horizontal";
    let delta = 0;
    if (event.shiftKey) delta = 100;
    else delta = keyboardResizeBy ?? 10;
    let movement = 0;
    switch (event.key) {
      case "ArrowDown":
        movement = isHorizontal ? 0 : delta;
        break;
      case "ArrowLeft":
        movement = isHorizontal ? -delta : 0;
        break;
      case "ArrowRight":
        movement = isHorizontal ? delta : 0;
        break;
      case "ArrowUp":
        movement = isHorizontal ? 0 : -delta;
        break;
      case "End":
        movement = 100;
        break;
      case "Home":
        movement = -100;
        break;
    }
    return movement;
  } else {
    if (initialDragState == null) return 0;
    return calculateDragOffsetPercentage(event, dragHandleId, direction, initialDragState, panelGroupElement);
  }
}
function calculateAriaValues({ layout, panelsArray, pivotIndices }) {
  let currentMinSize = 0;
  let currentMaxSize = 100;
  let totalMinSize = 0;
  let totalMaxSize = 0;
  const firstIndex = pivotIndices[0];
  assert(firstIndex != null);
  panelsArray.forEach((panelData, index) => {
    const { constraints } = panelData;
    const { maxSize = 100, minSize = 0 } = constraints;
    if (index === firstIndex) {
      currentMinSize = minSize;
      currentMaxSize = maxSize;
    } else {
      totalMinSize += minSize;
      totalMaxSize += maxSize;
    }
  });
  const valueMax = Math.min(currentMaxSize, 100 - totalMinSize);
  const valueMin = Math.max(currentMinSize, 100 - totalMaxSize);
  const valueNow = layout[firstIndex];
  return {
    valueMax,
    valueMin,
    valueNow
  };
}
function calculateUnsafeDefaultLayout({ panelDataArray }) {
  const layout = Array.from({ length: panelDataArray.length });
  const panelConstraintsArray = panelDataArray.map((panelData) => panelData.constraints);
  let numPanelsWithSizes = 0;
  let remainingSize = 100;
  for (let index = 0; index < panelDataArray.length; index++) {
    const panelConstraints = panelConstraintsArray[index];
    assert(panelConstraints);
    const { defaultSize } = panelConstraints;
    if (defaultSize != null) {
      numPanelsWithSizes++;
      layout[index] = defaultSize;
      remainingSize -= defaultSize;
    }
  }
  for (let index = 0; index < panelDataArray.length; index++) {
    const panelConstraints = panelConstraintsArray[index];
    assert(panelConstraints);
    const { defaultSize } = panelConstraints;
    if (defaultSize != null) continue;
    const numRemainingPanels = panelDataArray.length - numPanelsWithSizes;
    const size3 = remainingSize / numRemainingPanels;
    numPanelsWithSizes++;
    layout[index] = size3;
    remainingSize -= size3;
  }
  return layout;
}

// node_modules/reka-ui/dist/utils/callPanelCallbacks.js
function callPanelCallbacks(panelsArray, layout, panelIdToLastNotifiedSizeMap) {
  layout.forEach((size3, index) => {
    const panelData = panelsArray[index];
    assert(panelData);
    const { callbacks, constraints, id: panelId } = panelData;
    const { collapsedSize = 0, collapsible } = constraints;
    const lastNotifiedSize = panelIdToLastNotifiedSizeMap[panelId];
    if (lastNotifiedSize == null || size3 !== lastNotifiedSize) {
      panelIdToLastNotifiedSizeMap[panelId] = size3;
      const { onCollapse, onExpand, onResize } = callbacks;
      if (onResize) onResize(size3, lastNotifiedSize);
      if (collapsible && (onCollapse || onExpand)) {
        if (onExpand && (lastNotifiedSize == null || lastNotifiedSize === collapsedSize) && size3 !== collapsedSize) onExpand();
        if (onCollapse && (lastNotifiedSize == null || lastNotifiedSize !== collapsedSize) && size3 === collapsedSize) onCollapse();
      }
    }
  });
}

// node_modules/reka-ui/dist/utils/debounce.js
function debounce2(callback, durationMs = 10) {
  let timeoutId = null;
  const callable = (...args) => {
    if (timeoutId !== null) clearTimeout(timeoutId);
    timeoutId = setTimeout(() => {
      callback(...args);
    }, durationMs);
  };
  return callable;
}

// node_modules/reka-ui/dist/utils/constants.js
var PRECISION = 10;

// node_modules/reka-ui/dist/utils/compare.js
function fuzzyCompareNumbers(actual, expected, fractionDigits = PRECISION) {
  actual = Number.parseFloat(actual.toFixed(fractionDigits));
  expected = Number.parseFloat(expected.toFixed(fractionDigits));
  const delta = actual - expected;
  if (delta === 0) return 0;
  else return delta > 0 ? 1 : -1;
}
function fuzzyNumbersEqual(actual, expected, fractionDigits) {
  return fuzzyCompareNumbers(actual, expected, fractionDigits) === 0;
}

// node_modules/reka-ui/dist/utils/resizePanel.js
function resizePanel({ panelConstraints: panelConstraintsArray, panelIndex, size: size3 }) {
  const panelConstraints = panelConstraintsArray[panelIndex];
  assert(panelConstraints != null);
  const { collapsedSize = 0, collapsible, maxSize = 100, minSize = 0 } = panelConstraints;
  if (fuzzyCompareNumbers(size3, minSize) < 0) if (collapsible) {
    const halfwayPoint = (collapsedSize + minSize) / 2;
    if (fuzzyCompareNumbers(size3, halfwayPoint) < 0) size3 = collapsedSize;
    else size3 = minSize;
  } else size3 = minSize;
  size3 = Math.min(maxSize, size3);
  size3 = Number.parseFloat(size3.toFixed(PRECISION));
  return size3;
}

// node_modules/reka-ui/dist/utils/layout.js
function compareLayouts(a, b) {
  if (a.length !== b.length) return false;
  else for (let index = 0; index < a.length; index++) if (a[index] !== b[index]) return false;
  return true;
}
function adjustLayoutByDelta({ delta, layout: prevLayout, panelConstraints: panelConstraintsArray, pivotIndices, trigger }) {
  if (fuzzyNumbersEqual(delta, 0)) return prevLayout;
  const nextLayout = [...prevLayout];
  const [firstPivotIndex, secondPivotIndex] = pivotIndices;
  assert(firstPivotIndex != null);
  assert(secondPivotIndex != null);
  let deltaApplied = 0;
  if (trigger === "keyboard") {
    {
      const index = delta < 0 ? secondPivotIndex : firstPivotIndex;
      const panelConstraints = panelConstraintsArray[index];
      assert(panelConstraints);
      if (panelConstraints.collapsible) {
        const prevSize = prevLayout[index];
        assert(prevSize != null);
        const panelConstraints$1 = panelConstraintsArray[index];
        assert(panelConstraints$1);
        const { collapsedSize = 0, minSize = 0 } = panelConstraints$1;
        if (fuzzyNumbersEqual(prevSize, collapsedSize)) {
          const localDelta = minSize - prevSize;
          if (fuzzyCompareNumbers(localDelta, Math.abs(delta)) > 0) delta = delta < 0 ? 0 - localDelta : localDelta;
        }
      }
    }
    {
      const index = delta < 0 ? firstPivotIndex : secondPivotIndex;
      const panelConstraints = panelConstraintsArray[index];
      assert(panelConstraints);
      const { collapsible } = panelConstraints;
      if (collapsible) {
        const prevSize = prevLayout[index];
        assert(prevSize != null);
        const panelConstraints$1 = panelConstraintsArray[index];
        assert(panelConstraints$1);
        const { collapsedSize = 0, minSize = 0 } = panelConstraints$1;
        if (fuzzyNumbersEqual(prevSize, minSize)) {
          const localDelta = prevSize - collapsedSize;
          if (fuzzyCompareNumbers(localDelta, Math.abs(delta)) > 0) delta = delta < 0 ? 0 - localDelta : localDelta;
        }
      }
    }
  }
  {
    const increment = delta < 0 ? 1 : -1;
    let index = delta < 0 ? secondPivotIndex : firstPivotIndex;
    let maxAvailableDelta = 0;
    while (true) {
      const prevSize = prevLayout[index];
      assert(prevSize != null);
      const maxSafeSize = resizePanel({
        panelConstraints: panelConstraintsArray,
        panelIndex: index,
        size: 100
      });
      const delta$1 = maxSafeSize - prevSize;
      maxAvailableDelta += delta$1;
      index += increment;
      if (index < 0 || index >= panelConstraintsArray.length) break;
    }
    const minAbsDelta = Math.min(Math.abs(delta), Math.abs(maxAvailableDelta));
    delta = delta < 0 ? 0 - minAbsDelta : minAbsDelta;
  }
  {
    const pivotIndex = delta < 0 ? firstPivotIndex : secondPivotIndex;
    let index = pivotIndex;
    while (index >= 0 && index < panelConstraintsArray.length) {
      const deltaRemaining = Math.abs(delta) - Math.abs(deltaApplied);
      const prevSize = prevLayout[index];
      assert(prevSize != null);
      const unsafeSize = prevSize - deltaRemaining;
      const safeSize = resizePanel({
        panelConstraints: panelConstraintsArray,
        panelIndex: index,
        size: unsafeSize
      });
      if (!fuzzyNumbersEqual(prevSize, safeSize)) {
        deltaApplied += prevSize - safeSize;
        nextLayout[index] = safeSize;
        if (deltaApplied.toPrecision(3).localeCompare(Math.abs(delta).toPrecision(3), void 0, { numeric: true }) >= 0) break;
      }
      if (delta < 0) index--;
      else index++;
    }
  }
  if (fuzzyNumbersEqual(deltaApplied, 0)) return prevLayout;
  {
    const pivotIndex = delta < 0 ? secondPivotIndex : firstPivotIndex;
    const prevSize = prevLayout[pivotIndex];
    assert(prevSize != null);
    const unsafeSize = prevSize + deltaApplied;
    const safeSize = resizePanel({
      panelConstraints: panelConstraintsArray,
      panelIndex: pivotIndex,
      size: unsafeSize
    });
    nextLayout[pivotIndex] = safeSize;
    if (!fuzzyNumbersEqual(safeSize, unsafeSize)) {
      let deltaRemaining = unsafeSize - safeSize;
      const pivotIndex$1 = delta < 0 ? secondPivotIndex : firstPivotIndex;
      let index = pivotIndex$1;
      while (index >= 0 && index < panelConstraintsArray.length) {
        const prevSize$1 = nextLayout[index];
        assert(prevSize$1 != null);
        const unsafeSize$1 = prevSize$1 + deltaRemaining;
        const safeSize$1 = resizePanel({
          panelConstraints: panelConstraintsArray,
          panelIndex: index,
          size: unsafeSize$1
        });
        if (!fuzzyNumbersEqual(prevSize$1, safeSize$1)) {
          deltaRemaining -= safeSize$1 - prevSize$1;
          nextLayout[index] = safeSize$1;
        }
        if (fuzzyNumbersEqual(deltaRemaining, 0)) break;
        if (delta > 0) index--;
        else index++;
      }
    }
  }
  const totalSize = nextLayout.reduce((total, size3) => size3 + total, 0);
  if (!fuzzyNumbersEqual(totalSize, 100)) return prevLayout;
  return nextLayout;
}

// node_modules/reka-ui/dist/utils/pivot.js
function determinePivotIndices(groupId, dragHandleId, panelGroupElement) {
  const index = getResizeHandleElementIndex(groupId, dragHandleId, panelGroupElement);
  return index != null ? [index, index + 1] : [-1, -1];
}

// node_modules/reka-ui/dist/utils/rects.js
function intersects(rectOne, rectTwo, strict) {
  if (strict) return rectOne.x < rectTwo.x + rectTwo.width && rectOne.x + rectOne.width > rectTwo.x && rectOne.y < rectTwo.y + rectTwo.height && rectOne.y + rectOne.height > rectTwo.y;
  else return rectOne.x <= rectTwo.x + rectTwo.width && rectOne.x + rectOne.width >= rectTwo.x && rectOne.y <= rectTwo.y + rectTwo.height && rectOne.y + rectOne.height >= rectTwo.y;
}

// node_modules/reka-ui/dist/utils/stackingOrder.js
function compare3(a, b) {
  if (a === b) throw new Error("Cannot compare node with itself");
  const ancestors = {
    a: getAncestors(a),
    b: getAncestors(b)
  };
  let common_ancestor;
  while (ancestors.a.at(-1) === ancestors.b.at(-1)) {
    a = ancestors.a.pop();
    b = ancestors.b.pop();
    common_ancestor = a;
  }
  assert(common_ancestor);
  const z_indexes = {
    a: getZIndex(findStackingContext(ancestors.a)),
    b: getZIndex(findStackingContext(ancestors.b))
  };
  if (z_indexes.a === z_indexes.b) {
    const children = common_ancestor.childNodes;
    const furthest_ancestors = {
      a: ancestors.a.at(-1),
      b: ancestors.b.at(-1)
    };
    let i = children.length;
    while (i--) {
      const child = children[i];
      if (child === furthest_ancestors.a) return 1;
      if (child === furthest_ancestors.b) return -1;
    }
  }
  return Math.sign(z_indexes.a - z_indexes.b);
}
var props = /\b(?:position|zIndex|opacity|transform|webkitTransform|mixBlendMode|filter|webkitFilter|isolation)\b/;
function isFlexItem(node) {
  const display = getComputedStyle(getParent(node)).display;
  return display === "flex" || display === "inline-flex";
}
function createsStackingContext(node) {
  const style = getComputedStyle(node);
  if (style.position === "fixed") return true;
  if (style.zIndex !== "auto" && (style.position !== "static" || isFlexItem(node))) return true;
  if (+style.opacity < 1) return true;
  if ("transform" in style && style.transform !== "none") return true;
  if ("webkitTransform" in style && style.webkitTransform !== "none") return true;
  if ("mixBlendMode" in style && style.mixBlendMode !== "normal") return true;
  if ("filter" in style && style.filter !== "none") return true;
  if ("webkitFilter" in style && style.webkitFilter !== "none") return true;
  if ("isolation" in style && style.isolation === "isolate") return true;
  if (props.test(style.willChange)) return true;
  if (style.webkitOverflowScrolling === "touch") return true;
  return false;
}
function findStackingContext(nodes) {
  let i = nodes.length;
  while (i--) {
    const node = nodes[i];
    assert(node);
    if (createsStackingContext(node)) return node;
  }
  return null;
}
function getZIndex(node) {
  return node && Number(getComputedStyle(node).zIndex) || 0;
}
function getAncestors(node) {
  const ancestors = [];
  while (node) {
    ancestors.push(node);
    node = getParent(node);
  }
  return ancestors;
}
function getParent(node) {
  return node.parentNode instanceof DocumentFragment && node.parentNode?.host || node.parentNode;
}

// node_modules/reka-ui/dist/utils/registry.js
var EXCEEDED_HORIZONTAL_MIN = 1;
var EXCEEDED_HORIZONTAL_MAX = 2;
var EXCEEDED_VERTICAL_MIN = 4;
var EXCEEDED_VERTICAL_MAX = 8;
function getInputType() {
  if (typeof matchMedia === "function") return matchMedia("(pointer:coarse)").matches ? "coarse" : "fine";
}
var isCoarsePointer = getInputType() === "coarse";
var intersectingHandles = [];
var isPointerDown = false;
var ownerDocumentCounts = /* @__PURE__ */ new Map();
var panelConstraintFlags = /* @__PURE__ */ new Map();
var registeredResizeHandlers = /* @__PURE__ */ new Set();
function registerResizeHandle(resizeHandleId, element, direction, hitAreaMargins, nonce, setResizeHandlerState) {
  const { ownerDocument } = element;
  const data = {
    direction,
    element,
    hitAreaMargins,
    nonce,
    setResizeHandlerState
  };
  const count3 = ownerDocumentCounts.get(ownerDocument) ?? 0;
  ownerDocumentCounts.set(ownerDocument, count3 + 1);
  registeredResizeHandlers.add(data);
  updateListeners();
  return function unregisterResizeHandle() {
    panelConstraintFlags.delete(resizeHandleId);
    registeredResizeHandlers.delete(data);
    const count$1 = ownerDocumentCounts.get(ownerDocument) ?? 1;
    ownerDocumentCounts.set(ownerDocument, count$1 - 1);
    updateListeners();
    resetGlobalCursorStyle();
    if (count$1 === 1) ownerDocumentCounts.delete(ownerDocument);
  };
}
function handlePointerDown(event) {
  const { target } = event;
  const { x, y } = getResizeEventCoordinates(event);
  isPointerDown = true;
  recalculateIntersectingHandles({
    target,
    x,
    y
  });
  updateListeners();
  if (intersectingHandles.length > 0) {
    updateResizeHandlerStates("down", event);
    event.preventDefault();
  }
}
function handlePointerMove(event) {
  const { x, y } = getResizeEventCoordinates(event);
  if (!isPointerDown) {
    const { target } = event;
    recalculateIntersectingHandles({
      target,
      x,
      y
    });
  }
  updateResizeHandlerStates("move", event);
  updateCursor();
  if (intersectingHandles.length > 0) event.preventDefault();
}
function handlePointerUp(event) {
  const { target } = event;
  const { x, y } = getResizeEventCoordinates(event);
  panelConstraintFlags.clear();
  isPointerDown = false;
  if (intersectingHandles.length > 0) event.preventDefault();
  updateResizeHandlerStates("up", event);
  recalculateIntersectingHandles({
    target,
    x,
    y
  });
  updateCursor();
  updateListeners();
}
function recalculateIntersectingHandles({ target, x, y }) {
  intersectingHandles.splice(0);
  let targetElement = null;
  if (target instanceof HTMLElement) targetElement = target;
  registeredResizeHandlers.forEach((data) => {
    const { element: dragHandleElement, hitAreaMargins } = data;
    const dragHandleRect = dragHandleElement.getBoundingClientRect();
    const { bottom, left, right, top } = dragHandleRect;
    const margin = isCoarsePointer ? hitAreaMargins.coarse : hitAreaMargins.fine;
    const eventIntersects = x >= left - margin && x <= right + margin && y >= top - margin && y <= bottom + margin;
    if (eventIntersects) {
      if (targetElement !== null && dragHandleElement !== targetElement && !dragHandleElement.contains(targetElement) && !targetElement.contains(dragHandleElement) && compare3(targetElement, dragHandleElement) > 0) {
        let currentElement = targetElement;
        let didIntersect = false;
        while (currentElement) {
          if (currentElement.contains(dragHandleElement)) break;
          else if (intersects(currentElement.getBoundingClientRect(), dragHandleRect, true)) {
            didIntersect = true;
            break;
          }
          currentElement = currentElement.parentElement;
        }
        if (didIntersect) return;
      }
      intersectingHandles.push(data);
    }
  });
}
function reportConstraintsViolation(resizeHandleId, flag) {
  panelConstraintFlags.set(resizeHandleId, flag);
}
function updateCursor() {
  let intersectsHorizontal = false;
  let intersectsVertical = false;
  let nonce;
  intersectingHandles.forEach((data) => {
    const { direction, nonce: _nonce } = data;
    if (direction.value === "horizontal") intersectsHorizontal = true;
    else intersectsVertical = true;
    nonce = _nonce.value;
  });
  let constraintFlags = 0;
  panelConstraintFlags.forEach((flag) => {
    constraintFlags |= flag;
  });
  if (intersectsHorizontal && intersectsVertical) setGlobalCursorStyle("intersection", constraintFlags, nonce);
  else if (intersectsHorizontal) setGlobalCursorStyle("horizontal", constraintFlags, nonce);
  else if (intersectsVertical) setGlobalCursorStyle("vertical", constraintFlags, nonce);
  else resetGlobalCursorStyle();
}
function updateListeners() {
  ownerDocumentCounts.forEach((_, ownerDocument) => {
    const { body } = ownerDocument;
    body.removeEventListener("contextmenu", handlePointerUp);
    body.removeEventListener("mousedown", handlePointerDown);
    body.removeEventListener("mouseleave", handlePointerMove);
    body.removeEventListener("mousemove", handlePointerMove);
    body.removeEventListener("touchmove", handlePointerMove);
    body.removeEventListener("touchstart", handlePointerDown);
  });
  window.removeEventListener("mouseup", handlePointerUp);
  window.removeEventListener("touchcancel", handlePointerUp);
  window.removeEventListener("touchend", handlePointerUp);
  if (registeredResizeHandlers.size > 0) if (isPointerDown) {
    if (intersectingHandles.length > 0) ownerDocumentCounts.forEach((count3, ownerDocument) => {
      const { body } = ownerDocument;
      if (count3 > 0) {
        body.addEventListener("contextmenu", handlePointerUp);
        body.addEventListener("mouseleave", handlePointerMove);
        body.addEventListener("mousemove", handlePointerMove);
        body.addEventListener("touchmove", handlePointerMove, { passive: false });
      }
    });
    window.addEventListener("mouseup", handlePointerUp);
    window.addEventListener("touchcancel", handlePointerUp);
    window.addEventListener("touchend", handlePointerUp);
  } else ownerDocumentCounts.forEach((count3, ownerDocument) => {
    const { body } = ownerDocument;
    if (count3 > 0) {
      body.addEventListener("mousedown", handlePointerDown);
      body.addEventListener("mousemove", handlePointerMove);
      body.addEventListener("touchmove", handlePointerMove, { passive: false });
      body.addEventListener("touchstart", handlePointerDown);
    }
  });
}
function updateResizeHandlerStates(action, event) {
  registeredResizeHandlers.forEach((data) => {
    const { setResizeHandlerState } = data;
    const isActive = intersectingHandles.includes(data);
    setResizeHandlerState(action, isActive, event);
  });
}

// node_modules/reka-ui/dist/utils/style.js
var currentCursorStyle = null;
var styleElement = null;
function getCursorStyle(state, constraintFlags) {
  if (constraintFlags) {
    const horizontalMin = (constraintFlags & EXCEEDED_HORIZONTAL_MIN) !== 0;
    const horizontalMax = (constraintFlags & EXCEEDED_HORIZONTAL_MAX) !== 0;
    const verticalMin = (constraintFlags & EXCEEDED_VERTICAL_MIN) !== 0;
    const verticalMax = (constraintFlags & EXCEEDED_VERTICAL_MAX) !== 0;
    if (horizontalMin) if (verticalMin) return "se-resize";
    else if (verticalMax) return "ne-resize";
    else return "e-resize";
    else if (horizontalMax) if (verticalMin) return "sw-resize";
    else if (verticalMax) return "nw-resize";
    else return "w-resize";
    else if (verticalMin) return "s-resize";
    else if (verticalMax) return "n-resize";
  }
  switch (state) {
    case "horizontal":
      return "ew-resize";
    case "intersection":
      return "move";
    case "vertical":
      return "ns-resize";
  }
}
function resetGlobalCursorStyle() {
  if (styleElement !== null) {
    document.head.removeChild(styleElement);
    currentCursorStyle = null;
    styleElement = null;
  }
}
function setGlobalCursorStyle(state, constraintFlags, nonce) {
  const style = getCursorStyle(state, constraintFlags);
  if (currentCursorStyle === style) return;
  currentCursorStyle = style;
  if (styleElement === null) {
    styleElement = document.createElement("style");
    if (nonce) styleElement.nonce = nonce;
    document.head.appendChild(styleElement);
  }
  styleElement.innerHTML = `*{cursor: ${style}!important;}`;
}
function computePanelFlexBoxStyle({ defaultSize, dragState, layout, panelData, panelIndex, precision = 3 }) {
  const size3 = layout[panelIndex];
  let flexGrow;
  if (size3 == null) flexGrow = defaultSize !== void 0 ? defaultSize.toPrecision(precision) : "1";
  else if (panelData.length === 1) flexGrow = "1";
  else flexGrow = size3.toPrecision(precision);
  return {
    flexBasis: 0,
    flexGrow,
    flexShrink: 1,
    overflow: "hidden",
    pointerEvents: dragState !== null ? "none" : void 0
  };
}

// node_modules/reka-ui/dist/utils/validation.js
function validatePanelGroupLayout({ layout: prevLayout, panelConstraints }) {
  const nextLayout = [...prevLayout];
  const nextLayoutTotalSize = nextLayout.reduce((accumulated, current) => accumulated + current, 0);
  if (nextLayout.length !== panelConstraints.length) throw new Error(`Invalid ${panelConstraints.length} panel layout: ${nextLayout.map((size3) => `${size3}%`).join(", ")}`);