import { onMounted, ref } from 'vue';

type Appearance = 'light';

export function updateTheme() {
    if (typeof window === 'undefined') {
        return;
    }

    // Sempre remove a classe dark para garantir modo light
    document.documentElement.classList.remove('dark');
}

export function initializeTheme() {
    if (typeof window === 'undefined') {
        return;
    }

    // Sempre inicializa com modo light
    updateTheme();
}

const appearance = ref<Appearance>('light');

export function useAppearance() {
    onMounted(() => {
        // Sempre usa light
        appearance.value = 'light';
    });

    function updateAppearance(value: Appearance) {
        // Apenas aceita light
        appearance.value = 'light';
        updateTheme();
    }

    return {
        appearance,
        updateAppearance,
    };
}
