import type { ToastData } from '@/components/ui/toast/Toaster.vue';
import { ref } from 'vue';

const toasterRef = ref<{
    addToast: (toast: Omit<ToastData, 'id'>) => string;
} | null>(null);

export function useToast() {
    const toast = (toastData: Omit<ToastData, 'id'>) => {
        if (toasterRef.value) {
            return toasterRef.value.addToast(toastData);
        }
    };

    const setToasterRef = (
        ref: { addToast: (toast: Omit<ToastData, 'id'>) => string } | null,
    ) => {
        toasterRef.value = ref;
    };

    return {
        toast,
        setToasterRef,
    };
}
