<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use Dompdf\Dompdf;
use Dompdf\Options;

// Função helper para obter dados mockados dos pedidos
function getMockOrders(): array
{
    return [
        [
            'id' => 'ORD001',
            'bank' => [
                'name' => 'ATM Banco Angola',
                'icon' => 'bank',
            ],
            'distance' => '5.2 km',
            'time' => '15 min',
            'status' => 'indisponivel',
            'atms_count' => 1,
            'location' => 'Site Centro',
            'date' => 'Ontem às 16:15',
            'route' => 'Shopping A',
            'duration' => '30 min',
            'loading_duration' => '28 min',
            'responsible' => [
                'name' => 'Maria Santos',
                'phone' => '+244 923 123 456',
            ],
            'atms' => [
                [
                    'id' => 'ATM-CENTRO-001',
                    'status' => 'indisponivel',
                    'loading_date' => 'Ontem às 16:43',
                    'cassettes_count' => 2,
                    
                ],
            ],
        ],
        [
            'id' => 'ORD002',
            'bank' => [
                'name' => 'Agencia Morro bento',
                'icon' => 'bank',
            ],
            'distance' => '5.2 km',
            'time' => '15 min',
            'status' => 'indisponivel',
            'atms_count' => 1,
            'location' => 'Site Academia',
            'date' => 'Ontem às 16:15',
            'route' => 'Shopping Avenida',
            'duration' => '50 min',
            'responsible' => [
                'name' => 'Pedro Costa',
                'phone' => '+244 923 789 012',
            ],
            'atms' => [
                [
                    'id' => 'ATM-ACADEMIA-001',
                    'status' => 'ativo',
                    'loading_date' => null,
                    'cassettes_count' => 2,
                ],
            ],
        ],
        [
            'id' => 'ORD004',
            'bank' => [
                'name' => 'ATM Morr Bento',
                'icon' => 'bank',
            ],
            'distance' => '4.5 km',
            'time' => '12 min',
            'status' => 'disponivel',
            'atms_count' => 2,
            'location' => 'Site Marginal',
            'date' => 'Hoje às 10:30',
            'route' => 'Agência Marginal Angola',
            'duration' => '35 min',
            'atms' => [
                [
                    'id' => 'ATM-MARGINAL-001',
                    'status' => 'disponivel',
                    'loading_date' => null,
                    'cassettes_count' => 2,
                ],
                [
                    'id' => 'ATM-MARGINAL-002',
                    'status' => 'disponivel',
                    'loading_date' => null,
                    'cassettes_count' => 2,
                ],
            ],
        ],
        [
            'id' => 'ORD005',
            'bank' => [
                'name' => 'ATM Belas',
                'icon' => 'bank',
            ],
            'distance' => '6.8 km',
            'time' => '20 min',
            'status' => 'disponivel',
            'carregamento'=> '..',
            'atms_count' => 1,
            'location' => 'Site Belas',
            'date' => 'Ontem às 14:00',
            'route' => 'Shopping Belas',
            'duration' => '45 min',
            'loading_duration' => '42 min',
            'completed_at' => now()->subDay()->setTime(14, 42)->toIso8601String(),
            'responsible' => [
                'name' => 'Carlos Mendes',
                'phone' => '+244 923 567 890',
            ],
            'atms' => [
                [
                    'id' => 'ATM-BELAS-001',
                    'status' => 'ativo',
                    'loading_date' => 'Ontem às 14:42',
                    'cassettes_count' => 3,
                    'carregamento'=> "Confere",
                    'cassettes' => [
                        [
                            'notes' => '2000 KZ',
                            'status' => 'presente',
                            'selo'=> 'Selo nº 654321',
                            'estadoSelo'=> "Verificado",

                        ],
                        [
                            'notes' => '5000 KZ',
                            'status' => 'presente',
                            'selo'=> 'Selo nº 123456',
                            'estadoSelo'=> "Verificado",
                        ],
                        [
                            'notes' => '10000 KZ',
                            'status' => 'presente',
                            'selo'=> 'Selo nº 654321',
                            'estadoSelo'=> "Verificado",
                        ],
                    ],
                    'validation' => [
                        'atm_id' => 'ATM-BELAS-001',
                        'status' => 'ativo',
                        'cassettes_count' => 3,
                        'loading_date' => 'Ontem às 14:42',
                        'cassettes' => [
                            [
                                'notes' => '2000 KZ',
                                'status' => 'presente',
                                "selo"=> "Selo nº 123456",
                                "estadoSelo"=> "Não verificado",
                            ],
                            [
                                'notes' => '5000 KZ',
                                'status' => 'presente',
                                "selo"=> "Selo nº 654321",
                                "estadoSelo"=> "Não verificado",
                            ],
                            [
                                'notes' => '10000 KZ',
                                'status' => 'presente',
                                "selo"=> "Selo nº 123456",
                                "estadoSelo"=> "Não verificado",
                            ],
                        ],
                        'validated' => true,
                        'validated_at' => now()->subDay()->setTime(14, 45)->toIso8601String(),
                    ],
                ],
            ],
        ],
        [
            'id' => 'ORD003',
            'bank' => [
                'name' => 'ATM agencia Luanda',
                'icon' => 'bank',
            ],
            'distance' => '3.8 km',
            'time' => '12 min',
            'status' => 'disponivel',
            'atms_count' => 1,
            'location' => 'Site Marginal',
            'date' => 'Hoje às 06:54',
            'route' => 'Centro Comercial Angola',
            'duration' => '45 min',
            'started_at' => now()->subHours(1)->subMinutes(0)->subSeconds(7)->toIso8601String(),
            'responsible' => [
                'name' => 'Ana Oliveira',
                'phone' => '+244 923 345 678',
            ],
            'atms' => [
                [
                    'id' => 'ATM-MARGINAL-Angola-001',
                    'status' => 'ativo',
                    'loading_date' => null,
                    'cassettes_count' => 2,
                ],
            ],
        ],
    ];
}

function getMockCarregamentos(): array
{
    return [
        [
        "id"=> 1,
        "data"=> '2022-01-01',
        "tempo"=> '4 horas',
        "tempoMinutos"=> 240,
        "equipe"=> 'Equipe A - Centro',
        "site"=> 'Luanda Centro',
        "atms"=> ['ATM-001', 'ATM-002', 'ATM-003'],
        "atmsComCassetes"=> [
            [
                "atm"=> 'ATM-001',
                "cassetes"=> [1, 2, 3]
            ],
            [
                "atm"=> 'ATM-002',
                "cassetes"=> [1, 2, 4]
            ],
            [
                "atm"=> 'ATM-003',
                "cassetes"=> [2, 3, 4]
            ]
        ],
        "valores"=> [
            'ATM-001'=> [
                1=> 2000000,
                2=> 3500000,
                3=> 1500000
            ],
            'ATM-002'=> [
                1=> 1800000,
                2=> 2700000,
                4=> 1500000
            ],
            'ATM-003'=> [
                2=> 2000000,
                3=> 1500000,
                4=> 1555555
            ]
        ],
        "totalGeral"=> '15.500.000 Kz',
        "status"=> 'pendente',
        "qrCodeData"=> 'PEDIDO-001-2022-01-01-12:30:00',
        "inicioTimer"=> null,
        "fimTimer"=> null
    ],
    [
        "id"=> 2,
        "data"=> '2022-01-01',
        "tempo"=> '5 horas',
        "tempoMinutos"=> 300,
        "equipe"=> 'Equipe B - Marginal',
        "site"=> 'Luanda Marginal',
        "atms"=> ['ATM-004', 'ATM-005', 'ATM-006'],
        "atmsComCassetes"=> [
            [
                "atm"=> 'ATM-004',
                "cassetes"=> [1, 2, 3]
            ],
            [
                "atm"=> 'ATM-005',
                "cassetes"=> [1, 2, 4]
            ],
            [
                "atm"=> 'ATM-006',
                "cassetes"=> [2, 3, 4]
            ]
        ],
        "valores"=> [
            'ATM-004'=> [
                1=> 2000000,
                2=> 3500000,
                3=> 1500000
            ],
            'ATM-005'=> [
                1=> 1800000,
                2=> 2700000,
                4=> 1500000
            ],
            'ATM-006'=> [
                2=> 2000000,
                3=> 1500000,
                4=> 1555555
            ]
        ],
        "totalGeral"=> '15.500.000 Kz',
        "status"=> 'pendente',
        "qrCodeData"=> 'PEDIDO-002-2022-01-01-14:00:00',
        "inicioTimer"=> null,
        "fimTimer"=> null
    ],
    [
        "id"=> 3,
        "data"=> '2022-01-01',
        "tempo"=> '6 horas',
        "tempoMinutos"=> 360,
        "equipe"=> 'Equipe C - Academia',
        "site"=> 'Luanda Academia',
        "atms"=> ['ATM-007', 'ATM-008', 'ATM-009'],
        "atmsComCassetes"=> [
            [
                "atm"=> 'ATM-007',
                "cassetes"=> [1, 2, 3]
            ],
            [
                "atm"=> 'ATM-008',
                "cassetes"=> [1, 2, 4]
            ],
            [
                "atm"=> 'ATM-009',
                "cassetes"=> [2, 3, 4]
            ]
        ],
        "valores"=> [
            'ATM-007'=> [
                1=> 2000000,
                2=> 3500000,
                3=> 1500000
            ],
            'ATM-008'=> [
                1=> 1800000,
                2=> 2700000,
                4=> 1500000
            ],
            'ATM-009'=> [
                2=> 2000000,
                3=> 1500000,
                4=> 1555555
            ]
        ],
        "totalGeral"=> '15.500.000 Kz',
        "status"=> 'pendente',
        "qrCodeData"=> 'PEDIDO-003-2022-01-01-16:00:00',
        "inicioTimer"=> null,
        "fimTimer"=> null
    ]
    ];
}

 
// Página default - Lista de Pedidos
Route::get('/', function () {
    return Inertia::render('Orders/Index', [
        'orders' => getMockOrders(),
    ]);
})->name('home');

Route::get('dashboard', function () {
    return Inertia::render('Dashboard');
})->name('dashboard');


Route::get('carregamentos', function () {
    return Inertia::render('carregamentos/Index', [
       "orders"=> getMockCarregamentos()
    ]);
})->name('carregamentos.index');

Route::get('pedidos', function () {
    return Inertia::render('Orders/Index', [
        'orders' => getMockOrders(),
    ]);
})->name('orders.index');

Route::get('relatorios', function () {
    return Inertia::render('Reports/Index', [
        'orders' => getMockOrders(),
    ]);
})->name('reports.index');

Route::get('retornos', function () {
    return Inertia::render('Retornos/Index');
})->name('retornos.index');

Route::get('maps', function () {
    return Inertia::render('maps/Index', [
        'orders' => getMockOrders(),
    ]);
})->name('maps.index');

Route::get('cassetes', function () {
    return Inertia::render('cassetes/Index');
})->name('cassetes.index');

Route::get('relatorios/pedido/{orderId}/pdf', function (string $orderId) {
    $orders = getMockOrders();
    $order = collect($orders)->firstWhere('id', $orderId);
    
    if (!$order) {
        abort(404, 'Pedido não encontrado');
    }

    // Configurar DomPDF
    $options = new Options();
    $options->set('isHtml5ParserEnabled', true);
    $options->set('isRemoteEnabled', true);
    $options->set('defaultFont', 'DejaVu Sans');
    $options->set('isPhpEnabled', true);
    $options->set('chroot', base_path());
    
    $dompdf = new Dompdf($options);
    
    // Renderizar a view
    $html = view('reports.order-pdf', ['order' => $order])->render();
    
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    
    return $dompdf->stream("Relatorio_Pedido_{$orderId}.pdf", [
        'Attachment' => true
    ]);
})->name('reports.order.pdf');

Route::get('pedidos/{order}', function (string $order) {
    // Dados mockados baseados nas imagens
    $orderData = [
        'id' => $order,
        'bank' => [
            'name' => 'Banco Angola',
            'icon' => 'bank',
        ],
        'atms_count' => 1,
        'status' => 'indisponivel',
        'atms' => [
            [
                'id' => 'ATM-CENTRO-001',
                'status' => 'ativo',
                'loading_date' => null,
                'cassettes_count' => 2,
                'cassettes' => [
                    [
                        'notes' => '2000 KZ',
                        'status' => 'presente',
                    ],
                    [
                        'notes' => '5000 KZ',
                        'status' => 'presente',
                    ],
                ],
            ],
        ],
    ];

    return Inertia::render('Orders/Show', [
        'order' => $orderData,
    ]);
})->name('orders.show');

require __DIR__.'/settings.php';
